/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.triggers;

import com.applitools.eyes.Logger;
import com.applitools.eyes.Region;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class EyesKeyboard {
    private final Logger logger;
    private final EyesSeleniumDriver eyesDriver;

    public EyesKeyboard(Logger logger, EyesSeleniumDriver eyesDriver) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)((Object)eyesDriver), (String)"eyesDriver");
        this.logger = logger;
        this.eyesDriver = eyesDriver;
    }

    public void sendKeys(CharSequence ... charSequences) {
        Region control = Region.EMPTY;
        Object activeElement = this.eyesDriver.switchTo().activeElement();
        if (activeElement instanceof RemoteWebElement) {
            activeElement = new EyesRemoteWebElement(this.logger, this.eyesDriver, (WebElement)activeElement);
            control = ((EyesRemoteWebElement)((Object)activeElement)).getBounds();
        }
        for (CharSequence keys : charSequences) {
            String text = String.valueOf(keys);
            this.eyesDriver.getEyes().addTextTrigger(control, text);
        }
    }

    public void pressKey(CharSequence keyToPress) {
    }

    public void releaseKey(CharSequence keyToRelease) {
    }
}

