/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.wrappers;

import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.selenium.AppiumJsCommandExtractor;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.triggers.MouseTrigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

public class EyesSeleniumDriver
extends EyesWebDriver
implements IEyesJsExecutor {
    private final SeleniumEyes eyes;
    private final RemoteWebDriver driver;
    private final Map<String, WebElement> elementsIds;
    private final FrameChain frameChain;
    private ImageRotation rotation;
    private RectangleSize defaultContentViewportSize;

    public static BufferedImage normalizeRotation(Logger logger, WebDriver driver, BufferedImage image, ImageRotation rotation) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)image, (String)"image");
        BufferedImage normalizedImage = image;
        if (rotation != null) {
            if (rotation.getRotation() != 0) {
                normalizedImage = ImageUtils.rotateImage((BufferedImage)image, (double)rotation.getRotation());
            }
        } else {
            try {
                if (EyesDriverUtils.isMobileDevice((WebDriver)driver) && EyesDriverUtils.isLandscapeOrientation((Logger)logger, (WebDriver)driver) && image.getHeight() > image.getWidth()) {
                    int degrees = EyesDriverUtils.isAndroid((WebDriver)driver) ? 90 : -90;
                    normalizedImage = ImageUtils.rotateImage((BufferedImage)image, (double)degrees);
                }
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
            }
        }
        return normalizedImage;
    }

    public EyesSeleniumDriver(Logger logger, SeleniumEyes eyes, RemoteWebDriver driver) throws EyesException {
        super(logger, (EyesBase)eyes);
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        this.eyes = eyes;
        this.driver = driver;
        this.elementsIds = new HashMap<String, WebElement>();
        this.frameChain = new FrameChain(logger);
        this.defaultContentViewportSize = null;
        RemoteExecuteMethod executeMethod = null;
        try {
            executeMethod = new RemoteExecuteMethod(driver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SeleniumEyes getEyes() {
        return this.eyes;
    }

    public RemoteWebDriver getRemoteWebDriver() {
        return this.driver;
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(ImageRotation rotation) {
        this.rotation = rotation;
    }

    public void get(String s) {
        this.frameChain.clear();
    }

    public String getCurrentUrl() {
        return null;
    }

    public String getTitle() {
        return null;
    }

    public List<WebElement> findElements(By by) {
        List foundWebElementsList = null;
        ArrayList<WebElement> resultElementsList = new ArrayList<WebElement>(foundWebElementsList.size());
        for (WebElement currentElement : foundWebElementsList) {
            if (currentElement instanceof RemoteWebElement) {
                resultElementsList.add((WebElement)new EyesRemoteWebElement(this.logger, this, (WebElement)((RemoteWebElement)currentElement)));
                this.elementsIds.put(((RemoteWebElement)currentElement).getId(), currentElement);
                continue;
            }
            throw new EyesException(String.format("findElements: element is not a RemoteWebElement: %s", by));
        }
        return resultElementsList;
    }

    protected double getDevicePixelRatioInner() {
        if (EyesDriverUtils.isMobileDeviceByContext((WebDriver)this)) {
            return 1.0;
        }
        return Float.parseFloat(this.executeScript("return window.devicePixelRatio", new Object[0]).toString());
    }

    public WebElement findElement(By by) {
        EyesRemoteWebElement webElement = null;
        if (!(webElement instanceof RemoteWebElement) || webElement instanceof EyesRemoteWebElement) {
            throw new EyesException("findElement: Element is not a RemoteWebElement: " + by);
        }
        webElement = new EyesRemoteWebElement(this.logger, this, (WebElement)webElement);
        this.elementsIds.put(((RemoteWebElement)webElement).getId(), (WebElement)webElement);
        return webElement;
    }

    public Map<String, WebElement> getElementIds() {
        return this.elementsIds;
    }

    public String getPageSource() {
        return null;
    }

    public void close() {
    }

    public void quit() {
    }

    public Set<String> getWindowHandles() {
        return null;
    }

    public String getWindowHandle() {
        return null;
    }

    public WebDriver.TargetLocator switchTo() {
        return null;
    }

    public WebDriver.Navigation navigate() {
        return null;
    }

    public WebDriver.Options manage() {
        return null;
    }

    public WebElement findElementByClassName(String className) {
        return this.findElement(By.className((String)className));
    }

    public List<WebElement> findElementsByClassName(String className) {
        return this.findElements(By.className((String)className));
    }

    public WebElement findElementByCssSelector(String cssSelector) {
        return this.findElement(By.cssSelector((String)cssSelector));
    }

    public List<WebElement> findElementsByCssSelector(String cssSelector) {
        return this.findElements(By.cssSelector((String)cssSelector));
    }

    public WebElement findElementById(String id) {
        return this.findElement(By.id((String)id));
    }

    public List<WebElement> findElementsById(String id) {
        return this.findElements(By.id((String)id));
    }

    public WebElement findElementByLinkText(String linkText) {
        return this.findElement(By.linkText((String)linkText));
    }

    public List<WebElement> findElementsByLinkText(String linkText) {
        return this.findElements(By.linkText((String)linkText));
    }

    public WebElement findElementByPartialLinkText(String partialLinkText) {
        return this.findElement(By.partialLinkText((String)partialLinkText));
    }

    public List<WebElement> findElementsByPartialLinkText(String partialLinkText) {
        return this.findElements(By.partialLinkText((String)partialLinkText));
    }

    public WebElement findElementByName(String name) {
        return this.findElement(By.name((String)name));
    }

    public List<WebElement> findElementsByName(String name) {
        return this.findElements(By.name((String)name));
    }

    public WebElement findElementByTagName(String tagName) {
        return this.findElement(By.tagName((String)tagName));
    }

    public List<WebElement> findElementsByTagName(String tagName) {
        return this.findElements(By.tagName((String)tagName));
    }

    public WebElement findElementByXPath(String path) {
        return this.findElement(By.xpath((String)path));
    }

    public List<WebElement> findElementsByXPath(String path) {
        return this.findElements(By.xpath((String)path));
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public Object executeScript(String script, Object ... args) {
        Object trigger;
        if (AppiumJsCommandExtractor.isAppiumJsCommand(script) && (trigger = null) != null && trigger instanceof MouseTrigger) {
            MouseTrigger mt = trigger;
            this.eyes.addMouseTrigger(mt.getMouseAction(), mt.getControl(), mt.getLocation());
        }
        Object result = null;
        return result;
    }

    public Object executeAsyncScript(String script, Object ... args) {
        Object trigger;
        if (AppiumJsCommandExtractor.isAppiumJsCommand(script) && (trigger = null) != null && trigger instanceof MouseTrigger) {
            MouseTrigger mt = trigger;
            this.eyes.addMouseTrigger(mt.getMouseAction(), mt.getControl(), mt.getLocation());
        }
        return null;
    }

    public RectangleSize getDefaultContentViewportSize(boolean forceQuery) {
        FrameChain currentFrames;
        if (this.defaultContentViewportSize != null && !forceQuery) {
            return this.defaultContentViewportSize;
        }
        EyesTargetLocator switchTo = null;
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            switchTo = (EyesTargetLocator)this.switchTo();
        }
        if ((currentFrames = this.getFrameChain().clone()).size() > 0) {
            switchTo.defaultContent();
        }
        this.defaultContentViewportSize = EyesDriverUtils.getViewportSizeOrDisplaySize((Logger)this.logger, (WebDriver)this);
        if (currentFrames.size() > 0) {
            switchTo.frames(currentFrames);
        }
        return this.defaultContentViewportSize;
    }

    public RectangleSize getDefaultContentViewportSize() {
        return this.getDefaultContentViewportSize(true);
    }

    public FrameChain getFrameChain() {
        return this.frameChain;
    }

    public <X> X getScreenshotAs(OutputType<X> xOutputType) throws WebDriverException {
        String screenshot64 = null;
        BufferedImage screenshot = ImageUtils.imageFromBase64(screenshot64);
        screenshot = EyesSeleniumDriver.normalizeRotation(this.logger, (WebDriver)this.driver, screenshot, this.rotation);
        screenshot64 = ImageUtils.base64FromImage((BufferedImage)screenshot);
        return (X)xOutputType.convertFromBase64Png(screenshot64);
    }

    public String getUserAgent() {
        Object userAgent = null;
        try {
            if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
                userAgent = null;
            }
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
            userAgent = null;
        }
        return userAgent;
    }

    public long getInnerWidth() {
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            return 0L;
        }
        return 0L;
    }
}

