/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.wrappers;

import com.applitools.eyes.Borders;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.Feature;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.SizeAndBorders;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ScrollPositionProviderFactory;
import com.applitools.eyes.selenium.positioning.SeleniumScrollPositionProvider;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.utils.ArgumentGuard;
import java.util.List;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public abstract class EyesTargetLocator
implements WebDriver.TargetLocator {
    private final Logger logger;
    private final EyesSeleniumDriver driver;
    private SeleniumScrollPositionProvider scrollPosition;
    private final WebDriver.TargetLocator targetLocator;
    private final SeleniumJavaScriptExecutor jsExecutor;
    private final Configuration configuration;
    private PositionMemento defaultContentPositionMemento;

    public EyesTargetLocator(EyesSeleniumDriver driver, Logger logger, WebDriver.TargetLocator targetLocator) {
        ArgumentGuard.notNull((Object)((Object)driver), (String)"driver");
        ArgumentGuard.notNull((Object)targetLocator, (String)"targetLocator");
        this.driver = driver;
        this.logger = logger;
        this.targetLocator = targetLocator;
        this.jsExecutor = new SeleniumJavaScriptExecutor(driver);
        this.configuration = driver.getEyes().getConfiguration();
    }

    private void willSwitchToFrame(WebElement targetFrame) {
        ArgumentGuard.notNull((Object)targetFrame, (String)"targetFrame");
        EyesRemoteWebElement eyesFrame = targetFrame instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)targetFrame : new EyesRemoteWebElement(this.logger, this.driver, targetFrame);
        Point pl = targetFrame.getLocation();
        Dimension ds = targetFrame.getSize();
        SizeAndBorders sizeAndBorders = eyesFrame.getSizeAndBorders();
        Borders borders = sizeAndBorders.getBorders();
        RectangleSize frameInnerSize = sizeAndBorders.getSize();
        Rectangle bounds = eyesFrame.getBoundingClientRect();
        Region boundsAsRegion = new Region(bounds.x, bounds.y, bounds.width, bounds.height);
        Location contentLocation = new Location(bounds.getX() + borders.getLeft(), bounds.getY() + borders.getTop());
        Location originalLocation = eyesFrame.getScrollLocation();
        Frame frame = new Frame(this.logger, targetFrame, contentLocation, new RectangleSize(ds.getWidth(), ds.getHeight()), frameInnerSize, originalLocation, boundsAsRegion, borders, this.driver);
        this.driver.getFrameChain().push(frame);
    }

    public WebDriver frame(int index) {
        List<WebElement> frames = this.driver.findElementsByCssSelector("frame, iframe");
        if (index > frames.size()) {
            throw new NoSuchFrameException(String.format("Frame index [%d] is invalid!", index));
        }
        WebElement targetFrame = frames.get(index);
        this.willSwitchToFrame(targetFrame);
        this.targetLocator.frame(index);
        return this.driver;
    }

    public WebDriver frame(String nameOrId) {
        List<WebElement> frames = this.driver.findElementsByName(nameOrId);
        if (frames.size() == 0 && (frames = this.driver.findElementsById(nameOrId)).size() == 0) {
            throw new NoSuchFrameException(String.format("No frame with name or id '%s' exists!", nameOrId));
        }
        this.willSwitchToFrame(frames.get(0));
        this.targetLocator.frame(nameOrId);
        return this.driver;
    }

    public WebDriver frame(WebElement frameElement) {
        this.willSwitchToFrame(frameElement);
        this.targetLocator.frame(frameElement);
        return this.driver;
    }

    public WebDriver parentFrame() {
        if (this.driver.getFrameChain().size() != 0) {
            this.driver.getFrameChain().pop();
            EyesTargetLocator.parentFrame(this.logger, this.targetLocator, this.driver.getFrameChain());
        }
        return this.driver;
    }

    public static void parentFrame(Logger logger, WebDriver.TargetLocator targetLocator, FrameChain frameChainToParent) {
        try {
            targetLocator.parentFrame();
        }
        catch (Exception WebDriverException) {
            targetLocator.defaultContent();
            for (Frame frame : frameChainToParent) {
                targetLocator.frame(frame.getReference());
            }
        }
    }

    public WebDriver framesDoScroll(FrameChain frameChain) {
        this.defaultContent();
        SeleniumScrollPositionProvider scrollProvider = ScrollPositionProviderFactory.getScrollPositionProvider(this.driver.getUserAgent(), this.logger, (IEyesJsExecutor)this.jsExecutor, this.driver.getEyes().getCurrentFrameScrollRootElement());
        this.defaultContentPositionMemento = scrollProvider.getState();
        for (Frame frame : frameChain) {
            Location frameLocation = frame.getLocation();
            scrollProvider.setPosition(frameLocation);
            this.frame(frame.getReference());
            Frame newFrame = this.driver.getFrameChain().peek();
            newFrame.setScrollRootElement(frame.getScrollRootElement());
        }
        return this.driver;
    }

    public WebDriver frames(FrameChain frameChain) {
        this.defaultContent();
        for (Frame frame : frameChain) {
            this.frame(frame.getReference());
            Frame newFrame = this.driver.getFrameChain().peek();
            newFrame.setScrollRootElement(frame.getScrollRootElement());
        }
        return this.driver;
    }

    public WebDriver frames(String[] framesPath) {
        for (String frameNameOrId : framesPath) {
            this.targetLocator.frame(frameNameOrId);
        }
        return this.driver;
    }

    public WebDriver window(String nameOrHandle) {
        this.driver.getFrameChain().clear();
        this.targetLocator.window(nameOrHandle);
        return this.driver;
    }

    public WebDriver defaultContent() {
        if (this.driver.getFrameChain().size() != 0) {
            this.driver.getFrameChain().clear();
            this.targetLocator.defaultContent();
        } else if (!this.configuration.isFeatureActivated(Feature.NO_SWITCH_WITHOUT_FRAME_CHAIN)) {
            this.targetLocator.defaultContent();
        }
        return this.driver;
    }

    public WebElement activeElement() {
        WebElement element = this.targetLocator.activeElement();
        if (!(element instanceof RemoteWebElement)) {
            throw new EyesException("Not a remote web element!");
        }
        return new EyesRemoteWebElement(this.logger, this.driver, element);
    }

    public Alert alert() {
        Alert result = this.targetLocator.alert();
        return result;
    }

    public void resetScroll() {
        if (this.driver.getEyes() != null) {
            this.scrollPosition = ScrollPositionProviderFactory.getScrollPositionProvider(this.driver.getUserAgent(), this.logger, (IEyesJsExecutor)this.jsExecutor, this.driver.getEyes().getCurrentFrameScrollRootElement());
        }
        if (this.defaultContentPositionMemento != null) {
            this.scrollPosition.restoreState(this.defaultContentPositionMemento);
        }
    }
}

