/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AutProxySettings;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.Logger;
import com.applitools.eyes.exceptions.StaleElementReferenceException;
import com.applitools.eyes.universal.AbstractSDKListener;
import com.applitools.eyes.universal.ManagerType;
import com.applitools.eyes.universal.USDKListener;
import com.applitools.eyes.visualgrid.services.RunnerOptions;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ClassVersionGetter;

public class VisualGridRunner
extends EyesRunner {
    protected static String BASE_AGENT_ID = "eyes.sdk.java";
    protected static String VERSION = ClassVersionGetter.CURRENT_VERSION;
    private static final USDKListener listener = USDKListener.getInstance();
    static final int DEFAULT_CONCURRENCY = 5;
    private boolean isDisabled;
    private RunnerOptions runnerOptions;

    public VisualGridRunner() {
        this(Thread.currentThread().getStackTrace()[2].getClassName());
    }

    public VisualGridRunner(String suiteName) {
        this(new RunnerOptions().testConcurrency(5));
    }

    public VisualGridRunner(int testConcurrency) {
        this(testConcurrency, Thread.currentThread().getStackTrace()[2].getClassName());
    }

    public VisualGridRunner(int testConcurrency, String suiteName) {
        super(BASE_AGENT_ID, VERSION, (AbstractSDKListener)listener);
        this.runnerOptions = new RunnerOptions().testConcurrency(testConcurrency);
        this.managerRef = this.commandExecutor.coreMakeManager(ManagerType.VISUAL_GRID.value, null, Integer.valueOf(testConcurrency), BASE_AGENT_ID);
    }

    public VisualGridRunner(RunnerOptions runnerOptions) {
        this(runnerOptions, Thread.currentThread().getStackTrace()[2].getClassName());
    }

    public VisualGridRunner(RunnerOptions runnerOptions, String suiteName) {
        super(BASE_AGENT_ID, VERSION, runnerOptions, (AbstractSDKListener)listener);
        this.runnerOptions = runnerOptions;
        int testConcurrency = runnerOptions.getTestConcurrency() == null ? 5 : runnerOptions.getTestConcurrency();
        this.managerRef = this.commandExecutor.coreMakeManager(ManagerType.VISUAL_GRID.value, Integer.valueOf(testConcurrency), null, BASE_AGENT_ID);
    }

    protected VisualGridRunner(String baseAgentId, String version) {
        super(baseAgentId, version, (AbstractSDKListener)listener);
        this.runnerOptions = new RunnerOptions().testConcurrency(5);
        this.managerRef = this.commandExecutor.coreMakeManager(ManagerType.VISUAL_GRID.value, Integer.valueOf(5), null, BASE_AGENT_ID);
    }

    protected VisualGridRunner(int testConcurrency, String baseAgentId, String version) {
        super(baseAgentId, version, (AbstractSDKListener)listener);
        this.runnerOptions = new RunnerOptions().testConcurrency(testConcurrency);
        this.managerRef = this.commandExecutor.coreMakeManager(ManagerType.VISUAL_GRID.value, null, Integer.valueOf(testConcurrency), BASE_AGENT_ID);
    }

    protected VisualGridRunner(RunnerOptions runnerOptions, String baseAgentId, String version) {
        super(baseAgentId, version, (AbstractSDKListener)listener);
        ArgumentGuard.notNull((Object)runnerOptions, (String)"runnerOptions");
        this.runnerOptions = runnerOptions;
        int testConcurrency = runnerOptions.getTestConcurrency() == null ? 5 : runnerOptions.getTestConcurrency();
        this.managerRef = this.commandExecutor.coreMakeManager(ManagerType.VISUAL_GRID.value, Integer.valueOf(testConcurrency), null, BASE_AGENT_ID);
    }

    public StaleElementReferenceException getStaleElementException() {
        return new com.applitools.eyes.selenium.exceptions.StaleElementReferenceException();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        if (proxySettings != null) {
            this.runnerOptions = this.runnerOptions.proxy(proxySettings);
        }
    }

    public void setAutProxy(AutProxySettings autProxy) {
        this.runnerOptions = this.runnerOptions.autProxy(autProxy);
    }

    public AutProxySettings getAutProxy() {
        return this.runnerOptions.getAutProxy();
    }

    public AbstractProxySettings getProxy() {
        return this.runnerOptions.getProxy();
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }
}

