package com.applitools.eyes.selenium.universal.mapper;

import com.applitools.ICheckSettings;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.universal.dto.CheckSettingsDto;
import com.applitools.eyes.universal.dto.DebugScreenshotHandlerDto;
import com.applitools.eyes.universal.mapper.AccessibilitySettingsMapper;
import com.applitools.eyes.universal.mapper.LayoutBreakpointsMapper;
import com.applitools.eyes.universal.mapper.ProxyMapper;
import com.applitools.eyes.universal.mapper.VisualGridOptionMapper;

import java.util.Arrays;

import static com.applitools.eyes.universal.mapper.SettingsMapper.toImageCropRect;
import static com.applitools.eyes.universal.mapper.SettingsMapper.toNormalizationDto;

/**
 * check settings mapper
 */
public class CheckSettingsMapper {

  public static CheckSettingsDto toCheckSettingsDtoV3(ICheckSettings checkSettings, Configuration config) {
  if (!(checkSettings instanceof SeleniumCheckSettings)) {
      return null;
    }

    SeleniumCheckSettings seleniumCheckSettings = (SeleniumCheckSettings) checkSettings;

    CheckSettingsDto checkSettingsDto = new CheckSettingsDto();
    // CheckSettings
    checkSettingsDto.setRegion(TRegionMapper.toTRegionFromCheckSettings(checkSettings));
    checkSettingsDto.setFrames(ContextReferenceMapper.toContextReferenceDtoList(seleniumCheckSettings.getFrameChain()));
    checkSettingsDto.setFully(seleniumCheckSettings.getStitchContent());
    checkSettingsDto.setScrollRootElement(TRegionMapper.toTRegionDtoFromScrolls(seleniumCheckSettings.getScrollRootSelector(),
            seleniumCheckSettings.getScrollRootElement()));
    checkSettingsDto.setStitchMode(seleniumCheckSettings.getStitchMode() != null ? seleniumCheckSettings.getStitchMode().getName()
            : config.getStitchMode() != null ? config.getStitchMode().getName() : null);
    checkSettingsDto.setHideScrollbars(seleniumCheckSettings.getHideScrollBars());
    checkSettingsDto.setHideCaret(seleniumCheckSettings.getHideCaret());
    checkSettingsDto.setOverlap(seleniumCheckSettings.getStitchOverlap());
    checkSettingsDto.setWaitBeforeCapture(seleniumCheckSettings.getWaitBeforeCapture());
    checkSettingsDto.setLazyLoad(seleniumCheckSettings.getLazyLoadOptions());
    checkSettingsDto.setIgnoreDisplacements(seleniumCheckSettings.isIgnoreDisplacements());
    checkSettingsDto.setNormalization(toNormalizationDto(
            toImageCropRect(config.getCutProvider(), config.getContentInset()), config.getRotation(), config.getScaleRatio()));
    checkSettingsDto.setDebugImages(new DebugScreenshotHandlerDto(config.getSaveDebugScreenshots(),
            config.getDebugScreenshotsPath(), config.getDebugScreenshotsPrefix()));
    checkSettingsDto.setName(seleniumCheckSettings.getName());
    checkSettingsDto.setPageId(seleniumCheckSettings.getPageId());
    checkSettingsDto.setIgnoreRegions(CodedRegionReferenceMapper
            .toCodedRegionReferenceList(Arrays.asList(seleniumCheckSettings.getIgnoreRegions())));
    checkSettingsDto.setLayoutRegions(CodedRegionReferenceMapper
            .toCodedRegionReferenceList(Arrays.asList(seleniumCheckSettings.getLayoutRegions())));
    checkSettingsDto.setStrictRegions(CodedRegionReferenceMapper
            .toCodedRegionReferenceList(Arrays.asList(seleniumCheckSettings.getStrictRegions())));
    checkSettingsDto.setContentRegions(CodedRegionReferenceMapper
            .toCodedRegionReferenceList(Arrays.asList(seleniumCheckSettings.getContentRegions())));
    checkSettingsDto.setFloatingRegions(TFloatingRegionMapper.toTFloatingRegionDtoList(Arrays.asList(seleniumCheckSettings.getFloatingRegions())));
    checkSettingsDto.setAccessibilityRegions(TAccessibilityRegionMapper.toTAccessibilityRegionDtoList(Arrays.asList(seleniumCheckSettings.getAccessibilityRegions())));
    checkSettingsDto.setAccessibilitySettings(AccessibilitySettingsMapper.toAccessibilitySettingsDto(((SeleniumCheckSettings) checkSettings).getAccessibilityValidation()));
    checkSettingsDto.setMatchLevel(seleniumCheckSettings.getMatchLevel() == null ? null : seleniumCheckSettings.getMatchLevel().getName());
    checkSettingsDto.setRetryTimeout(config.getMatchTimeout()); //I'm NEW - former matchTimeout
    checkSettingsDto.setSendDom(seleniumCheckSettings.isSendDom());
    checkSettingsDto.setUseDom(seleniumCheckSettings.isUseDom());
    checkSettingsDto.setEnablePatterns(seleniumCheckSettings.isEnablePatterns());
    checkSettingsDto.setIgnoreCaret(seleniumCheckSettings.getIgnoreCaret());
    checkSettingsDto.setUfgOptions(VisualGridOptionMapper.toVisualGridOptionDtoList(seleniumCheckSettings.getVisualGridOptions())); //I'm NEW - former visualGridOptions
    checkSettingsDto.setLayoutBreakpoints(LayoutBreakpointsMapper.toLayoutBreakpointsDto(seleniumCheckSettings.getLayoutBreakpointsOptions()));
    checkSettingsDto.setDisableBrowserFetching(seleniumCheckSettings.isDisableBrowserFetching());
    checkSettingsDto.setAutProxy(ProxyMapper.toAutProxyDto(config.getAutProxy()));
    checkSettingsDto.setHooks(seleniumCheckSettings.getScriptHooks());
    checkSettingsDto.setUserCommandId(seleniumCheckSettings.getVariationGroupId());
    checkSettingsDto.setDensityMetrics(seleniumCheckSettings.getDensityMetrics());

    return checkSettingsDto;
  }
}
