/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.AccessibilityRegionType;
import com.applitools.eyes.LazyLoadOptions;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.Padding;
import com.applitools.eyes.Region;
import com.applitools.eyes.StitchOverlap;
import com.applitools.eyes.TargetPath;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.options.LayoutBreakpointsOptions;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.TargetPathLocator;
import com.applitools.eyes.selenium.fluent.AccessibilityRegionByElement;
import com.applitools.eyes.selenium.fluent.AccessibilityRegionBySelector;
import com.applitools.eyes.selenium.fluent.FloatingRegionByElement;
import com.applitools.eyes.selenium.fluent.FloatingRegionBySelector;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.ISeleniumCheckTarget;
import com.applitools.eyes.selenium.fluent.SimpleRegionByElement;
import com.applitools.eyes.selenium.fluent.SimpleRegionBySelector;
import com.applitools.eyes.serializers.BySerializer;
import com.applitools.eyes.serializers.WebElementSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class SeleniumCheckSettings
extends CheckSettings
implements ISeleniumCheckTarget,
Cloneable {
    public static final String FULL_PAGE = "full-page";
    public static final String VIEWPORT = "viewport";
    public static final String REGION = "region";
    public static final String SELECTOR = "selector";
    public static final String FULL_SELECTOR = "full-selector";
    private TargetPathLocator targetLocator;
    private final List<FrameLocator> frameChain = new ArrayList<FrameLocator>();
    @JsonSerialize(using=WebElementSerializer.class)
    private WebElement scrollRootElement;
    @JsonSerialize(using=BySerializer.class)
    private By scrollRootSelector;

    public SeleniumCheckSettings() {
    }

    public SeleniumCheckSettings(Region region) {
        super(region);
    }

    public SeleniumCheckSettings(String tag) {
        this.name = tag;
    }

    public SeleniumCheckSettings(TargetPathLocator targetLocator) {
        this.targetLocator = targetLocator;
    }

    @Override
    public List<FrameLocator> getFrameChain() {
        return this.frameChain;
    }

    public SeleniumCheckSettings clone() {
        SeleniumCheckSettings clone = new SeleniumCheckSettings();
        super.populateClone((CheckSettings)clone);
        clone.targetLocator = this.targetLocator;
        clone.frameChain.addAll(this.frameChain);
        clone.scrollRootElement = this.scrollRootElement;
        clone.scrollRootSelector = this.scrollRootSelector;
        clone.sendDom = this.sendDom;
        return clone;
    }

    public SeleniumCheckSettings frame(By by) {
        SeleniumCheckSettings clone = this.clone();
        FrameLocator fl = new FrameLocator();
        fl.setFrameSelector(by);
        clone.frameChain.add(fl);
        return clone;
    }

    public SeleniumCheckSettings frame(String frameNameOrId) {
        SeleniumCheckSettings clone = this.clone();
        FrameLocator fl = new FrameLocator();
        fl.setFrameNameOrId(frameNameOrId);
        clone.frameChain.add(fl);
        return clone;
    }

    public SeleniumCheckSettings frame(int index) {
        SeleniumCheckSettings clone = this.clone();
        FrameLocator fl = new FrameLocator();
        fl.setFrameIndex(index);
        clone.frameChain.add(fl);
        return clone;
    }

    public SeleniumCheckSettings frame(WebElement frameReference) {
        SeleniumCheckSettings clone = this.clone();
        FrameLocator fl = new FrameLocator();
        fl.setFrameReference(frameReference);
        clone.frameChain.add(fl);
        return clone;
    }

    public SeleniumCheckSettings region(Region region) {
        SeleniumCheckSettings clone = this.clone();
        clone.updateTargetRegion(region);
        return clone;
    }

    public SeleniumCheckSettings region(WebElement element) {
        SeleniumCheckSettings clone = this.clone();
        clone.targetLocator = TargetPath.region(element);
        return clone;
    }

    public SeleniumCheckSettings region(By by) {
        return this.region(TargetPath.region(by));
    }

    public SeleniumCheckSettings region(TargetPathLocator targetPathLocator) {
        SeleniumCheckSettings clone = this.clone();
        clone.targetLocator = targetPathLocator;
        return clone;
    }

    public SeleniumCheckSettings ignore(By regionSelector, By ... regionSelectors) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionBySelector(regionSelector));
        for (By selector : regionSelectors) {
            clone.ignore_((GetRegion)new SimpleRegionBySelector(selector));
        }
        return clone;
    }

    public SeleniumCheckSettings ignore(By regionSelector, String regionId, By ... regionSelectors) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionBySelector(regionSelector).regionId(regionId));
        for (By selector : regionSelectors) {
            clone.ignore_((GetRegion)new SimpleRegionBySelector(selector).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings ignore(WebElement element, WebElement ... elements) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionByElement(element));
        for (WebElement e : elements) {
            clone.ignore_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public SeleniumCheckSettings ignore(WebElement element, String regionId, WebElement ... elements) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionByElement(element).regionId(regionId));
        for (WebElement e : elements) {
            clone.ignore_((GetRegion)new SimpleRegionByElement(e).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings ignore(By[] regionSelectors) {
        SeleniumCheckSettings clone = this.clone();
        for (By selector : regionSelectors) {
            clone.ignore_((GetRegion)new SimpleRegionBySelector(selector));
        }
        return clone;
    }

    public SeleniumCheckSettings ignore(By[] regionSelectors, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        for (By selector : regionSelectors) {
            clone.ignore_((GetRegion)new SimpleRegionBySelector(selector).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings ignore(WebElement[] elements) {
        SeleniumCheckSettings clone = this.clone();
        for (WebElement e : elements) {
            clone.ignore_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public SeleniumCheckSettings ignore(WebElement[] elements, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        for (WebElement e : elements) {
            clone.ignore_((GetRegion)new SimpleRegionByElement(e).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings ignore(By selector, Padding padding) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionBySelector(selector, padding));
        return clone;
    }

    public SeleniumCheckSettings ignore(By selector, Padding padding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionBySelector(selector, padding).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings ignore(WebElement element, Padding padding) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionByElement(element, padding));
        return clone;
    }

    public SeleniumCheckSettings ignore(WebElement element, Padding padding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionByElement(element, padding).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings ignore(By selector, int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionBySelector(selector, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)));
        return clone;
    }

    public SeleniumCheckSettings ignore(By selector, int leftPadding, int topPadding, int rightPadding, int bottomPadding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionBySelector(selector, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings ignore(WebElement element, int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionByElement(element, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)));
        return clone;
    }

    public SeleniumCheckSettings ignore(WebElement element, int leftPadding, int topPadding, int rightPadding, int bottomPadding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionByElement(element, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings layout(By regionSelector, By ... regionSelectors) {
        SeleniumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionBySelector(regionSelector));
        for (By selector : regionSelectors) {
            clone.layout_((GetRegion)new SimpleRegionBySelector(selector));
        }
        return clone;
    }

    public SeleniumCheckSettings layout(By regionSelector, String regionId, By ... regionSelectors) {
        SeleniumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionBySelector(regionSelector).regionId(regionId));
        for (By selector : regionSelectors) {
            clone.layout_((GetRegion)new SimpleRegionBySelector(selector).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings layout(WebElement element, WebElement ... elements) {
        SeleniumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionByElement(element));
        for (WebElement e : elements) {
            clone.layout_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public SeleniumCheckSettings layout(WebElement element, String regionId, WebElement ... elements) {
        SeleniumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionByElement(element).regionId(regionId));
        for (WebElement e : elements) {
            clone.layout_((GetRegion)new SimpleRegionByElement(e).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings layout(By[] regionSelectors) {
        SeleniumCheckSettings clone = this.clone();
        for (By selector : regionSelectors) {
            clone.layout_((GetRegion)new SimpleRegionBySelector(selector));
        }
        return clone;
    }

    public SeleniumCheckSettings layout(By[] regionSelectors, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        for (By selector : regionSelectors) {
            clone.layout_((GetRegion)new SimpleRegionBySelector(selector).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings layout(WebElement[] elements) {
        SeleniumCheckSettings clone = this.clone();
        for (WebElement e : elements) {
            clone.layout_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public SeleniumCheckSettings layout(WebElement[] elements, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        for (WebElement e : elements) {
            clone.layout_((GetRegion)new SimpleRegionByElement(e).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings layout(By selector, Padding padding) {
        SeleniumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionBySelector(selector, padding));
        return clone;
    }

    public SeleniumCheckSettings layout(By selector, Padding padding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionBySelector(selector, padding).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings layout(WebElement element, Padding padding) {
        SeleniumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionByElement(element, padding));
        return clone;
    }

    public SeleniumCheckSettings layout(WebElement element, Padding padding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignore_((GetRegion)new SimpleRegionByElement(element, padding).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings layout(By selector, int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        SeleniumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionBySelector(selector, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)));
        return clone;
    }

    public SeleniumCheckSettings layout(By selector, int leftPadding, int topPadding, int rightPadding, int bottomPadding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionBySelector(selector, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings layout(WebElement element, int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        SeleniumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionByElement(element, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)));
        return clone;
    }

    public SeleniumCheckSettings layout(WebElement element, int leftPadding, int topPadding, int rightPadding, int bottomPadding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.layout_((GetRegion)new SimpleRegionByElement(element, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings strict(By regionSelector, By ... regionSelectors) {
        SeleniumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionBySelector(regionSelector));
        for (By selector : regionSelectors) {
            clone.strict_((GetRegion)new SimpleRegionBySelector(selector));
        }
        return clone;
    }

    public SeleniumCheckSettings strict(By regionSelector, String regionId, By ... regionSelectors) {
        SeleniumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionBySelector(regionSelector).regionId(regionId));
        for (By selector : regionSelectors) {
            clone.strict_((GetRegion)new SimpleRegionBySelector(selector).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings strict(WebElement element, WebElement ... elements) {
        SeleniumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionByElement(element));
        for (WebElement e : elements) {
            clone.strict_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public SeleniumCheckSettings strict(WebElement element, String regionId, WebElement ... elements) {
        SeleniumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionByElement(element).regionId(regionId));
        for (WebElement e : elements) {
            clone.strict_((GetRegion)new SimpleRegionByElement(e).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings strict(By[] regionSelectors) {
        SeleniumCheckSettings clone = this.clone();
        for (By selector : regionSelectors) {
            clone.strict_((GetRegion)new SimpleRegionBySelector(selector));
        }
        return clone;
    }

    public SeleniumCheckSettings strict(By[] regionSelectors, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        for (By selector : regionSelectors) {
            clone.strict_((GetRegion)new SimpleRegionBySelector(selector).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings strict(WebElement[] elements) {
        SeleniumCheckSettings clone = this.clone();
        for (WebElement e : elements) {
            clone.strict_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public SeleniumCheckSettings strict(WebElement[] elements, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        for (WebElement e : elements) {
            clone.strict_((GetRegion)new SimpleRegionByElement(e).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings strict(By selector, Padding padding) {
        SeleniumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionBySelector(selector, padding));
        return clone;
    }

    public SeleniumCheckSettings strict(By selector, Padding padding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionBySelector(selector, padding).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings strict(WebElement element, Padding padding) {
        SeleniumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionByElement(element, padding));
        return clone;
    }

    public SeleniumCheckSettings strict(WebElement element, Padding padding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionByElement(element, padding).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings strict(By selector, int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        SeleniumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionBySelector(selector, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)));
        return clone;
    }

    public SeleniumCheckSettings strict(By selector, int leftPadding, int topPadding, int rightPadding, int bottomPadding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionBySelector(selector, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings strict(WebElement element, int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        SeleniumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionByElement(element, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)));
        return clone;
    }

    public SeleniumCheckSettings strict(WebElement element, int leftPadding, int topPadding, int rightPadding, int bottomPadding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.strict_((GetRegion)new SimpleRegionByElement(element, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings content(By regionSelector, By ... regionSelectors) {
        SeleniumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionBySelector(regionSelector));
        for (By selector : regionSelectors) {
            clone.content_((GetRegion)new SimpleRegionBySelector(selector));
        }
        return clone;
    }

    public SeleniumCheckSettings content(By regionSelector, String regionId, By ... regionSelectors) {
        SeleniumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionBySelector(regionSelector).regionId(regionId));
        for (By selector : regionSelectors) {
            clone.content_((GetRegion)new SimpleRegionBySelector(selector).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings content(WebElement element, WebElement ... elements) {
        SeleniumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionByElement(element));
        for (WebElement e : elements) {
            clone.content_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public SeleniumCheckSettings content(WebElement element, String regionId, WebElement ... elements) {
        SeleniumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionByElement(element).regionId(regionId));
        for (WebElement e : elements) {
            clone.content_((GetRegion)new SimpleRegionByElement(e).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings content(By[] regionSelectors) {
        SeleniumCheckSettings clone = this.clone();
        for (By selector : regionSelectors) {
            clone.content_((GetRegion)new SimpleRegionBySelector(selector));
        }
        return clone;
    }

    public SeleniumCheckSettings content(By[] regionSelectors, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        for (By selector : regionSelectors) {
            clone.content_((GetRegion)new SimpleRegionBySelector(selector).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings content(WebElement[] elements) {
        SeleniumCheckSettings clone = this.clone();
        for (WebElement e : elements) {
            clone.content_((GetRegion)new SimpleRegionByElement(e));
        }
        return clone;
    }

    public SeleniumCheckSettings content(WebElement[] elements, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        for (WebElement e : elements) {
            clone.content_((GetRegion)new SimpleRegionByElement(e).regionId(regionId));
        }
        return clone;
    }

    public SeleniumCheckSettings content(By selector, Padding padding) {
        SeleniumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionBySelector(selector, padding));
        return clone;
    }

    public SeleniumCheckSettings content(By selector, Padding padding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionBySelector(selector, padding).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings content(WebElement element, Padding padding) {
        SeleniumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionByElement(element, padding));
        return clone;
    }

    public SeleniumCheckSettings content(WebElement element, Padding padding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionByElement(element, padding).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings content(By selector, int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        SeleniumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionBySelector(selector, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)));
        return clone;
    }

    public SeleniumCheckSettings content(By selector, int leftPadding, int topPadding, int rightPadding, int bottomPadding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionBySelector(selector, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings content(WebElement element, int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        SeleniumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionByElement(element, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)));
        return clone;
    }

    public SeleniumCheckSettings content(WebElement element, int leftPadding, int topPadding, int rightPadding, int bottomPadding, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.content_((GetRegion)new SimpleRegionByElement(element, new Padding(topPadding, rightPadding, bottomPadding, leftPadding)).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings floating(By regionSelector, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        SeleniumCheckSettings clone = this.clone();
        clone.floating((GetRegion)new FloatingRegionBySelector(regionSelector, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
        return clone;
    }

    public SeleniumCheckSettings floating(By regionSelector, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.floating((GetRegion)new FloatingRegionBySelector(regionSelector, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings floating(WebElement element, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        SeleniumCheckSettings clone = this.clone();
        clone.floating((GetRegion)new FloatingRegionByElement(element, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
        return clone;
    }

    public SeleniumCheckSettings floating(WebElement element, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset, String regionId) {
        SeleniumCheckSettings clone = this.clone();
        clone.floating((GetRegion)new FloatingRegionByElement(element, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset).regionId(regionId));
        return clone;
    }

    public SeleniumCheckSettings scrollRootElement(By selector) {
        SeleniumCheckSettings clone = this.clone();
        if (this.frameChain.size() == 0) {
            clone.scrollRootSelector = selector;
        } else {
            this.frameChain.get(this.frameChain.size() - 1).setScrollRootSelector(selector);
        }
        return clone;
    }

    public SeleniumCheckSettings scrollRootElement(WebElement element) {
        SeleniumCheckSettings clone = this.clone();
        if (this.frameChain.size() == 0) {
            clone.scrollRootElement = element;
        } else {
            this.frameChain.get(this.frameChain.size() - 1).setScrollRootElement(element);
        }
        return clone;
    }

    public SeleniumCheckSettings fully() {
        return (SeleniumCheckSettings)super.fully();
    }

    public SeleniumCheckSettings fully(Boolean fully) {
        return (SeleniumCheckSettings)super.fully(fully);
    }

    public SeleniumCheckSettings withName(String name) {
        return (SeleniumCheckSettings)super.withName(name);
    }

    public SeleniumCheckSettings ignoreCaret(Boolean ignoreCaret) {
        return (SeleniumCheckSettings)super.ignoreCaret(ignoreCaret);
    }

    public SeleniumCheckSettings ignoreCaret() {
        return (SeleniumCheckSettings)super.ignoreCaret();
    }

    public SeleniumCheckSettings matchLevel(MatchLevel matchLevel) {
        return (SeleniumCheckSettings)super.matchLevel(matchLevel);
    }

    public SeleniumCheckSettings content() {
        return (SeleniumCheckSettings)super.content();
    }

    public SeleniumCheckSettings strict() {
        return (SeleniumCheckSettings)super.strict();
    }

    public SeleniumCheckSettings layout() {
        return (SeleniumCheckSettings)super.layout();
    }

    public SeleniumCheckSettings exact() {
        return (SeleniumCheckSettings)super.exact();
    }

    public SeleniumCheckSettings timeout(Integer timeoutMilliseconds) {
        return (SeleniumCheckSettings)super.timeout(timeoutMilliseconds);
    }

    public SeleniumCheckSettings ignore(Region region, Region ... regions) {
        return (SeleniumCheckSettings)super.ignore(region, regions);
    }

    public SeleniumCheckSettings ignore(Region[] regions) {
        return (SeleniumCheckSettings)super.ignore(regions);
    }

    public SeleniumCheckSettings layout(Region region, Region ... regions) {
        return (SeleniumCheckSettings)super.layout(region, regions);
    }

    public SeleniumCheckSettings layout(Region[] regions) {
        return (SeleniumCheckSettings)super.layout(regions);
    }

    public SeleniumCheckSettings strict(Region region, Region ... regions) {
        return (SeleniumCheckSettings)super.strict(region, regions);
    }

    public SeleniumCheckSettings strict(Region[] regions) {
        return (SeleniumCheckSettings)super.strict(regions);
    }

    public SeleniumCheckSettings content(Region region, Region ... regions) {
        return (SeleniumCheckSettings)super.content(region, regions);
    }

    public SeleniumCheckSettings content(Region[] regions) {
        return (SeleniumCheckSettings)super.content(regions);
    }

    @Override
    public WebElement getScrollRootElement() {
        return this.scrollRootElement;
    }

    @Override
    public By getScrollRootSelector() {
        return this.scrollRootSelector;
    }

    public SeleniumCheckSettings(Region region, boolean isSendDom) {
        super(region);
        this.sendDom = isSendDom;
    }

    @JsonProperty(value="sizeMode")
    public String getSizeMode() {
        Region region;
        SeleniumCheckSettings checkSettingsInternal = this;
        Boolean stitchContent = checkSettingsInternal.getStitchContent();
        if (stitchContent == null) {
            stitchContent = false;
        }
        if ((region = checkSettingsInternal.getTargetRegion()) == null) {
            return stitchContent != false ? FULL_PAGE : VIEWPORT;
        }
        if (region != null) {
            return REGION;
        }
        if (stitchContent.booleanValue()) {
            return FULL_SELECTOR;
        }
        return SELECTOR;
    }

    public Map<String, String> getScriptHooks() {
        return this.scriptHooks;
    }

    @Deprecated
    public SeleniumCheckSettings scriptHook(String hook) {
        return this.beforeRenderScreenshotHook(hook);
    }

    public SeleniumCheckSettings beforeRenderScreenshotHook(String hook) {
        SeleniumCheckSettings clone = this.clone();
        clone.scriptHooks.put("beforeCaptureScreenshot", hook);
        return clone;
    }

    public SeleniumCheckSettings ignoreDisplacements(boolean ignoreDisplacements) {
        SeleniumCheckSettings clone = this.clone();
        clone.ignoreDisplacements = ignoreDisplacements;
        return clone;
    }

    public SeleniumCheckSettings ignoreDisplacements() {
        return this.ignoreDisplacements(true);
    }

    public SeleniumCheckSettings accessibility(By regionSelector, AccessibilityRegionType regionType) {
        SeleniumCheckSettings clone = this.clone();
        clone.accessibility_((GetRegion)new AccessibilityRegionBySelector(regionSelector, regionType));
        return clone;
    }

    public SeleniumCheckSettings accessibility(WebElement element, AccessibilityRegionType regionType) {
        SeleniumCheckSettings clone = this.clone();
        clone.accessibility((GetRegion)new AccessibilityRegionByElement(element, regionType));
        return clone;
    }

    public SeleniumCheckSettings accessibility(AccessibilityRegionType regionType, WebElement[] elementsToIgnore) {
        SeleniumCheckSettings clone = this.clone();
        for (WebElement element : elementsToIgnore) {
            clone.accessibility((GetRegion)new AccessibilityRegionByElement(element, regionType));
        }
        return clone;
    }

    public Boolean isDefaultLayoutBreakpointsSet() {
        return super.isDefaultLayoutBreakpointsSet();
    }

    public SeleniumCheckSettings layoutBreakpoints(Boolean shouldSet) {
        return (SeleniumCheckSettings)super.layoutBreakpoints(shouldSet);
    }

    public SeleniumCheckSettings layoutBreakpoints(Integer ... breakpoints) {
        return (SeleniumCheckSettings)super.layoutBreakpoints(breakpoints);
    }

    public SeleniumCheckSettings layoutBreakpoints(int[] breakpoints) {
        return (SeleniumCheckSettings)super.layoutBreakpoints(breakpoints);
    }

    public SeleniumCheckSettings layoutBreakpoints(LayoutBreakpointsOptions layoutBreakpointsOptions) {
        return (SeleniumCheckSettings)super.layoutBreakpoints(layoutBreakpointsOptions);
    }

    public List<Integer> getLayoutBreakpoints() {
        return super.getLayoutBreakpoints();
    }

    public LayoutBreakpointsOptions getLayoutBreakpointsOptions() {
        return super.getLayoutBreakpointsOptions();
    }

    @Deprecated
    public PositionProvider getStepPositionProvider() {
        return null;
    }

    public SeleniumCheckSettings lazyLoad() {
        return (SeleniumCheckSettings)super.lazyLoad();
    }

    public SeleniumCheckSettings lazyLoad(LazyLoadOptions lazyLoadOptions) {
        return (SeleniumCheckSettings)super.lazyLoad(lazyLoadOptions);
    }

    public LazyLoadOptions getLazyLoadOptions() {
        return super.getLazyLoadOptions();
    }

    public SeleniumCheckSettings densityMetrics(int xDpi, int yDpi) {
        return (SeleniumCheckSettings)super.densityMetrics(xDpi, yDpi);
    }

    public SeleniumCheckSettings densityMetrics(int xDpi, int yDpi, Double scaleRatio) {
        return (SeleniumCheckSettings)super.densityMetrics(xDpi, yDpi, scaleRatio);
    }

    public SeleniumCheckSettings stitchOverlap(Integer overlap) {
        return (SeleniumCheckSettings)super.stitchOverlap(overlap);
    }

    public SeleniumCheckSettings stitchOverlap(StitchOverlap stitchOverlap) {
        return (SeleniumCheckSettings)super.stitchOverlap(stitchOverlap);
    }

    public SeleniumCheckSettings hideCaret(Boolean hideCaret) {
        return (SeleniumCheckSettings)super.hideCaret(hideCaret);
    }

    public SeleniumCheckSettings hideScrollBars(Boolean hideScrollBars) {
        return (SeleniumCheckSettings)super.hideScrollBars(hideScrollBars);
    }

    public SeleniumCheckSettings stitchMode(StitchMode stitchMode) {
        return (SeleniumCheckSettings)super.stitchMode(stitchMode);
    }

    @Override
    public TargetPathLocator getTargetPathLocator() {
        return this.targetLocator;
    }

    @Deprecated
    public SeleniumCheckSettings setHideCaret(Boolean hideCaret) {
        return this.hideCaret(hideCaret);
    }

    @Deprecated
    public SeleniumCheckSettings setHideScrollBars(Boolean hideScrollBars) {
        return this.hideScrollBars(hideScrollBars);
    }
}

