/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AutProxySettings;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.Logger;
import com.applitools.eyes.exceptions.StaleElementReferenceException;
import com.applitools.eyes.selenium.SeleniumRunnerSettings;
import com.applitools.eyes.settings.EyesManagerSettings;
import com.applitools.eyes.universal.ManagerType;
import com.applitools.eyes.universal.settings.RunnerSettings;
import com.applitools.eyes.visualgrid.services.RunnerOptions;
import com.applitools.utils.ArgumentGuard;

public class VisualGridRunner
extends EyesRunner {
    static final int DEFAULT_CONCURRENCY = 5;
    private boolean isDisabled;
    private RunnerOptions runnerOptions;
    private static final SeleniumRunnerSettings runnerSettings = new SeleniumRunnerSettings();

    public VisualGridRunner() {
        this(Thread.currentThread().getStackTrace()[2].getClassName());
    }

    public VisualGridRunner(String suiteName) {
        this(new RunnerOptions().testConcurrency(5));
    }

    public VisualGridRunner(int testConcurrency) {
        this(testConcurrency, Thread.currentThread().getStackTrace()[2].getClassName());
    }

    public VisualGridRunner(int testConcurrency, String suiteName) {
        super((RunnerSettings)runnerSettings);
        this.runnerOptions = new RunnerOptions().testConcurrency(testConcurrency);
        EyesManagerSettings managerSettings = new EyesManagerSettings(null, Integer.valueOf(testConcurrency), null);
        this.managerRef = this.commandExecutor.coreMakeManager(ManagerType.VISUAL_GRID.value, managerSettings);
    }

    public VisualGridRunner(RunnerOptions runnerOptions) {
        this(runnerOptions, Thread.currentThread().getStackTrace()[2].getClassName());
    }

    public VisualGridRunner(RunnerOptions runnerOptions, String suiteName) {
        super((RunnerSettings)runnerSettings, runnerOptions);
        this.runnerOptions = runnerOptions;
        int testConcurrency = runnerOptions.getTestConcurrency() == null ? 5 : runnerOptions.getTestConcurrency();
        EyesManagerSettings managerSettings = new EyesManagerSettings(Integer.valueOf(testConcurrency), null, null);
        this.managerRef = this.commandExecutor.coreMakeManager(ManagerType.VISUAL_GRID.value, managerSettings);
    }

    protected VisualGridRunner(RunnerSettings runnerSettings) {
        super(runnerSettings);
        this.runnerOptions = new RunnerOptions().testConcurrency(5);
        EyesManagerSettings managerSettings = new EyesManagerSettings(Integer.valueOf(5), null, null);
        this.managerRef = this.commandExecutor.coreMakeManager(ManagerType.VISUAL_GRID.value, managerSettings);
    }

    protected VisualGridRunner(int testConcurrency, RunnerSettings runnerSettings) {
        super(runnerSettings);
        this.runnerOptions = new RunnerOptions().testConcurrency(testConcurrency);
        EyesManagerSettings managerSettings = new EyesManagerSettings(null, Integer.valueOf(testConcurrency), null);
        this.managerRef = this.commandExecutor.coreMakeManager(ManagerType.VISUAL_GRID.value, managerSettings);
    }

    protected VisualGridRunner(RunnerSettings runnerSettings, RunnerOptions runnerOptions) {
        super(runnerSettings);
        ArgumentGuard.notNull((Object)runnerOptions, (String)"runnerOptions");
        this.runnerOptions = runnerOptions;
        int testConcurrency = runnerOptions.getTestConcurrency() == null ? 5 : runnerOptions.getTestConcurrency();
        EyesManagerSettings managerSettings = new EyesManagerSettings(Integer.valueOf(testConcurrency), null, null);
        this.managerRef = this.commandExecutor.coreMakeManager(ManagerType.VISUAL_GRID.value, managerSettings);
    }

    public StaleElementReferenceException getStaleElementException() {
        return new com.applitools.eyes.selenium.exceptions.StaleElementReferenceException();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        if (proxySettings != null) {
            this.runnerOptions = this.runnerOptions.proxy(proxySettings);
        }
    }

    public void setAutProxy(AutProxySettings autProxy) {
        this.runnerOptions = this.runnerOptions.autProxy(autProxy);
    }

    public AutProxySettings getAutProxy() {
        return this.runnerOptions.getAutProxy();
    }

    public AbstractProxySettings getProxy() {
        return this.runnerOptions.getProxy();
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }
}

