/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.universal.mapper;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AccessibilitySettings;
import com.applitools.eyes.AutProxySettings;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.ContentInset;
import com.applitools.eyes.options.LayoutBreakpointsOptions;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.universal.mapper.CodedRegionReferenceMapper;
import com.applitools.eyes.selenium.universal.mapper.ContextReferenceMapper;
import com.applitools.eyes.selenium.universal.mapper.TAccessibilityRegionMapper;
import com.applitools.eyes.selenium.universal.mapper.TDynamicRegionMapper;
import com.applitools.eyes.selenium.universal.mapper.TFloatingRegionMapper;
import com.applitools.eyes.selenium.universal.mapper.TRegionMapper;
import com.applitools.eyes.universal.dto.CheckSettingsDto;
import com.applitools.eyes.universal.dto.DebugScreenshotHandlerDto;
import com.applitools.eyes.universal.dto.ICut;
import com.applitools.eyes.universal.mapper.AccessibilitySettingsMapper;
import com.applitools.eyes.universal.mapper.LayoutBreakpointsMapper;
import com.applitools.eyes.universal.mapper.ProxyMapper;
import com.applitools.eyes.universal.mapper.SettingsMapper;
import com.applitools.eyes.universal.mapper.VisualGridOptionMapper;
import java.util.Arrays;
import java.util.List;

public class CheckSettingsMapper {
    public static CheckSettingsDto toCheckSettingsDtoV3(ICheckSettings checkSettings, Configuration config) {
        if (!(checkSettings instanceof SeleniumCheckSettings)) {
            return null;
        }
        SeleniumCheckSettings seleniumCheckSettings = (SeleniumCheckSettings)checkSettings;
        CheckSettingsDto checkSettingsDto = new CheckSettingsDto();
        checkSettingsDto.setRegion(TRegionMapper.toTRegionFromCheckSettings(checkSettings));
        checkSettingsDto.setFrames(ContextReferenceMapper.toContextReferenceDtoList(seleniumCheckSettings.getFrameChain()));
        checkSettingsDto.setFully(seleniumCheckSettings.getStitchContent());
        checkSettingsDto.setScrollRootElement(TRegionMapper.toTRegionDtoFromScrolls(seleniumCheckSettings.getScrollRootSelector(), seleniumCheckSettings.getScrollRootElement()));
        checkSettingsDto.setStitchMode(seleniumCheckSettings.getStitchMode() != null ? seleniumCheckSettings.getStitchMode().getName() : (config.getStitchMode() != null ? config.getStitchMode().getName() : null));
        checkSettingsDto.setHideScrollbars(seleniumCheckSettings.getHideScrollBars());
        checkSettingsDto.setHideCaret(seleniumCheckSettings.getHideCaret());
        checkSettingsDto.setOverlap(seleniumCheckSettings.getStitchOverlap());
        checkSettingsDto.setWaitBeforeCapture(seleniumCheckSettings.getWaitBeforeCapture());
        checkSettingsDto.setLazyLoad(seleniumCheckSettings.getLazyLoadOptions());
        checkSettingsDto.setIgnoreDisplacements(seleniumCheckSettings.isIgnoreDisplacements());
        checkSettingsDto.setNormalization(SettingsMapper.toNormalizationDto((ICut)SettingsMapper.toImageCropRect((CutProvider)config.getCutProvider(), (ContentInset)config.getContentInset()), (Integer)config.getRotation(), (Double)config.getScaleRatio()));
        checkSettingsDto.setDebugImages(new DebugScreenshotHandlerDto(config.getSaveDebugScreenshots(), config.getDebugScreenshotsPath(), config.getDebugScreenshotsPrefix()));
        checkSettingsDto.setName(seleniumCheckSettings.getName());
        checkSettingsDto.setPageId(seleniumCheckSettings.getPageId());
        checkSettingsDto.setIgnoreRegions(CodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(seleniumCheckSettings.getIgnoreRegions())));
        checkSettingsDto.setLayoutRegions(CodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(seleniumCheckSettings.getLayoutRegions())));
        checkSettingsDto.setStrictRegions(CodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(seleniumCheckSettings.getStrictRegions())));
        checkSettingsDto.setContentRegions(CodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(seleniumCheckSettings.getContentRegions())));
        checkSettingsDto.setFloatingRegions(TFloatingRegionMapper.toTFloatingRegionDtoList(Arrays.asList(seleniumCheckSettings.getFloatingRegions())));
        checkSettingsDto.setAccessibilityRegions(TAccessibilityRegionMapper.toTAccessibilityRegionDtoList(Arrays.asList(seleniumCheckSettings.getAccessibilityRegions())));
        checkSettingsDto.setAccessibilitySettings(AccessibilitySettingsMapper.toAccessibilitySettingsDto((AccessibilitySettings)((SeleniumCheckSettings)checkSettings).getAccessibilityValidation()));
        checkSettingsDto.setDynamicRegions(TDynamicRegionMapper.toTDynamicRegionDtoList(Arrays.asList(seleniumCheckSettings.getDynamicRegions())));
        checkSettingsDto.setMatchLevel(seleniumCheckSettings.getMatchLevel() == null ? null : seleniumCheckSettings.getMatchLevel().getName());
        checkSettingsDto.setRetryTimeout(config.getMatchTimeout());
        checkSettingsDto.setSendDom(seleniumCheckSettings.isSendDom());
        checkSettingsDto.setUseDom(seleniumCheckSettings.isUseDom());
        checkSettingsDto.setEnablePatterns(seleniumCheckSettings.isEnablePatterns());
        checkSettingsDto.setIgnoreCaret(seleniumCheckSettings.getIgnoreCaret());
        checkSettingsDto.setUfgOptions(VisualGridOptionMapper.toVisualGridOptionDtoList((List)seleniumCheckSettings.getVisualGridOptions()));
        checkSettingsDto.setLayoutBreakpoints(LayoutBreakpointsMapper.toLayoutBreakpointsDto((LayoutBreakpointsOptions)seleniumCheckSettings.getLayoutBreakpointsOptions()));
        checkSettingsDto.setDisableBrowserFetching(seleniumCheckSettings.isDisableBrowserFetching());
        checkSettingsDto.setAutProxy(ProxyMapper.toAutProxyDto((AutProxySettings)config.getAutProxy()));
        checkSettingsDto.setHooks(seleniumCheckSettings.getScriptHooks());
        checkSettingsDto.setUserCommandId(seleniumCheckSettings.getVariationGroupId());
        checkSettingsDto.setDensityMetrics(seleniumCheckSettings.getDensityMetrics());
        return checkSettingsDto;
    }
}

