/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.universal.mapper;

import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.selenium.fluent.SimpleRegionByElement;
import com.applitools.eyes.selenium.fluent.SimpleRegionBySelector;
import com.applitools.eyes.selenium.fluent.SimpleRegionByTargetPathLocator;
import com.applitools.eyes.selenium.universal.dto.ElementRegionDto;
import com.applitools.eyes.selenium.universal.dto.TargetPathLocatorDto;
import com.applitools.eyes.selenium.universal.mapper.ElementRegionMapper;
import com.applitools.eyes.selenium.universal.mapper.SelectorRegionMapper;
import com.applitools.eyes.selenium.universal.mapper.TargetPathLocatorMapper;
import com.applitools.eyes.universal.dto.CodedRegionReference;
import com.applitools.eyes.universal.dto.RectangleRegionDto;
import com.applitools.eyes.universal.dto.SelectorRegionDto;
import com.applitools.eyes.universal.dto.TRegion;
import com.applitools.eyes.universal.mapper.RectangleRegionMapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CodedRegionReferenceMapper {
    public static CodedRegionReference toCodedRegionReference(GetRegion getSimpleRegion) {
        if (getSimpleRegion == null) {
            return null;
        }
        CodedRegionReference codedRegionReference = new CodedRegionReference();
        if (getSimpleRegion instanceof SimpleRegionByRectangle) {
            SimpleRegionByRectangle simpleRegionByRectangle = (SimpleRegionByRectangle)getSimpleRegion;
            RectangleRegionDto region = RectangleRegionMapper.toRectangleRegionDto((Region)simpleRegionByRectangle.getRegion());
            codedRegionReference.setRegion((TRegion)region);
            codedRegionReference.setRegionId(simpleRegionByRectangle.getRegion().getRegionId());
            codedRegionReference.setPadding(simpleRegionByRectangle.getPadding());
        } else if (getSimpleRegion instanceof SimpleRegionByElement) {
            SimpleRegionByElement simpleRegionByElement = (SimpleRegionByElement)getSimpleRegion;
            ElementRegionDto region = ElementRegionMapper.toElementRegionDto(simpleRegionByElement.getElement());
            codedRegionReference.setRegion((TRegion)region);
            codedRegionReference.setRegionId(simpleRegionByElement.getRegionId());
            codedRegionReference.setPadding(simpleRegionByElement.getPadding());
        } else if (getSimpleRegion instanceof SimpleRegionBySelector) {
            SimpleRegionBySelector simpleRegionBySelector = (SimpleRegionBySelector)getSimpleRegion;
            SelectorRegionDto region = SelectorRegionMapper.toSelectorRegionDto(simpleRegionBySelector.getSelector());
            codedRegionReference.setRegion((TRegion)region);
            codedRegionReference.setRegionId(simpleRegionBySelector.getRegionId());
            codedRegionReference.setPadding(simpleRegionBySelector.getPadding());
        } else if (getSimpleRegion instanceof SimpleRegionByTargetPathLocator) {
            SimpleRegionByTargetPathLocator simpleRegionByTargetPathLocator = (SimpleRegionByTargetPathLocator)getSimpleRegion;
            TargetPathLocatorDto region = TargetPathLocatorMapper.toTargetPathLocatorDto(simpleRegionByTargetPathLocator.getTargetPathLocator());
            codedRegionReference.setRegion((TRegion)region);
            codedRegionReference.setRegionId(simpleRegionByTargetPathLocator.getRegionId());
            codedRegionReference.setPadding(simpleRegionByTargetPathLocator.getPadding());
        }
        return codedRegionReference;
    }

    public static List<CodedRegionReference> toCodedRegionReferenceList(List<GetRegion> getSimpleRegionList) {
        if (getSimpleRegionList == null || getSimpleRegionList.isEmpty()) {
            return null;
        }
        return getSimpleRegionList.stream().filter(Objects::nonNull).map(CodedRegionReferenceMapper::toCodedRegionReference).collect(Collectors.toList());
    }
}

