/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.universal.mapper;

import com.applitools.eyes.Region;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.locators.OcrRegion;
import com.applitools.eyes.selenium.universal.mapper.ElementRegionMapper;
import com.applitools.eyes.selenium.universal.mapper.SelectorRegionMapper;
import com.applitools.eyes.universal.dto.OCRExtractSettingsDto;
import com.applitools.eyes.universal.dto.TRegion;
import com.applitools.eyes.universal.mapper.RectangleRegionMapper;
import java.util.List;
import java.util.stream.Collectors;

public class OCRExtractSettingsDtoMapper {
    public static OCRExtractSettingsDto toOCRExtractSettingsDto(BaseOcrRegion baseOcrRegion) {
        if (!(baseOcrRegion instanceof OcrRegion)) {
            return null;
        }
        OcrRegion ocrRegion = (OcrRegion)baseOcrRegion;
        OCRExtractSettingsDto ocrExtractSettingsDto = new OCRExtractSettingsDto();
        if (ocrRegion.getSelector() != null) {
            ocrExtractSettingsDto.setRegion((TRegion)SelectorRegionMapper.toSelectorRegionDto(ocrRegion.getSelector()));
        } else if (ocrRegion.getElement() != null) {
            ocrExtractSettingsDto.setRegion((TRegion)ElementRegionMapper.toElementRegionDto(ocrRegion.getElement()));
        } else if (ocrRegion.getRegion() != null) {
            ocrExtractSettingsDto.setRegion((TRegion)RectangleRegionMapper.toRectangleRegionDto((Region)ocrRegion.getRegion()));
        }
        ocrExtractSettingsDto.setHint(ocrRegion.getHint());
        ocrExtractSettingsDto.setMinMatch(ocrRegion.getMinMatch());
        ocrExtractSettingsDto.setLanguage(ocrRegion.getLanguage());
        return ocrExtractSettingsDto;
    }

    public static List<OCRExtractSettingsDto> toOCRExtractSettingsDtoList(List<BaseOcrRegion> baseOcrRegionList) {
        if (baseOcrRegionList == null || baseOcrRegionList.isEmpty()) {
            return null;
        }
        return baseOcrRegionList.stream().map(OCRExtractSettingsDtoMapper::toOCRExtractSettingsDto).collect(Collectors.toList());
    }
}

