/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.dom;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.dom.ScriptExecutor;
import com.applitools.eyes.dom.ScriptResponse;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class DomScriptUtils {
    private static final long DOM_EXTRACTION_TIMEOUT = 300000L;
    private static final String DOM_SCRIPTS_WRAPPER = "return (%s)(%s);";
    private static final String DS_PROCESS_PAGE;
    private static final String DS_PROCESS_PAGE_FOR_IE;
    private static final String DS_POLL_RESULT;
    private static final String DS_POLL_RESULT_FOR_IE;
    private static final String CAPTURE_DOM;
    private static final String CAPTURE_DOM_FOR_IE;
    private static final String POLL_RESULT;
    private static final String POLL_RESULT_FOR_IE;

    public static FrameData runDomSnapshot(Logger logger, ScriptExecutor executor, Set<String> testIds, UserAgent userAgent, final boolean shouldSerializeResource, final boolean disableBrowserFetching) throws Exception {
        String domScript = userAgent.isInternetExplorer() ? DS_PROCESS_PAGE_FOR_IE : DS_PROCESS_PAGE;
        String pollingScript = userAgent.isInternetExplorer() ? DS_POLL_RESULT_FOR_IE : DS_POLL_RESULT;
        HashMap<String, Object> arguments = new HashMap<String, Object>(){
            {
                this.put("serializeResources", shouldSerializeResource);
                this.put("dontFetchResources", disableBrowserFetching);
            }
        };
        String result = DomScriptUtils.runDomScript(logger, executor, userAgent, testIds, domScript, (Map<String, Object>)arguments, pollingScript);
        return (FrameData)GeneralUtils.parseJsonToObject((String)result, FrameData.class);
    }

    public static String runDomCapture(Logger logger, ScriptExecutor executor, Set<String> testIds, UserAgent userAgent) throws Exception {
        String domScript = userAgent.isInternetExplorer() ? CAPTURE_DOM_FOR_IE : CAPTURE_DOM;
        String pollingScript = userAgent.isInternetExplorer() ? POLL_RESULT_FOR_IE : POLL_RESULT;
        String result = DomScriptUtils.runDomScript(logger, executor, userAgent, testIds, domScript, null, pollingScript);
        return (String)GeneralUtils.parseJsonToObject((String)result, String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runDomScript(Logger logger, ScriptExecutor executor, UserAgent userAgent, Set<String> testIds, String domScript, Map<String, Object> domScriptArguments, String pollingScript) throws Exception {
        if (domScriptArguments == null) {
            domScriptArguments = new HashMap<String, Object>();
        }
        HashMap<String, Integer> pollingScriptArguments = new HashMap<String, Integer>();
        int chunkByteLength = userAgent.getOS().toLowerCase().contains("ios") ? 0xA00000 : 0xF000000;
        domScriptArguments.put("chunkByteLength", chunkByteLength);
        pollingScriptArguments.put("chunkByteLength", chunkByteLength);
        ObjectMapper mapper = new ObjectMapper();
        String domScriptWrapped = String.format(DOM_SCRIPTS_WRAPPER, domScript, mapper.writeValueAsString(domScriptArguments));
        String pollingScriptWrapped = String.format(DOM_SCRIPTS_WRAPPER, pollingScript, mapper.writeValueAsString(pollingScriptArguments));
        AtomicBoolean isCheckTimerTimedOut = new AtomicBoolean(false);
        Timer timer = new Timer("VG_Check_StopWatch", true);
        timer.schedule((TimerTask)new TimeoutTask(isCheckTimerTimedOut), 300000L);
        try {
            String resultAsString = (String)executor.execute(domScriptWrapped);
            ScriptResponse scriptResponse = (ScriptResponse)GeneralUtils.parseJsonToObject((String)resultAsString, ScriptResponse.class);
            ScriptResponse.Status status = scriptResponse.getStatus();
            logger.log(TraceLevel.Info, testIds, Stage.CHECK, Type.DOM_SCRIPT, "Starting dom script");
            while (status == ScriptResponse.Status.WIP && !isCheckTimerTimedOut.get()) {
                resultAsString = (String)executor.execute(pollingScriptWrapped);
                scriptResponse = (ScriptResponse)GeneralUtils.parseJsonToObject((String)resultAsString, ScriptResponse.class);
                status = scriptResponse.getStatus();
                Thread.sleep(200L);
            }
            if (status == ScriptResponse.Status.ERROR) {
                throw new EyesException("DomSnapshot Error: " + scriptResponse.getError());
            }
            if (isCheckTimerTimedOut.get()) {
                throw new EyesException("Domsnapshot Timed out");
            }
            if (status == ScriptResponse.Status.SUCCESS) {
                String string = scriptResponse.getValue().toString();
                return string;
            }
            logger.log(TraceLevel.Info, testIds, Stage.CHECK, Type.DOM_SCRIPT, "Collecting chunks");
            StringBuilder value = new StringBuilder();
            while (status == ScriptResponse.Status.SUCCESS_CHUNKED && !scriptResponse.isDone() && !isCheckTimerTimedOut.get()) {
                value.append((String)GeneralUtils.parseJsonToObject((String)scriptResponse.getValue().toString(), String.class));
                resultAsString = (String)executor.execute(pollingScriptWrapped);
                scriptResponse = (ScriptResponse)GeneralUtils.parseJsonToObject((String)resultAsString, ScriptResponse.class);
                status = scriptResponse.getStatus();
                Thread.sleep(200L);
            }
            if (status == ScriptResponse.Status.ERROR) {
                throw new EyesException("DomSnapshot Error: " + scriptResponse.getError());
            }
            if (isCheckTimerTimedOut.get()) {
                throw new EyesException("Domsnapshot Timed out");
            }
            value.append((String)GeneralUtils.parseJsonToObject((String)scriptResponse.getValue().toString(), String.class));
            String string = value.toString();
            return string;
        }
        finally {
            timer.cancel();
            logger.log(TraceLevel.Info, testIds, Stage.CHECK, Type.DOM_SCRIPT, "Finished dom script");
        }
    }

    static {
        try {
            DS_PROCESS_PAGE = GeneralUtils.readInputStreamAsString((InputStream)DomScriptUtils.class.getResourceAsStream("/node_modules/@applitools/dom-snapshot/dist/processPagePoll.js"));
            DS_PROCESS_PAGE_FOR_IE = GeneralUtils.readInputStreamAsString((InputStream)DomScriptUtils.class.getResourceAsStream("/node_modules/@applitools/dom-snapshot/dist/processPagePollForIE.js"));
            DS_POLL_RESULT = GeneralUtils.readInputStreamAsString((InputStream)DomScriptUtils.class.getResourceAsStream("/node_modules/@applitools/dom-snapshot/dist/pollResult.js"));
            DS_POLL_RESULT_FOR_IE = GeneralUtils.readInputStreamAsString((InputStream)DomScriptUtils.class.getResourceAsStream("/node_modules/@applitools/dom-snapshot/dist/pollResultForIE.js"));
            CAPTURE_DOM = GeneralUtils.readInputStreamAsString((InputStream)DomScriptUtils.class.getResourceAsStream("/node_modules/@applitools/dom-capture/dist/captureDomAndPoll.js"));
            CAPTURE_DOM_FOR_IE = GeneralUtils.readInputStreamAsString((InputStream)DomScriptUtils.class.getResourceAsStream("/node_modules/@applitools/dom-capture/dist/captureDomAndPollForIE.js"));
            POLL_RESULT = GeneralUtils.readInputStreamAsString((InputStream)DomScriptUtils.class.getResourceAsStream("/node_modules/@applitools/dom-capture/dist/pollResult.js"));
            POLL_RESULT_FOR_IE = GeneralUtils.readInputStreamAsString((InputStream)DomScriptUtils.class.getResourceAsStream("/node_modules/@applitools/dom-capture/dist/pollResultForIE.js"));
        }
        catch (IOException e) {
            throw new EyesException("Failed getting resources for dom scripts", (Throwable)e);
        }
    }

    private static class TimeoutTask
    extends TimerTask {
        private final AtomicBoolean isCheckTimerTimedOut;

        public TimeoutTask(AtomicBoolean isCheckTimerTimedOut) {
            this.isCheckTimerTimedOut = isCheckTimerTimedOut;
        }

        @Override
        public void run() {
            this.isCheckTimerTimedOut.set(true);
        }
    }
}

