/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.connectivity.Cookie;
import com.applitools.connectivity.UfgConnector;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.visualgrid.model.BlobData;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.NullDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RGridDom;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.tuple.Pair;

public class DomAnalyzer {
    private final Logger logger;
    private boolean isRunning = true;
    final UfgConnector defaultConnector;
    final UfgConnector customConnector;
    private final List<String> domainsForCustomConnector;
    private final IDebugResourceWriter debugResourceWriter;
    private final FrameData domData;
    private final UserAgent userAgent;
    private final TaskListener<Map<String, RGridResource>> listener;
    final Map<String, RGridResource> cachedResources;
    private final Set<String> domResources = Collections.synchronizedSet(new HashSet());
    private final ExecutorService executor;
    final List<Pair<FrameData, RGridResource>> resourcesToParse = Collections.synchronizedList(new ArrayList());
    final List<Pair<FrameData, URI>> resourcesToDownload = Collections.synchronizedList(new ArrayList());
    private final Set<String> resourcesInDownloadProcess = Collections.synchronizedSet(new HashSet());
    private final Set<String> resourcesInParseProcess = Collections.synchronizedSet(new HashSet());

    public DomAnalyzer(Logger logger, UfgConnector defaultConnector, UfgConnector customConnector, String[] domainsForCustomConnector, IDebugResourceWriter resourceWriter, FrameData domData, Map<String, RGridResource> cachedResources, TaskListener<Map<String, RGridResource>> listener) {
        this.logger = logger;
        this.defaultConnector = defaultConnector;
        this.customConnector = customConnector;
        this.domainsForCustomConnector = domainsForCustomConnector == null ? new ArrayList() : Arrays.asList(domainsForCustomConnector);
        this.debugResourceWriter = resourceWriter;
        this.domData = domData;
        this.cachedResources = cachedResources;
        this.userAgent = domData.getUserAgent();
        this.listener = listener;
        this.executor = Executors.newFixedThreadPool(15);
        for (int i = 0; i < 15; ++i) {
            this.executor.submit(new ResourceParser());
        }
        this.writeFrameDataAsResource();
        this.parseScriptResult(domData);
        System.gc();
        this.logResourcesToDownload();
        logger.log(TraceLevel.Info, domData.getTestIds(), Stage.RESOURCE_COLLECTION, null, "dom analyzer created");
    }

    private boolean tryComplete() {
        if (this.resourcesToParse.isEmpty() && this.resourcesToDownload.isEmpty() && this.resourcesInDownloadProcess.isEmpty() && this.resourcesInParseProcess.isEmpty()) {
            this.notifyResourceMap();
            this.isRunning = false;
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)new TimeoutException("Parsing threads didn't finish on time"), (String[])this.domData.getTestIds().toArray(new String[0]));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public boolean run() {
        try {
            this.fetchAllResources();
            return this.tryComplete();
        }
        catch (Throwable t) {
            this.isRunning = false;
            this.executor.shutdown();
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)t, (String[])this.domData.getTestIds().toArray(new String[0]));
            this.listener.onFail();
            return true;
        }
    }

    private void writeFrameDataAsResource() {
        if (this.debugResourceWriter == null || this.debugResourceWriter instanceof NullDebugResourceWriter) {
            return;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            byte[] content = objectMapper.writeValueAsBytes((Object)this.domData);
            RGridResource resource = new RGridResource(this.domData.getUrl(), "x-applitools-html/cdt", content);
            this.debugResourceWriter.write(resource);
        }
        catch (JsonProcessingException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])this.domData.getTestIds().toArray(new String[0]));
        }
    }

    private void parseScriptResult(FrameData domData) {
        Base64 codec = new Base64();
        String baseUrlStr = domData.getUrl();
        baseUrlStr = GeneralUtils.sanitizeURL((String)baseUrlStr);
        URI baseUrl = null;
        try {
            baseUrl = new URI(baseUrlStr);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])domData.getTestIds().toArray(new String[0]));
        }
        Set<String> newBlobsUrls = this.parseBlobs(codec, baseUrl, domData.getBlobs());
        this.parseResourceUrls(domData, baseUrl);
        this.parseFrames(domData);
        this.parseAndCollectExternalResources(domData, newBlobsUrls);
    }

    private void parseFrames(FrameData frameData) {
        for (FrameData frameObj : frameData.getFrames()) {
            this.parseScriptResult(frameObj);
        }
    }

    private void parseResourceUrls(FrameData result, URI baseUrl) {
        ArrayList<String> sanitizedUrls = new ArrayList<String>();
        for (String url : result.getResourceUrls()) {
            try {
                url = GeneralUtils.sanitizeURL((String)url);
                sanitizedUrls.add(url);
                this.addResourceToDownload(result, baseUrl.resolve(url));
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])this.domData.getTestIds().toArray(new String[0]));
            }
        }
        result.setResourceUrls(sanitizedUrls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> parseBlobs(Base64 codec, URI baseUrl, List<BlobData> resources) {
        HashSet<String> newBlobUrls = new HashSet<String>();
        for (BlobData blob : resources) {
            String sanitizedURL = GeneralUtils.sanitizeURL((String)blob.getUrl());
            blob.setUrl(sanitizedURL);
            RGridResource resource = this.parseBlobToGridResource(codec, baseUrl, blob);
            blob.clearContent();
            this.domResources.add(resource.getUrl());
            newBlobUrls.add(resource.getUrl());
            Map<String, RGridResource> map = this.cachedResources;
            synchronized (map) {
                if (this.cachedResources.containsKey(resource.getUrl())) {
                    continue;
                }
                String contentType = resource.getContentType();
                if (contentType == null || !contentType.equalsIgnoreCase("x-applitools-html/cdt")) {
                    this.cachedResources.put(resource.getUrl(), resource);
                }
            }
        }
        return newBlobUrls;
    }

    private RGridResource parseBlobToGridResource(Base64 codec, URI baseUrl, BlobData blobAsMap) {
        String contentAsString = blobAsMap.getValue();
        byte[] content = codec.decode(contentAsString);
        String urlAsString = blobAsMap.getUrl();
        urlAsString = GeneralUtils.sanitizeURL((String)urlAsString);
        Integer errorStatusCode = blobAsMap.getErrorStatusCode();
        try {
            URI url = baseUrl.resolve(urlAsString);
            urlAsString = GeneralUtils.sanitizeURL((String)url.toString());
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])this.domData.getTestIds().toArray(new String[0]));
        }
        return new RGridResource(urlAsString, blobAsMap.getType(), content, errorStatusCode);
    }

    private void parseAndCollectExternalResources(FrameData frameData, Set<String> resourcesToParse) {
        for (String url : resourcesToParse) {
            RGridResource resource = this.cachedResources.get(url);
            Set<URI> newResources = resource.parse(this.logger, this.domData.getTestIds());
            this.logger.log(TraceLevel.Info, frameData.getTestIds(), Stage.RESOURCE_COLLECTION, Type.PARSE_RESOURCE, new Pair[]{Pair.of((Object)"resourceParsed", (Object)resource.getUrl()), Pair.of((Object)"baseUrl", (Object)frameData.getUrl()), Pair.of((Object)"newResources", newResources)});
            this.handleNewResources(newResources, frameData);
        }
    }

    void fetchAllResources() {
        if (this.resourcesToDownload.isEmpty()) {
            return;
        }
        this.logResourcesToDownload();
        while (!this.resourcesToDownload.isEmpty()) {
            Pair<FrameData, URI> nextInput = this.resourcesToDownload.get(0);
            final FrameData frameData = (FrameData)nextInput.getLeft();
            final URI uri = (URI)nextInput.getRight();
            String uriStr = GeneralUtils.sanitizeURL((String)uri.toString());
            if (this.cachedResources.containsKey(uriStr)) {
                RGridResource resource = this.cachedResources.get(uriStr);
                try {
                    this.debugResourceWriter.write(resource);
                }
                catch (Exception e) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])this.domData.getTestIds().toArray(new String[0]));
                }
                this.addResourceToParse(frameData, resource);
                this.resourcesToDownload.remove(0);
                continue;
            }
            this.resourcesInDownloadProcess.add(uri.toString());
            this.resourcesToDownload.remove(0);
            Set<Cookie> cookies = frameData.getCookies();
            HashSet<Cookie> cookiesToSend = new HashSet<Cookie>();
            for (Cookie cookie : cookies) {
                if (!cookie.isCookieForUrl(uri)) continue;
                cookiesToSend.add(cookie);
            }
            UfgConnector chosenConnector = this.defaultConnector;
            for (String domain : this.domainsForCustomConnector) {
                if (!uri.getHost().equals(domain) && !uri.getHost().endsWith(String.format(".%s", domain))) continue;
                chosenConnector = this.customConnector;
                break;
            }
            chosenConnector.downloadResource(uri, this.userAgent.getOriginalUserAgentString(), this.domData.getUrl(), cookiesToSend, new TaskListener<RGridResource>(){

                public void onComplete(RGridResource downloadedResource) {
                    if (downloadedResource == null) {
                        return;
                    }
                    if (!DomAnalyzer.this.cachedResources.containsKey(downloadedResource.getUrl())) {
                        DomAnalyzer.this.cachedResources.put(downloadedResource.getUrl(), downloadedResource);
                    }
                    try {
                        DomAnalyzer.this.debugResourceWriter.write(downloadedResource);
                    }
                    catch (Exception e) {
                        GeneralUtils.logExceptionStackTrace((Logger)DomAnalyzer.this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])DomAnalyzer.this.domData.getTestIds().toArray(new String[0]));
                    }
                    DomAnalyzer.this.addResourceToParse(frameData, downloadedResource);
                    DomAnalyzer.this.resourcesInDownloadProcess.remove(uri.toString());
                }

                public void onFail() {
                    DomAnalyzer.this.logger.log(TraceLevel.Error, DomAnalyzer.this.domData.getTestIds(), Stage.RESOURCE_COLLECTION, Type.DOWNLOAD_RESOURCE, new Pair[]{Pair.of((Object)"url", (Object)uri.toString())});
                    DomAnalyzer.this.resourcesInDownloadProcess.remove(uri.toString());
                    DomAnalyzer.this.listener.onFail();
                }
            });
        }
        this.logger.log(TraceLevel.Info, this.domData.getTestIds(), Stage.RESOURCE_COLLECTION, null, "fetchAllResources end");
    }

    private void handleNewResources(Set<URI> newResources, FrameData frameData) {
        for (URI uri : newResources) {
            if (!frameData.getResourceUrls().contains(uri.toString())) {
                frameData.getResourceUrls().add(uri.toString());
            }
            if (this.cachedResources.containsKey(uri.toString())) {
                this.addResourceToParse(frameData, this.cachedResources.get(uri.toString()));
                continue;
            }
            this.addResourceToDownload(frameData, uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyResourceMap() {
        HashMap<String, RGridResource> resourceMapping = new HashMap<String, RGridResource>();
        Set<String> set = this.domResources;
        synchronized (set) {
            for (String url : this.domResources) {
                RGridResource resource = this.cachedResources.get(url);
                if (resource == null) continue;
                resourceMapping.put(url, resource);
            }
        }
        this.buildAllRGDoms(resourceMapping, this.domData);
        this.logger.log(TraceLevel.Info, this.domData.getTestIds(), Stage.RESOURCE_COLLECTION, null, new Pair[]{Pair.of((Object)"resourceMap", resourceMapping)});
        this.listener.onComplete(resourceMapping);
    }

    private List<RGridResource> buildAllRGDoms(Map<String, RGridResource> resourceMapping, FrameData domData) {
        URL baseUrl = null;
        String domDataUrl = domData.getUrl();
        try {
            baseUrl = new URL(domDataUrl);
        }
        catch (MalformedURLException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])domData.getTestIds().toArray(new String[0]));
        }
        ArrayList<RGridResource> innerFrames = new ArrayList<RGridResource>();
        List<FrameData> allFrame = domData.getFrames();
        HashMap<String, RGridResource> mapping = new HashMap<String, RGridResource>();
        for (FrameData frameObj : allFrame) {
            URL frameUrl;
            List<BlobData> allFramesBlobs = frameObj.getBlobs();
            List<String> allResourceUrls = frameObj.getResourceUrls();
            try {
                frameUrl = new URL(baseUrl, frameObj.getUrl());
            }
            catch (MalformedURLException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])domData.getTestIds().toArray(new String[0]));
                continue;
            }
            for (BlobData blobData : allFramesBlobs) {
                String blobUrl = blobData.getUrl();
                RGridResource rGridResource = resourceMapping.get(blobUrl);
                mapping.put(blobUrl, rGridResource);
            }
            for (String string : allResourceUrls) {
                RGridResource rGridResource = resourceMapping.get(string);
                mapping.put(string, rGridResource);
            }
            List<RGridResource> frames = this.buildAllRGDoms(resourceMapping, frameObj);
            for (RGridResource frameResource : frames) {
                mapping.put(frameResource.getUrl(), frameResource);
            }
            List<Map<String, Object>> list = frameObj.getCdt();
            RGridDom rGridDom = new RGridDom(list, mapping, frameUrl.toString());
            try {
                RGridResource domResource = rGridDom.asResource();
                innerFrames.add(domResource);
                resourceMapping.put(frameUrl.toString(), domResource);
                this.debugResourceWriter.write(domResource);
            }
            catch (JsonProcessingException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])domData.getTestIds().toArray(new String[0]));
            }
        }
        return innerFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourceToDownload(FrameData frameData, URI uri) {
        List<Pair<FrameData, URI>> list = this.resourcesToDownload;
        synchronized (list) {
            for (Pair<FrameData, URI> resource : this.resourcesToDownload) {
                if (!((URI)resource.getRight()).equals(uri)) continue;
                return;
            }
        }
        this.resourcesToDownload.add((Pair<FrameData, URI>)Pair.of((Object)frameData, (Object)uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourceToParse(FrameData frameData, RGridResource resource) {
        List<Pair<FrameData, RGridResource>> list = this.resourcesToParse;
        synchronized (list) {
            for (Pair<FrameData, RGridResource> pair : this.resourcesToParse) {
                if (!((RGridResource)pair.getRight()).getUrl().equals(resource.getUrl())) continue;
                return;
            }
        }
        this.resourcesToParse.add((Pair<FrameData, RGridResource>)Pair.of((Object)frameData, (Object)resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logResourcesToDownload() {
        List<Pair<FrameData, URI>> list = this.resourcesToDownload;
        synchronized (list) {
            ArrayList<Object> resources = new ArrayList<Object>();
            for (Pair<FrameData, URI> resource : this.resourcesToDownload) {
                resources.add(resource.getRight());
            }
            this.logger.log(TraceLevel.Info, this.domData.getTestIds(), Stage.RESOURCE_COLLECTION, null, new Pair[]{Pair.of((Object)"resourcesToDownload", resources)});
        }
    }

    private class ResourceParser
    implements Runnable {
        private ResourceParser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DomAnalyzer.this.isRunning) {
                Pair<FrameData, RGridResource> nextInput;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (DomAnalyzer.this.resourcesToParse.isEmpty()) continue;
                List<Pair<FrameData, RGridResource>> list = DomAnalyzer.this.resourcesToParse;
                synchronized (list) {
                    DomAnalyzer.this.resourcesInParseProcess.add(((RGridResource)DomAnalyzer.this.resourcesToParse.get(0).getRight()).getUrl());
                    nextInput = DomAnalyzer.this.resourcesToParse.remove(0);
                }
                FrameData frameData = (FrameData)nextInput.getLeft();
                RGridResource resource = (RGridResource)nextInput.getRight();
                DomAnalyzer.this.domResources.add(resource.getUrl());
                Set<URI> newResources = resource.parse(DomAnalyzer.this.logger, DomAnalyzer.this.domData.getTestIds());
                DomAnalyzer.this.logger.log(TraceLevel.Info, frameData.getTestIds(), Stage.RESOURCE_COLLECTION, Type.PARSE_RESOURCE, new Pair[]{Pair.of((Object)"resourceParsed", (Object)resource.getUrl()), Pair.of((Object)"baseUrl", (Object)frameData.getUrl()), Pair.of((Object)"newResources", newResources)});
                DomAnalyzer.this.handleNewResources(newResources, frameData);
                DomAnalyzer.this.resourcesInParseProcess.remove(resource.getUrl());
            }
        }
    }
}

