/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity;

import java.net.URI;
import java.util.Date;

public class Cookie {
    private final String name;
    private final String value;
    private final String path;
    private final String domain;
    private final boolean secure;
    private final boolean httpOnly;
    private final Date expiry;

    public Cookie(String name, String value, String path, String domain, boolean secure, boolean httpOnly, Date expiry) {
        this.name = name;
        this.value = value;
        this.path = path;
        this.domain = domain;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.expiry = expiry;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getPath() {
        return this.path;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    public boolean isExpired() {
        if (this.expiry == null) {
            return false;
        }
        return this.expiry.before(new Date());
    }

    public boolean isCookieForUrl(URI uri) {
        if (uri.getHost() == null) {
            return false;
        }
        if (this.secure && !uri.getScheme().equalsIgnoreCase("https")) {
            return false;
        }
        if (this.isExpired()) {
            return false;
        }
        boolean subDomainsAllowed = false;
        String domain = this.domain;
        if (domain.startsWith(".")) {
            subDomainsAllowed = true;
            domain = domain.substring(1);
        }
        boolean domainMatch = uri.getHost().equalsIgnoreCase(domain);
        boolean subDomainMatch = uri.getHost().endsWith(this.domain);
        if (!(domainMatch || subDomainsAllowed && subDomainMatch)) {
            return false;
        }
        String path = this.path;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return uri.getPath().equalsIgnoreCase(path) || uri.getPath().startsWith(this.path);
    }
}

