function charCodeAt(string, index = 0) {
  const code = string.charCodeAt(index);
  // if the code of high word (16 bits) in this diapason the character encoded by two words
  if (code >= 0xd800 && code < 0xdc00) {
    const high = code;
    const low = string.charCodeAt(index + 1);

    // convert 2 utf16le words into integer code
    return (high - 0xd800) * 0x400 + (low - 0xdc00) + 0x10000;
  }
  // diapason is reserved for surrogates, we can skip it
  if (0xdc00 <= code && code <= 0xdfff) return -1;
  return code;
}

function chunkify(string, chunkByteLength) {
  const chunks = [];
  let currChunkByteLength = 0;

  for (let index = 0; index < string.length; ++index) {
    const code = charCodeAt(string, index);
    let charByteLength = 0;
    if (code > 0) {
      if (code < 128) charByteLength = 1;
      else if (code < 2048) charByteLength = 2;
      else if (code < 65536) charByteLength = 3;
      else if (code < 2097152) charByteLength = 4;
      else if (code < 67108864) charByteLength = 5;
      else charByteLength = 6;
    }

    if (currChunkByteLength + charByteLength > chunkByteLength) {
      chunks.push(index);
      currChunkByteLength = charByteLength;
    } else {
      currChunkByteLength += charByteLength;
    }
  }

  return chunks;
}

module.exports = chunkify;
