/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.services;

import com.applitools.connectivity.UfgConnector;
import com.applitools.eyes.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public abstract class EyesService<INPUT, OUTPUT> {
    protected Logger logger;
    protected UfgConnector serverConnector;
    protected final List<Pair<String, INPUT>> inputQueue = new ArrayList<Pair<String, INPUT>>();
    protected final List<Pair<String, OUTPUT>> outputQueue = Collections.synchronizedList(new ArrayList());
    protected final List<Pair<String, Throwable>> errorQueue = Collections.synchronizedList(new ArrayList());

    public EyesService(Logger logger, UfgConnector serverConnector) {
        this.logger = logger;
        this.serverConnector = serverConnector;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
        this.serverConnector.setLogger(logger);
    }

    public void setServerConnector(UfgConnector serverConnector) {
        this.serverConnector = serverConnector;
    }

    public abstract void run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OUTPUT runSingleSyncTask(String id, INPUT input) throws Throwable {
        this.addInput(id, input);
        while (true) {
            this.run();
            List<Object> list = this.outputQueue;
            synchronized (list) {
                for (Pair<String, OUTPUT> pair : this.outputQueue) {
                    if (!((String)pair.getLeft()).equals(id)) continue;
                    return (OUTPUT)pair.getRight();
                }
            }
            list = this.errorQueue;
            synchronized (list) {
                for (Pair pair : this.errorQueue) {
                    if (!((String)pair.getLeft()).equals(id)) continue;
                    throw (Throwable)pair.getRight();
                }
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void addInput(String id, INPUT input) {
        this.inputQueue.add(Pair.of((Object)id, input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, OUTPUT>> getSucceededTasks() {
        List<Pair<String, OUTPUT>> list = this.outputQueue;
        synchronized (list) {
            ArrayList<Pair<String, OUTPUT>> succeededTasks = new ArrayList<Pair<String, OUTPUT>>(this.outputQueue);
            this.outputQueue.clear();
            return succeededTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, Throwable>> getFailedTasks() {
        List<Pair<String, Throwable>> list = this.errorQueue;
        synchronized (list) {
            ArrayList<Pair<String, Throwable>> failedTasks = new ArrayList<Pair<String, Throwable>>(this.errorQueue);
            this.errorQueue.clear();
            return failedTasks;
        }
    }
}

