/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.visualgrid.model.IRenderingBrowserInfo;
import com.applitools.eyes.visualgrid.model.IosDeviceName;
import com.applitools.eyes.visualgrid.model.IosVersion;
import com.applitools.eyes.visualgrid.model.ScreenOrientation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class IosDeviceInfo
implements IRenderingBrowserInfo {
    @JsonProperty(value="name")
    private final IosDeviceName deviceName;
    private final ScreenOrientation screenOrientation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final IosVersion version;
    RectangleSize size = null;

    public IosDeviceInfo(IosDeviceName deviceName) {
        this(deviceName, ScreenOrientation.PORTRAIT);
    }

    public IosDeviceInfo(IosDeviceName deviceName, ScreenOrientation screenOrientation) {
        this(deviceName, screenOrientation, null);
    }

    public IosDeviceInfo(IosDeviceName deviceName, IosVersion version) {
        this(deviceName, ScreenOrientation.PORTRAIT, version);
    }

    public IosDeviceInfo(IosDeviceName deviceName, ScreenOrientation screenOrientation, IosVersion version) {
        this.deviceName = deviceName;
        this.screenOrientation = screenOrientation;
        this.version = version;
    }

    public String getDeviceName() {
        return this.deviceName.getName();
    }

    public ScreenOrientation getScreenOrientation() {
        return this.screenOrientation;
    }

    public IosVersion getVersion() {
        return this.version;
    }

    public String toString() {
        return "IosDeviceInfo{deviceName=" + (Object)((Object)this.deviceName) + ", screenOrientation=" + (Object)((Object)this.screenOrientation) + ", version=" + (Object)((Object)this.version) + '}';
    }
}

