'use strict';

function absolutizeUrl(url, baseUrl) {
  let isEncoded = true;
  try {
    isEncoded = url !== decodeURI(url);
  } catch (err) {
    isEncoded = true;
  }
  const absoluteUrl = new URL(url, baseUrl).href;
  return !isEncoded ? decodeURI(absoluteUrl) : absoluteUrl;
}

module.exports = absolutizeUrl;
