/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.CharStream;
import com.steadystate.css.parser.CssCharStream;
import com.steadystate.css.parser.SACParserCSS3;
import com.steadystate.css.parser.SACParserCSS3TokenManager;
import com.steadystate.css.parser.Token;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.css.CSSRuleList;

public class CssTokenizer {
    private final SACParserCSS3TokenManager tokenManager;
    private Token currentToken = null;

    public CssTokenizer(String css) throws IOException {
        InputSource source = new InputSource((Reader)new StringReader(css));
        this.tokenManager = new SACParserCSS3TokenManager(this.getCharStream(source));
    }

    private CharStream getCharStream(InputSource source) throws IOException {
        if (source.getCharacterStream() != null) {
            return new CssCharStream(source.getCharacterStream(), 1, 1);
        }
        if (source.getByteStream() != null) {
            String encoding = source.getEncoding();
            InputStreamReader reader = encoding == null || encoding.length() < 1 ? new InputStreamReader(source.getByteStream(), Charset.defaultCharset()) : new InputStreamReader(source.getByteStream(), encoding);
            return new CssCharStream((Reader)reader, 1, 1);
        }
        if (source.getURI() != null) {
            InputStreamReader reader = new InputStreamReader(new URL(source.getURI()).openStream());
            return new CssCharStream((Reader)reader, 1, 1);
        }
        return null;
    }

    public Token nextToken() {
        if (this.currentToken == null) {
            this.currentToken = this.tokenManager.getNextToken();
            return this.currentToken;
        }
        if (this.currentToken.kind == 0) {
            return null;
        }
        this.currentToken = this.currentToken.next != null ? this.currentToken.next : this.tokenManager.getNextToken();
        if (this.currentToken.kind == 0) {
            return null;
        }
        return this.currentToken;
    }

    public static Set<String> getImportedUrls(String css) throws IOException {
        Token token;
        HashSet<String> resourceUrls = new HashSet<String>();
        CssTokenizer tokenizer = new CssTokenizer(css);
        boolean importRuleMet = false;
        while ((token = tokenizer.nextToken()) != null) {
            if (token.kind == 100) {
                importRuleMet = false;
                resourceUrls.add(token.image);
            }
            if (token.kind == 73) {
                importRuleMet = true;
            }
            if (!importRuleMet || token.kind != 25) continue;
            importRuleMet = false;
            resourceUrls.add(token.image);
        }
        return resourceUrls;
    }

    public static CSSRuleList getCssRules(String css) throws IOException {
        SACParserCSS3 parser = new SACParserCSS3();
        CSSOMParser cssomParser = new CSSOMParser((Parser)parser);
        return cssomParser.parseStyleSheet(new InputSource((Reader)new StringReader(css)), null, null).getCssRules();
    }
}

