/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.selenium.BrowserType;
import com.applitools.eyes.visualgrid.model.AndroidDeviceInfo;
import com.applitools.eyes.visualgrid.model.DeviceSize;
import com.applitools.eyes.visualgrid.model.EmulationBaseInfo;
import com.applitools.eyes.visualgrid.model.IRenderingBrowserInfo;
import com.applitools.eyes.visualgrid.model.IosDeviceInfo;
import com.applitools.eyes.visualgrid.model.ScreenOrientation;

public class RenderBrowserInfo
implements IRenderingBrowserInfo {
    private RectangleSize viewportSize;
    private BrowserType browserType;
    private String platform = "linux";
    private EmulationBaseInfo emulationInfo;
    private IosDeviceInfo iosDeviceInfo;
    private final String sizeMode = "full-page";
    private String baselineEnvName;
    private AndroidDeviceInfo androidDeviceInfo;

    public RenderBrowserInfo(RectangleSize viewportSize, BrowserType browserType, String baselineEnvName) {
        this.viewportSize = viewportSize;
        this.browserType = browserType;
        this.baselineEnvName = baselineEnvName;
        this.platform = this.getPlatform();
    }

    public RenderBrowserInfo(RectangleSize viewportSize, BrowserType browserType) {
        this.viewportSize = viewportSize;
        this.browserType = browserType;
        this.platform = this.getPlatform();
    }

    public RenderBrowserInfo(EmulationBaseInfo emulationInfo, String baselineEnvName) {
        this.emulationInfo = emulationInfo;
        this.baselineEnvName = baselineEnvName;
        this.browserType = BrowserType.CHROME;
        this.platform = this.getPlatform();
    }

    public RenderBrowserInfo(int width, int height) {
        this(new RectangleSize(width, height), BrowserType.CHROME, null);
    }

    public RenderBrowserInfo(EmulationBaseInfo emulationInfo) {
        this.emulationInfo = emulationInfo;
        this.browserType = BrowserType.CHROME;
        this.platform = this.getPlatform();
    }

    public RenderBrowserInfo(int width, int height, BrowserType browserType, String baselineEnvName) {
        this(new RectangleSize(width, height), browserType, baselineEnvName);
    }

    public RenderBrowserInfo(int width, int height, BrowserType browserType) {
        this(new RectangleSize(width, height), browserType, null);
    }

    public RenderBrowserInfo(IosDeviceInfo deviceInfo) {
        this.iosDeviceInfo = deviceInfo;
        this.browserType = BrowserType.SAFARI;
        this.platform = this.getPlatform();
    }

    public RenderBrowserInfo(IosDeviceInfo deviceInfo, String baselineEnvName) {
        this.iosDeviceInfo = deviceInfo;
        this.baselineEnvName = baselineEnvName;
        this.browserType = BrowserType.SAFARI;
        this.platform = this.getPlatform();
    }

    public RenderBrowserInfo(AndroidDeviceInfo deviceInfo) {
        this.androidDeviceInfo = deviceInfo;
        this.browserType = BrowserType.CHROME;
        this.platform = this.getPlatform();
    }

    public RenderBrowserInfo(AndroidDeviceInfo deviceInfo, String baselineEnvName) {
        this.androidDeviceInfo = deviceInfo;
        this.baselineEnvName = baselineEnvName;
        this.browserType = BrowserType.CHROME;
        this.platform = this.getPlatform();
    }

    public RectangleSize getDeviceSize() {
        if (this.viewportSize != null) {
            return this.viewportSize;
        }
        if (this.emulationInfo != null && this.emulationInfo.size != null) {
            return this.emulationInfo.size;
        }
        if (this.iosDeviceInfo != null && this.iosDeviceInfo.size != null) {
            return this.iosDeviceInfo.size;
        }
        if (this.androidDeviceInfo != null && this.androidDeviceInfo.size != null) {
            return this.androidDeviceInfo.size;
        }
        return RectangleSize.EMPTY;
    }

    public void setEmulationDeviceSize(DeviceSize size) {
        if (size != null && this.emulationInfo != null) {
            this.emulationInfo.size = this.emulationInfo.screenOrientation.equals((Object)ScreenOrientation.PORTRAIT) ? size.getPortrait() : size.getLandscape();
        }
    }

    public void setIosDeviceSize(DeviceSize size) {
        if (size != null && this.iosDeviceInfo != null) {
            this.iosDeviceInfo.size = this.iosDeviceInfo.getScreenOrientation().equals((Object)ScreenOrientation.PORTRAIT) ? size.getPortrait() : size.getLandscape();
        }
    }

    public int getWidth() {
        if (this.viewportSize != null) {
            return this.viewportSize.getWidth();
        }
        return 0;
    }

    public int getHeight() {
        if (this.viewportSize != null) {
            return this.viewportSize.getHeight();
        }
        return 0;
    }

    public RectangleSize getViewportSize() {
        return this.viewportSize;
    }

    public BrowserType getBrowserType() {
        return this.browserType;
    }

    public String getPlatform() {
        if (this.iosDeviceInfo != null) {
            return "ios";
        }
        if (this.androidDeviceInfo != null) {
            return "android";
        }
        if (this.browserType != null) {
            switch (this.browserType) {
                case CHROME: 
                case CHROME_ONE_VERSION_BACK: 
                case CHROME_TWO_VERSIONS_BACK: 
                case FIREFOX: 
                case FIREFOX_ONE_VERSION_BACK: 
                case FIREFOX_TWO_VERSIONS_BACK: {
                    return "linux";
                }
                case SAFARI: 
                case SAFARI_ONE_VERSION_BACK: 
                case SAFARI_TWO_VERSIONS_BACK: {
                    return "mac os x";
                }
                case IE_10: 
                case IE_11: 
                case EDGE: 
                case EDGE_LEGACY: 
                case EDGE_CHROMIUM: 
                case EDGE_CHROMIUM_ONE_VERSION_BACK: {
                    return "windows";
                }
            }
        }
        return "linux";
    }

    public EmulationBaseInfo getEmulationInfo() {
        return this.emulationInfo;
    }

    public IosDeviceInfo getIosDeviceInfo() {
        return this.iosDeviceInfo;
    }

    public AndroidDeviceInfo getAndroidDeviceInfo() {
        return this.androidDeviceInfo;
    }

    public String getSizeMode() {
        return this.sizeMode;
    }

    public void setViewportSize(RectangleSize viewportSize) {
        this.viewportSize = viewportSize;
    }

    public String getBaselineEnvName() {
        return this.baselineEnvName;
    }

    public String toString() {
        return "RenderBrowserInfo{viewportSize=" + this.viewportSize + ", browserType=" + this.browserType + ", platform='" + this.platform + '\'' + ", emulationInfo=" + this.emulationInfo + ", iosDeviceInfo=" + this.iosDeviceInfo + ", sizeMode='" + "full-page" + '\'' + ", baselineEnvName='" + this.baselineEnvName + '\'' + ", androidDeviceInfo=" + this.androidDeviceInfo + '}';
    }
}

