/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.utils.GeneralUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;

public class FileDebugResourceWriter
implements IDebugResourceWriter {
    private final Logger logger;
    private final File outputDir;

    public FileDebugResourceWriter(Logger logger, String directoryPath) {
        this.logger = logger;
        this.outputDir = new File(directoryPath);
        if (!this.outputDir.exists() && !this.outputDir.mkdir()) {
            throw new EyesException(String.format("Failed creating directory %s", directoryPath));
        }
    }

    @Override
    public void write(RGridResource resource) {
        if (resource == null || resource.wasDebugWritten() || resource.getContent() == null) {
            return;
        }
        String url = resource.getUrl();
        try {
            String urlHash = GeneralUtils.getSha256hash((byte[])url.getBytes(StandardCharsets.UTF_8));
            String fileName = String.format("resource_%s_%s", urlHash, resource.getSha256());
            fileName = fileName.replaceAll("\\?", "_");
            File file = new File(this.outputDir, fileName);
            byte[] data = resource.getContent();
            try (FileOutputStream stream = new FileOutputStream(file);){
                stream.write(data);
                stream.flush();
            }
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])new String[0]);
        }
        resource.setWasDebugWritten();
    }
}

