/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.eyes.Logger;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.visualgrid.model.CssTokenizer;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class RGridResource {
    @JsonIgnore
    private static final String TEXT_CSS = "text/css";
    @JsonIgnore
    private static final String IMAGE_SVG_XML = "image/svg+xml";
    @JsonIgnore
    private static final int MAX_RESOURCE_SIZE = 0x1900000;
    @JsonIgnore
    private Logger logger;
    @JsonIgnore
    private final String url;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String contentType;
    @JsonIgnore
    private byte[] content;
    @JsonInclude
    private final int size;
    @JsonProperty(value="hash")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String sha256;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Integer errorStatusCode;
    @JsonInclude
    private final String hashFormat = "sha256";
    @JsonIgnore
    private Set<String> subResources = null;
    @JsonIgnore
    private boolean wasDebugWritten = false;

    public static RGridResource createEmpty(String url) {
        return new RGridResource(url, "application/empty-response", new byte[0]);
    }

    public String getUrl() {
        return this.url;
    }

    public RGridResource(String url, String contentType, byte[] content) {
        this(url, contentType, content, null);
    }

    public RGridResource(String url, String contentType, byte[] content, Integer errorStatusCode) {
        this.contentType = contentType;
        this.url = url;
        this.errorStatusCode = errorStatusCode;
        if (content == null) {
            content = new byte[]{};
        }
        this.size = content.length;
        this.content = content.length > 0x1900000 ? Arrays.copyOf(content, 0x1900000) : content;
        this.sha256 = GeneralUtils.getSha256hash((byte[])this.content);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void resetContent() {
        this.content = null;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public String getHashFormat() {
        return "sha256";
    }

    public String getSha256() {
        return this.sha256;
    }

    public Integer getErrorStatusCode() {
        return this.errorStatusCode;
    }

    public boolean wasDebugWritten() {
        return this.wasDebugWritten;
    }

    public void setWasDebugWritten() {
        this.wasDebugWritten = true;
    }

    public boolean wasParsed() {
        return this.subResources != null;
    }

    public synchronized Set<URI> parse(Logger logger, Set<String> testIds) {
        URI resourceUri;
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
        if (!this.wasParsed()) {
            this.subResources = new HashSet<String>();
            if (this.content == null) {
                logger.log(TraceLevel.Error, testIds, Stage.RESOURCE_COLLECTION, Type.PARSE_RESOURCE, new Pair[]{Pair.of((Object)"resourceUrl", (Object)this.url), Pair.of((Object)"message", (Object)"Illegal state: Tried to parse a resource with null content")});
                return new HashSet<URI>();
            }
            TextualDataResource tdr = this.tryGetTextualData(testIds);
            if (tdr != null) {
                switch (tdr.mimeType) {
                    case "text/css": {
                        this.parseCSS(testIds, tdr);
                        break;
                    }
                    case "image/svg+xml": {
                        this.parseSVG(testIds, tdr);
                    }
                }
            }
        }
        if (this.subResources == null || this.subResources.isEmpty()) {
            return new HashSet<URI>();
        }
        try {
            resourceUri = new URI(GeneralUtils.sanitizeURL((String)this.url));
        }
        catch (URISyntaxException e) {
            GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])testIds.toArray(new String[0]));
            return new HashSet<URI>();
        }
        HashSet<URI> newResources = new HashSet<URI>();
        for (String uriStr : this.subResources) {
            URI uri = this.resolveUriString(resourceUri, uriStr);
            if (uri == null) continue;
            newResources.add(uri);
        }
        return new HashSet<URI>(newResources);
    }

    private TextualDataResource tryGetTextualData(Set<String> testIds) {
        if (this.contentType == null) {
            return null;
        }
        if (this.content == null || this.content.length == 0) {
            return null;
        }
        String[] parts = this.contentType.split(";");
        TextualDataResource tdr = new TextualDataResource();
        if (parts.length > 0) {
            tdr.mimeType = parts[0].toLowerCase();
        }
        String charset = "UTF-8";
        if (parts.length > 1) {
            String[] keyVal = parts[1].split("=");
            String key = keyVal[0].trim();
            String val = keyVal[1].trim();
            if (key.equalsIgnoreCase("charset")) {
                charset = val.toUpperCase();
            }
        }
        charset = charset.replaceAll("\"", "");
        try {
            tdr.data = new String(this.content, charset);
        }
        catch (UnsupportedEncodingException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])testIds.toArray(new String[0]));
        }
        tdr.originalData = this.content;
        return tdr;
    }

    private void parseSVG(Set<String> testIds, TextualDataResource tdr) {
        try {
            Document doc = Jsoup.parse((String)new String(tdr.originalData), (String)GeneralUtils.sanitizeURL((String)this.url), (Parser)Parser.xmlParser());
            Elements links = doc.select("[href]");
            links.addAll((Collection)doc.select("[xlink:href]"));
            for (Element element : links) {
                String href = element.attr("href");
                if (href.isEmpty() && (href = element.attr("xlink:href")).startsWith("#")) continue;
                href = GeneralUtils.sanitizeURL((String)href);
                this.subResources.add(href);
            }
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])testIds.toArray(new String[0]));
        }
    }

    private void parseCSS(Set<String> testIds, TextualDataResource css) {
        try {
            String data = css.data;
            if (data == null) {
                return;
            }
            Set<String> urlsString = CssTokenizer.getImportedUrls(data);
            for (String urlString : urlsString) {
                urlString = GeneralUtils.sanitizeURL((String)urlString);
                this.subResources.add(urlString);
            }
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])testIds.toArray(new String[0]));
        }
    }

    private URI resolveUriString(URI baseUrl, String uri) {
        if (uri.toLowerCase().startsWith("data:") || uri.toLowerCase().startsWith("javascript:")) {
            return null;
        }
        try {
            return baseUrl.resolve(uri);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Throwable)e, (String[])new String[0]);
            return null;
        }
    }

    @JsonProperty(value="size")
    public int getSize() {
        return this.size;
    }

    public String toString() {
        return "RGridResource{url='" + this.url + '\'' + ", contentType='" + this.contentType + '\'' + ", sha256='" + this.sha256 + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RGridResource)) {
            return false;
        }
        RGridResource that = (RGridResource)o;
        return this.getSha256().equals(that.getSha256()) && this.getHashFormat().equals(that.getHashFormat());
    }

    public int hashCode() {
        int result = Objects.hash(this.getSha256(), this.getHashFormat());
        result = 31 * result + Arrays.hashCode(this.getContent());
        return result;
    }

    private static class TextualDataResource {
        String mimeType;
        String data;
        byte[] originalData;

        private TextualDataResource() {
        }
    }
}

