/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.universal.server;

import com.applitools.eyes.EyesException;
import com.applitools.utils.GeneralUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;

public class UniversalSdkNativeLoader {
    private static Process nativeProcess = null;
    private static String port;

    public static synchronized void start() {
        try {
            UniversalSdkNativeLoader.startProcess();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                UniversalSdkNativeLoader.startProcess();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new EyesException("Failed to start universal server", (Throwable)e1);
            }
        }
    }

    public static void stop() {
        if (nativeProcess != null && nativeProcess.isAlive()) {
            nativeProcess.destroy();
        }
    }

    private static void startProcess() throws Exception {
        if (nativeProcess == null || !nativeProcess.isAlive()) {
            String suffix;
            String os;
            String osVersion = GeneralUtils.getPropertyString((String)"os.name").toLowerCase();
            if (osVersion.contains("windows")) {
                os = "win-x64";
                suffix = "win.exe";
            } else if (osVersion.contains("mac")) {
                os = "mac-x64";
                suffix = "macos";
            } else {
                os = "linux-x64";
                suffix = "linux";
            }
            String pathInJar = "runtimes/" + os + "/native/eyes-universal-" + suffix;
            InputStream inputStream = UniversalSdkNativeLoader.getFileFromResourceAsStream(pathInJar);
            Path tempFile = Files.createTempFile("eyes-universal-", suffix, new FileAttribute[0]);
            Files.copy(inputStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
            inputStream.close();
            if (!osVersion.contains("windows")) {
                HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
                permissions.add(PosixFilePermission.OWNER_READ);
                permissions.add(PosixFilePermission.OWNER_WRITE);
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
                permissions.add(PosixFilePermission.GROUP_READ);
                permissions.add(PosixFilePermission.GROUP_WRITE);
                permissions.add(PosixFilePermission.GROUP_EXECUTE);
                permissions.add(PosixFilePermission.OTHERS_READ);
                permissions.add(PosixFilePermission.OTHERS_WRITE);
                permissions.add(PosixFilePermission.OTHERS_EXECUTE);
                Files.setPosixFilePermissions(Paths.get(tempFile.toString(), new String[0]), permissions);
            }
            nativeProcess = UniversalSdkNativeLoader.createProcess(tempFile.toString());
            UniversalSdkNativeLoader.readPortOfProcess(nativeProcess);
        }
    }

    private static InputStream getFileFromResourceAsStream(String fileName) {
        ClassLoader classLoader = UniversalSdkNativeLoader.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("file not found! " + fileName);
        }
        return inputStream;
    }

    private static Process createProcess(String executableName) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(executableName);
        return builder.start();
    }

    public static void readPortOfProcess(Process process) {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            UniversalSdkNativeLoader.getFirstLineAsPort(input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void getFirstLineAsPort(BufferedReader reader) throws IOException {
        String lastLine = null;
        String temp = reader.readLine();
        if (temp != null) {
            port = lastLine = temp;
        }
        reader.close();
    }

    public static String getPort() {
        return port;
    }
}

