/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.universal.server;

import com.applitools.eyes.EyesException;
import com.applitools.utils.GeneralUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;

public class UniversalSdkNativeLoader {
    private static Process nativeProcess = null;
    private static Integer port;
    private static final String BINARY_SERVER_PATH = "APPLITOOLS_UNIVERSAL_PATH";
    private static final String TEMP_FOLDER_PATH = "java.io.tmpdir";

    public static synchronized void start() {
        try {
            UniversalSdkNativeLoader.startProcess();
        }
        catch (Exception e) {
            try {
                UniversalSdkNativeLoader.startProcess();
            }
            catch (Exception e1) {
                System.err.println("Could not launch server, ERROR: " + e.getMessage());
                throw new EyesException("Failed to launch universal server", (Throwable)e1);
            }
        }
    }

    public static void stopProcess() {
        if (nativeProcess != null && nativeProcess.isAlive()) {
            nativeProcess.destroy();
        }
    }

    private static void startProcess() throws Exception {
        if (nativeProcess == null || !nativeProcess.isAlive()) {
            String suffix;
            String os;
            String osVersion = GeneralUtils.getPropertyString((String)"os.name").toLowerCase();
            if (osVersion.contains("windows")) {
                os = "win-x64";
                suffix = "win.exe";
            } else if (osVersion.contains("mac")) {
                os = "mac-x64";
                suffix = "macos";
            } else {
                os = "linux-x64";
                suffix = "linux";
            }
            Path directoryPath = GeneralUtils.getEnvString((String)BINARY_SERVER_PATH) != null ? Paths.get(GeneralUtils.getEnvString((String)BINARY_SERVER_PATH), new String[0]) : Paths.get(GeneralUtils.getPropertyString((String)TEMP_FOLDER_PATH), new String[0]);
            String fileName = "eyes-universal-" + suffix;
            Path path = Paths.get(directoryPath + File.separator + fileName, new String[0]);
            String pathInJar = UniversalSdkNativeLoader.getBinaryPath(os, suffix);
            InputStream inputStream = UniversalSdkNativeLoader.getFileFromResourceAsStream(pathInJar);
            UniversalSdkNativeLoader.copyBinaryFileToLocalPath(inputStream, path);
            inputStream.close();
            UniversalSdkNativeLoader.setPosixPermissionsToPath(osVersion, path);
            try {
                nativeProcess = UniversalSdkNativeLoader.createProcess(path.toString());
            }
            catch (IOException e) {
                System.err.println("Could not create process, WARN: " + e.getMessage());
                try {
                    Thread.sleep(3000L);
                    nativeProcess = UniversalSdkNativeLoader.createProcess(path.toString());
                }
                catch (IOException e1) {
                    System.err.println("Could not create process, WARN: " + e.getMessage());
                    Thread.sleep(3000L);
                    nativeProcess = UniversalSdkNativeLoader.createProcess(path.toString());
                }
            }
            UniversalSdkNativeLoader.readPortOfProcess(nativeProcess);
        }
    }

    private static InputStream getFileFromResourceAsStream(String fileName) throws Exception {
        ClassLoader classLoader = UniversalSdkNativeLoader.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            System.err.println("Could not find binary file inside jar");
            throw new Exception("binary file not found! " + fileName);
        }
        return inputStream;
    }

    private static Process createProcess(String executableName) throws IOException {
        try {
            return new ProcessBuilder(executableName, "--no-singleton", "--shutdown-mode", "stdin").redirectError(ProcessBuilder.Redirect.INHERIT).start();
        }
        catch (IOException e) {
            System.err.println("Could not start process, ERROR: " + e.getMessage());
            throw new IOException("Could not start process", e);
        }
    }

    public static void readPortOfProcess(Process process) throws Exception {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            UniversalSdkNativeLoader.getFirstLineAsPort(input);
        }
        catch (Exception e) {
            System.err.println("Could not read server port, ERROR: " + e.getMessage());
            throw new Exception("Could not read server port", e);
        }
    }

    private static void getFirstLineAsPort(BufferedReader reader) throws Exception {
        try {
            port = Integer.parseInt(reader.readLine());
            reader.close();
        }
        catch (Exception e) {
            System.err.println("Could not read first line as port, ERROR: " + e.getMessage());
            throw new Exception("Could not read first line as port", e);
        }
    }

    public static Integer getPort() {
        return port;
    }

    private static void assignHookToStopProcess() {
        Runtime.getRuntime().addShutdownHook(new Thread(UniversalSdkNativeLoader::stopProcess));
    }

    private static String getBinaryPath(String os, String suffix) {
        return "runtimes/" + os + "/native/eyes-universal-" + suffix;
    }

    private static void setPosixPermissionsToPath(String osVersion, Path path) throws Exception {
        try {
            if (!osVersion.contains("windows")) {
                HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
                permissions.add(PosixFilePermission.OWNER_READ);
                permissions.add(PosixFilePermission.OWNER_WRITE);
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
                permissions.add(PosixFilePermission.GROUP_READ);
                permissions.add(PosixFilePermission.GROUP_WRITE);
                permissions.add(PosixFilePermission.GROUP_EXECUTE);
                permissions.add(PosixFilePermission.OTHERS_READ);
                permissions.add(PosixFilePermission.OTHERS_WRITE);
                permissions.add(PosixFilePermission.OTHERS_EXECUTE);
                Files.setPosixFilePermissions(path, permissions);
            }
        }
        catch (IOException e) {
            System.err.println("Could not set posix file permissions, ERROR: " + e.getMessage());
            throw new Exception("Could not set posix file permissions", e);
        }
    }

    private static void copyBinaryFileToLocalPath(InputStream inputStream, Path path) {
        try {
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            System.err.println("Could not copy binary file to " + path + ", Error: " + e.getMessage());
        }
    }
}

