/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.universal.server;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesRunnable;
import com.applitools.eyes.Logger;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.utils.GeneralUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class UniversalSdkNativeLoader {
    private static Process nativeProcess = null;
    private static Integer port;
    private static final String BINARY_SERVER_PATH = "APPLITOOLS_UNIVERSAL_PATH";
    private static final String TEMP_FOLDER_PATH = "java.io.tmpdir";
    private static final long MAX_ACTION_WAIT_SECONDS = 90L;
    private static final long SLEEP_BETWEEN_ACTION_CHECK_MS = 3000L;
    private static final String ALPINE_PATH = "/etc/alpine-release";
    private static Logger logger;
    private static final TraceLevel INFO_LOG_LEVEL;
    private static final String UNIVERSAL_DEBUG;

    public static synchronized void start() {
        try {
            UniversalSdkNativeLoader.copyAndStartUniversalCore();
        }
        catch (Exception e) {
            String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Could not launch server!");
            logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
            throw new EyesException(errorMessage, (Throwable)e);
        }
    }

    private static void destroyProcess() {
        if (nativeProcess.isAlive() && nativeProcess != null) {
            try {
                nativeProcess.destroy();
                nativeProcess.waitFor();
                nativeProcess = null;
            }
            catch (Exception e) {
                String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Could not destroy server!");
                logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
                throw new EyesException(errorMessage, (Throwable)e);
            }
        }
    }

    private static void copyAndStartUniversalCore() throws Exception {
        if (nativeProcess == null) {
            Path serverTargetPath;
            String suffix;
            String os;
            String osVersion = GeneralUtils.getPropertyString((String)"os.name").toLowerCase();
            if (osVersion.contains("windows")) {
                os = "win-x64";
                suffix = "win.exe";
            } else if (osVersion.contains("mac")) {
                os = "mac-x64";
                suffix = "macos";
            } else if (osVersion.contains("linux") && Files.exists(Paths.get(ALPINE_PATH, new String[0]), new LinkOption[0])) {
                os = "linux-x64";
                suffix = "alpine";
            } else {
                os = "linux-x64";
                suffix = "linux";
            }
            logger.log(INFO_LOG_LEVEL, Stage.GENERAL, String.format("Identifies OS: %s", os));
            String userSetPath = GeneralUtils.getEnvString((String)BINARY_SERVER_PATH);
            Path directoryPath = userSetPath == null ? Paths.get(GeneralUtils.getPropertyString((String)TEMP_FOLDER_PATH), new String[0]) : Paths.get(userSetPath, new String[0]);
            String serverFilename = "eyes-universal-" + suffix;
            String pathInJar = UniversalSdkNativeLoader.getBinaryPath(os, suffix);
            try (InputStream serverBinaryAsStream = UniversalSdkNativeLoader.getFileFromResourceAsStream(pathInJar);){
                serverTargetPath = UniversalSdkNativeLoader.copyBinaryFileToLocalPath(serverBinaryAsStream, directoryPath, serverFilename);
            }
            UniversalSdkNativeLoader.setAndVerifyPosixPermissionsForUniversalCore(osVersion, serverTargetPath);
            UniversalSdkNativeLoader.createProcessAndReadPort(serverTargetPath.toString());
        }
    }

    private static void createProcessAndReadPort(final String executablePath) {
        if (Boolean.parseBoolean(UNIVERSAL_DEBUG)) {
            GeneralUtils.tryRunTaskWithRetry((EyesRunnable)new EyesRunnable(){

                public void run() {
                    try {
                        nativeProcess = new ProcessBuilder(executablePath, "--port 0", "--no-singleton", "--shutdown-mode", "--debug", "stdin").start();
                    }
                    catch (Exception e) {
                        String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Failed to start universal core!");
                        logger.log(INFO_LOG_LEVEL, Stage.GENERAL, errorMessage);
                        throw new EyesException(errorMessage, (Throwable)e);
                    }
                    logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "Universal Core (debug) start returned ok.");
                }

                public String getName() {
                    return "Start universal core";
                }
            }, (long)90L, (long)3000L, (String)"Timed out trying to start universal core!", (Logger)logger);
        } else {
            GeneralUtils.tryRunTaskWithRetry((EyesRunnable)new EyesRunnable(){

                public void run() {
                    try {
                        nativeProcess = new ProcessBuilder(executablePath, "--port 0", "--no-singleton", "--shutdown-mode", "stdin").start();
                    }
                    catch (Exception e) {
                        String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Failed to start universal core!");
                        logger.log(INFO_LOG_LEVEL, Stage.GENERAL, errorMessage);
                        throw new EyesException(errorMessage, (Throwable)e);
                    }
                    logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "Universal Core start returned ok.");
                }

                public String getName() {
                    return "Start universal core";
                }
            }, (long)90L, (long)3000L, (String)"Timed out trying to start universal core!", (Logger)logger);
        }
        GeneralUtils.tryRunTaskWithRetry((EyesRunnable)new EyesRunnable(){

            public void run() throws EyesException {
                String inputLineFromServer = "";
                try {
                    InputStream childOutputStream = nativeProcess.getInputStream();
                    if (childOutputStream.available() == 0) {
                        String errorMessage = "server did not yet output the port number..";
                        logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
                        throw new EyesException(errorMessage);
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(childOutputStream));
                    inputLineFromServer = reader.readLine();
                    port = Integer.parseInt(inputLineFromServer);
                    logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "Port read and parsed okay: " + port);
                }
                catch (IOException e) {
                    String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Failed to get core's input stream!");
                    logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
                    throw new EyesException(errorMessage, (Throwable)e);
                }
                catch (NumberFormatException nfe) {
                    String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)nfe, (String)("Got a non-integer as port! Text: '" + inputLineFromServer + "'"));
                    logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
                    throw new EyesException(errorMessage, (Throwable)nfe);
                }
            }

            public String getName() {
                return "Read universal core port";
            }
        }, (long)90L, (long)3000L, (String)"Timed out trying to read port from core!", (Logger)logger);
    }

    private static InputStream getFileFromResourceAsStream(String fileName) throws Exception {
        ClassLoader classLoader = UniversalSdkNativeLoader.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            String errorMessage = "Could not find the universal core inside the SDK jar! Filename searched: " + fileName;
            throw new EyesException(errorMessage);
        }
        return inputStream;
    }

    public static Integer getPort() {
        return port;
    }

    private static String getBinaryPath(String os, String suffix) {
        return "runtimes/" + os + "/native/eyes-universal-" + suffix;
    }

    private static void setAndVerifyPosixPermissionsForUniversalCore(String osVersion, final Path path) throws Exception {
        if (osVersion.contains("windows")) {
            return;
        }
        final HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        permissions.add(PosixFilePermission.OWNER_READ);
        permissions.add(PosixFilePermission.OWNER_WRITE);
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        permissions.add(PosixFilePermission.GROUP_READ);
        permissions.add(PosixFilePermission.GROUP_WRITE);
        permissions.add(PosixFilePermission.GROUP_EXECUTE);
        permissions.add(PosixFilePermission.OTHERS_READ);
        permissions.add(PosixFilePermission.OTHERS_WRITE);
        permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        GeneralUtils.tryRunTaskWithRetry((EyesRunnable)new EyesRunnable(){

            public void run() throws EyesException {
                try {
                    Files.setPosixFilePermissions(path, permissions);
                    logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "'Set core permissions' ended. Now verifying the permissions...");
                }
                catch (Exception e) {
                    String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Could not set permissions on the universal core file!");
                    logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
                    throw new EyesException(errorMessage, (Throwable)e);
                }
            }

            public String getName() {
                return "Set core permissions";
            }
        }, (long)90L, (long)3000L, (String)"Timed out waiting for permissions to be set for universal core!", (Logger)logger);
        GeneralUtils.tryRunTaskWithRetry((EyesRunnable)new EyesRunnable(){

            public void run() throws EyesException {
                Set<PosixFilePermission> retrievedPermissions = null;
                try {
                    retrievedPermissions = Files.getPosixFilePermissions(path, LinkOption.NOFOLLOW_LINKS);
                }
                catch (IOException e) {
                    String errMsg = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Got IOException trying to read universal core permissions!");
                    logger.log(TraceLevel.Error, Stage.GENERAL, errMsg);
                    throw new EyesException(errMsg, (Throwable)e);
                }
                if (!retrievedPermissions.containsAll(permissions)) {
                    String errMsg = "Permissions for universal core were not yet set correctly! Current permissions: " + Arrays.toString(retrievedPermissions.toArray());
                    logger.log(TraceLevel.Error, Stage.GENERAL, errMsg);
                    throw new EyesException(errMsg);
                }
                logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "Core permissions verified.");
            }

            public String getName() {
                return "Verify core permissions";
            }
        }, (long)90L, (long)3000L, (String)"Timed out waiting for permissions to be set for universal core!", (Logger)logger);
    }

    private static Path copyBinaryFileToLocalPath(InputStream inputStream, Path directoryPath, String filename) {
        Path serverTargetPath = Paths.get(directoryPath + File.separator + filename, new String[0]);
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "The path '" + directoryPath + "' for the universal core does not exist. Creating the directory structure...");
            try {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
            catch (Exception e) {
                String errMsg = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)("Could not create the directory structure '" + directoryPath + "'!"));
                logger.log(TraceLevel.Error, Stage.GENERAL, errMsg);
                throw new EyesException(errMsg, (Throwable)e);
            }
            logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "Directory structure created.");
        }
        try {
            Files.copy(inputStream, serverTargetPath, StandardCopyOption.REPLACE_EXISTING);
            logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "Successfully copied the universal core to path: '" + serverTargetPath + "'");
        }
        catch (Exception e) {
            String errMsg = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)("Could not copy universal core to '" + serverTargetPath + "' (can happen if server is already running)"));
            logger.log(TraceLevel.Error, Stage.GENERAL, errMsg);
        }
        return serverTargetPath;
    }

    public static void setLogger(Logger logger1) {
        logger = logger1;
    }

    static {
        logger = new Logger();
        INFO_LOG_LEVEL = TraceLevel.Info;
        UNIVERSAL_DEBUG = GeneralUtils.getEnvString((String)"APPLITOOLS_UNIVERSAL_DEBUG");
    }
}

