/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.universal.server;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesRunnable;
import com.applitools.eyes.Logger;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.universal.utils.SystemInfo;
import com.applitools.utils.GeneralUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class UniversalSdkNativeLoader {
    private static Process nativeProcess = null;
    private static Integer port;
    private static final String BINARY_SERVER_PATH = "APPLITOOLS_UNIVERSAL_PATH";
    private static final String TEMP_FOLDER_PATH = "java.io.tmpdir";
    private static final long MAX_ACTION_WAIT_SECONDS = 90L;
    private static final long SLEEP_BETWEEN_ACTION_CHECK_MS = 3000L;
    private static Logger logger;
    private static final TraceLevel INFO_LOG_LEVEL;
    private static final String UNIVERSAL_DEBUG;
    private static final String UNIVERSAL_MASK_LOG;
    private static Boolean debug;
    private static Boolean maskLog;

    public static synchronized void start() {
        try {
            UniversalSdkNativeLoader.copyAndStartUniversalCore();
        }
        catch (Exception e) {
            String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Could not launch server!");
            logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
            throw new EyesException(errorMessage, (Throwable)e);
        }
    }

    private static void destroyProcess() {
        if (nativeProcess.isAlive() && nativeProcess != null) {
            try {
                nativeProcess.destroy();
                nativeProcess.waitFor();
                nativeProcess = null;
            }
            catch (Exception e) {
                String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Could not destroy server!");
                System.out.println(errorMessage);
                throw new EyesException(errorMessage, (Throwable)e);
            }
        }
    }

    private static void copyAndStartUniversalCore() throws Exception {
        String portStr = System.getenv("APPLITOOLS_UNIVERSAL_PORT");
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
                return;
            }
            catch (NumberFormatException ex) {
                System.out.println("APPLITOOLS_UNIVERSAL_PORT is not a valid number");
            }
        }
        if (nativeProcess == null) {
            Path serverTargetPath;
            String userSetPath = GeneralUtils.getEnvString((String)BINARY_SERVER_PATH);
            Path directoryPath = userSetPath == null ? Paths.get(GeneralUtils.getPropertyString((String)TEMP_FOLDER_PATH), new String[0]) : Paths.get(userSetPath, new String[0]);
            String serverFilename = SystemInfo.getCurrentBinary();
            try (InputStream serverBinaryAsStream = UniversalSdkNativeLoader.getFileFromResourceAsStream(serverFilename);){
                serverTargetPath = UniversalSdkNativeLoader.copyBinaryFileToLocalPath(serverBinaryAsStream, directoryPath, serverFilename);
            }
            UniversalSdkNativeLoader.setAndVerifyPosixPermissionsForUniversalCore(serverTargetPath);
            UniversalSdkNativeLoader.createProcessAndReadPort(serverTargetPath.toString());
        }
    }

    private static void createProcessAndReadPort(final String executablePath) {
        String message;
        final ArrayList<String> args = new ArrayList<String>();
        args.add(executablePath);
        args.add("universal");
        args.add("--port 0");
        args.add("--no-singleton");
        args.add("--shutdown-mode");
        args.add("stdin");
        if (debug == null) {
            debug = Boolean.parseBoolean(UNIVERSAL_DEBUG);
        }
        if (maskLog == null) {
            maskLog = Boolean.parseBoolean(UNIVERSAL_MASK_LOG);
        }
        String string = message = debug != false ? "Universal Core (debug) start returned ok." : "Universal Core start returned ok.";
        if (debug.booleanValue()) {
            args.add("--debug");
        }
        if (maskLog.booleanValue()) {
            args.add("--maskLog");
        }
        GeneralUtils.tryRunTaskWithRetry((EyesRunnable)new EyesRunnable(){

            public void run() {
                try {
                    System.out.println("Starting universal core in: " + executablePath);
                    nativeProcess = new ProcessBuilder(args).start();
                }
                catch (Exception e) {
                    String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Failed to start universal core!");
                    logger.log(INFO_LOG_LEVEL, Stage.GENERAL, errorMessage);
                    throw new EyesException(errorMessage, (Throwable)e);
                }
                logger.log(INFO_LOG_LEVEL, Stage.GENERAL, message);
            }

            public String getName() {
                return "Start universal core";
            }
        }, (long)90L, (long)3000L, (String)"Timed out trying to start universal core!", (Logger)logger);
        GeneralUtils.tryRunTaskWithRetry((EyesRunnable)new EyesRunnable(){

            public void run() throws EyesException {
                String inputLineFromServer = "";
                try {
                    InputStream childOutputStream = nativeProcess.getInputStream();
                    if (childOutputStream.available() == 0) {
                        System.out.println();
                        String errorMessage = "server did not yet output the port number..";
                        logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
                        throw new EyesException(errorMessage);
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(childOutputStream));
                    inputLineFromServer = reader.readLine();
                    port = Integer.parseInt(inputLineFromServer);
                    logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "Port read and parsed okay: " + port);
                }
                catch (IOException e) {
                    String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Failed to get core's input stream!");
                    logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
                    throw new EyesException(errorMessage, (Throwable)e);
                }
                catch (NumberFormatException nfe) {
                    String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)nfe, (String)("Got a non-integer as port! Text: '" + inputLineFromServer + "'"));
                    logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
                    throw new EyesException(errorMessage, (Throwable)nfe);
                }
            }

            public String getName() {
                return "Read universal core port";
            }
        }, (long)90L, (long)3000L, (String)"Timed out trying to read port from core!", (Logger)logger);
    }

    private static InputStream getFileFromResourceAsStream(String fileName) throws EyesException {
        ClassLoader classLoader = UniversalSdkNativeLoader.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            String errorMessage = "Could not find the universal core inside the SDK jar! Filename searched: " + fileName;
            throw new EyesException(errorMessage);
        }
        return inputStream;
    }

    public static Integer getPort() {
        return port;
    }

    private static void setAndVerifyPosixPermissionsForUniversalCore(final Path path) throws Exception {
        String osVersion = GeneralUtils.getPropertyString((String)"os.name").toLowerCase();
        if (osVersion.contains("windows")) {
            return;
        }
        final HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        permissions.add(PosixFilePermission.OWNER_READ);
        permissions.add(PosixFilePermission.OWNER_WRITE);
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        permissions.add(PosixFilePermission.GROUP_READ);
        permissions.add(PosixFilePermission.GROUP_WRITE);
        permissions.add(PosixFilePermission.GROUP_EXECUTE);
        permissions.add(PosixFilePermission.OTHERS_READ);
        permissions.add(PosixFilePermission.OTHERS_WRITE);
        permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        GeneralUtils.tryRunTaskWithRetry((EyesRunnable)new EyesRunnable(){

            public void run() throws EyesException {
                try {
                    Files.setPosixFilePermissions(path, permissions);
                    logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "'Set core permissions' ended. Now verifying the permissions...");
                }
                catch (Exception e) {
                    String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Could not set permissions on the universal core file!");
                    logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
                    throw new EyesException(errorMessage, (Throwable)e);
                }
            }

            public String getName() {
                return "Set core permissions";
            }
        }, (long)90L, (long)3000L, (String)"Timed out waiting for permissions to be set for universal core!", (Logger)logger);
        GeneralUtils.tryRunTaskWithRetry((EyesRunnable)new EyesRunnable(){

            public void run() throws EyesException {
                Set<PosixFilePermission> retrievedPermissions = null;
                try {
                    retrievedPermissions = Files.getPosixFilePermissions(path, LinkOption.NOFOLLOW_LINKS);
                }
                catch (IOException e) {
                    String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Got IOException trying to read universal core permissions!");
                    logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
                    throw new EyesException(errorMessage, (Throwable)e);
                }
                if (!retrievedPermissions.containsAll(permissions)) {
                    String errorMessage = "Permissions for universal core were not yet set correctly! Current permissions: " + Arrays.toString(retrievedPermissions.toArray());
                    logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
                    throw new EyesException(errorMessage);
                }
                logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "Core permissions verified.");
            }

            public String getName() {
                return "Verify core permissions";
            }
        }, (long)90L, (long)3000L, (String)"Timed out waiting for permissions to be set for universal core!", (Logger)logger);
    }

    private static Path copyBinaryFileToLocalPath(InputStream inputStream, Path directoryPath, String filename) {
        Path serverTargetPath = Paths.get(directoryPath + File.separator + filename, new String[0]);
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "The path '" + directoryPath + "' for the universal core does not exist. Creating the directory structure...");
            try {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
            catch (Exception e) {
                String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)("Could not create the directory structure '" + directoryPath + "'!"));
                logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
                throw new EyesException(errorMessage, (Throwable)e);
            }
            logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "Directory structure created.");
        }
        try {
            Files.copy(inputStream, serverTargetPath, StandardCopyOption.REPLACE_EXISTING);
            logger.log(INFO_LOG_LEVEL, Stage.GENERAL, "Successfully copied the universal core to path: '" + serverTargetPath + "'");
        }
        catch (Exception e) {
            String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)("Could not copy universal core to '" + serverTargetPath + "' (can happen if server is already running)"));
            logger.log(TraceLevel.Error, Stage.GENERAL, errorMessage);
        }
        return serverTargetPath;
    }

    public static void setLogger(Logger logger1) {
        logger = logger1;
    }

    public static void setMaskLog(Boolean maskLog) {
        UniversalSdkNativeLoader.maskLog = maskLog;
    }

    public static void setDebug(Boolean debug) {
        UniversalSdkNativeLoader.debug = debug;
    }

    static {
        logger = new Logger();
        INFO_LOG_LEVEL = TraceLevel.Info;
        UNIVERSAL_DEBUG = GeneralUtils.getEnvString((String)"APPLITOOLS_UNIVERSAL_DEBUG");
        UNIVERSAL_MASK_LOG = GeneralUtils.getEnvString((String)"APPLITOOLS_UNIVERSAL_MASK_LOG");
    }
}

