/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.content.Context;
import com.applovin.impl.sdk.r;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppLovinSdkSettings {
    private boolean a;
    private boolean b;
    private boolean c;
    private boolean d;
    private final Map<String, Object> localSettings = new HashMap<String, Object>();
    private final Map<String, String> metaData = new HashMap<String, String>();
    private List<String> e = Collections.emptyList();
    private List<String> f = Collections.emptyList();

    @Deprecated
    public AppLovinSdkSettings() {
        this(null);
    }

    public AppLovinSdkSettings(Context context) {
        this.a = Utils.isVerboseLoggingEnabled(context);
        this.c = true;
        this.d = true;
    }

    public void setTestDeviceAdvertisingIds(List<String> list) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (string2 != null && string2.length() == 36) {
                    arrayList.add(string2);
                    continue;
                }
                r.i("AppLovinSdkSettings", "Unable to set test device advertising id (" + string2 + ") - please make sure it is in the format of xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx");
            }
            this.e = arrayList;
        } else {
            this.e = Collections.emptyList();
        }
    }

    public List<String> getTestDeviceAdvertisingIds() {
        return this.e;
    }

    public void setInitializationAdUnitIds(List<String> list) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (!StringUtils.isValidString(string2) || string2.length() <= 0) continue;
                if (string2.length() == 16) {
                    arrayList.add(string2);
                    continue;
                }
                r.i("AppLovinSdkSettings", "Unable to set initialization ad unit id (" + string2 + ") - please make sure it is in the format of XXXXXXXXXXXXXXXX");
            }
            this.f = arrayList;
        } else {
            this.f = Collections.emptyList();
        }
    }

    public List<String> getInitializationAdUnitIds() {
        return this.f;
    }

    public void setVerboseLogging(boolean bl) {
        if (Utils.isVerboseLoggingConfigured()) {
            r.i("AppLovinSdkSettings", "Ignoring setting of verbose logging - it is configured from Android manifest already or AppLovinSdkSettings was initialized without a context.");
            if (Utils.isVerboseLoggingEnabled(null) != bl) {
                r.i("AppLovinSdkSettings", "Attempted to programmatically set verbose logging flag to value different from value configured in Android Manifest.");
            }
        } else {
            this.a = bl;
        }
    }

    public boolean isVerboseLoggingEnabled() {
        return this.a;
    }

    public boolean isMuted() {
        return this.b;
    }

    public void setMuted(boolean bl) {
        this.b = bl;
    }

    public void setCreativeDebuggerEnabled(boolean bl) {
        this.c = bl;
    }

    public boolean isCreativeDebuggerEnabled() {
        return this.c;
    }

    public void setExceptionHandlerEnabled(boolean bl) {
        this.d = true;
    }

    public boolean isExceptionHandlerEnabled() {
        return this.d;
    }

    public String toString() {
        return "AppLovinSdkSettings{isVerboseLoggingEnabled=" + this.a + ", muted=" + this.b + ", testDeviceAdvertisingIds=" + this.e.toString() + ", initializationAdUnitIds=" + this.f.toString() + ", creativeDebuggerEnabled=" + this.c + ", exceptionHandlerEnabled=" + this.d + '}';
    }
}

