package com.applovin.sdk;

/**
 * This interface represents an ad that has been served by the AppLovin server and should be displayed to the user.
 *
 * @author Basil Shikin, Thomas So
 */

public interface AppLovinAd
{
    /**
     * Get size of the ad to display.
     *
     * @return Ad size.
     */
    AppLovinAdSize getSize();

    /**
     * The zone identifier for the ad, if any.
     *
     * @return zone identifier of this ad, If any.
     */
    String getZoneId();

    /**
     * Get the ad type of the current ad.
     *
     * @return Ad type.
     */
    AppLovinAdType getType();

    /**
     * @deprecated This API has been deprecated and will be removed in a future release.
     */
    @Deprecated
    long getAdIdNumber();

    /**
     * @deprecated This API has been deprecated and will be removed in a future release.
     */
    @Deprecated
    boolean isVideoAd();

    /**
     * @deprecated This API has been deprecated and will be removed in a future release.
     */
    @Deprecated
    String getAdValue(final String key);

    /**
     * @deprecated This API has been deprecated and will be removed in a future release.
     */
    @Deprecated
    String getAdValue(final String key, final String defaultValue);
}
