/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Preconditions;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Strings {
    private Strings() {
    }

    public static String padStart(String string2, int n10, char c10) {
        StringBuilder stringBuilder;
        String string3 = string2;
        Preconditions.checkNotNull(string3);
        if (string3.length() >= n10) {
            return string2;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(n10);
        for (int i10 = string2.length(); i10 < n10; ++i10) {
            stringBuilder2.append(c10);
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(string2);
        return stringBuilder3.toString();
    }

    public static String padEnd(String string2, int n10, char c10) {
        StringBuilder stringBuilder;
        String string3 = string2;
        Preconditions.checkNotNull(string3);
        if (string3.length() >= n10) {
            return string2;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder(n10).append(string2);
        for (int i10 = string2.length(); i10 < n10; ++i10) {
            stringBuilder2.append(c10);
        }
        return stringBuilder2.toString();
    }

    public static String repeat(String object, int n10) {
        Preconditions.checkNotNull(object);
        if (n10 <= 1) {
            Preconditions.checkArgument(n10 >= 0, "invalid count: %s", n10);
            if (n10 == 0) {
                object = "";
            }
            return object;
        }
        int n11 = ((String)object).length();
        long l10 = (long)n11 * (long)n10;
        n10 = (int)l10;
        if ((long)n10 == l10) {
            int n12;
            String string2 = object;
            object = new char[n10];
            string2.getChars(0, n11, (char[])object, 0);
            while (n11 < (n12 = n10 - n11)) {
                int n13 = n11;
                System.arraycopy(object, 0, object, n13, n13);
                n11 <<= 1;
            }
            System.arraycopy(object, 0, object, n11, n12);
            return new String((char[])object);
        }
        throw new ArrayIndexOutOfBoundsException("Required array size too large: " + l10);
    }

    public static String commonPrefix(CharSequence charSequence, CharSequence charSequence2) {
        int n10;
        Preconditions.checkNotNull(charSequence);
        Preconditions.checkNotNull(charSequence2);
        int n11 = Math.min(charSequence.length(), charSequence2.length());
        for (n10 = 0; n10 < n11 && charSequence.charAt(n10) == charSequence2.charAt(n10); ++n10) {
        }
        n11 = n10 - 1;
        if (Strings.validSurrogatePairAt(charSequence, n11) || Strings.validSurrogatePairAt(charSequence2, n11)) {
            --n10;
        }
        return charSequence.subSequence(0, n10).toString();
    }

    public static String commonSuffix(CharSequence charSequence, CharSequence charSequence2) {
        int n10;
        block4: {
            block3: {
                Preconditions.checkNotNull(charSequence);
                Preconditions.checkNotNull(charSequence2);
                int n11 = Math.min(charSequence.length(), charSequence2.length());
                for (n10 = 0; n10 < n11; ++n10) {
                    CharSequence charSequence3 = charSequence;
                    CharSequence charSequence4 = charSequence2;
                    if (charSequence3.charAt(charSequence3.length() - n10 - 1) != charSequence4.charAt(charSequence4.length() - n10 - 1)) break;
                }
                CharSequence charSequence5 = charSequence;
                if (Strings.validSurrogatePairAt(charSequence5, charSequence5.length() - n10 - 1)) break block3;
                CharSequence charSequence6 = charSequence2;
                if (!Strings.validSurrogatePairAt(charSequence6, charSequence6.length() - n10 - 1)) break block4;
            }
            --n10;
        }
        CharSequence charSequence7 = charSequence;
        int n12 = charSequence7.length() - n10;
        return charSequence7.subSequence(n12, charSequence7.length()).toString();
    }

    static boolean validSurrogatePairAt(CharSequence charSequence, int n10) {
        return n10 >= 0 && n10 <= charSequence.length() - 2 && Character.isHighSurrogate(charSequence.charAt(n10)) && Character.isLowSurrogate(charSequence.charAt(n10 + 1));
    }

    public static String lenientFormat(@NullableDecl String string2, Object ... objectArray) {
        int n10;
        StringBuilder stringBuilder;
        string2 = String.valueOf(string2);
        if (objectArray == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "(Object[])null";
        } else {
            for (int i10 = 0; i10 < objectArray.length; ++i10) {
                objectArray[i10] = Strings.lenientToString(objectArray[i10]);
            }
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string2.length() + objectArray.length * 16);
        int n11 = 0;
        int n12 = 0;
        while (n12 < objectArray.length && (n10 = string2.indexOf("%s", n11)) != -1) {
            stringBuilder2.append(string2, n11, n10);
            stringBuilder2.append(objectArray[n12++]);
            n11 = n10 + 2;
        }
        String string3 = string2;
        stringBuilder2.append(string3, n11, string3.length());
        if (n12 < objectArray.length) {
            stringBuilder2.append(" [");
            int n13 = n12 + 1;
            stringBuilder2.append(objectArray[n12]);
            while (n13 < objectArray.length) {
                stringBuilder2.append(", ");
                stringBuilder2.append(objectArray[n13++]);
            }
            stringBuilder2.append(']');
        }
        return stringBuilder2.toString();
    }

    private static String lenientToString(@NullableDecl Object object) {
        try {
            return String.valueOf(object);
        }
        catch (Exception exception) {
            object = object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
            Logger.getLogger("com.applovin.exoplayer2.common.base.Strings").log(Level.WARNING, "Exception during lenientFormat for " + (String)object, exception);
            return "<" + (String)object + " threw " + exception.getClass().getName() + ">";
        }
    }
}

