package com.applovin.sdk;

import android.content.Intent;

import java.util.Map;

/**
 * Service used for tracking various analytical events.
 */
public interface AppLovinEventService
{
    /**
     * Track an event without additional data.
     * <p>
     * Where applicable, it is suggested to use one of the predefined strings provided in {@link AppLovinEventTypes} for the event and parameter key.
     *
     * @param eventName A string representing the event to track.
     */
    void trackEvent(final String eventName);

    /**
     * Track an event with additional data.
     * <p>
     * Where applicable, it is suggested to use one of the predefined strings provided in {@link AppLovinEventTypes} for the event and parameter key.
     *
     * @param eventName  A string representing the event to track.
     * @param parameters A map containing key-value pairs further describing this event.
     */
    void trackEvent(final String eventName, final Map<String, String> parameters);

    /**
     * Track an in app purchase.
     *
     * @param purchaseIntent Intent returned to you by Google Play.
     * @param parameters     A map containing key-value pairs further describing this event. You should provide, at a minimum, {@link AppLovinEventParameters#PRODUCT_IDENTIFIER}, {@link AppLovinEventParameters#REVENUE_AMOUNT} and {@link AppLovinEventParameters#REVENUE_CURRENCY}.
     */
    void trackInAppPurchase(final Intent purchaseIntent, final Map<String, String> parameters);

    /**
     * Track a checkout / standard purchase.
     *
     * @param transactionId An optional unique identifier for this transaction, as generated by you.
     * @param parameters    A map containing key-value pairs further describing this event. You should provide, at a minimum, {@link AppLovinEventParameters#PRODUCT_IDENTIFIER}, {@link AppLovinEventParameters#REVENUE_AMOUNT} and {@link AppLovinEventParameters#REVENUE_CURRENCY}.
     */
    void trackCheckout(final String transactionId, final Map<String, String> parameters);
}
