package com.applovin.sdk;

/**
 * This interface contains settings that enable the AppLovin Unified Consent Flow.
 */
public interface AppLovinTermsAndPrivacyPolicyFlowSettings
        extends AppLovinTermsFlowSettings
{
    /**
     * The current debug geography of the user.
     */
    AppLovinSdkConfiguration.ConsentFlowUserGeography getDebugUserGeography();

    /**
     * Set debug user geography. You may use this to test CMP flow by setting this to {@link AppLovinSdkConfiguration.ConsentFlowUserGeography#GDPR}.
     * <p>
     * The flow would only be shown to new users. If you wish to test the flow after completing the CMP prompt, you would need to delete and re-install the app.
     * <p>
     * NOTE: The debug geography is used only when the app is in debug mode.
     */
    void setDebugUserGeography(final AppLovinSdkConfiguration.ConsentFlowUserGeography debugUserGeography);
}
