package com.applovin.sdk;

import android.net.Uri;

import androidx.annotation.Nullable;

/**
 * This interface contains settings that enable the AppLovin Terms Flow.
 */
public interface AppLovinTermsFlowSettings
{
    /**
     * Whether or not the consent flow is currently enabled.
     */
    boolean isEnabled();

    /**
     * Set whether to enable the consent flow or not.
     */
    void setEnabled(final boolean enabled);

    /**
     * Get the current privacy policy URL.
     */
    @Nullable
    Uri getPrivacyPolicyUri();

    /**
     * Set the privacy policy URL.
     */
    void setPrivacyPolicyUri(final Uri privacyPolicyUri);

    /**
     * Get the current terms of service URL.
     */
    @Nullable
    Uri getTermsOfServiceUri();

    /**
     * Set the terms of service URL.
     */
    void setTermsOfServiceUri(final Uri termsOfServiceUri);
}
