/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.applovin.impl.mediation.MaxRewardImpl;
import com.applovin.impl.sdk.j;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.impl.yp;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxAppOpenAdapter;
import com.applovin.mediation.adapter.MaxInterstitialAdViewAdapter;
import com.applovin.mediation.adapter.MaxNativeAdAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdViewAdapter;
import com.applovin.mediation.adapter.listeners.MaxAppOpenAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.sdk.AppLovinSdk;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public abstract class MediationAdapterBase
implements MaxAdapter,
MaxNativeAdAdapter,
MaxInterstitialAdViewAdapter,
MaxRewardedAdViewAdapter,
MaxAppOpenAdapter {
    private final String mTag;
    private final AppLovinSdk mWrappingSdk;
    private final j mSdk;
    private final n mLogger;
    private MaxReward reward;
    private boolean alwaysRewardUser;

    protected static String mediationTag() {
        return "AppLovinSdk_" + AppLovinSdk.VERSION;
    }

    public MediationAdapterBase(AppLovinSdk appLovinSdk) {
        MediationAdapterBase mediationAdapterBase = j10;
        ((MediationAdapterBase)((Object)j10)).mWrappingSdk = appLovinSdk;
        j j10 = appLovinSdk.a();
        mediationAdapterBase.mSdk = j10;
        mediationAdapterBase.mLogger = j10.I();
        mediationAdapterBase.mTag = mediationAdapterBase.getClass().getSimpleName();
    }

    @Override
    public boolean isBeta() {
        return false;
    }

    @Override
    @Nullable
    public Boolean shouldInitializeOnUiThread() {
        return null;
    }

    @Override
    @Nullable
    public Boolean shouldCollectSignalsOnUiThread() {
        return null;
    }

    @Override
    @Nullable
    public Boolean shouldLoadAdsOnUiThread(MaxAdFormat maxAdFormat) {
        return null;
    }

    @Override
    @Nullable
    public Boolean shouldShowAdsOnUiThread(MaxAdFormat maxAdFormat) {
        return null;
    }

    protected Context getApplicationContext() {
        return j.m();
    }

    protected AppLovinSdk getWrappingSdk() {
        return this.mWrappingSdk;
    }

    protected ExecutorService getCachingExecutorService() {
        return this.mSdk.i0().b();
    }

    protected void log(String string2) {
        if (n.a()) {
            this.mLogger.d(this.mTag, string2);
        }
    }

    protected void log(String string2, Throwable throwable) {
        if (n.a()) {
            this.mLogger.a(this.mTag, string2, throwable);
        }
    }

    protected void userError(String string2) {
        this.userError(string2, null);
    }

    protected void userError(String string2, Throwable throwable) {
        n.c(this.mTag, string2, throwable);
    }

    protected void checkExistence(Class<?> ... classArray) {
        if (classArray != null && classArray.length > 0) {
            int n10 = classArray.length;
            for (int i10 = 0; i10 < n10; ++i10) {
                this.log("Found: " + classArray[i10].getName());
            }
        }
    }

    protected void checkActivities(Context context, Class<?> ... classArray) {
    }

    protected Future<Drawable> createDrawableFuture(final String string2, final Resources resources) {
        return this.getCachingExecutorService().submit(new Callable<Drawable>(){

            @Override
            public Drawable call() throws Exception {
                InputStream inputStream = new URL(string2).openStream();
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                BitmapDrawable bitmapDrawable = new BitmapDrawable(resources, bitmap);
                inputStream.close();
                return bitmapDrawable;
            }
        });
    }

    protected MaxReward getReward() {
        Object object = ((MediationAdapterBase)object).reward;
        if (object == null) {
            object = MaxRewardImpl.createDefault();
        }
        return object;
    }

    protected boolean shouldAlwaysRewardUser() {
        return this.alwaysRewardUser;
    }

    protected void configureReward(MaxAdapterResponseParameters maxAdapterResponseParameters) {
        MediationAdapterBase mediationAdapterBase = string2;
        MaxAdapterResponseParameters maxAdapterResponseParameters2 = maxAdapterResponseParameters;
        maxAdapterResponseParameters = maxAdapterResponseParameters2.getServerParameters();
        mediationAdapterBase.alwaysRewardUser = BundleUtils.getBoolean("always_reward_user", maxAdapterResponseParameters2.isTesting(), (Bundle)maxAdapterResponseParameters);
        int n10 = BundleUtils.getInt("amount", 0, (Bundle)maxAdapterResponseParameters);
        MediationAdapterBase mediationAdapterBase2 = string2;
        String string2 = BundleUtils.getString("currency", "", (Bundle)maxAdapterResponseParameters);
        mediationAdapterBase2.log("Creating reward: " + n10 + " " + (String)string2);
        mediationAdapterBase.reward = MaxRewardImpl.create(n10, string2);
    }

    String getVersionString(Class object, String string2) {
        if ((object = yp.b((Class)object, string2)) == null) {
            this.log("Failed to retrieve version string.");
        }
        return object;
    }

    protected void d(String string2) {
        if (n.a()) {
            this.mLogger.a(this.mTag, string2);
        }
    }

    protected void i(String string2) {
        if (n.a()) {
            this.mLogger.d(this.mTag, string2);
        }
    }

    protected void w(String string2) {
        if (n.a()) {
            this.mLogger.k(this.mTag, string2);
        }
    }

    protected void e(String string2) {
        if (n.a()) {
            this.mLogger.b(this.mTag, string2);
        }
    }

    protected void e(String string2, Throwable throwable) {
        if (n.a()) {
            this.mLogger.a(this.mTag, string2, throwable);
        }
    }

    @Override
    public void loadNativeAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxNativeAdAdapterListener maxNativeAdAdapterListener) {
        this.d("This adapter (" + this.getAdapterVersion() + ") does not support native ads.");
        maxNativeAdAdapterListener.onNativeAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
    }

    @Override
    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, ViewGroup viewGroup, Lifecycle lifecycle, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.d("This adapter (" + this.getAdapterVersion() + ") does not support interstitial ad view ads.");
        maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.INVALID_CONFIGURATION);
    }

    @Override
    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, ViewGroup viewGroup, Lifecycle lifecycle, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.d("This adapter (" + this.getAdapterVersion() + ") does not support rewarded ad view ads.");
        maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.INVALID_CONFIGURATION);
    }

    @Override
    public void loadAppOpenAd(@NonNull MaxAdapterResponseParameters maxAdapterResponseParameters, @Nullable Activity activity, @NonNull MaxAppOpenAdapterListener maxAppOpenAdapterListener) {
        this.d("This adapter (" + this.getAdapterVersion() + ") does not support app open ads.");
        maxAppOpenAdapterListener.onAppOpenAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
    }

    @Override
    public void showAppOpenAd(@NonNull MaxAdapterResponseParameters maxAdapterResponseParameters, @Nullable Activity activity, @NonNull MaxAppOpenAdapterListener maxAppOpenAdapterListener) {
        this.d("This adapter (" + this.getAdapterVersion() + ") does not support app open ads.");
        maxAppOpenAdapterListener.onAppOpenAdDisplayFailed(MaxAdapterError.INVALID_CONFIGURATION);
    }
}

