/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.nativeAds.adPlacer;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.applovin.impl.dd;
import com.applovin.impl.ie;
import com.applovin.impl.sdk.j;
import com.applovin.impl.sdk.n;
import com.applovin.impl.yc;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.mediation.nativeAds.MaxNativeAdViewBinder;
import com.applovin.mediation.nativeAds.adPlacer.MaxAdPlacerSettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MaxAdPlacer
implements dd.a {
    private AppLovinSdkUtils.Size a;
    private MaxNativeAdViewBinder b;
    private final yc c;
    private final dd d;
    protected final j sdk;
    protected final n logger;
    private Listener e;

    public MaxAdPlacer(MaxAdPlacerSettings maxAdPlacerSettings, Context context) {
        this(maxAdPlacerSettings, AppLovinSdk.getInstance(context), context);
    }

    public MaxAdPlacer(MaxAdPlacerSettings maxAdPlacerSettings, AppLovinSdk object, Context context) {
        MaxAdPlacer maxAdPlacer = this;
        this.a = AppLovinSdkUtils.Size.ZERO;
        this.sdk = ((AppLovinSdk)object).a();
        object = this.sdk.I();
        maxAdPlacer.logger = object;
        maxAdPlacer.c = new yc(maxAdPlacerSettings);
        maxAdPlacer.d = new dd(maxAdPlacerSettings, context, this);
        if (n.a()) {
            ((n)object).a("MaxAdPlacer", "Initializing ad placer with settings: " + maxAdPlacerSettings);
        }
    }

    private void a() {
        int n10;
        while (this.d.d() && (n10 = this.c.c()) != -1) {
            if (n.a()) {
                this.logger.a("MaxAdPlacer", "Placing ad at position: " + n10);
            }
            MaxAdPlacer maxAdPlacer = this;
            Object object = maxAdPlacer.d.b();
            maxAdPlacer.c.a((MaxAd)object, n10);
            object = maxAdPlacer.e;
            if (object == null) continue;
            object.onAdLoaded(n10);
        }
    }

    private void a(Collection object, Runnable object2) {
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            MaxAdPlacer maxAdPlacer = this;
            Object object3 = (Integer)iterator.next();
            object3 = maxAdPlacer.c.a((Integer)object3);
            maxAdPlacer.d.a((MaxAd)object3);
        }
        object2.run();
        if (!object.isEmpty()) {
            if (n.a()) {
                this.logger.a("MaxAdPlacer", "Removed " + object.size() + " ads from stream: " + object);
            }
            if (this.e != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    object2 = (Integer)object.next();
                    this.e.onAdRemoved((Integer)object2);
                }
            }
        }
    }

    public void destroy() {
        if (n.a()) {
            this.logger.a("MaxAdPlacer", "Destroying ad placer");
        }
        MaxAdPlacer maxAdPlacer = this;
        maxAdPlacer.clearAds();
        maxAdPlacer.d.c();
    }

    public void setAdSize(int n10, int n11) {
        AppLovinSdkUtils.Size size;
        MaxAdPlacer maxAdPlacer = size2;
        AppLovinSdkUtils.Size size2 = size;
        size = new AppLovinSdkUtils.Size(n10, n11);
        maxAdPlacer.a = size2;
    }

    public void setNativeAdViewBinder(MaxNativeAdViewBinder maxNativeAdViewBinder) {
        this.b = maxNativeAdViewBinder;
    }

    public void setListener(Listener listener) {
        this.e = listener;
    }

    public void loadAds() {
        if (n.a()) {
            this.logger.a("MaxAdPlacer", "Loading ads");
        }
        this.d.e();
    }

    public void clearAds() {
        MaxAdPlacer maxAdPlacer = collection;
        Collection collection = maxAdPlacer.c.b();
        maxAdPlacer.a(collection, () -> {
            if (n.a()) {
                this.logger.a("MaxAdPlacer", "Clearing all cached ads");
            }
            MaxAdPlacer maxAdPlacer = this;
            maxAdPlacer.c.a();
            maxAdPlacer.d.a();
        });
    }

    public Collection<Integer> clearTrailingAds(int n10) {
        Collection collection = this.c.e(n10);
        if (!collection.isEmpty()) {
            MaxAdPlacer maxAdPlacer = this;
            maxAdPlacer.a(collection, () -> {
                if (n.a()) {
                    this.logger.a("MaxAdPlacer", "Clearing trailing ads after position " + n10);
                }
                this.c.a(collection);
            });
        }
        return collection;
    }

    public boolean isAdPosition(int n10) {
        return this.c.g(n10);
    }

    public boolean isFilledPosition(int n10) {
        return this.c.h(n10);
    }

    public long getAdItemId(int n10) {
        if (this.isFilledPosition(n10)) {
            return -System.identityHashCode(this.c.a(n10));
        }
        return 0L;
    }

    public AppLovinSdkUtils.Size getAdSize(int n10, int n11) {
        if (this.isFilledPosition(n10)) {
            AppLovinSdkUtils.Size size = this.a;
            boolean bl2 = size != AppLovinSdkUtils.Size.ZERO;
            n11 = Math.min(bl2 ? size.getWidth() : 360, n11);
            ie ie2 = (ie)this.c.a(n10);
            if ("small_template_1".equalsIgnoreCase(ie2.r0())) {
                int n12 = bl2 ? this.a.getHeight() : 120;
                return new AppLovinSdkUtils.Size(n11, n12);
            }
            if ("medium_template_1".equalsIgnoreCase(ie2.r0())) {
                double d10 = bl2 ? (double)this.a.getWidth() / (double)this.a.getHeight() : 1.2;
                int n13 = n11;
                return new AppLovinSdkUtils.Size(n13, (int)((double)n13 / d10));
            }
            if (bl2) {
                return this.a;
            }
            if (ie2.o0() != null) {
                MaxAdPlacer maxAdPlacer = this = ie2.o0().getMainView();
                int n14 = maxAdPlacer.getMeasuredWidth();
                return new AppLovinSdkUtils.Size(n14, maxAdPlacer.getMeasuredHeight());
            }
        }
        return AppLovinSdkUtils.Size.ZERO;
    }

    public void renderAd(int n10, ViewGroup viewGroup) {
        block15: {
            MaxNativeAdView maxNativeAdView;
            block14: {
                MaxNativeAdView maxNativeAdView2;
                MaxAd maxAd;
                block13: {
                    maxAd = this.c.a(n10);
                    if (maxAd == null) {
                        if (n.a()) {
                            this.logger.a("MaxAdPlacer", "An ad is not available for position: " + n10);
                        }
                        return;
                    }
                    maxNativeAdView = ((ie)maxAd).o0();
                    if (maxNativeAdView == null) break block13;
                    if (n.a()) {
                        this.logger.a("MaxAdPlacer", "Using pre-rendered ad at position: " + n10);
                    }
                    break block14;
                }
                if (this.b == null) break block15;
                maxNativeAdView = maxNativeAdView2;
                MaxNativeAdViewBinder maxNativeAdViewBinder = this.b;
                maxNativeAdView2 = new MaxNativeAdView(maxNativeAdViewBinder, viewGroup.getContext());
                if (this.d.a(maxNativeAdView, maxAd)) {
                    if (n.a()) {
                        this.logger.a("MaxAdPlacer", "Rendered ad at position: " + n10);
                    }
                } else if (n.a()) {
                    this.logger.b("MaxAdPlacer", "Unable to render ad at position: " + n10);
                }
            }
            for (int i10 = viewGroup.getChildCount(); i10 >= 0; --i10) {
                if (!(viewGroup.getChildAt(i10) instanceof MaxNativeAdView)) continue;
                viewGroup.removeViewAt(i10);
            }
            if (maxNativeAdView.getParent() != null) {
                ((ViewGroup)maxNativeAdView.getParent()).removeView((View)maxNativeAdView);
            }
            viewGroup.addView((View)maxNativeAdView, -1, -1);
            return;
        }
        if (n.a()) {
            this.logger.b("MaxAdPlacer", "Unable to render ad at position: " + n10 + ". If you're using a custom ad template, check that nativeAdViewBinder is set.");
        }
    }

    public void updateFillablePositions(int n10, int n11) {
        this.c.c(n10, n11);
        if (n10 != -1 && n11 != -1) {
            this.a();
        }
    }

    public int getAdjustedCount(int n10) {
        return this.c.b(n10);
    }

    public int getAdjustedPosition(int n10) {
        return this.c.c(n10);
    }

    public int getOriginalPosition(int n10) {
        return this.c.d(n10);
    }

    public void insertItem(int n10) {
        if (n.a()) {
            this.logger.a("MaxAdPlacer", "Inserting item at position: " + n10);
        }
        this.c.f(n10);
    }

    public void removeItem(int n10) {
        List<Object> list = this.isFilledPosition(n10) ? Collections.singletonList(n10) : Collections.emptyList();
        MaxAdPlacer maxAdPlacer = this;
        maxAdPlacer.a(list, () -> {
            if (n.a()) {
                this.logger.a("MaxAdPlacer", "Removing item at position: " + n10);
            }
            this.c.i(n10);
        });
    }

    public void moveItem(int n10, int n11) {
        this.c.b(n10, n11);
    }

    @Override
    public void onNativeAdLoaded() {
        if (n.a()) {
            this.logger.a("MaxAdPlacer", "Native ad enqueued");
        }
        this.a();
    }

    @Override
    public void onNativeAdLoadFailed(String string2, MaxError maxError) {
        if (n.a()) {
            this.logger.b("MaxAdPlacer", "Native ad failed to load: " + maxError);
        }
    }

    @Override
    public void onNativeAdClicked(MaxAd maxAd) {
        Listener listener = ((MaxAdPlacer)((Object)listener)).e;
        if (listener != null) {
            listener.onAdClicked(maxAd);
        }
    }

    @Override
    public void onAdRevenuePaid(MaxAd maxAd) {
        Listener listener = ((MaxAdPlacer)((Object)listener)).e;
        if (listener != null) {
            listener.onAdRevenuePaid(maxAd);
        }
    }

    public static interface Listener {
        public void onAdLoaded(int var1);

        public void onAdRemoved(int var1);

        public void onAdClicked(MaxAd var1);

        public void onAdRevenuePaid(MaxAd var1);
    }
}

