package com.applovin.adview;

import com.applovin.impl.adview.InterstitialAdDialogWrapper;
import com.applovin.impl.adview.activity.presenters.FullscreenAdPresenter;

import java.util.concurrent.atomic.AtomicBoolean;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import lombok.Setter;

/**
 * Lifecycle Observer class to manage fullscreen ad view lifecycle events.
 */
public class AppLovinFullscreenAdViewObserver
        implements LifecycleObserver
{
    private final Lifecycle                   lifecycle;
    private       InterstitialAdDialogWrapper parentInterstitialWrapper;

    private final AtomicBoolean         isFirstLifecycleSetup = new AtomicBoolean( true );
    @Setter
    private       FullscreenAdPresenter presenter;

    public AppLovinFullscreenAdViewObserver(final Lifecycle lifecycle, final InterstitialAdDialogWrapper parentInterstitialWrapper)
    {
        this.lifecycle = lifecycle;
        this.parentInterstitialWrapper = parentInterstitialWrapper;

        lifecycle.addObserver( this );
    }

    @OnLifecycleEvent(Lifecycle.Event.ON_PAUSE)
    public void onPause()
    {
        if ( presenter != null )
        {
            presenter.onPause();
            presenter.pauseVideo();
        }
    }

    @OnLifecycleEvent(Lifecycle.Event.ON_RESUME)
    public void onResume()
    {
        if ( isFirstLifecycleSetup.getAndSet( false ) ) return;

        if ( presenter != null )
        {
            presenter.onResume();
            presenter.resumeVideoFromLastPosition( 0 );
        }
    }

    @OnLifecycleEvent(Lifecycle.Event.ON_STOP)
    public void onStop()
    {
        if ( presenter != null )
        {
            presenter.onStop();
        }
    }

    @OnLifecycleEvent(Lifecycle.Event.ON_DESTROY)
    public void onDestroy()
    {
        lifecycle.removeObserver( this );

        if ( parentInterstitialWrapper != null )
        {
            parentInterstitialWrapper.cleanupForAdView();
            parentInterstitialWrapper = null;
        }

        if ( presenter != null )
        {
            presenter.dismiss();
            presenter.onDestroy();
            presenter = null;
        }
    }
}
