/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.array;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.applovin.array.apphub.aidl.IAppHubDirectDownloadServiceCallback;
import com.applovin.array.apphub.aidl.IAppHubService;
import com.applovin.impl.b;
import com.applovin.impl.k0;
import com.applovin.impl.l3;
import com.applovin.impl.l4;
import com.applovin.impl.q2;
import com.applovin.impl.sdk.array.ArrayDataCollector;
import com.applovin.impl.sdk.array.ArrayDirectDownloadAd;
import com.applovin.impl.sdk.k;
import com.applovin.impl.sdk.o;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.y1;
import com.applovin.sdk.AppLovinSdk;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ArrayService
extends IAppHubDirectDownloadServiceCallback.Stub {
    private static final String TAG = "ArrayService";
    private static final String SERVICE_INTENT_FILTER_ACTION = "com.applovin.am.intent.action.APPHUB_SERVICE";
    private static final String SERVICE_INTENT_CLASS_NAME = "com.applovin.oem.am.android.external.AppHubService";
    public static final String DIRECT_DOWNLOAD_EVENT_APP_DETAILS_SHOWN = "APP_DETAILS_SHOWN";
    public static final String DIRECT_DOWNLOAD_EVENT_APP_DETAILS_DISMISSED = "APP_DETAILS_DISMISSED";
    public static final String KEY_AD_TOKEN = "ad_token";
    private static final int MAX_RECONNECT_RETRY_COUNT = 3;
    private int currentRetryCount;
    private final k sdk;
    private final o logger;
    private final ArrayDataCollector dataCollector;
    @Nullable
    private final Intent appHubServiceIntent;
    @Nullable
    private IAppHubService appHubService;
    private final int minVersionCodeWithGenericEventsSupport;
    private long appHubVersionCode = -1L;
    @Nullable
    private Boolean isDirectDownloadEnabled;
    @Nullable
    private String randomUserToken;
    @Nullable
    private String appHubPackageName;
    @Nullable
    private DirectDownloadState currentDownloadState;

    public ArrayService(final k k8) {
        Intent intent;
        this.sdk = k8;
        this.logger = k8.O();
        this.dataCollector = new ArrayDataCollector(k8);
        this.appHubServiceIntent = intent = this.createAppHubServiceIntent();
        this.minVersionCodeWithGenericEventsSupport = (Integer)k8.a(l4.d0);
        if (intent != null) {
            this.bindAppHubService();
        }
        k8.e().a(new b(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onActivityStopped(Activity object) {
                RemoteException remoteException2;
                block6: {
                    1 v02 = map;
                    object = v02.ArrayService.this.currentDownloadState;
                    if (v02.ArrayService.this.appHubService == null) return;
                    if (object == null) {
                        return;
                    }
                    try {
                        map.ArrayService.this.logger;
                    }
                    catch (RemoteException remoteException2) {
                        break block6;
                    }
                    if (o.a()) {
                        map.ArrayService.this.logger.a(ArrayService.TAG, "Dismissing Direct Download Activity");
                    }
                    map.ArrayService.this.appHubService.dismissDirectDownloadAppDetails(((DirectDownloadState)object).adToken);
                    ((DirectDownloadState)object).listener.onEvent(ArrayService.DIRECT_DOWNLOAD_EVENT_APP_DETAILS_DISMISSED, map.ArrayService.this.createBaseExtras(((DirectDownloadState)object).adToken));
                    ArrayService.access$002(map.ArrayService.this, null);
                    return;
                }
                map.ArrayService.this.logger;
                if (o.a()) {
                    map.ArrayService.this.logger.a(ArrayService.TAG, "Failed dismiss Direct Download Activity", remoteException2);
                }
                1 v12 = map;
                Map map = v12.ArrayService.this.getHealthEventExtraParameters();
                v12.k8.E().a(ArrayService.TAG, "dismissDirectDownloadActivity", remoteException2, map);
            }
        });
    }

    private void handleEvent(String string2, Bundle bundle) {
        DirectDownloadState directDownloadState = ((ArrayService)((Object)map)).currentDownloadState;
        if (directDownloadState == null) {
            return;
        }
        if (!directDownloadState.adToken.equalsIgnoreCase(bundle.getString(KEY_AD_TOKEN))) {
            string2 = "Ignoring event (" + string2 + ") for mismatched token.";
            if (o.a()) {
                ((ArrayService)((Object)map)).logger.a(TAG, string2);
            }
            ArrayService arrayService = map;
            Map<String, String> map = arrayService.getHealthEventExtraParameters();
            map.put("source", "ArrayService:handleEvent");
            map.put("details", string2);
            arrayService.sdk.E().d(y1.E0, map);
            return;
        }
        directDownloadState.listener.onEvent(string2, bundle);
        if (DIRECT_DOWNLOAD_EVENT_APP_DETAILS_DISMISSED.equals(string2)) {
            ((ArrayService)((Object)map)).currentDownloadState = null;
        }
    }

    @Nullable
    private Intent createAppHubServiceIntent() {
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent(SERVICE_INTENT_FILTER_ACTION);
        List list = k.o().getPackageManager().queryIntentServices(intent2, 0);
        if (list != null && !list.isEmpty()) {
            Intent intent3 = intent2;
            ArrayService arrayService = string2;
            String string2 = ((ResolveInfo)list.get((int)0)).serviceInfo.packageName;
            arrayService.appHubPackageName = string2;
            intent3.setClassName(string2, SERVICE_INTENT_CLASS_NAME);
            return intent3;
        }
        if (o.a()) {
            ((ArrayService)((Object)string2)).logger.k(TAG, "App Hub not available");
        }
        return null;
    }

    private void bindAppHubService() {
        block10: {
            int n8;
            block9: {
                if (((ArrayService)((Object)map)).currentRetryCount > 3) {
                    if (o.a()) {
                        ((ArrayService)((Object)map)).logger.k(TAG, "Exceeded maximum retry count");
                    }
                    return;
                }
                if (o.a()) {
                    ((ArrayService)((Object)map)).logger.a(TAG, "Attempting connection to App Hub service...");
                }
                ++((ArrayService)((Object)map)).currentRetryCount;
                n8 = 1;
                if (!k0.c()) break block9;
                n8 = 513;
            }
            if (k.o().bindService(((ArrayService)((Object)map)).appHubServiceIntent, new ServiceConnection(){

                public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                    ArrayService.this.logger;
                    if (o.a()) {
                        ArrayService.this.logger.a(ArrayService.TAG, "Connection successful: " + componentName);
                    }
                    ArrayService.access$102(ArrayService.this, IAppHubService.Stub.asInterface(iBinder));
                }

                public void onServiceDisconnected(ComponentName componentName) {
                    ArrayService.this.logger;
                    if (o.a()) {
                        ArrayService.this.logger.b(ArrayService.TAG, "Service disconnected: " + componentName);
                    }
                    2 v02 = this;
                    ArrayService.access$102(v02.ArrayService.this, null);
                    v02.ArrayService.this.logger;
                    if (o.a()) {
                        ArrayService.this.logger.b(ArrayService.TAG, "Retrying...");
                    }
                    ArrayService.this.bindAppHubService();
                }
            }, n8)) break block10;
            if (!o.a()) break block10;
            try {
                ((ArrayService)((Object)map)).logger.k(TAG, "App Hub not available");
            }
            catch (Throwable throwable) {
                if (o.a()) {
                    ((ArrayService)((Object)map)).logger.a(TAG, "Failed to bind to service", throwable);
                }
                ArrayService arrayService = map;
                Map<String, String> map = arrayService.getHealthEventExtraParameters();
                arrayService.sdk.E().a(TAG, "bindAppHubService", throwable, map);
            }
        }
    }

    private Bundle createBaseExtras(String string2) {
        Bundle bundle;
        ArrayService arrayService = bundle;
        bundle = new Bundle();
        BundleUtils.putString(KEY_AD_TOKEN, string2, (Bundle)arrayService);
        return bundle;
    }

    private boolean shouldUseGenericDirectDownloadEvent() {
        if (this.minVersionCodeWithGenericEventsSupport < 0) {
            return false;
        }
        return this.getAppHubVersionCode() >= (long)this.minVersionCodeWithGenericEventsSupport;
    }

    private Map<String, String> getHealthEventExtraParameters() {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        ArrayService arrayService = this;
        hashMap2(2);
        CollectionUtils.putStringIfValid("array_version_code", String.valueOf(arrayService.getAppHubVersionCode()), hashMap2);
        CollectionUtils.putStringIfValid("array_sdk_package_name", arrayService.getAppHubPackageName(), hashMap2);
        return hashMap;
    }

    static /* synthetic */ DirectDownloadState access$002(ArrayService arrayService, DirectDownloadState directDownloadState) {
        arrayService.currentDownloadState = directDownloadState;
        return directDownloadState;
    }

    static /* synthetic */ IAppHubService access$102(ArrayService arrayService, IAppHubService iAppHubService) {
        arrayService.appHubService = iAppHubService;
        return iAppHubService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startDirectInstallOrDownloadProcess(ArrayDirectDownloadAd arrayDirectDownloadAd, @Nullable Bundle bundle, DirectDownloadListener directDownloadListener) {
        Throwable throwable2;
        block11: {
            Bundle bundle2;
            block10: {
                if (((ArrayService)((Object)map)).appHubService == null) {
                    if (o.a()) {
                        ((ArrayService)((Object)map)).logger.b(TAG, "Cannot begin Direct Install / Download process - service disconnected");
                    }
                    directDownloadListener.onFailure();
                    return;
                }
                if (!arrayDirectDownloadAd.isDirectDownloadEnabled()) {
                    if (o.a()) {
                        ((ArrayService)((Object)map)).logger.b(TAG, "Cannot begin Direct Install / Download process - missing token");
                    }
                    directDownloadListener.onFailure();
                    return;
                }
                try {
                    bundle2 = arrayDirectDownloadAd.getDirectDownloadParameters();
                    if (bundle == null) break block10;
                    bundle2.putAll(bundle);
                }
                catch (Throwable throwable2) {
                    break block11;
                }
            }
            ((ArrayService)((Object)map)).currentDownloadState = new DirectDownloadState(arrayDirectDownloadAd.getDirectDownloadToken(), bundle2, directDownloadListener);
            if (o.a()) {
                ((ArrayService)((Object)map)).logger.a(TAG, "Starting Direct Download Activity");
            }
            if (((ArrayService)((Object)map)).appHubVersionCode >= 21L) {
                ((ArrayService)((Object)map)).appHubService.showDirectDownloadAppDetailsWithExtra(((ArrayService)((Object)map)).currentDownloadState.adToken, ((ArrayService)((Object)map)).currentDownloadState.parameters, (IAppHubDirectDownloadServiceCallback)((Object)map));
            } else {
                ((ArrayService)((Object)map)).appHubService.showDirectDownloadAppDetails(((ArrayService)((Object)map)).currentDownloadState.adToken, (IAppHubDirectDownloadServiceCallback)((Object)map));
            }
            if (!o.a()) return;
            ((ArrayService)((Object)map)).logger.a(TAG, "Activity started");
            return;
        }
        if (o.a()) {
            ((ArrayService)((Object)map)).logger.a(TAG, "Failed to execute Direct Install / Download process", throwable2);
        }
        ArrayService arrayService = map;
        Map<String, String> map = arrayService.getHealthEventExtraParameters();
        arrayService.sdk.E().a(TAG, "directInstallDownload", throwable2, map);
        arrayService.currentDownloadState = null;
        directDownloadListener.onFailure();
    }

    public void collectAppHubData() {
        if (!this.isAppHubInstalled()) {
            return;
        }
        if (o.a()) {
            this.logger.a(TAG, "Collecting data...");
        }
        if (this.isDirectDownloadEnabled == null && ((Boolean)this.sdk.a(l4.a0)).booleanValue()) {
            this.isDirectDownloadEnabled = this.dataCollector.collectDirectDownloadEnabled(this.appHubService);
        }
        if (this.appHubVersionCode == -1L && ((Boolean)this.sdk.a(l4.Z)).booleanValue()) {
            this.appHubVersionCode = this.dataCollector.collectAppHubVersionCode(this.appHubService);
        }
        if (TextUtils.isEmpty((CharSequence)this.randomUserToken) && ((Boolean)this.sdk.a(l4.b0)).booleanValue()) {
            this.randomUserToken = this.dataCollector.collectRandomUserToken(this.appHubService);
        }
    }

    public void maybeSendAdEvent(q2 q22, String object) {
        Bundle bundle;
        if (!((Boolean)this.sdk.a(l4.c0)).booleanValue()) {
            return;
        }
        IAppHubService iAppHubService = this.appHubService;
        if (iAppHubService == null) {
            return;
        }
        if (!l3.b(q22)) {
            return;
        }
        if (o.a()) {
            this.logger.a(TAG, "Sending ad event: " + (String)object + " for ad: " + q22);
        }
        q2 q23 = q22;
        q22 = bundle;
        bundle = new Bundle();
        BundleUtils.putString("sdk_version", AppLovinSdk.VERSION, (Bundle)q22);
        BundleUtils.putString("ad_format", q23.getFormat().getLabel(), (Bundle)q22);
        Bundle bundle2 = q23.B();
        if (bundle2 != null) {
            q22.putAll(bundle2);
        }
        try {
            iAppHubService.onAdSdkEvent((String)object, (Bundle)q22);
        }
        catch (Throwable throwable) {
            if (o.a()) {
                this.logger.a(TAG, "Failed to send ad event: " + (String)object, throwable);
            }
            object = CollectionUtils.map("name", object);
            object.putAll(this.getHealthEventExtraParameters());
            this.sdk.E().a(TAG, "failedToSendAdEvent", throwable, (Map)object);
        }
    }

    @Override
    public void onError(String string2, String object) {
        if (o.a()) {
            this.logger.b(TAG, "Encountered error: " + (String)object);
        }
        ArrayService arrayService = this;
        Map<String, String> map = arrayService.getHealthEventExtraParameters();
        CollectionUtils.putStringIfValid("error_message", (String)object, map);
        arrayService.sdk.E().d(y1.n0, map);
        object = arrayService.currentDownloadState;
        if (object == null) {
            return;
        }
        if (!((DirectDownloadState)object).adToken.equalsIgnoreCase(string2)) {
            if (o.a()) {
                this.logger.a(TAG, "Ignoring error callback for mismatched token.");
            }
            map.put("details", "Ignoring error callback for mismatched token.");
            this.sdk.E().a(y1.E0, "ArrayService:onError", map);
            return;
        }
        if (((DirectDownloadState)object).errorCallbackInvoked.compareAndSet(false, true)) {
            ((DirectDownloadState)object).listener.onFailure();
            this.currentDownloadState = null;
        }
    }

    @Override
    public void onAppDetailsShown(String string2) {
        if (o.a()) {
            this.logger.a(TAG, "App details shown");
        }
        if (this.shouldUseGenericDirectDownloadEvent()) {
            return;
        }
        ArrayService arrayService = this;
        arrayService.handleEvent(DIRECT_DOWNLOAD_EVENT_APP_DETAILS_SHOWN, arrayService.createBaseExtras(string2));
    }

    @Override
    public void onAppDetailsDismissed(String string2) {
        if (o.a()) {
            this.logger.a(TAG, "App details dismissed");
        }
        if (this.shouldUseGenericDirectDownloadEvent()) {
            return;
        }
        ArrayService arrayService = this;
        arrayService.handleEvent(DIRECT_DOWNLOAD_EVENT_APP_DETAILS_DISMISSED, arrayService.createBaseExtras(string2));
    }

    @Override
    public void onDownloadStarted(String string2) {
        if (o.a()) {
            this.logger.a(TAG, "Download started");
        }
    }

    @Override
    public void onEvent(String string2, Bundle bundle) {
        if (o.a()) {
            this.logger.a(TAG, "Received event: " + string2);
        }
        if (!this.shouldUseGenericDirectDownloadEvent()) {
            return;
        }
        this.handleEvent(string2, bundle);
    }

    public String getJavaScript(String string2, Bundle bundle) {
        return "javascript:al_onDirectDownloadEvent('" + string2 + "'," + BundleUtils.toJSONObject(bundle) + ");";
    }

    public boolean isAppHubInstalled() {
        return this.appHubService != null;
    }

    public long getAppHubVersionCode() {
        return this.appHubVersionCode;
    }

    @Nullable
    public Boolean getIsDirectDownloadEnabled() {
        return this.isDirectDownloadEnabled;
    }

    @Nullable
    public String getRandomUserToken() {
        return this.randomUserToken;
    }

    @Nullable
    public String getAppHubPackageName() {
        return this.appHubPackageName;
    }

    private static class DirectDownloadState {
        private final AtomicBoolean errorCallbackInvoked;
        private final String adToken;
        @Nullable
        private final Bundle parameters;
        private final DirectDownloadListener listener;

        public DirectDownloadState(String string2, @Nullable Bundle bundle, DirectDownloadListener directDownloadListener) {
            AtomicBoolean atomicBoolean;
            AtomicBoolean atomicBoolean2 = atomicBoolean;
            atomicBoolean = new AtomicBoolean();
            v1.errorCallbackInvoked = atomicBoolean2;
            v1.adToken = string2;
            v1.parameters = bundle;
            v1.listener = directDownloadListener;
        }

        public AtomicBoolean getErrorCallbackInvoked() {
            return this.errorCallbackInvoked;
        }

        public String getAdToken() {
            return this.adToken;
        }

        @Nullable
        public Bundle getParameters() {
            return this.parameters;
        }

        public DirectDownloadListener getListener() {
            return this.listener;
        }

        public boolean equals(Object object) {
            if (object == directDownloadListener) {
                return true;
            }
            if (!(object instanceof DirectDownloadState)) {
                return false;
            }
            if (!((DirectDownloadState)(object = (DirectDownloadState)object)).canEqual(directDownloadListener)) {
                return false;
            }
            Object object2 = ((DirectDownloadState)((Object)directDownloadListener)).getErrorCallbackInvoked();
            Object object3 = ((DirectDownloadState)object).getErrorCallbackInvoked();
            if (object2 == null ? object3 != null : !object2.equals(object3)) {
                return false;
            }
            object2 = ((DirectDownloadState)((Object)directDownloadListener)).getAdToken();
            object3 = ((DirectDownloadState)object).getAdToken();
            if (object2 == null ? object3 != null : !object2.equals(object3)) {
                return false;
            }
            object2 = ((DirectDownloadState)((Object)directDownloadListener)).getParameters();
            object3 = ((DirectDownloadState)object).getParameters();
            if (object2 == null ? object3 != null : !object2.equals(object3)) {
                return false;
            }
            DirectDownloadListener directDownloadListener = ((DirectDownloadState)((Object)directDownloadListener)).getListener();
            object = ((DirectDownloadState)object).getListener();
            return !(directDownloadListener == null ? object != null : !directDownloadListener.equals(object));
        }

        protected boolean canEqual(Object object) {
            return object instanceof DirectDownloadState;
        }

        public int hashCode() {
            AtomicBoolean atomicBoolean = this.getErrorCallbackInvoked();
            int n8 = 59;
            int n9 = atomicBoolean == null ? 43 : atomicBoolean.hashCode();
            n9 = n8 + n9;
            String string2 = this.getAdToken();
            n9 *= 59;
            int n10 = string2 == null ? 43 : string2.hashCode();
            n9 += n10;
            Bundle bundle = this.getParameters();
            int n11 = bundle == null ? 43 : bundle.hashCode();
            int n12 = (n9 *= 59) + n11;
            DirectDownloadListener directDownloadListener = this.getListener();
            int n13 = directDownloadListener == null ? 43 : directDownloadListener.hashCode();
            return (n12 *= 59) + n13;
        }

        public String toString() {
            return "ArrayService.DirectDownloadState(errorCallbackInvoked=" + this.getErrorCallbackInvoked() + ", adToken=" + this.getAdToken() + ", parameters=" + this.getParameters() + ", listener=" + this.getListener() + ")";
        }
    }

    public static interface DirectDownloadListener {
        public void onEvent(String var1, Bundle var2);

        public void onFailure();
    }
}

