/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.o;
import com.applovin.impl.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    public static final String EMPTY_JSON = "{}";

    public static boolean isValid(JSONObject jSONObject) {
        return jSONObject != null && jSONObject.length() > 0;
    }

    @Nullable
    public static JSONObject deserialize(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            return new JSONObject(string2);
        }
        catch (Throwable throwable) {
            o.b("JsonUtils", "Failed to deserialize into JSON: " + string2, throwable);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> tryToStringMap(JSONObject jSONObject) {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            try {
                Object object = JsonUtils.a(jSONObject.get(string2));
                object = object != null ? object.toString() : null;
                hashMap2.put(string2, (String)object);
            }
            catch (Throwable throwable) {
            }
        }
        return hashMap2;
    }

    public static Map<String, String> toStringMap(JSONObject jSONObject) throws JSONException {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            hashMap2.put(string2, JsonUtils.a(jSONObject.get(string2)).toString());
        }
        return hashMap2;
    }

    public static Map<String, Object> toStringObjectMap(JSONObject jSONObject) throws JSONException {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2 = hashMap;
        hashMap = new HashMap<String, Object>();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            hashMap2.put(string2, JsonUtils.a(jSONObject.get(string2)));
        }
        return hashMap2;
    }

    public static Map<String, Object> toStringObjectMap(String string2) {
        try {
            return JsonUtils.toStringObjectMap(new JSONObject(string2));
        }
        catch (JSONException jSONException) {
            o.b("JsonUtils", "Failed to convert json string '" + string2 + "' to map", jSONException);
            return new HashMap<String, Object>();
        }
    }

    public static JSONArray toJsonArray(String string2, JSONArray jSONArray) {
        try {
            return new JSONArray(string2);
        }
        catch (JSONException jSONException) {
            return jSONArray;
        }
    }

    public static Bundle toBundle(Object object) {
        JSONObject jSONObject = null;
        if (object instanceof JSONObject) {
            jSONObject = (JSONObject)object;
        } else if (object instanceof String) {
            JSONObject jSONObject2;
            object = (String)object;
            JSONObject jSONObject3 = jSONObject2;
            try {
                jSONObject2 = new JSONObject((String)object);
                jSONObject = jSONObject3;
            }
            catch (JSONException jSONException) {}
        }
        return JsonUtils.toBundle(jSONObject);
    }

    public static Bundle toBundle(JSONObject jSONObject) {
        if (jSONObject != null && jSONObject.length() != 0) {
            Bundle bundle;
            Bundle bundle2 = bundle;
            bundle = new Bundle();
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (jSONObject.isNull(string2)) {
                    bundle2.putString(string2, null);
                    continue;
                }
                Object object = jSONObject.opt(string2);
                if (object instanceof JSONObject) {
                    bundle2.putBundle(string2, JsonUtils.toBundle((JSONObject)object));
                    continue;
                }
                if (object instanceof JSONArray) {
                    if ((object = (JSONArray)object).length() == 0) {
                        ArrayList arrayList;
                        object = arrayList;
                        arrayList = new ArrayList(0);
                        bundle2.putStringArrayList(string2, (ArrayList)object);
                        continue;
                    }
                    if (JsonUtils.getObjectAtIndex((JSONArray)object, 0, null) instanceof String) {
                        ArrayList<String> arrayList;
                        ArrayList<String> arrayList2 = arrayList;
                        arrayList = new ArrayList<String>(object.length());
                        for (int i8 = 0; i8 < object.length(); ++i8) {
                            arrayList2.add((String)JsonUtils.getObjectAtIndex((JSONArray)object, i8, null));
                        }
                        bundle2.putStringArrayList(string2, arrayList2);
                        continue;
                    }
                    bundle2.putParcelableArrayList(string2, JsonUtils.toBundle((JSONArray)object));
                    continue;
                }
                if (object instanceof Boolean) {
                    bundle2.putBoolean(string2, ((Boolean)object).booleanValue());
                    continue;
                }
                if (object instanceof String) {
                    bundle2.putString(string2, (String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    bundle2.putInt(string2, ((Integer)object).intValue());
                    continue;
                }
                if (object instanceof Long) {
                    bundle2.putLong(string2, ((Long)object).longValue());
                    continue;
                }
                if (!(object instanceof Double)) continue;
                bundle2.putDouble(string2, ((Double)object).doubleValue());
            }
            return bundle2;
        }
        return new Bundle();
    }

    public static ArrayList<Bundle> toBundle(JSONArray jSONArray) {
        if (jSONArray != null && jSONArray.length() != 0) {
            ArrayList<Bundle> arrayList;
            ArrayList<Bundle> arrayList2 = arrayList;
            arrayList = new ArrayList<Bundle>(jSONArray.length());
            for (int i8 = 0; i8 < jSONArray.length(); ++i8) {
                arrayList2.add(JsonUtils.toBundle(jSONArray.optJSONObject(i8)));
            }
            return arrayList2;
        }
        return new ArrayList<Bundle>();
    }

    public static <T> List<T> optList(JSONArray jSONArray, List<T> list) {
        try {
            return JsonUtils.a(jSONArray, list);
        }
        catch (JSONException jSONException) {
            return list;
        }
    }

    public static List<Integer> toIntegerList(JSONArray jSONArray) {
        ArrayList<Integer> arrayList;
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        for (int i8 = 0; i8 < jSONArray.length(); ++i8) {
            try {
                arrayList2.add((Integer)jSONArray.get(i8));
            }
            catch (Throwable throwable) {}
        }
        return arrayList2;
    }

    public static List<String> toStringList(JSONArray jSONArray) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        for (int i8 = 0; i8 < jSONArray.length(); ++i8) {
            try {
                arrayList2.add((String)jSONArray.get(i8));
            }
            catch (Throwable throwable) {}
        }
        return arrayList2;
    }

    public static <T> List<T> toList(JSONArray jSONArray) throws JSONException {
        return JsonUtils.a(jSONArray, new ArrayList());
    }

    private static List a(JSONArray jSONArray, List list) {
        ArrayList arrayList;
        if (jSONArray == null) {
            return list;
        }
        list = arrayList;
        arrayList = new ArrayList(jSONArray.length());
        for (int i8 = 0; i8 < jSONArray.length(); ++i8) {
            list.add(JsonUtils.a(jSONArray.get(i8)));
        }
        return list;
    }

    private static Object a(Object object) {
        if (object == JSONObject.NULL) {
            return null;
        }
        if (object instanceof JSONObject) {
            return JsonUtils.toStringObjectMap((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return JsonUtils.toList((JSONArray)object);
        }
        return object;
    }

    public static JSONObject jsonObjectFromJsonString(String string2, JSONObject jSONObject) {
        try {
            return new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            o.b("JsonUtils", "Failed to convert JSON string '" + string2 + "' to JSONObject", jSONException);
            return jSONObject;
        }
    }

    public static JSONObject shallowCopy(JSONObject jSONObject) {
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2;
        jSONObject2 = new JSONObject();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            try {
                jSONObject3.put(string2, jSONObject.get(string2));
            }
            catch (JSONException jSONException) {
                o.l("JsonUtils", "Failed to copy over item for key '" + string2 + "' to JSONObject copy");
            }
        }
        return jSONObject3;
    }

    public static JSONArray shallowCopy(JSONArray jSONArray) {
        JSONArray jSONArray2;
        JSONArray jSONArray3 = jSONArray2;
        jSONArray2 = new JSONArray();
        for (int i8 = 0; i8 < jSONArray.length(); ++i8) {
            jSONArray3.put(jSONArray.opt(i8));
        }
        return jSONArray3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject deepCopy(JSONObject jSONObject) {
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2;
        jSONObject2 = new JSONObject();
        Iterator iterator = jSONObject.keys();
        while (true) {
            String string2;
            block8: {
                JSONObject jSONObject4;
                Object object;
                if (!iterator.hasNext()) {
                    return jSONObject3;
                }
                string2 = (String)iterator.next();
                try {
                    object = jSONObject.get(string2);
                    if (object instanceof JSONObject) {
                        jSONObject4 = jSONObject3.put(string2, (Object)JsonUtils.deepCopy((JSONObject)object));
                        continue;
                    }
                    if (object instanceof JSONArray) {
                        jSONObject4 = jSONObject3.put(string2, (Object)JsonUtils.deepCopy((JSONArray)object));
                        continue;
                    }
                }
                catch (JSONException jSONException) {
                    break block8;
                }
                jSONObject4 = jSONObject3.put(string2, object);
                continue;
            }
            o.l("JsonUtils", "Failed to copy over item for key '" + string2 + "' to JSONObject deep copy");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONArray deepCopy(JSONArray jSONArray) {
        JSONArray jSONArray2;
        JSONArray jSONArray3 = jSONArray2;
        jSONArray2 = new JSONArray();
        int n8 = 0;
        while (true) {
            block7: {
                block9: {
                    JSONArray jSONArray4;
                    Object object;
                    block8: {
                        if (n8 >= jSONArray.length()) {
                            return jSONArray3;
                        }
                        try {
                            object = jSONArray.get(n8);
                            if (object instanceof JSONObject) {
                                jSONArray4 = jSONArray3.put(n8, (Object)JsonUtils.deepCopy((JSONObject)object));
                                break block7;
                            }
                            if (!(object instanceof JSONArray)) break block8;
                            jSONArray4 = jSONArray3.put(n8, (Object)JsonUtils.deepCopy((JSONArray)object));
                        }
                        catch (JSONException jSONException) {
                            break block9;
                        }
                    }
                    jSONArray4 = jSONArray3.put(n8, object);
                    break block7;
                }
                o.l("JsonUtils", "Failed to copy over item at index " + n8 + " to JSONArray deep copy");
            }
            ++n8;
        }
    }

    public static String maybeConvertToIndentedString(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        try {
            return jSONObject.toString(4);
        }
        catch (JSONException jSONException) {
            return jSONObject.toString();
        }
    }

    public static String maybeConvertToIndentedString(String string2, int n8) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        try {
            return new JSONObject(string2).toString(n8);
        }
        catch (JSONException jSONException) {
            return string2;
        }
    }

    public static boolean valueExists(JSONObject jSONObject, String string2) {
        return jSONObject != null && jSONObject.has(string2);
    }

    public static boolean valueExists(JSONArray jSONArray, Object object) {
        if (jSONArray != null && object != null) {
            for (int i8 = 0; i8 < jSONArray.length(); ++i8) {
                if (!object.equals(JsonUtils.getObjectAtIndex(jSONArray, i8, null))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void removeObjectsForKeys(JSONObject jSONObject, String[] stringArray) {
        int n8 = stringArray.length;
        for (int i8 = 0; i8 < n8; ++i8) {
            jSONObject.remove(stringArray[i8]);
        }
    }

    public static void putObject(JSONObject jSONObject, String string2, Object object) {
        if (jSONObject != null) {
            try {
                jSONObject.put(string2, object);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to put Object property for key = " + string2, jSONException);
            }
        }
    }

    public static void putStringIfValid(JSONArray jSONArray, String string2) {
        if (StringUtils.isValidString(string2)) {
            jSONArray.put((Object)string2);
        }
    }

    public static void putStringIfValid(JSONObject jSONObject, String string2, String string3) {
        if (StringUtils.isValidString(string2) && StringUtils.isValidString(string3)) {
            JsonUtils.putString(jSONObject, string2, string3);
        }
    }

    public static void putString(JSONObject jSONObject, String string2, String string3) {
        if (jSONObject != null) {
            try {
                jSONObject.put(string2, (Object)string3);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to put String property for key = " + string2, jSONException);
            }
        }
    }

    public static String getString(JSONObject jSONObject, String string2, String string3) {
        block4: {
            if (jSONObject != null) {
                if (!jSONObject.has(string2)) break block4;
                try {
                    string3 = jSONObject.getString(string2);
                }
                catch (Exception exception) {
                    o.b("JsonUtils", "Failed to retrieve string property for key = " + string2, exception);
                }
            }
        }
        return string3;
    }

    public static void putInt(JSONObject jSONObject, String string2, int n8) {
        if (jSONObject != null) {
            try {
                jSONObject.put(string2, n8);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to put int property for key = " + string2, jSONException);
            }
        }
    }

    public static int getInt(JSONObject jSONObject, String string2, int n8) {
        if (jSONObject != null && jSONObject.has(string2)) {
            try {
                n8 = jSONObject.getInt(string2);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to retrieve int property for key = " + string2, jSONException);
            }
        }
        return n8;
    }

    @Nullable
    public static Integer getInteger(@Nullable JSONObject jSONObject, String string2, @Nullable Integer n8) {
        if (jSONObject != null && jSONObject.has(string2)) {
            try {
                n8 = jSONObject.getInt(string2);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to retrieve int property for key = " + string2, jSONException);
            }
        }
        return n8;
    }

    public static long getLong(JSONObject jSONObject, String string2, long l8) {
        if (jSONObject != null && jSONObject.has(string2)) {
            try {
                l8 = jSONObject.getLong(string2);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to retrieve long property for key = " + string2, jSONException);
            }
        }
        return l8;
    }

    public static void putLong(JSONObject jSONObject, String string2, long l8) {
        if (jSONObject != null) {
            try {
                jSONObject.put(string2, l8);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to put long property for key = " + string2, jSONException);
            }
        }
    }

    public static double getDouble(JSONObject jSONObject, String string2, double d9) {
        if (jSONObject != null && jSONObject.has(string2)) {
            try {
                d9 = jSONObject.getDouble(string2);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to retrieve double property for key = " + string2, jSONException);
            }
        }
        return d9;
    }

    public static void putDouble(JSONObject jSONObject, String string2, double d9) {
        if (jSONObject != null) {
            try {
                jSONObject.put(string2, d9);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to put double property for key = " + string2, jSONException);
            }
        }
    }

    @Nullable
    public static Double getDouble(JSONObject jSONObject, String string2, @Nullable Double d9) {
        if (jSONObject != null && jSONObject.has(string2)) {
            try {
                d9 = jSONObject.getDouble(string2);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to retrieve Double property for key = " + string2, jSONException);
            }
        }
        return d9;
    }

    public static Boolean getBoolean(JSONObject jSONObject, String string2, Boolean bl) {
        if (jSONObject != null && jSONObject.has(string2)) {
            try {
                bl = jSONObject.getBoolean(string2);
            }
            catch (JSONException jSONException) {
                int n8 = bl != null && bl != false ? 1 : 0;
                return JsonUtils.getInt(jSONObject, string2, n8) > 0;
            }
        }
        return bl;
    }

    public static void putBooleanIfValid(JSONObject jSONObject, String string2, Boolean bl) {
        if (StringUtils.isValidString(string2) && bl != null) {
            JsonUtils.putBoolean(jSONObject, string2, bl);
        }
    }

    public static void putBoolean(JSONObject jSONObject, String string2, boolean bl) {
        if (jSONObject != null) {
            try {
                jSONObject.put(string2, bl);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to put boolean property for key = " + string2, jSONException);
            }
        }
    }

    public static float getFloat(JSONObject jSONObject, String string2, float f8) {
        if (jSONObject != null && jSONObject.has(string2)) {
            double d9;
            try {
                d9 = jSONObject.getDouble(string2);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to retrieve float property for key = " + string2, jSONException);
            }
            if (-3.4028234663852886E38 < d9 && d9 < 3.4028234663852886E38) {
                f8 = (float)d9;
            }
        }
        return f8;
    }

    @Nullable
    public static Float getFloat(JSONObject jSONObject, String string2, @Nullable Float f8) {
        block3: {
            if (jSONObject == null || !jSONObject.has(string2)) break block3;
            double d9 = jSONObject.getDouble(string2);
            if (!(-3.4028234663852886E38 < d9) || !(d9 < 3.4028234663852886E38)) break block3;
            try {
                f8 = Float.valueOf((float)d9);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to retrieve float property for key = " + string2, jSONException);
            }
        }
        return f8;
    }

    public static Object getObject(JSONObject object, String string2, Object object2) {
        if (object != null && object.has(string2)) {
            try {
                object = object.get(string2);
                if (object != null) {
                    object2 = object;
                }
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to retrieve Object for key = " + string2, jSONException);
            }
        }
        return object2;
    }

    public static void putJSONObjectIfValid(JSONObject jSONObject, String string2, JSONObject jSONObject2) {
        if (jSONObject2 != null && jSONObject2.length() != 0) {
            JsonUtils.putJSONObject(jSONObject, string2, jSONObject2);
            return;
        }
    }

    public static void putJSONObject(JSONObject jSONObject, String string2, JSONObject jSONObject2) {
        if (jSONObject != null) {
            try {
                jSONObject.put(string2, (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to put JSON property for key = " + string2, jSONException);
            }
        }
    }

    @Nullable
    public static JSONObject getJSONObject(JSONObject jSONObject, String string2) {
        return JsonUtils.getJSONObject(jSONObject, string2, null);
    }

    @Nullable
    public static JSONObject getJSONObject(JSONObject jSONObject, String string2, @Nullable JSONObject jSONObject2) {
        if (jSONObject != null && jSONObject.has(string2)) {
            try {
                jSONObject2 = jSONObject.getJSONObject(string2);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to retrieve JSON property for key = " + string2, jSONException);
            }
        }
        return jSONObject2;
    }

    public static void putJsonArrayIfValid(JSONObject jSONObject, String string2, JSONArray jSONArray) {
        if (jSONArray != null && jSONArray.length() != 0) {
            JsonUtils.putJsonArray(jSONObject, string2, jSONArray);
            return;
        }
    }

    public static void putJsonArray(JSONObject jSONObject, String string2, JSONArray jSONArray) {
        if (jSONObject != null) {
            try {
                jSONObject.put(string2, (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to put JSONArray property for key = " + string2, jSONException);
            }
        }
    }

    public static Object getObjectAtIndex(JSONArray jSONArray, int n8, Object object) {
        if (jSONArray != null && jSONArray.length() > n8) {
            try {
                object = jSONArray.get(n8);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to retrieve object at index " + n8 + " for JSON array", jSONException);
            }
        }
        return object;
    }

    public static void putAll(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject != null && jSONObject2 != null) {
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object object = JsonUtils.getObject(jSONObject2, string2, null);
                if (object == null) continue;
                JsonUtils.putObject(jSONObject, string2, object);
            }
            return;
        }
    }

    public static void putAll(JSONObject jSONObject, Map<String, ?> object) {
        if (jSONObject != null && object != null) {
            for (Map.Entry entry : object.entrySet()) {
                String string2 = (String)entry.getKey();
                Object v8 = entry.getValue();
                if (v8 == null) continue;
                JsonUtils.putObject(jSONObject, string2, v8);
            }
            return;
        }
    }

    public static List<String> getStringList(JSONObject jSONObject, String string2, List<String> list) {
        if ((jSONObject = JsonUtils.getJSONArray(jSONObject, string2, null)) != null) {
            list = JsonUtils.toStringList((JSONArray)jSONObject);
        }
        return list;
    }

    public static List<Integer> getIntegerList(JSONObject jSONObject, String string2, List<Integer> list) {
        if ((jSONObject = JsonUtils.getJSONArray(jSONObject, string2, null)) != null) {
            list = JsonUtils.toIntegerList((JSONArray)jSONObject);
        }
        return list;
    }

    public static List getList(JSONObject jSONObject, String string2, List list) {
        block4: {
            block3: {
                try {
                    jSONObject = JsonUtils.getJSONArray(jSONObject, string2, null);
                    if (jSONObject == null) break block3;
                }
                catch (JSONException jSONException) {
                    break block4;
                }
                list = JsonUtils.toList((JSONArray)jSONObject);
            }
            return list;
        }
        return list;
    }

    public static JSONArray getJSONArray(JSONObject jSONObject, String string2, JSONArray jSONArray) {
        if (jSONObject != null && jSONObject.has(string2)) {
            try {
                jSONArray = jSONObject.getJSONArray(string2);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to retrieve JSON array for key = " + string2, jSONException);
            }
        }
        return jSONArray;
    }

    public static JSONObject getJSONObject(JSONArray jSONArray, int n8, JSONObject jSONObject) {
        if (jSONArray != null && n8 < jSONArray.length()) {
            try {
                jSONObject = jSONArray.getJSONObject(n8);
            }
            catch (JSONException jSONException) {
                o.b("JsonUtils", "Failed to retrieve JSON object from array for index = " + n8, jSONException);
            }
        }
        return jSONObject;
    }

    public static boolean containsCaseInsensitiveString(String string2, JSONArray jSONArray) {
        int n8 = 0;
        while (true) {
            block7: {
                try {
                    if (n8 >= jSONArray.length()) break;
                }
                catch (JSONException jSONException) {
                    break;
                }
                Object object = jSONArray.get(n8);
                if (!(object instanceof String)) break block7;
                if (((String)object).equalsIgnoreCase(string2)) {
                    return true;
                }
            }
            ++n8;
        }
        return false;
    }

    public static boolean containsJSONObjectContainingInt(JSONArray jSONArray, int n8, String string2) {
        if (jSONArray != null && jSONArray.length() != 0) {
            for (int i8 = 0; i8 < jSONArray.length(); ++i8) {
                JSONObject jSONObject = jSONArray.optJSONObject(i8);
                if (jSONObject == null || jSONObject.optInt(string2) != n8) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static JSONArray getJSONArray(Object object) {
        if (object == null) {
            return new JSONArray();
        }
        JSONArray jSONArray = new JSONArray();
        jSONArray.put(object);
        return jSONArray;
    }
}

