package com.applovin.sdk;

import android.app.Activity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Created by santoshbagadi on 8/3/23.
 * <p>
 * This class provides direct APIs for interfacing with the Google-certified CMP installed, if any.
 */
public interface AppLovinCmpService
{
    interface OnCompletedListener
    {
        /**
         * @param error {@code null} if the flow completed successfully. Otherwise, the error object contains more details about the reason for failure.
         */
        void onCompleted(@Nullable final AppLovinCmpError error);
    }

    /**
     * Shows the CMP flow to an existing user.
     * Note that the user's current consent will be reset before the CMP alert is shown.
     *
     * @param activity          An valid Android {@link Activity} that should be used to show the CMP alert.
     * @param completedListener The completion listener that will be called once the flow finishes showing.
     */
    void showCmpForExistingUser(@NonNull final Activity activity, @NonNull final OnCompletedListener completedListener);

    /**
     * @return {@code true} if a supported CMP is integrated.
     */
    boolean hasSupportedCmp();
}
