package com.applovin.mediation;

import com.applovin.impl.mediation.MaxSegmentCollectionImpl;

import java.util.List;

/**
 * This class contains a collection of {@link MaxSegment} objects.
 * 
 * NOTE: This is an abstract class rather than an interface to fix the static method not found error when minimum Android SDK is <24.
 * TODO: Return to interface when our minimum Android SDK is 24.
 */
public abstract class MaxSegmentCollection
{
    /**
     * @return a list of {@link MaxSegment} objects.
     */
    public abstract List<MaxSegment> getSegments();

    /**
     * Creates a builder object for {@link MaxSegmentCollection}.
     * Please call {@code build()} to create a {@link MaxSegmentCollection} object.
     *
     * @return a {@link MaxSegmentCollection.Builder} object.
     */
    public static Builder builder()
    {
        return new MaxSegmentCollectionImpl.BuilderImpl();
    }

    /**
     * Builder class used to create a {@link MaxSegmentCollection} object.
     */
    public interface Builder
    {
        /**
         * Adds a {@link MaxSegment} to the collection.
         *
         * @param segment The {@link MaxSegment} to add.
         */
        Builder addSegment(final MaxSegment segment);

        /**
         * Builds a {@link MaxSegmentCollection} object from the builder properties' values.
         *
         * @return a {@link MaxSegmentCollection} object.
         */
        MaxSegmentCollection build();
    }
}
