/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amazon.aps.ads.Aps;
import com.amazon.aps.ads.ApsAd;
import com.amazon.aps.ads.ApsAdController;
import com.amazon.aps.ads.ApsAdError;
import com.amazon.aps.ads.ApsAdNetworkInfo;
import com.amazon.aps.ads.ApsAdRequest;
import com.amazon.aps.ads.listeners.ApsAdListener;
import com.amazon.aps.ads.listeners.ApsAdRequestListener;
import com.amazon.aps.ads.model.ApsAdNetwork;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.aps.shared.metrics.ApsMetricsPerfEventModelBuilder;
import com.amazon.aps.shared.metrics.model.ApsMetricsResult;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.DTBAdLoader;
import com.amazon.device.ads.DTBAdRequest;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdSize;
import com.amazon.device.ads.SDKUtilities;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class AmazonAdMarketplaceMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxAdViewAdapter,
MaxInterstitialAdapter,
MaxRewardedAdapter {
    private static final Map<MaxAdFormat, DTBAdLoader> adLoaders = Collections.synchronizedMap(new HashMap());
    private static final Set<Integer> usedAdLoaders = new HashSet<Integer>();
    private static final Map<String, MediationHints> mediationHintsCache = new HashMap<String, MediationHints>();
    private static final Object mediationHintsCacheLock = new Object();
    private static final Map<MaxAdFormat, String> hashedBidderIds = new HashMap<MaxAdFormat, String>();
    private static final Object hashedBidderIdsLock = new Object();
    private ApsAdController adViewController;
    private ApsAdController interstitialAdController;
    private ApsAdController rewardedAdController;

    public AmazonAdMarketplaceMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, @Nullable Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        if (parameters.isTesting()) {
            Aps.setTestingMode((boolean)true);
            Aps.enableLogging((boolean)true);
        }
        onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.DOES_NOT_APPLY, null);
    }

    public String getSdkVersion() {
        return Aps.getSdkVersion();
    }

    public String getAdapterVersion() {
        return "10.1.1.0";
    }

    public void onDestroy() {
        this.maybeCleanupAdView(this.adViewController);
        this.adViewController = null;
        this.maybeCleanupAdView(this.interstitialAdController);
        this.interstitialAdController = null;
        this.maybeCleanupAdView(this.rewardedAdController);
        this.rewardedAdController = null;
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, @Nullable Activity activity, MaxSignalCollectionListener callback) {
        ApsAdRequest retrievedAdLoader;
        long startTime = System.currentTimeMillis();
        ApsMetrics.Companion.setAdapterVersion("MAX" + this.getAdapterVersion());
        ApsMetricsResult metricsResult = ApsMetricsResult.Success;
        String apsBidId = null;
        String corrId = UUID.randomUUID().toString();
        MaxAdFormat adFormat = parameters.getAdFormat();
        Object adResponseObj = parameters.getLocalExtraParameters().get("amazon_ad_response");
        Object adErrorObj = parameters.getLocalExtraParameters().get("amazon_ad_error");
        ApsAdRequest adLoader = null;
        if (adResponseObj instanceof ApsAd) {
            retrievedAdLoader = ((ApsAd)adResponseObj).getAdLoader();
            if (!usedAdLoaders.contains(retrievedAdLoader.hashCode())) {
                this.d("Using ad loader from ad response object: " + retrievedAdLoader);
                adLoader = retrievedAdLoader;
            } else {
                parameters.getLocalExtraParameters().remove("amazon_ad_response");
            }
            apsBidId = ((ApsAd)adResponseObj).getBidId();
        } else if (adResponseObj instanceof DTBAdResponse) {
            retrievedAdLoader = ((DTBAdResponse)adResponseObj).getAdLoader();
            if (!usedAdLoaders.contains(retrievedAdLoader.hashCode())) {
                this.d("Using ad loader from ad response object: " + retrievedAdLoader);
                adLoader = retrievedAdLoader;
            } else {
                parameters.getLocalExtraParameters().remove("amazon_ad_response");
            }
            apsBidId = ((DTBAdResponse)adResponseObj).getBidId();
        }
        if (adErrorObj instanceof ApsAdError) {
            retrievedAdLoader = (ApsAdRequest)((ApsAdError)adErrorObj).getAdLoader();
            corrId = retrievedAdLoader.getCorrelationId();
            if (!usedAdLoaders.contains(retrievedAdLoader.hashCode())) {
                this.d("Using ad loader from ad error object: " + retrievedAdLoader);
                adLoader = retrievedAdLoader;
            } else {
                parameters.getLocalExtraParameters().remove("amazon_ad_error");
            }
        } else if (adErrorObj instanceof AdError) {
            retrievedAdLoader = ((AdError)adErrorObj).getAdLoader();
            corrId = ((DTBAdRequest)retrievedAdLoader).getCorrelationId();
            if (!usedAdLoaders.contains(retrievedAdLoader.hashCode())) {
                this.d("Using ad loader from ad error object: " + retrievedAdLoader);
                adLoader = retrievedAdLoader;
            } else {
                parameters.getLocalExtraParameters().remove("amazon_ad_error");
            }
        }
        DTBAdLoader currentAdLoader = adLoaders.get(adFormat);
        if (adLoader != null) {
            if (adLoader == currentAdLoader) {
                this.d("Passed in ad loader same as current ad loader: " + currentAdLoader);
                this.loadSubsequentSignal((DTBAdLoader)adLoader, corrId, parameters, adFormat, callback);
            } else {
                this.d("New loader passed in for " + adFormat + ": " + adLoader + ", replacing current ad loader: " + currentAdLoader);
                adLoaders.put(adFormat, (DTBAdLoader)adLoader);
                usedAdLoaders.add(adLoader.hashCode());
                if (adResponseObj instanceof DTBAdResponse) {
                    DTBAdResponse adResponse = (DTBAdResponse)adResponseObj;
                    this.processAdResponse(parameters, adResponse, adFormat, callback);
                } else {
                    this.failSignalCollection((AdError)adErrorObj, callback);
                }
            }
        } else if (currentAdLoader != null) {
            this.d("Using cached ad loader: " + currentAdLoader);
            this.loadSubsequentSignal(currentAdLoader, corrId, parameters, adFormat, callback);
        } else {
            this.failSignalCollection("DTBAdResponse or AdError not passed in ad load API", callback);
        }
        ApsMetrics.adapterEvent((String)apsBidId, (ApsMetricsPerfEventModelBuilder)new ApsMetricsPerfEventModelBuilder().withAdapterStartTime(startTime).withCorrelationId(corrId).withAdapterEndTime(metricsResult, System.currentTimeMillis()).withBidId(apsBidId));
    }

    private void loadSubsequentSignal(DTBAdLoader adLoader, String corrId, final MaxAdapterSignalCollectionParameters parameters, final MaxAdFormat adFormat, final MaxSignalCollectionListener callback) {
        this.d("Found existing ad loader (" + adLoader + ") for format: " + adFormat + " - loading...");
        if (!(adLoader instanceof ApsAdRequest)) {
            adLoader = new ApsAdRequest((DTBAdRequest)adLoader);
        }
        ApsAdRequest apsAdRequest = (ApsAdRequest)adLoader;
        apsAdRequest.setCorrelationId(corrId);
        if (apsAdRequest.getAdNetworkInfo() == null) {
            apsAdRequest.setNetworkInfo(new ApsAdNetworkInfo(ApsAdNetwork.MAX));
            ApsMetrics.customEvent((String)"APPLOVIN_SET_NETWORK_EVENT", (String)"AdNetwork Type : null", null);
        } else {
            String adNetworkName = apsAdRequest.getAdNetworkInfo().getAdNetworkName();
            if (!ApsAdNetwork.MAX.toString().equalsIgnoreCase(adNetworkName)) {
                apsAdRequest.setNetworkInfo(new ApsAdNetworkInfo(ApsAdNetwork.MAX));
                String customEventValue = "AdNetwork Type : mismatch . Network name set as " + adNetworkName + ", instead of " + ApsAdNetwork.MAX;
                ApsMetrics.customEvent((String)"APPLOVIN_SET_NETWORK_EVENT", (String)customEventValue, null);
            }
        }
        apsAdRequest.loadAd(new ApsAdRequestListener(){

            public void onSuccess(ApsAd apsAd) {
                adLoaders.put(adFormat, apsAd.getAdLoader());
                usedAdLoaders.add(apsAd.getAdLoader().hashCode());
                AmazonAdMarketplaceMediationAdapter.this.d("Signal collected for ad loader: " + apsAd.getAdLoader());
                AmazonAdMarketplaceMediationAdapter.this.processAdResponse(parameters, (DTBAdResponse)apsAd, adFormat, callback);
            }

            public void onFailure(ApsAdError apsAdError) {
                if (apsAdError.getAdLoader() != null) {
                    adLoaders.put(adFormat, apsAdError.getAdLoader());
                    usedAdLoaders.add(apsAdError.getAdLoader().hashCode());
                    AmazonAdMarketplaceMediationAdapter.this.d("Signal failed to collect for ad loader: " + apsAdError.getAdLoader());
                    AmazonAdMarketplaceMediationAdapter.this.failSignalCollection((AdError)apsAdError, callback);
                } else {
                    APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"MAX - ApsAdError getAdLoader returns null");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAdResponse(MaxAdapterSignalCollectionParameters parameters, DTBAdResponse adResponse, MaxAdFormat adFormat, MaxSignalCollectionListener callback) {
        this.d("Processing ad response...");
        String encodedBidId = SDKUtilities.getPricePoint((DTBAdResponse)adResponse);
        if (AppLovinSdkUtils.isValidString((String)encodedBidId)) {
            MediationHints mediationHints = new MediationHints(adResponse);
            String mediationHintsCacheId = this.getMediationHintsCacheId(encodedBidId, adFormat);
            Object object = mediationHintsCacheLock;
            synchronized (object) {
                mediationHintsCache.put(mediationHintsCacheId, mediationHints);
            }
            long mediationHintsCacheCleanupDelaySec = parameters.getServerParameters().getLong("mediation_hints_cleanup_delay_sec", TimeUnit.MINUTES.toSeconds(5L));
            long mediationHintsCacheCleanupDelayMillis = TimeUnit.SECONDS.toMillis(mediationHintsCacheCleanupDelaySec);
            if (mediationHintsCacheCleanupDelayMillis > 0L) {
                AppLovinSdkUtils.runOnUiThreadDelayed((Runnable)new CleanupMediationHintsTask(mediationHintsCacheId, mediationHints), (long)mediationHintsCacheCleanupDelayMillis);
            }
            String hashedBidderId = adFormat.isAdViewAd() ? String.valueOf(adResponse.getDefaultDisplayAdsRequestCustomParams().get("amznp")) : String.valueOf(adResponse.getDefaultVideoAdsRequestCustomParams().get("amznp"));
            this.setHashedBidderId(adFormat, hashedBidderId);
            this.d("Successfully loaded encoded bid id: " + encodedBidId);
            callback.onSignalCollected(encodedBidId);
        } else {
            this.failSignalCollection("Received empty bid id", callback);
        }
    }

    private void failSignalCollection(AdError adError, MaxSignalCollectionListener callback) {
        this.failSignalCollection("Signal collection failed: " + adError.getCode() + " - " + adError.getMessage(), callback);
    }

    private void failSignalCollection(String errorMessage, MaxSignalCollectionListener callback) {
        this.e(errorMessage);
        callback.onSignalCollectionFailed(errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, @Nullable Activity activity, MaxAdViewAdapterListener listener) {
        MediationHints mediationHints;
        String encodedBidId = parameters.getServerParameters().getString("encoded_bid_id");
        this.d("Loading " + adFormat.getLabel() + " ad view ad for encoded bid id: " + encodedBidId + "...");
        if (TextUtils.isEmpty((CharSequence)encodedBidId)) {
            listener.onAdViewAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
            return;
        }
        String mediationHintsCacheId = this.getMediationHintsCacheId(encodedBidId, adFormat);
        Object object = mediationHintsCacheLock;
        synchronized (object) {
            mediationHints = mediationHintsCache.get(mediationHintsCacheId);
            mediationHintsCache.remove(mediationHintsCacheId);
        }
        if (mediationHints != null) {
            this.adViewController = new ApsAdController(this.getContext(activity), (ApsAdListener)new AdViewListener(adFormat, listener));
            if (mediationHints.dtbAdResponse instanceof ApsAd) {
                this.adViewController.fetchAd((ApsAd)mediationHints.dtbAdResponse);
            } else {
                DTBAdSize dtbAdSize = (DTBAdSize)mediationHints.dtbAdResponse.getDTBAds().get(0);
                this.adViewController.fetchBannerAd(SDKUtilities.getBidInfo((DTBAdResponse)mediationHints.dtbAdResponse), dtbAdSize.getWidth(), dtbAdSize.getHeight());
            }
        } else {
            this.e("Unable to find mediation hints");
            listener.onAdViewAdLoadFailed(MaxAdapterError.INVALID_LOAD_STATE);
        }
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        String encodedBidId = parameters.getServerParameters().getString("encoded_bid_id");
        this.d("Loading interstitial ad for encoded bid id: " + encodedBidId + "...");
        if (TextUtils.isEmpty((CharSequence)encodedBidId)) {
            listener.onInterstitialAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
            return;
        }
        if (activity == null) {
            this.log("Interstitial ad load failed: Activity is null");
            listener.onInterstitialAdLoadFailed(MaxAdapterError.MISSING_ACTIVITY);
            return;
        }
        this.interstitialAdController = new ApsAdController((Context)activity, (ApsAdListener)new InterstitialListener(listener));
        String mediationHintsCacheId = this.getMediationHintsCacheId(encodedBidId, MaxAdFormat.INTERSTITIAL);
        boolean success = this.loadFullscreenAd(mediationHintsCacheId, this.interstitialAdController);
        if (!success) {
            listener.onInterstitialAdLoadFailed(MaxAdapterError.INVALID_LOAD_STATE);
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial ad...");
        if (this.interstitialAdController != null) {
            this.interstitialAdController.show();
        } else {
            this.e("Interstitial ad is null");
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, "Interstitial ad is null"));
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        String encodedBidId = parameters.getServerParameters().getString("encoded_bid_id");
        this.d("Loading rewarded ad for encoded bid id: " + encodedBidId + "...");
        if (TextUtils.isEmpty((CharSequence)encodedBidId)) {
            listener.onRewardedAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
            return;
        }
        if (activity == null) {
            this.log("Rewarded ad load failed: Activity is null");
            listener.onRewardedAdLoadFailed(MaxAdapterError.MISSING_ACTIVITY);
            return;
        }
        this.rewardedAdController = new ApsAdController((Context)activity, (ApsAdListener)new RewardedAdListener(listener));
        String mediationHintsCacheId = this.getMediationHintsCacheId(encodedBidId, MaxAdFormat.REWARDED);
        boolean success = this.loadFullscreenAd(mediationHintsCacheId, this.rewardedAdController);
        if (!success) {
            listener.onRewardedAdLoadFailed(MaxAdapterError.INVALID_LOAD_STATE);
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad...");
        if (this.rewardedAdController != null) {
            this.configureReward(parameters);
            this.rewardedAdController.show();
        } else {
            this.e("Rewarded ad is null");
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, "Rewarded ad is null"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFullscreenAd(String mediationHintsCacheId, ApsAdController apsAdController) {
        MediationHints mediationHints;
        Object object = mediationHintsCacheLock;
        synchronized (object) {
            mediationHints = mediationHintsCache.get(mediationHintsCacheId);
            mediationHintsCache.remove(mediationHintsCacheId);
        }
        if (mediationHints == null) {
            this.e("Unable to find mediation hints");
            return false;
        }
        apsAdController.fetchInterstitialAd(SDKUtilities.getBidInfo((DTBAdResponse)mediationHints.dtbAdResponse));
        return true;
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHashedBidderId(MaxAdFormat adFormat, String hashedBidderId) {
        Object object = hashedBidderIdsLock;
        synchronized (object) {
            hashedBidderIds.put(adFormat, hashedBidderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle createExtraInfo(MaxAdFormat adFormat, String creativeId) {
        Bundle extraInfo = new Bundle(2);
        if (AppLovinSdkUtils.isValidString((String)creativeId)) {
            extraInfo.putString("creative_id", creativeId);
        }
        Object object = hashedBidderIdsLock;
        synchronized (object) {
            String hashedBidderId = hashedBidderIds.get(adFormat);
            if (AppLovinSdkUtils.isValidString((String)hashedBidderId)) {
                Bundle adValues = new Bundle(1);
                adValues.putString("amazon_hashed_bidder_id", hashedBidderId);
                extraInfo.putBundle("ad_values", adValues);
            }
        }
        return extraInfo;
    }

    private String getMediationHintsCacheId(String encodedBidId, MaxAdFormat adFormat) {
        String adFormatLabel = adFormat == MaxAdFormat.LEADER ? MaxAdFormat.BANNER.getLabel() : adFormat.getLabel();
        return encodedBidId + "_" + adFormatLabel;
    }

    private void maybeCleanupAdView(ApsAdController apsAdController) {
        if (apsAdController != null && apsAdController.getApsAdView() != null) {
            apsAdController.getApsAdView().cleanup();
        }
    }

    private static class MediationHints {
        private final DTBAdResponse dtbAdResponse;
        private final String id = UUID.randomUUID().toString().toLowerCase(Locale.US);

        private MediationHints(DTBAdResponse dtbAdResponse) {
            this.dtbAdResponse = dtbAdResponse;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MediationHints)) {
                return false;
            }
            MediationHints mediationHints = (MediationHints)o;
            if (this.id != null ? !this.id.equals(mediationHints.id) : mediationHints.id != null) {
                return false;
            }
            return this.dtbAdResponse != null ? this.dtbAdResponse.equals(mediationHints.dtbAdResponse) : mediationHints.dtbAdResponse == null;
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.dtbAdResponse != null ? this.dtbAdResponse.hashCode() : 0);
            return result;
        }

        @NonNull
        public String toString() {
            return "MediationHints{id=" + this.id + ", dtbAdResponse=" + this.dtbAdResponse + '}';
        }
    }

    private static class CleanupMediationHintsTask
    implements Runnable {
        private final String mediationHintsCacheId;
        private final MediationHints mediationHints;

        private CleanupMediationHintsTask(String mediationHintsCacheId, MediationHints mediationHints) {
            this.mediationHintsCacheId = mediationHintsCacheId;
            this.mediationHints = mediationHints;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = mediationHintsCacheLock;
            synchronized (object) {
                MediationHints currentMediationHints = (MediationHints)mediationHintsCache.get(this.mediationHintsCacheId);
                if (currentMediationHints != null && currentMediationHints.id.equals(this.mediationHints.id)) {
                    mediationHintsCache.remove(this.mediationHintsCacheId);
                }
            }
        }
    }

    private class AdViewListener
    implements ApsAdListener {
        private final MaxAdFormat adFormat;
        private final MaxAdViewAdapterListener listener;

        private AdViewListener(MaxAdFormat adFormat, MaxAdViewAdapterListener listener) {
            this.adFormat = adFormat;
            this.listener = listener;
        }

        public void onAdLoaded(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("AdView ad loaded");
            Bundle extraInfo = AmazonAdMarketplaceMediationAdapter.this.createExtraInfo(this.adFormat, apsAd.getCrid());
            this.listener.onAdViewAdLoaded((View)apsAd.getAdView(), extraInfo);
        }

        public void onAdFailedToLoad(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.e("AdView failed to load");
            this.listener.onAdViewAdLoadFailed(MaxAdapterError.UNSPECIFIED);
        }

        public void onAdClicked(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("AdView clicked");
            this.listener.onAdViewAdClicked();
        }

        public void onImpressionFired(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("AdView impression fired");
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdError(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.e("AdView error");
        }

        public void onAdOpen(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("AdView expanded");
            this.listener.onAdViewAdExpanded();
        }

        public void onAdClosed(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("AdView collapsed");
            this.listener.onAdViewAdCollapsed();
        }
    }

    private class InterstitialListener
    implements ApsAdListener {
        private final MaxInterstitialAdapterListener listener;

        InterstitialListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("Interstitial loaded");
            Bundle extraInfo = AmazonAdMarketplaceMediationAdapter.this.createExtraInfo(MaxAdFormat.INTERSTITIAL, apsAd.getCrid());
            this.listener.onInterstitialAdLoaded(extraInfo);
        }

        public void onAdFailedToLoad(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.e("Interstitial failed to load");
            this.listener.onInterstitialAdLoadFailed(MaxAdapterError.NO_FILL);
        }

        public void onImpressionFired(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("Interstitial did fire impression");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdError(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.e("Interstitial ad error");
        }

        public void onAdOpen(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("Interstitial did open");
        }

        public void onAdClicked(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("Interstitial clicked");
            this.listener.onInterstitialAdClicked();
        }

        public void onVideoCompleted(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("Interstitial video completed");
        }

        public void onAdClosed(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("Interstitial closed");
            this.listener.onInterstitialAdHidden();
        }
    }

    private class RewardedAdListener
    implements ApsAdListener {
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedAdListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("Rewarded ad loaded");
            Bundle extraInfo = AmazonAdMarketplaceMediationAdapter.this.createExtraInfo(MaxAdFormat.REWARDED, apsAd.getCrid());
            this.listener.onRewardedAdLoaded(extraInfo);
        }

        public void onAdFailedToLoad(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.e("Rewarded ad failed to load");
            this.listener.onRewardedAdLoadFailed(MaxAdapterError.NO_FILL);
        }

        public void onImpressionFired(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("Rewarded ad did fire impression");
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdError(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.e("Rewarded ad error");
        }

        public void onAdOpen(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("Rewarded ad did open");
        }

        public void onAdClicked(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("Rewarded ad clicked");
            this.listener.onRewardedAdClicked();
        }

        public void onVideoCompleted(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("Rewarded ad video completed");
            this.hasGrantedReward = true;
        }

        public void onAdClosed(ApsAd apsAd) {
            AmazonAdMarketplaceMediationAdapter.this.d("Rewarded ad closed");
            if (this.hasGrantedReward || AmazonAdMarketplaceMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = AmazonAdMarketplaceMediationAdapter.this.getReward();
                AmazonAdMarketplaceMediationAdapter.this.d("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            this.listener.onRewardedAdHidden();
        }
    }
}

