/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxNativeAdAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import io.bidmachine.AdListener;
import io.bidmachine.AdRequest;
import io.bidmachine.AdsFormat;
import io.bidmachine.BidMachine;
import io.bidmachine.BidTokenCallback;
import io.bidmachine.ImageData;
import io.bidmachine.InitializationCallback;
import io.bidmachine.MediaAssetType;
import io.bidmachine.banner.BannerListener;
import io.bidmachine.banner.BannerRequest;
import io.bidmachine.banner.BannerSize;
import io.bidmachine.banner.BannerView;
import io.bidmachine.interstitial.InterstitialAd;
import io.bidmachine.interstitial.InterstitialListener;
import io.bidmachine.interstitial.InterstitialRequest;
import io.bidmachine.models.AuctionResult;
import io.bidmachine.nativead.NativeAd;
import io.bidmachine.nativead.NativeListener;
import io.bidmachine.nativead.NativeRequest;
import io.bidmachine.nativead.view.NativeMediaView;
import io.bidmachine.rewarded.RewardedAd;
import io.bidmachine.rewarded.RewardedListener;
import io.bidmachine.rewarded.RewardedRequest;
import io.bidmachine.utils.BMError;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class BidMachineMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter,
MaxNativeAdAdapter {
    private static final int DEFAULT_IMAGE_TASK_TIMEOUT_SECONDS = 10;
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus status;
    private InterstitialAd interstitialAd;
    private RewardedAd rewardedAd;
    private BannerView adView;
    private NativeAd nativeAd;

    public BidMachineMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, @Nullable Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            status = MaxAdapter.InitializationStatus.INITIALIZING;
            final String sourceId = parameters.getServerParameters().getString("source_id");
            this.log("Initializing BidMachine SDK with source id: " + sourceId);
            BidMachine.setLoggingEnabled((boolean)parameters.isTesting());
            BidMachine.setTestMode((boolean)parameters.isTesting());
            this.updateSettings((MaxAdapterParameters)parameters);
            BidMachine.initialize((Context)this.getApplicationContext(), (String)sourceId, (InitializationCallback)new InitializationCallback(){

                public void onInitialized() {
                    BidMachineMediationAdapter.this.log("BidMachine SDK successfully finished initialization with source id: " + sourceId);
                    status = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(status, null);
                }
            });
        } else {
            onCompletionListener.onCompletion(status, null);
        }
    }

    public String getSdkVersion() {
        return this.getVersionString(BidMachine.class, "VERSION");
    }

    public String getAdapterVersion() {
        return "3.2.1.0";
    }

    public void onDestroy() {
        if (this.interstitialAd != null) {
            this.interstitialAd.setListener(null);
            this.interstitialAd.destroy();
            this.interstitialAd = null;
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.setListener(null);
            this.rewardedAd.destroy();
            this.rewardedAd = null;
        }
        if (this.adView != null) {
            this.adView.setListener(null);
            this.adView.destroy();
            this.adView = null;
        }
        if (this.nativeAd != null) {
            this.nativeAd.unregisterView();
            this.nativeAd.setListener(null);
            this.nativeAd.destroy();
            this.nativeAd = null;
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, @Nullable Activity activity, final MaxSignalCollectionListener callback) {
        this.log("Collecting signal for " + parameters.getAdFormat().getLabel() + " ad...");
        this.updateSettings((MaxAdapterParameters)parameters);
        BidMachine.getBidToken((Context)this.getApplicationContext(), (AdsFormat)this.toAdsFormat(parameters), (BidTokenCallback)new BidTokenCallback(){

            public void onCollected(@NonNull String bidToken) {
                BidMachineMediationAdapter.this.log("Signal collection successful");
                callback.onSignalCollected(bidToken);
            }
        });
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Loading interstitial ad...");
        this.updateSettings((MaxAdapterParameters)parameters);
        this.interstitialAd = new InterstitialAd(this.getApplicationContext());
        this.interstitialAd.setListener((AdListener)new InterstitialAdListener(listener));
        this.interstitialAd.load((AdRequest)((InterstitialRequest)((InterstitialRequest.Builder)new InterstitialRequest.Builder().setBidPayload(parameters.getBidResponse())).build()));
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial ad...");
        if (this.interstitialAd.isExpired()) {
            this.log("Unable to show interstitial - ad expired");
            listener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_EXPIRED);
            return;
        }
        if (!this.interstitialAd.canShow()) {
            this.log("Unable to show interstitial - ad not ready");
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, "Interstitial ad not ready"));
            return;
        }
        this.interstitialAd.show();
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Loading rewarded ad...");
        this.updateSettings((MaxAdapterParameters)parameters);
        this.rewardedAd = new RewardedAd(this.getApplicationContext());
        this.rewardedAd.setListener((AdListener)new RewardedAdListener(listener));
        this.rewardedAd.load((AdRequest)((RewardedRequest)((RewardedRequest.Builder)new RewardedRequest.Builder().setBidPayload(parameters.getBidResponse())).build()));
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad...");
        if (this.rewardedAd.isExpired()) {
            this.log("Unable to show rewarded ad - ad expired");
            listener.onRewardedAdDisplayFailed(MaxAdapterError.AD_EXPIRED);
            return;
        }
        if (!this.rewardedAd.canShow()) {
            this.log("Unable to show rewarded ad - ad not ready");
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, "Rewarded ad not ready"));
            return;
        }
        this.configureReward(parameters);
        this.rewardedAd.show();
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, @Nullable Activity activity, MaxAdViewAdapterListener listener) {
        this.log("Loading " + adFormat.getLabel() + " ad...");
        this.updateSettings((MaxAdapterParameters)parameters);
        this.adView = new BannerView(this.getApplicationContext());
        this.adView.setListener((AdListener)new AdViewListener(listener));
        this.adView.load((AdRequest)((BannerRequest)((BannerRequest.Builder)new BannerRequest.Builder().setSize(this.toAdSize(adFormat)).setBidPayload(parameters.getBidResponse())).build()));
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxNativeAdAdapterListener listener) {
        this.log("Loading native ad...");
        this.updateSettings((MaxAdapterParameters)parameters);
        this.nativeAd = new NativeAd(this.getApplicationContext());
        this.nativeAd.setListener((AdListener)new NativeAdListener(parameters.getServerParameters(), listener));
        this.nativeAd.load((AdRequest)((NativeRequest)((NativeRequest.Builder)new NativeRequest.Builder().setMediaAssetTypes(new MediaAssetType[]{MediaAssetType.All}).setBidPayload(parameters.getBidResponse())).build()));
    }

    private MaxAdapterError toMaxError(BMError bidMachineError) {
        int bidMachineErrorCode = bidMachineError.getCode();
        MaxAdapterError maxAdapterError = MaxAdapterError.UNSPECIFIED;
        switch (bidMachineErrorCode) {
            case 100: {
                maxAdapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case 102: {
                maxAdapterError = MaxAdapterError.TIMEOUT;
                break;
            }
            case 110: {
                maxAdapterError = MaxAdapterError.BAD_REQUEST;
                break;
            }
            case 109: 
            case 200: {
                maxAdapterError = MaxAdapterError.SERVER_ERROR;
                break;
            }
            case 103: {
                maxAdapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case 107: {
                maxAdapterError = MaxAdapterError.AD_EXPIRED;
                break;
            }
            case 101: 
            case 106: 
            case 108: {
                maxAdapterError = MaxAdapterError.INTERNAL_ERROR;
            }
        }
        return new MaxAdapterError(maxAdapterError.getCode(), maxAdapterError.getMessage(), bidMachineErrorCode, bidMachineError.getMessage());
    }

    private BannerSize toAdSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER) {
            return BannerSize.Size_320x50;
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return BannerSize.Size_728x90;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return BannerSize.Size_300x250;
        }
        throw new IllegalArgumentException("Invalid ad format: " + adFormat);
    }

    @Nullable
    private AdsFormat toAdsFormat(MaxAdapterSignalCollectionParameters parameters) {
        MaxAdFormat adFormat = parameters.getAdFormat();
        if (adFormat == MaxAdFormat.BANNER) {
            return AdsFormat.Banner_320x50;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return AdsFormat.Banner_300x250;
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return AdsFormat.Banner_728x90;
        }
        if (adFormat == MaxAdFormat.NATIVE) {
            return AdsFormat.Native;
        }
        if (adFormat == MaxAdFormat.INTERSTITIAL) {
            return AdsFormat.Interstitial;
        }
        if (adFormat == MaxAdFormat.REWARDED) {
            return AdsFormat.Rewarded;
        }
        return null;
    }

    private void updateSettings(MaxAdapterParameters parameters) {
        Boolean isDoNotSell;
        Boolean hasUserConsent = parameters.hasUserConsent();
        if (hasUserConsent != null) {
            BidMachine.setConsentConfig((boolean)hasUserConsent, null);
        }
        if ((isDoNotSell = parameters.isDoNotSell()) != null) {
            BidMachine.setUSPrivacyString((String)(isDoNotSell != false ? "1YY-" : "1YN-"));
        } else {
            BidMachine.setUSPrivacyString((String)"1---");
        }
    }

    @Nullable
    private String getCreativeId(@Nullable AuctionResult result) {
        return result != null ? result.getCreativeId() : null;
    }

    private class InterstitialAdListener
    implements InterstitialListener {
        private final MaxInterstitialAdapterListener listener;

        public InterstitialAdListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
            BidMachineMediationAdapter.this.log("Interstitial ad loaded");
            String creativeID = BidMachineMediationAdapter.this.getCreativeId(interstitialAd.getAuctionResult());
            Bundle extraInfo = null;
            if (!TextUtils.isEmpty((CharSequence)creativeID)) {
                extraInfo = new Bundle(1);
                extraInfo.putString("creative_id", creativeID);
            }
            this.listener.onInterstitialAdLoaded(extraInfo);
        }

        public void onAdLoadFailed(@NonNull InterstitialAd interstitialAd, @NonNull BMError bmError) {
            MaxAdapterError maxAdapterError = BidMachineMediationAdapter.this.toMaxError(bmError);
            BidMachineMediationAdapter.this.log("Interstitial ad failed to load with error (" + maxAdapterError + ")");
            this.listener.onInterstitialAdLoadFailed(maxAdapterError);
        }

        public void onAdShowFailed(@NonNull InterstitialAd interstitialAd, @NonNull BMError bmError) {
            MaxAdapterError maxAdapterError = BidMachineMediationAdapter.this.toMaxError(bmError);
            BidMachineMediationAdapter.this.log("Interstitial ad failed to show with error (" + maxAdapterError + ")");
            this.listener.onInterstitialAdDisplayFailed(maxAdapterError);
        }

        public void onAdImpression(@NonNull InterstitialAd interstitialAd) {
            BidMachineMediationAdapter.this.log("Interstitial ad impression");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdClicked(@NonNull InterstitialAd interstitialAd) {
            BidMachineMediationAdapter.this.log("Interstitial ad clicked");
            this.listener.onInterstitialAdClicked();
        }

        public void onAdClosed(@NonNull InterstitialAd interstitialAd, boolean finished) {
            BidMachineMediationAdapter.this.log("Interstitial ad closed");
            this.listener.onInterstitialAdHidden();
        }

        public void onAdExpired(@NonNull InterstitialAd interstitialAd) {
            BidMachineMediationAdapter.this.log("Interstitial ad expired");
        }
    }

    private class RewardedAdListener
    implements RewardedListener {
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        public RewardedAdListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
            BidMachineMediationAdapter.this.log("Rewarded ad loaded");
            String creativeID = BidMachineMediationAdapter.this.getCreativeId(rewardedAd.getAuctionResult());
            Bundle extraInfo = null;
            if (!TextUtils.isEmpty((CharSequence)creativeID)) {
                extraInfo = new Bundle(1);
                extraInfo.putString("creative_id", creativeID);
            }
            this.listener.onRewardedAdLoaded(extraInfo);
        }

        public void onAdLoadFailed(@NonNull RewardedAd rewardedAd, @NonNull BMError bmError) {
            MaxAdapterError maxAdapterError = BidMachineMediationAdapter.this.toMaxError(bmError);
            BidMachineMediationAdapter.this.log("Rewarded ad failed to load with error (" + maxAdapterError + ")");
            this.listener.onRewardedAdLoadFailed(maxAdapterError);
        }

        public void onAdShowFailed(@NonNull RewardedAd rewardedAd, @NonNull BMError bmError) {
            MaxAdapterError maxAdapterError = BidMachineMediationAdapter.this.toMaxError(bmError);
            BidMachineMediationAdapter.this.log("Rewarded ad failed to show with error (" + maxAdapterError + ")");
            this.listener.onRewardedAdDisplayFailed(maxAdapterError);
        }

        public void onAdImpression(@NonNull RewardedAd rewardedAd) {
            BidMachineMediationAdapter.this.log("Rewarded ad impression");
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdClicked(@NonNull RewardedAd rewardedAd) {
            BidMachineMediationAdapter.this.log("Rewarded ad clicked");
            this.listener.onRewardedAdClicked();
        }

        public void onAdRewarded(@NonNull RewardedAd rewardedAd) {
            BidMachineMediationAdapter.this.log("Rewarded ad should grant reward");
            this.hasGrantedReward = true;
        }

        public void onAdClosed(@NonNull RewardedAd rewardedAd, boolean finished) {
            BidMachineMediationAdapter.this.log("Rewarded ad closed");
            if (this.hasGrantedReward || BidMachineMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = BidMachineMediationAdapter.this.getReward();
                BidMachineMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            this.listener.onRewardedAdHidden();
        }

        public void onAdExpired(@NonNull RewardedAd rewardedAd) {
            BidMachineMediationAdapter.this.log("Rewarded ad expired");
        }
    }

    private class AdViewListener
    implements BannerListener {
        private final MaxAdViewAdapterListener listener;

        public AdViewListener(MaxAdViewAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull BannerView bannerView) {
            BidMachineMediationAdapter.this.log("AdView ad loaded");
            String creativeID = BidMachineMediationAdapter.this.getCreativeId(bannerView.getAuctionResult());
            Bundle extraInfo = null;
            if (!TextUtils.isEmpty((CharSequence)creativeID)) {
                extraInfo = new Bundle(1);
                extraInfo.putString("creative_id", creativeID);
            }
            this.listener.onAdViewAdLoaded((View)bannerView, extraInfo);
        }

        public void onAdLoadFailed(@NonNull BannerView bannerView, @NonNull BMError bmError) {
            MaxAdapterError maxAdapterError = BidMachineMediationAdapter.this.toMaxError(bmError);
            BidMachineMediationAdapter.this.log("AdView ad failed to load with error (" + maxAdapterError + ")");
            this.listener.onAdViewAdLoadFailed(maxAdapterError);
        }

        public void onAdImpression(@NonNull BannerView bannerView) {
            BidMachineMediationAdapter.this.log("AdView ad impression");
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdShowFailed(@NonNull BannerView bannerView, @NonNull BMError bmError) {
            MaxAdapterError maxAdapterError = BidMachineMediationAdapter.this.toMaxError(bmError);
            BidMachineMediationAdapter.this.log("AdView ad failed to show with error (" + maxAdapterError + ")");
            this.listener.onAdViewAdDisplayFailed(maxAdapterError);
        }

        public void onAdClicked(@NonNull BannerView bannerView) {
            BidMachineMediationAdapter.this.log("AdView ad clicked");
            this.listener.onAdViewAdClicked();
        }

        public void onAdExpired(@NonNull BannerView bannerView) {
            BidMachineMediationAdapter.this.log("AdView ad expired");
        }
    }

    private class NativeAdListener
    implements NativeListener {
        private final Bundle serverParameters;
        private final MaxNativeAdAdapterListener listener;

        public NativeAdListener(Bundle serverParameters, MaxNativeAdAdapterListener listener) {
            this.serverParameters = serverParameters;
            this.listener = listener;
        }

        public void onAdLoaded(final @NonNull NativeAd nativeAd) {
            BidMachineMediationAdapter.this.log("Native ad loaded");
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)nativeAd.getTitle())) {
                BidMachineMediationAdapter.this.e("Native ad (" + nativeAd + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                return;
            }
            ImageData iconImageData = nativeAd.getIcon();
            if (iconImageData == null) {
                this.handleNativeAdLoaded(nativeAd, null);
                return;
            }
            MaxNativeAd.MaxNativeAdImage maxNativeAdImage = null;
            Drawable image = iconImageData.getImage();
            Uri localUri = iconImageData.getLocalUri();
            final String remoteUrl = iconImageData.getRemoteUrl();
            if (image != null) {
                maxNativeAdImage = new MaxNativeAd.MaxNativeAdImage(image);
            } else if (localUri != null) {
                maxNativeAdImage = new MaxNativeAd.MaxNativeAdImage(localUri);
            } else if (remoteUrl != null) {
                BidMachineMediationAdapter.this.getCachingExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        Drawable image = null;
                        BidMachineMediationAdapter.this.log("Adding native ad icon (" + remoteUrl + ") to queue to be fetched");
                        Future imageFuture = BidMachineMediationAdapter.this.createDrawableFuture(remoteUrl, BidMachineMediationAdapter.this.getApplicationContext().getResources());
                        int imageTaskTimeoutSeconds = BundleUtils.getInt((String)"image_task_timeout_seconds", (int)10, (Bundle)NativeAdListener.this.serverParameters);
                        try {
                            image = (Drawable)imageFuture.get(imageTaskTimeoutSeconds, TimeUnit.SECONDS);
                        }
                        catch (Throwable th) {
                            BidMachineMediationAdapter.this.e("Failed to fetch icon image", th);
                        }
                        MaxNativeAd.MaxNativeAdImage maxNativeAdImage = new MaxNativeAd.MaxNativeAdImage(image);
                        NativeAdListener.this.handleNativeAdLoaded(nativeAd, maxNativeAdImage);
                    }
                });
                return;
            }
            this.handleNativeAdLoaded(nativeAd, maxNativeAdImage);
        }

        public void onAdLoadFailed(@NonNull NativeAd nativeAd, @NonNull BMError bmError) {
            MaxAdapterError maxAdapterError = BidMachineMediationAdapter.this.toMaxError(bmError);
            BidMachineMediationAdapter.this.log("Native ad failed to load with error (" + maxAdapterError + ")");
            this.listener.onNativeAdLoadFailed(maxAdapterError);
        }

        public void onAdImpression(@NonNull NativeAd nativeAd) {
            BidMachineMediationAdapter.this.log("Native ad impression");
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdShowFailed(@NonNull NativeAd nativeAd, @NonNull BMError bmError) {
            BidMachineMediationAdapter.this.log("Native ad failed to show with error (" + bmError + ")");
        }

        public void onAdClicked(@NonNull NativeAd nativeAd) {
            BidMachineMediationAdapter.this.log("Native ad clicked");
            this.listener.onNativeAdClicked();
        }

        public void onAdExpired(@NonNull NativeAd nativeAd) {
            BidMachineMediationAdapter.this.log("Native ad expired");
        }

        private void handleNativeAdLoaded(final @NonNull NativeAd nativeAd, final MaxNativeAd.MaxNativeAdImage iconMaxNativeAdImage) {
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NativeMediaView mediaView = new NativeMediaView(BidMachineMediationAdapter.this.getApplicationContext());
                    MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(nativeAd.getTitle()).setBody(nativeAd.getDescription()).setCallToAction(nativeAd.getCallToAction()).setIcon(iconMaxNativeAdImage).setOptionsView(nativeAd.getProviderView(BidMachineMediationAdapter.this.getApplicationContext())).setMediaView((View)mediaView);
                    if (nativeAd.getMainImage() != null) {
                        MaxNativeAd.MaxNativeAdImage mainImage = new MaxNativeAd.MaxNativeAdImage(nativeAd.getMainImage().getImage());
                        builder.setMainImage(mainImage);
                    }
                    MaxBidMachineNativeAd maxBidMachineNativeAd = new MaxBidMachineNativeAd(builder);
                    String creativeID = BidMachineMediationAdapter.this.getCreativeId(nativeAd.getAuctionResult());
                    Bundle extraInfo = null;
                    if (!TextUtils.isEmpty((CharSequence)creativeID)) {
                        extraInfo = new Bundle(1);
                        extraInfo.putString("creative_id", creativeID);
                    }
                    NativeAdListener.this.listener.onNativeAdLoaded((MaxNativeAd)maxBidMachineNativeAd, extraInfo);
                }
            });
        }
    }

    private class MaxBidMachineNativeAd
    extends MaxNativeAd {
        public MaxBidMachineNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            NativeAd nativeAd = BidMachineMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                BidMachineMediationAdapter.this.e("Failed to register native ad views: native ad is null.");
                return false;
            }
            BidMachineMediationAdapter.this.d("Preparing views for interaction: " + clickableViews + " with container: " + container);
            HashSet<View> clickableViewSet = new HashSet<View>(clickableViews);
            ImageView iconImageView = null;
            for (View clickableView : clickableViews) {
                if (!(clickableView instanceof ImageView)) continue;
                iconImageView = (ImageView)clickableView;
                break;
            }
            nativeAd.registerView(container, iconImageView, (NativeMediaView)this.getMediaView(), clickableViewSet);
            return true;
        }
    }
}

