/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkUtils;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdConfig;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTFeedAd;
import com.bytedance.sdk.openadsdk.TTFullScreenVideoAd;
import com.bytedance.sdk.openadsdk.TTImage;
import com.bytedance.sdk.openadsdk.TTNativeAd;
import com.bytedance.sdk.openadsdk.TTNativeExpressAd;
import com.bytedance.sdk.openadsdk.TTRewardVideoAd;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONObject;

public class ByteDanceMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final int OK = 20000;
    private static final int NO_AD = 20001;
    private static final int CONTENT_TYPE = 40000;
    private static final int REQUEST_PB_ERROR = 40001;
    private static final int APP_EMPTY = 40002;
    private static final int WAP_EMPTY = 40003;
    private static final int ADSLOT_EMPTY = 40004;
    private static final int ADSLOT_SIZE_EMPTY = 40005;
    private static final int ADSLOT_ID_ERROR = 40006;
    private static final int ERROR_CODE_ADCOUNT_ERROR = 40007;
    private static final int ERROR_IMAGE_SIZE = 40008;
    private static final int ERROR_MEDIA_ID = 40009;
    private static final int ERROR_MEDIA_TYPE = 40010;
    private static final int ERROR_AD_TYPE = 40011;
    private static final int ERROR_ACCESS_METHOD_PASS = 40012;
    private static final int ERROR_SPLASH_AD_TYPE = 40013;
    private static final int ERROR_REDIRECT = 40014;
    private static final int ERROR_REQUEST_INVALID = 40015;
    private static final int ERROR_SLOT_ID_APP_ID_DIFFER = 40016;
    private static final int ERROR_ACCESS_METHOD_API_SDK = 40017;
    private static final int ERROR_PACKAGE_NAME = 40018;
    private static final int ERROR_ADTYPE_DIFFER = 40019;
    private static final int ERROR_NEW_REGISTER_LIMIT = 40020;
    private static final int ERROR_APK_SIGN_CHECK_ERROR = 40021;
    private static final int ERROR_ORIGIN_AD_ERROR = 40022;
    private static final int ERROR_UNION_OS_ERROR = 40023;
    private static final int ERROR_UNION_SDK_TOO_OLD = 40024;
    private static final int ERROR_UNION_SDK_NOT_INSTALLED = 40025;
    private static final int ERROR_TEMPLATE_METHODS = 40029;
    private static final int SYS_ERROR = 50001;
    private static final int ROR_CODE_SHOW_EVENT_ERROR = 60001;
    private static final int ERROR_CODE_CLICK_EVENT_ERROR = 60002;
    private static final int ERROR_VERIFY_REWARD = 60007;
    private static final int PARSE_FAIL = -1;
    private static final int NET_ERROR = -2;
    private static final int NO_AD_PARSE = -3;
    private static final int AD_DATA_ERROR = -4;
    private static final int BANNER_AD_LOAD_IMAGE_ERROR = -5;
    private static final int INSERT_AD_LOAD_IMAGE_ERROR = -6;
    private static final int SPLASH_AD_LOAD_IMAGE_ERROR = -7;
    private static final int FREQUENT_CALL_ERROR = -8;
    private static final int REQUEST_BODY_ERROR = -9;
    private static final int SPLASH_CACHE_PARSE_ERROR = -10;
    private static final int SPLASH_CACHE_EXPIRED_ERROR = -11;
    private static final int SPLASH_NOT_HAVE_CACHE_ERROR = -12;
    private static final int FAIL_PARSE_RENDERING_RESULT_DATA_ERROR = 101;
    private static final int INVALID_MAIN_TEMPLATE_ERROR = 102;
    private static final int INVALID_TEMPLATE_DIFFERENCE_ERROR = 103;
    private static final int ABNORMAL_MATERIAL_DATA_ERROR = 104;
    private static final int TEMPLATE_DATA_PARSING_ERROR = 105;
    private static final int RENDERING_ERROR = 106;
    private static final int RENDERING_TIMEOUT_ERROR = 107;
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus status;
    private static final int DEFAULT_IMAGE_TASK_TIMEOUT_SECONDS = 10;
    private static final ExecutorService executor;
    private TTFullScreenVideoAd interstitialAd;
    private TTRewardVideoAd rewardedAd;
    private TTNativeExpressAd expressAdViewAd;
    private InterstitialAdListener interstitialAdListener;
    private RewardedAdListener rewardedAdListener;
    private NativeAdListener nativeAdListener;
    private TTFeedAd nativeAd;

    public ByteDanceMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            Boolean isDoNotSell;
            Boolean isAgeRestrictedUser;
            Boolean hasUserConsent;
            status = MaxAdapter.InitializationStatus.INITIALIZING;
            Bundle serverParameters = parameters.getServerParameters();
            String appId = serverParameters.getString("app_id");
            this.log("Initializing SDK with app id: " + appId + "...");
            TTAdConfig.Builder builder = new TTAdConfig.Builder();
            try {
                JSONArray data = new JSONArray();
                JSONObject mediationObject = new JSONObject();
                mediationObject.putOpt("name", (Object)"mediation");
                mediationObject.putOpt("value", (Object)"MAX");
                data.put((Object)mediationObject);
                JSONObject adapterVersionObject = new JSONObject();
                adapterVersionObject.putOpt("name", (Object)"adapter_version");
                adapterVersionObject.putOpt("value", (Object)this.getAdapterVersion());
                data.put((Object)adapterVersionObject);
                builder.data(data.toString());
            }
            catch (Throwable th) {
                this.log("Failed to set mediation provider", th);
            }
            if (this.getWrappingSdk().getConfiguration().getConsentDialogState() == AppLovinSdkConfiguration.ConsentDialogState.APPLIES && (hasUserConsent = this.getPrivacySetting("hasUserConsent", (MaxAdapterParameters)parameters)) != null) {
                builder.setGDPR(hasUserConsent != false ? 1 : 0);
            }
            if ((isAgeRestrictedUser = this.getPrivacySetting("isAgeRestrictedUser", (MaxAdapterParameters)parameters)) != null) {
                builder.coppa(isAgeRestrictedUser != false ? 1 : 0);
            }
            if (AppLovinSdk.VERSION_CODE >= 91100 && (isDoNotSell = this.getPrivacySetting("isDoNotSell", (MaxAdapterParameters)parameters)) != null) {
                builder.setCCPA(isDoNotSell != false ? 1 : 0);
            }
            TTAdConfig adConfig = builder.appId(appId).appName(serverParameters.getString("app_name", "Default App Name")).debug(parameters.isTesting()).supportMultiProcess(false).build();
            TTAdSdk.init((Context)this.getContext(activity), (TTAdConfig)adConfig, (TTAdSdk.InitCallback)new TTAdSdk.InitCallback(){

                public void success() {
                    ByteDanceMediationAdapter.this.log("SDK initialized");
                    status = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(status, null);
                }

                public void fail(int code, String msg) {
                    ByteDanceMediationAdapter.this.log("SDK failed to initialize with code: " + code + " and message: " + msg);
                    status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    onCompletionListener.onCompletion(status, msg);
                }
            });
        } else {
            this.log("attempted initialization already - marking initialization as completed");
            onCompletionListener.onCompletion(status, null);
        }
    }

    public String getSdkVersion() {
        return TTAdSdk.getAdManager().getSDKVersion();
    }

    public String getAdapterVersion() {
        return "4.2.5.2.4";
    }

    public void onDestroy() {
        this.interstitialAdListener = null;
        this.interstitialAd = null;
        this.rewardedAdListener = null;
        this.rewardedAd = null;
        if (this.expressAdViewAd != null) {
            this.expressAdViewAd.destroy();
            this.expressAdViewAd = null;
        }
        this.nativeAd = null;
        this.nativeAdListener = null;
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        String signal = TTAdSdk.getAdManager().getBiddingToken();
        callback.onSignalCollected(signal);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String codeId = parameters.getThirdPartyAdPlacementId();
        String bidResponse = parameters.getBidResponse();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)bidResponse) ? "bidding " : "") + "interstitial ad for code id \"" + codeId + "\"...");
        AdSlot.Builder adSlotBuilder = new AdSlot.Builder().setCodeId(codeId).setImageAcceptedSize(1080, 1920).setSupportDeepLink(true).setAdCount(1);
        if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
            adSlotBuilder.withBid(bidResponse);
        }
        this.interstitialAdListener = new InterstitialAdListener(codeId, listener);
        TTAdSdk.getAdManager().createAdNative(this.getContext(activity)).loadFullScreenVideoAd(adSlotBuilder.build(), (TTAdNative.FullScreenVideoAdListener)this.interstitialAdListener);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String codeId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing interstitial ad for code id \"" + codeId + "\"...");
        this.interstitialAd.setFullScreenVideoAdInteractionListener((TTFullScreenVideoAd.FullScreenVideoAdInteractionListener)this.interstitialAdListener);
        this.interstitialAd.showFullScreenVideoAd(activity);
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String codeId = parameters.getThirdPartyAdPlacementId();
        String bidResponse = parameters.getBidResponse();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)bidResponse) ? "bidding " : "") + "rewarded ad for code id \"" + codeId + "\"...");
        AdSlot.Builder adSlotBuilder = new AdSlot.Builder().setCodeId(codeId).setImageAcceptedSize(1080, 1920).setSupportDeepLink(true).setAdCount(1).setUserID(this.getWrappingSdk().getUserIdentifier());
        if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
            adSlotBuilder.withBid(bidResponse);
        }
        this.rewardedAdListener = new RewardedAdListener(codeId, listener);
        TTAdSdk.getAdManager().createAdNative(this.getContext(activity)).loadRewardVideoAd(adSlotBuilder.build(), (TTAdNative.RewardVideoAdListener)this.rewardedAdListener);
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String codeId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded ad for code id \"" + codeId + "\"...");
        this.configureReward(parameters);
        this.rewardedAd.setRewardAdInteractionListener((TTRewardVideoAd.RewardAdInteractionListener)this.rewardedAdListener);
        this.rewardedAd.showRewardVideoAd(activity);
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        String bidResponse = parameters.getBidResponse();
        String codeId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)bidResponse) ? "bidding " : "") + (isNative ? "native " : "") + adFormat.getLabel() + " ad for code id \"" + codeId + "\"...");
        AppLovinSdkUtils.Size adSize = adFormat.getSize();
        AdSlot.Builder adSlotBuilder = new AdSlot.Builder().setCodeId(codeId).setExpressViewAcceptedSize((float)adSize.getWidth(), (float)adSize.getHeight()).setSupportDeepLink(true).setAdCount(1);
        if (AppLovinSdkUtils.isValidString((String)bidResponse)) {
            adSlotBuilder.withBid(bidResponse);
        }
        TTAdNative adViewAd = TTAdSdk.getAdManager().createAdNative(this.getContext(activity));
        if (isNative) {
            NativeAdViewListener nativeListener = new NativeAdViewListener(parameters, adFormat, activity, listener);
            adViewAd.loadFeedAd(adSlotBuilder.build(), (TTAdNative.FeedAdListener)nativeListener);
        } else {
            AdViewListener adViewListener = new AdViewListener(codeId, adFormat, listener);
            adViewAd.loadBannerExpressAd(adSlotBuilder.build(), (TTAdNative.NativeExpressAdListener)adViewListener);
        }
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, Activity activity, MaxNativeAdAdapterListener listener) {
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        String codeId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "native ad for code id \"" + codeId + "\"...");
        if (AppLovinSdk.VERSION_CODE < 11010000) {
            this.log("Failing ad load for AppLovin SDK < 11.1.0 which requires an Activity context");
            listener.onNativeAdLoadFailed(MaxAdapterError.UNSPECIFIED);
            return;
        }
        AdSlot.Builder adSlotBuilder = new AdSlot.Builder().setCodeId(codeId).setImageAcceptedSize(640, 320).setSupportDeepLink(true).setAdCount(1);
        if (isBiddingAd) {
            adSlotBuilder.withBid(bidResponse);
        }
        this.nativeAdListener = new NativeAdListener(parameters, this.getContext(activity), listener);
        TTAdSdk.getAdManager().createAdNative(this.getContext(activity)).loadFeedAd(adSlotBuilder.build(), (TTAdNative.FeedAdListener)this.nativeAdListener);
    }

    private Boolean getPrivacySetting(String privacySetting, MaxAdapterParameters parameters) {
        try {
            Class<?> parametersClass = parameters.getClass();
            Method privacyMethod = parametersClass.getMethod(privacySetting, new Class[0]);
            return (Boolean)privacyMethod.invoke((Object)parameters, new Object[0]);
        }
        catch (Exception exception) {
            this.log("Error getting privacy setting " + privacySetting + " with exception: ", exception);
            return AppLovinSdk.VERSION_CODE >= 9140000 ? null : Boolean.valueOf(false);
        }
    }

    private Callable<Drawable> createDrawableTask(final String imageUrl, final Resources resources) {
        return new Callable<Drawable>(){

            @Override
            public Drawable call() throws Exception {
                InputStream inputStream = new URL(imageUrl).openStream();
                Bitmap imageData = BitmapFactory.decodeStream((InputStream)inputStream);
                return new BitmapDrawable(resources, imageData);
            }
        };
    }

    private boolean isVideoMediaView(int imageMode) {
        return imageMode == 5 || imageMode == 50 || imageMode == 15;
    }

    private static MaxAdapterError toMaxError(int byteDanceErrorCode, String byteDanceErrorMessage) {
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (byteDanceErrorCode) {
            case 20000: {
                throw new IllegalStateException("Returned error code for success");
            }
            case 20001: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case -12: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -1: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 40000: 
            case 40001: 
            case 40002: 
            case 40003: 
            case 40004: 
            case 40005: 
            case 40006: 
            case 40007: 
            case 40008: 
            case 40009: 
            case 40010: 
            case 40011: 
            case 40012: 
            case 40013: 
            case 40014: 
            case 40015: 
            case 40016: 
            case 40017: 
            case 40018: 
            case 40019: 
            case 40020: 
            case 40021: 
            case 40022: 
            case 40023: 
            case 40024: 
            case 40025: 
            case 40029: 
            case 50001: 
            case 60001: 
            case 60002: 
            case 60007: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case -11: {
                adapterError = MaxAdapterError.AD_EXPIRED;
                break;
            }
            case -2: {
                adapterError = MaxAdapterError.NO_CONNECTION;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), byteDanceErrorCode, byteDanceErrorMessage);
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    static {
        executor = Executors.newCachedThreadPool();
    }

    private class MaxByteDanceNativeAd
    extends MaxNativeAd {
        public MaxByteDanceNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
            TTFeedAd nativeAd = ByteDanceMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                ByteDanceMediationAdapter.this.e("Failed to register native ad view for interaction. Native ad is null");
                return;
            }
            ArrayList<Object> clickableViews = new ArrayList<Object>();
            if (AppLovinSdkUtils.isValidString((String)this.getTitle()) && maxNativeAdView.getTitleTextView() != null) {
                clickableViews.add(maxNativeAdView.getTitleTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getBody()) && maxNativeAdView.getBodyTextView() != null) {
                clickableViews.add(maxNativeAdView.getBodyTextView());
            }
            if (this.getIcon() != null && maxNativeAdView.getIconImageView() != null) {
                clickableViews.add(maxNativeAdView.getIconImageView());
            }
            if (this.getMediaView() != null && maxNativeAdView.getMediaContentViewGroup() != null) {
                clickableViews.add(maxNativeAdView.getMediaContentViewGroup());
            }
            ArrayList<Button> creativeViews = new ArrayList<Button>();
            if (AppLovinSdkUtils.isValidString((String)this.getCallToAction()) && maxNativeAdView.getCallToActionButton() != null) {
                creativeViews.add(maxNativeAdView.getCallToActionButton());
            }
            nativeAd.registerViewForInteraction((ViewGroup)maxNativeAdView, clickableViews, creativeViews, (TTNativeAd.AdInteractionListener)ByteDanceMediationAdapter.this.nativeAdListener);
        }
    }

    private class NativeAdListener
    implements TTAdNative.FeedAdListener,
    TTNativeAd.AdInteractionListener,
    TTFeedAd.VideoAdListener {
        final String codeId;
        final Bundle serverParameters;
        final Context context;
        final MaxNativeAdAdapterListener listener;

        NativeAdListener(MaxAdapterResponseParameters parameters, Context context, MaxNativeAdAdapterListener listener) {
            this.codeId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.context = context;
            this.listener = listener;
        }

        public void onFeedAdLoad(List<TTFeedAd> ads) {
            if (ads == null || ads.size() == 0) {
                ByteDanceMediationAdapter.this.log("Native ad (" + this.codeId + ") failed to load: no fill");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            ByteDanceMediationAdapter.this.log("Native ad loaded: " + this.codeId + ". Preparing assets...");
            final TTFeedAd nativeAd = ads.get(0);
            ByteDanceMediationAdapter.this.nativeAd = nativeAd;
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            final boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (!this.hasRequiredAssets(isTemplateAd, nativeAd)) {
                ByteDanceMediationAdapter.this.e("Native ad (" + nativeAd + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                return;
            }
            ExecutorService cachingExecutorService = ByteDanceMediationAdapter.this.getCachingExecutorService();
            cachingExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    TTImage ttMediaImage;
                    Future iconDrawableFuture = null;
                    if (nativeAd.getIcon().isValid()) {
                        ByteDanceMediationAdapter.this.log("Adding native ad icon (" + nativeAd.getIcon().getImageUrl() + ") to queue to be fetched");
                        iconDrawableFuture = ByteDanceMediationAdapter.this.createDrawableFuture(nativeAd.getIcon().getImageUrl(), NativeAdListener.this.context.getResources());
                    }
                    Future imageDrawableFuture = null;
                    if (ByteDanceMediationAdapter.this.isVideoMediaView(nativeAd.getImageMode())) {
                        nativeAd.setVideoAdListener((TTFeedAd.VideoAdListener)NativeAdListener.this);
                    } else if (nativeAd.getImageList() != null && nativeAd.getImageList().size() > 0 && (ttMediaImage = (TTImage)nativeAd.getImageList().get(0)).isValid()) {
                        ByteDanceMediationAdapter.this.log("Adding native ad media (" + ttMediaImage.getImageUrl() + ") to queue to be fetched");
                        imageDrawableFuture = ByteDanceMediationAdapter.this.createDrawableFuture(ttMediaImage.getImageUrl(), NativeAdListener.this.context.getResources());
                    }
                    int imageTaskTimeoutSeconds = BundleUtils.getInt((String)"image_task_timeout_seconds", (int)10, (Bundle)NativeAdListener.this.serverParameters);
                    Drawable iconDrawable = null;
                    Drawable mediaViewImageDrawable = null;
                    try {
                        if (iconDrawableFuture != null) {
                            iconDrawable = (Drawable)iconDrawableFuture.get(imageTaskTimeoutSeconds, TimeUnit.SECONDS);
                        }
                        if (imageDrawableFuture != null) {
                            mediaViewImageDrawable = (Drawable)imageDrawableFuture.get(imageTaskTimeoutSeconds, TimeUnit.SECONDS);
                        }
                    }
                    catch (Throwable th) {
                        ByteDanceMediationAdapter.this.e("Image fetching tasks failed", th);
                    }
                    final MaxNativeAd.MaxNativeAdImage icon = iconDrawable != null ? new MaxNativeAd.MaxNativeAdImage(iconDrawable) : null;
                    final Drawable finalMediaViewImageDrawable = mediaViewImageDrawable;
                    AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            View mediaView;
                            if (ByteDanceMediationAdapter.this.isVideoMediaView(nativeAd.getImageMode())) {
                                mediaView = nativeAd.getAdView();
                            } else if (finalMediaViewImageDrawable != null) {
                                mediaView = new ImageView(NativeAdListener.this.context);
                                ((ImageView)mediaView).setImageDrawable(finalMediaViewImageDrawable);
                            } else {
                                mediaView = null;
                            }
                            if (!isTemplateAd && mediaView == null) {
                                ByteDanceMediationAdapter.this.e("Media view asset is null for native custom ad view. Failing ad request.");
                                NativeAdListener.this.listener.onNativeAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                                return;
                            }
                            ByteDanceMediationAdapter.this.log("Creating native ad with assets");
                            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(nativeAd.getTitle()).setBody(nativeAd.getDescription()).setCallToAction(nativeAd.getButtonText()).setIcon(icon).setMediaView(mediaView).setOptionsView(nativeAd.getAdLogoView());
                            MaxByteDanceNativeAd maxNativeAd = new MaxByteDanceNativeAd(builder);
                            ByteDanceMediationAdapter.this.log("Native ad fully loaded: " + NativeAdListener.this.codeId);
                            NativeAdListener.this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, null);
                        }
                    });
                }
            });
        }

        public void onError(int code, String message) {
            ByteDanceMediationAdapter.this.log("Native ad (" + this.codeId + ") failed to load with error code (" + code + ") and message: " + message);
            MaxAdapterError adapterError = ByteDanceMediationAdapter.toMaxError(code, message);
            this.listener.onNativeAdLoadFailed(adapterError);
        }

        public void onAdShow(TTNativeAd ttNativeAd) {
            ByteDanceMediationAdapter.this.log("Native ad displayed: " + this.codeId);
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdClicked(View view, TTNativeAd ttNativeAd) {
            ByteDanceMediationAdapter.this.log("Native ad clicked: " + this.codeId);
            this.listener.onNativeAdClicked();
        }

        public void onAdCreativeClick(View view, TTNativeAd ttNativeAd) {
            ByteDanceMediationAdapter.this.log("Native ad creative clicked: " + this.codeId);
            this.listener.onNativeAdClicked();
        }

        public void onVideoLoad(TTFeedAd ad) {
            ByteDanceMediationAdapter.this.log("Native ad video loaded");
        }

        public void onVideoError(int errorCode, int extraCode) {
            ByteDanceMediationAdapter.this.log("Native ad video error: " + errorCode);
        }

        public void onVideoAdStartPlay(TTFeedAd ad) {
            ByteDanceMediationAdapter.this.log("Native ad video started playing");
        }

        public void onVideoAdPaused(TTFeedAd ad) {
            ByteDanceMediationAdapter.this.log("Native ad video paused");
        }

        public void onVideoAdContinuePlay(TTFeedAd ad) {
            ByteDanceMediationAdapter.this.log("Native ad video continued");
        }

        public void onProgressUpdate(long current, long duration) {
        }

        public void onVideoAdComplete(TTFeedAd ad) {
            ByteDanceMediationAdapter.this.log("Native ad video completed");
        }

        private boolean hasRequiredAssets(boolean isTemplateAd, TTFeedAd nativeAd) {
            if (isTemplateAd) {
                return AppLovinSdkUtils.isValidString((String)nativeAd.getTitle());
            }
            return AppLovinSdkUtils.isValidString((String)nativeAd.getTitle()) && AppLovinSdkUtils.isValidString((String)nativeAd.getButtonText());
        }
    }

    private class NativeAdViewListener
    implements TTAdNative.FeedAdListener,
    TTNativeAd.AdInteractionListener,
    TTFeedAd.VideoAdListener {
        final String codeId;
        final Bundle serverParameters;
        final MaxAdFormat adFormat;
        final WeakReference<Activity> activityRef;
        final MaxAdViewAdapterListener listener;

        NativeAdViewListener(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
            this.codeId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.adFormat = adFormat;
            this.activityRef = new WeakReference<Activity>(activity);
            this.listener = listener;
        }

        public void onFeedAdLoad(List<TTFeedAd> ads) {
            final Activity activity = (Activity)this.activityRef.get();
            if (activity == null) {
                ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad (" + this.codeId + ") failed to load: activity reference is null when ad is loaded");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.INVALID_LOAD_STATE);
                return;
            }
            if (ads == null || ads.size() == 0) {
                ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad (" + this.codeId + ") failed to load: no fill");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded: " + this.codeId + ". Preparing assets...");
            final TTFeedAd nativeAdViewAd = ads.get(0);
            final ExecutorService executorServiceToUse = AppLovinSdk.VERSION_CODE >= 11000000 ? ByteDanceMediationAdapter.this.getCachingExecutorService() : executor;
            executorServiceToUse.execute(new Runnable(){

                @Override
                public void run() {
                    View mediaView;
                    MaxNativeAd.MaxNativeAdImage icon;
                    TTImage ttMediaImage;
                    Resources resources = activity.getResources();
                    Future iconDrawableFuture = null;
                    if (nativeAdViewAd.getIcon().isValid()) {
                        ByteDanceMediationAdapter.this.log("Adding native ad icon (" + nativeAdViewAd.getIcon().getImageUrl() + ") to queue to be fetched");
                        String imageUrl = nativeAdViewAd.getIcon().getImageUrl();
                        iconDrawableFuture = AppLovinSdk.VERSION_CODE >= 11000000 ? ByteDanceMediationAdapter.this.createDrawableFuture(imageUrl, resources) : executorServiceToUse.submit(ByteDanceMediationAdapter.this.createDrawableTask(imageUrl, resources));
                    }
                    Future imageDrawableFuture = null;
                    if (ByteDanceMediationAdapter.this.isVideoMediaView(nativeAdViewAd.getImageMode())) {
                        nativeAdViewAd.setVideoAdListener((TTFeedAd.VideoAdListener)NativeAdViewListener.this);
                    } else if (nativeAdViewAd.getImageList() != null && nativeAdViewAd.getImageList().size() > 0 && (ttMediaImage = (TTImage)nativeAdViewAd.getImageList().get(0)).isValid()) {
                        ByteDanceMediationAdapter.this.log("Adding native ad media (" + ttMediaImage.getImageUrl() + ") to queue to be fetched");
                        String imageUrl = ttMediaImage.getImageUrl();
                        imageDrawableFuture = AppLovinSdk.VERSION_CODE >= 11000000 ? ByteDanceMediationAdapter.this.createDrawableFuture(imageUrl, resources) : executorServiceToUse.submit(ByteDanceMediationAdapter.this.createDrawableTask(imageUrl, resources));
                    }
                    int imageTaskTimeoutSeconds = BundleUtils.getInt((String)"image_task_timeout_seconds", (int)10, (Bundle)NativeAdViewListener.this.serverParameters);
                    Drawable iconDrawable = null;
                    Drawable mediaViewImageDrawable = null;
                    try {
                        if (iconDrawableFuture != null) {
                            iconDrawable = (Drawable)iconDrawableFuture.get(imageTaskTimeoutSeconds, TimeUnit.SECONDS);
                        }
                        if (imageDrawableFuture != null) {
                            mediaViewImageDrawable = (Drawable)imageDrawableFuture.get(imageTaskTimeoutSeconds, TimeUnit.SECONDS);
                        }
                    }
                    catch (Throwable th) {
                        ByteDanceMediationAdapter.this.e("Image fetching tasks failed", th);
                    }
                    MaxNativeAd.MaxNativeAdImage maxNativeAdImage = icon = iconDrawable != null ? new MaxNativeAd.MaxNativeAdImage(iconDrawable) : null;
                    if (ByteDanceMediationAdapter.this.isVideoMediaView(nativeAdViewAd.getImageMode())) {
                        mediaView = nativeAdViewAd.getAdView();
                    } else {
                        mediaView = new ImageView((Context)activity);
                        if (mediaViewImageDrawable != null) {
                            ((ImageView)mediaView).setImageDrawable(mediaViewImageDrawable);
                        }
                    }
                    AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ViewGroup mediaContentView;
                            ByteDanceMediationAdapter.this.log("Creating native ad with assets");
                            MaxNativeAd maxNativeAd = new MaxNativeAd.Builder().setAdFormat(NativeAdViewListener.this.adFormat).setTitle(nativeAdViewAd.getTitle()).setBody(nativeAdViewAd.getDescription()).setCallToAction(nativeAdViewAd.getButtonText()).setIcon(icon).setMediaView(mediaView).setOptionsView(nativeAdViewAd.getAdLogoView()).build();
                            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)NativeAdViewListener.this.serverParameters);
                            if (templateName.contains("vertical") && AppLovinSdk.VERSION_CODE < 9140500) {
                                ByteDanceMediationAdapter.this.log("Vertical native banners are only supported on MAX SDK 9.14.5 and above. Default horizontal native template will be used.");
                            }
                            MaxNativeAdView maxNativeAdView = AppLovinSdk.VERSION_CODE >= 11010000 ? new MaxNativeAdView(maxNativeAd, templateName, ByteDanceMediationAdapter.this.getApplicationContext()) : new MaxNativeAdView(maxNativeAd, templateName, activity);
                            ArrayList<Object> clickableViews = new ArrayList<Object>();
                            if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getTitle()) && maxNativeAdView.getTitleTextView() != null) {
                                clickableViews.add(maxNativeAdView.getTitleTextView());
                            }
                            if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getBody()) && maxNativeAdView.getBodyTextView() != null) {
                                clickableViews.add(maxNativeAdView.getBodyTextView());
                            }
                            if (maxNativeAd.getIcon() != null && maxNativeAdView.getIconImageView() != null) {
                                clickableViews.add(maxNativeAdView.getIconImageView());
                            }
                            Object object = mediaContentView = AppLovinSdk.VERSION_CODE >= 11000000 ? maxNativeAdView.getMediaContentViewGroup() : maxNativeAdView.getMediaContentView();
                            if (maxNativeAd.getMediaView() != null && mediaContentView != null) {
                                clickableViews.add(mediaContentView);
                            }
                            ArrayList<Button> creativeViews = new ArrayList<Button>();
                            if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getCallToAction()) && maxNativeAdView.getCallToActionButton() != null) {
                                creativeViews.add(maxNativeAdView.getCallToActionButton());
                            }
                            nativeAdViewAd.registerViewForInteraction((ViewGroup)maxNativeAdView, clickableViews, creativeViews, (TTNativeAd.AdInteractionListener)NativeAdViewListener.this);
                            ByteDanceMediationAdapter.this.log("Native " + NativeAdViewListener.this.adFormat.getLabel() + " ad fully loaded: " + NativeAdViewListener.this.codeId);
                            NativeAdViewListener.this.listener.onAdViewAdLoaded((View)maxNativeAdView);
                        }
                    });
                }
            });
        }

        public void onError(int code, String message) {
            MaxAdapterError adapterError = ByteDanceMediationAdapter.toMaxError(code, message);
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad (" + this.codeId + ") failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdShow(TTNativeAd ttNativeAd) {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad displayed: " + this.codeId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked(View view, TTNativeAd ttNativeAd) {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad clicked: " + this.codeId);
            this.listener.onAdViewAdClicked();
        }

        public void onAdCreativeClick(View view, TTNativeAd ttNativeAd) {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad creative clicked: " + this.codeId);
            this.listener.onAdViewAdClicked();
        }

        public void onVideoLoad(TTFeedAd ad) {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad video loaded");
        }

        public void onVideoError(int errorCode, int extraCode) {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad video error: " + errorCode);
        }

        public void onVideoAdStartPlay(TTFeedAd ad) {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad video started playing");
        }

        public void onVideoAdPaused(TTFeedAd ad) {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad video paused");
        }

        public void onVideoAdContinuePlay(TTFeedAd ad) {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad video continued");
        }

        public void onProgressUpdate(long current, long duration) {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad video progress updated (" + current + ") by duration (" + duration + ")");
        }

        public void onVideoAdComplete(TTFeedAd ad) {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad video completed");
        }
    }

    private class AdViewListener
    implements TTAdNative.NativeExpressAdListener,
    TTNativeExpressAd.ExpressAdInteractionListener {
        private final String codeId;
        private final MaxAdFormat adFormat;
        private final MaxAdViewAdapterListener listener;

        AdViewListener(String codeId, MaxAdFormat adFormat, MaxAdViewAdapterListener listener) {
            this.codeId = codeId;
            this.adFormat = adFormat;
            this.listener = listener;
        }

        public void onNativeExpressAdLoad(List<TTNativeExpressAd> ads) {
            if (ads == null || ads.isEmpty()) {
                ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad (" + this.codeId + ") failed to load: no fill");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            ByteDanceMediationAdapter.this.log(this.adFormat.getLabel() + " ad (" + this.codeId + ") loaded with " + ads.size() + " ads");
            ByteDanceMediationAdapter.this.expressAdViewAd = ads.get(0);
            ByteDanceMediationAdapter.this.expressAdViewAd.setExpressInteractionListener((TTNativeExpressAd.ExpressAdInteractionListener)this);
            ByteDanceMediationAdapter.this.expressAdViewAd.render();
        }

        public void onError(int code, String message) {
            MaxAdapterError adapterError = ByteDanceMediationAdapter.toMaxError(code, message);
            ByteDanceMediationAdapter.this.log(this.adFormat.getLabel() + " ad (" + this.codeId + ") failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onRenderSuccess(View view, float width, float height) {
            ByteDanceMediationAdapter.this.log(this.adFormat.getLabel() + " ad loaded: " + this.codeId);
            this.listener.onAdViewAdLoaded(view);
        }

        public void onRenderFail(View view, String message, int code) {
            MaxAdapterError adapterError = ByteDanceMediationAdapter.toMaxError(code, message);
            ByteDanceMediationAdapter.this.log(this.adFormat.getLabel() + " ad (" + this.codeId + ") failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdShow(View view, int type) {
            ByteDanceMediationAdapter.this.log(this.adFormat.getLabel() + " ad shown: " + this.codeId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked(View view, int type) {
            ByteDanceMediationAdapter.this.log(this.adFormat.getLabel() + " ad clicked: " + this.codeId);
            this.listener.onAdViewAdClicked();
        }
    }

    private class RewardedAdListener
    implements TTAdNative.RewardVideoAdListener,
    TTRewardVideoAd.RewardAdInteractionListener {
        private final String codeId;
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedAdListener(String codeId, MaxRewardedAdapterListener listener) {
            this.codeId = codeId;
            this.listener = listener;
        }

        public void onRewardVideoAdLoad(TTRewardVideoAd ad) {
            ByteDanceMediationAdapter.this.rewardedAd = ad;
            ByteDanceMediationAdapter.this.log("Rewarded ad loaded: " + this.codeId);
            this.listener.onRewardedAdLoaded();
        }

        public void onError(int code, String message) {
            MaxAdapterError adapterError = ByteDanceMediationAdapter.toMaxError(code, message);
            ByteDanceMediationAdapter.this.log("Rewarded ad (" + this.codeId + ") failed to load with error: " + adapterError);
            this.listener.onRewardedAdLoadFailed(adapterError);
        }

        public void onRewardVideoCached() {
            ByteDanceMediationAdapter.this.log("Rewarded ad cached: " + this.codeId);
        }

        public void onAdShow() {
            ByteDanceMediationAdapter.this.log("Rewarded ad displayed: " + this.codeId);
            this.listener.onRewardedAdDisplayed();
            this.listener.onRewardedAdVideoStarted();
        }

        public void onVideoError() {
            ByteDanceMediationAdapter.this.log("Rewarded ad failed to display: " + this.codeId);
            this.listener.onRewardedAdDisplayFailed(MaxAdapterError.UNSPECIFIED);
        }

        public void onAdVideoBarClick() {
            ByteDanceMediationAdapter.this.log("Rewarded ad clicked: " + this.codeId);
            this.listener.onRewardedAdClicked();
        }

        public void onAdClose() {
            ByteDanceMediationAdapter.this.log("Rewarded ad hidden: " + this.codeId);
            if (this.hasGrantedReward || ByteDanceMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = ByteDanceMediationAdapter.this.getReward();
                ByteDanceMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            this.listener.onRewardedAdHidden();
        }

        public void onVideoComplete() {
            ByteDanceMediationAdapter.this.log("Rewarded ad video completed: " + this.codeId);
            this.listener.onRewardedAdVideoCompleted();
        }

        public void onRewardVerify(boolean granted, int amount, String label, int errorCode, String errorMsg) {
            if (granted) {
                ByteDanceMediationAdapter.this.log("Rewarded user with reward: " + amount + " " + label);
                this.hasGrantedReward = true;
            } else {
                ByteDanceMediationAdapter.this.log("Failed to reward user with error: " + errorCode + " " + errorMsg);
            }
        }

        public void onSkippedVideo() {
            ByteDanceMediationAdapter.this.log("Rewarded ad video skipped: " + this.codeId);
        }
    }

    private class InterstitialAdListener
    implements TTAdNative.FullScreenVideoAdListener,
    TTFullScreenVideoAd.FullScreenVideoAdInteractionListener {
        private final String codeId;
        private final MaxInterstitialAdapterListener listener;

        InterstitialAdListener(String codeId, MaxInterstitialAdapterListener listener) {
            this.codeId = codeId;
            this.listener = listener;
        }

        public void onFullScreenVideoAdLoad(TTFullScreenVideoAd ad) {
            ByteDanceMediationAdapter.this.interstitialAd = ad;
            ByteDanceMediationAdapter.this.log("Interstitial ad loaded: " + this.codeId);
            this.listener.onInterstitialAdLoaded();
        }

        public void onError(int code, String message) {
            MaxAdapterError adapterError = ByteDanceMediationAdapter.toMaxError(code, message);
            ByteDanceMediationAdapter.this.log("Interstitial ad (" + this.codeId + ") failed to load with error: " + adapterError);
            this.listener.onInterstitialAdLoadFailed(adapterError);
        }

        public void onFullScreenVideoCached() {
            ByteDanceMediationAdapter.this.log("Interstitial ad cached: " + this.codeId);
        }

        public void onAdShow() {
            ByteDanceMediationAdapter.this.log("Interstitial ad displayed: " + this.codeId);
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdVideoBarClick() {
            ByteDanceMediationAdapter.this.log("Interstitial ad clicked: " + this.codeId);
            this.listener.onInterstitialAdClicked();
        }

        public void onAdClose() {
            ByteDanceMediationAdapter.this.log("Interstitial ad hidden: " + this.codeId);
            this.listener.onInterstitialAdHidden();
        }

        public void onVideoComplete() {
            ByteDanceMediationAdapter.this.log("Interstitial ad video completed: " + this.codeId);
        }

        public void onSkippedVideo() {
            ByteDanceMediationAdapter.this.log("Interstitial ad skipped: " + this.codeId);
        }
    }
}

