/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAppOpenAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAd;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdLoadListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerRequest;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerSize;
import com.bytedance.sdk.openadsdk.api.init.PAGConfig;
import com.bytedance.sdk.openadsdk.api.init.PAGSdk;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialAd;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialAdLoadListener;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialRequest;
import com.bytedance.sdk.openadsdk.api.nativeAd.PAGNativeAd;
import com.bytedance.sdk.openadsdk.api.nativeAd.PAGNativeAdData;
import com.bytedance.sdk.openadsdk.api.nativeAd.PAGNativeAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.nativeAd.PAGNativeAdLoadListener;
import com.bytedance.sdk.openadsdk.api.nativeAd.PAGNativeRequest;
import com.bytedance.sdk.openadsdk.api.nativeAd.PAGVideoAdListener;
import com.bytedance.sdk.openadsdk.api.open.PAGAppOpenAd;
import com.bytedance.sdk.openadsdk.api.open.PAGAppOpenAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.open.PAGAppOpenAdLoadListener;
import com.bytedance.sdk.openadsdk.api.open.PAGAppOpenRequest;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardItem;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedAd;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedAdLoadListener;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedRequest;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ByteDanceMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final int OK = 20000;
    private static final int NO_AD = 20001;
    private static final int CONTENT_TYPE = 40000;
    private static final int REQUEST_PB_ERROR = 40001;
    private static final int APP_EMPTY = 40002;
    private static final int WAP_EMPTY = 40003;
    private static final int ADSLOT_EMPTY = 40004;
    private static final int ADSLOT_SIZE_EMPTY = 40005;
    private static final int ADSLOT_ID_ERROR = 40006;
    private static final int ERROR_CODE_ADCOUNT_ERROR = 40007;
    private static final int ERROR_IMAGE_SIZE = 40008;
    private static final int ERROR_MEDIA_ID = 40009;
    private static final int ERROR_MEDIA_TYPE = 40010;
    private static final int ERROR_AD_TYPE = 40011;
    private static final int ERROR_ACCESS_METHOD_PASS = 40012;
    private static final int ERROR_SPLASH_AD_TYPE = 40013;
    private static final int ERROR_REDIRECT = 40014;
    private static final int ERROR_REQUEST_INVALID = 40015;
    private static final int ERROR_SLOT_ID_APP_ID_DIFFER = 40016;
    private static final int ERROR_ACCESS_METHOD_API_SDK = 40017;
    private static final int ERROR_PACKAGE_NAME = 40018;
    private static final int ERROR_ADTYPE_DIFFER = 40019;
    private static final int ERROR_NEW_REGISTER_LIMIT = 40020;
    private static final int ERROR_APK_SIGN_CHECK_ERROR = 40021;
    private static final int ERROR_ORIGIN_AD_ERROR = 40022;
    private static final int ERROR_UNION_OS_ERROR = 40023;
    private static final int ERROR_UNION_SDK_TOO_OLD = 40024;
    private static final int ERROR_UNION_SDK_NOT_INSTALLED = 40025;
    private static final int ERROR_TEMPLATE_METHODS = 40029;
    private static final int SYS_ERROR = 50001;
    private static final int ROR_CODE_SHOW_EVENT_ERROR = 60001;
    private static final int ERROR_CODE_CLICK_EVENT_ERROR = 60002;
    private static final int ERROR_VERIFY_REWARD = 60007;
    private static final int PARSE_FAIL = -1;
    private static final int NET_ERROR = -2;
    private static final int NO_AD_PARSE = -3;
    private static final int AD_DATA_ERROR = -4;
    private static final int BANNER_AD_LOAD_IMAGE_ERROR = -5;
    private static final int INSERT_AD_LOAD_IMAGE_ERROR = -6;
    private static final int SPLASH_AD_LOAD_IMAGE_ERROR = -7;
    private static final int FREQUENT_CALL_ERROR = -8;
    private static final int REQUEST_BODY_ERROR = -9;
    private static final int SPLASH_CACHE_PARSE_ERROR = -10;
    private static final int SPLASH_CACHE_EXPIRED_ERROR = -11;
    private static final int SPLASH_NOT_HAVE_CACHE_ERROR = -12;
    private static final int FAIL_PARSE_RENDERING_RESULT_DATA_ERROR = 101;
    private static final int INVALID_MAIN_TEMPLATE_ERROR = 102;
    private static final int INVALID_TEMPLATE_DIFFERENCE_ERROR = 103;
    private static final int ABNORMAL_MATERIAL_DATA_ERROR = 104;
    private static final int TEMPLATE_DATA_PARSING_ERROR = 105;
    private static final int RENDERING_ERROR = 106;
    private static final int RENDERING_TIMEOUT_ERROR = 107;
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus status;
    private static final int DEFAULT_IMAGE_TASK_TIMEOUT_SECONDS = 10;
    private static final ExecutorService executor;
    private PAGInterstitialAd interstitialAd;
    private PAGAppOpenAd appOpenAd;
    private PAGRewardedAd rewardedAd;
    private PAGBannerAd adViewAd;
    private PAGNativeAd nativeAd;
    private InterstitialAdListener interstitialAdListener;
    private AppOpenAdListener appOpenAdListener;
    private RewardedAdListener rewardedAdListener;
    private NativeAdListener nativeAdListener;

    public ByteDanceMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            Boolean isDoNotSell;
            Boolean isAgeRestrictedUser;
            status = MaxAdapter.InitializationStatus.INITIALIZING;
            Bundle serverParameters = parameters.getServerParameters();
            String appId = serverParameters.getString("app_id");
            this.log("Initializing SDK with app id: " + appId + "...");
            PAGConfig.Builder builder = new PAGConfig.Builder();
            builder.setUserData(this.createAdConfigData(serverParameters, true));
            Boolean hasUserConsent = parameters.hasUserConsent();
            if (hasUserConsent != null) {
                builder.setGDPRConsent(hasUserConsent != false ? 1 : 0);
            }
            if ((isAgeRestrictedUser = parameters.isAgeRestrictedUser()) != null) {
                builder.setChildDirected(isAgeRestrictedUser != false ? 1 : 0);
            }
            if ((isDoNotSell = parameters.isDoNotSell()) != null) {
                builder.setDoNotSell(isDoNotSell != false ? 1 : 0);
            }
            PAGConfig adConfig = builder.appId(appId).debugLog(parameters.isTesting()).supportMultiProcess(false).build();
            PAGSdk.init((Context)this.getContext(activity), (PAGConfig)adConfig, (PAGSdk.PAGInitCallback)new PAGSdk.PAGInitCallback(){

                public void success() {
                    ByteDanceMediationAdapter.this.log("SDK initialized");
                    status = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(status, null);
                }

                public void fail(int code, String msg) {
                    ByteDanceMediationAdapter.this.log("SDK failed to initialize with code: " + code + " and message: " + msg);
                    status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    onCompletionListener.onCompletion(status, msg);
                }
            });
        } else {
            this.log("attempted initialization already - marking initialization as completed");
            onCompletionListener.onCompletion(status, null);
        }
    }

    public String getSdkVersion() {
        return PAGSdk.getSDKVersion();
    }

    public String getAdapterVersion() {
        return "5.7.0.1.0";
    }

    public void onDestroy() {
        this.interstitialAdListener = null;
        this.interstitialAd = null;
        this.appOpenAdListener = null;
        this.appOpenAd = null;
        this.rewardedAdListener = null;
        this.rewardedAd = null;
        if (this.adViewAd != null) {
            this.adViewAd.destroy();
            this.adViewAd = null;
        }
        this.nativeAd = null;
        this.nativeAdListener = null;
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        String signal = PAGSdk.getBiddingToken();
        callback.onSignalCollected(signal);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String codeId = parameters.getThirdPartyAdPlacementId();
        String bidResponse = parameters.getBidResponse();
        boolean isBidding = AppLovinSdkUtils.isValidString((String)bidResponse);
        this.log("Loading " + (isBidding ? "bidding " : "") + "interstitial ad for code id \"" + codeId + "\"...");
        PAGConfig.setUserData((String)this.createAdConfigData(parameters.getServerParameters(), false));
        PAGInterstitialRequest request = new PAGInterstitialRequest();
        if (isBidding) {
            request.setAdString(bidResponse);
        }
        this.interstitialAdListener = new InterstitialAdListener(codeId, listener);
        PAGInterstitialAd.loadAd((String)codeId, (PAGInterstitialRequest)request, (PAGInterstitialAdLoadListener)this.interstitialAdListener);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String codeId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing interstitial ad for code id \"" + codeId + "\"...");
        this.interstitialAd.setAdInteractionListener((PAGInterstitialAdInteractionListener)this.interstitialAdListener);
        this.interstitialAd.show(activity);
    }

    public void loadAppOpenAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxAppOpenAdapterListener listener) {
        String codeId = parameters.getThirdPartyAdPlacementId();
        String bidResponse = parameters.getBidResponse();
        boolean isBidding = AppLovinSdkUtils.isValidString((String)bidResponse);
        this.log("Loading " + (isBidding ? "bidding " : "") + "app open ad for code id \"" + codeId + "\"...");
        PAGConfig.setUserData((String)this.createAdConfigData(parameters.getServerParameters(), false));
        int appIconId = this.getContext((Activity)activity).getApplicationInfo().icon;
        if (appIconId <= 0) {
            this.log("App icon resource id could not be found");
        } else {
            PAGConfig.setAppIconId((int)appIconId);
        }
        PAGAppOpenRequest request = new PAGAppOpenRequest();
        if (isBidding) {
            request.setAdString(bidResponse);
        }
        this.appOpenAdListener = new AppOpenAdListener(codeId, listener);
        PAGAppOpenAd.loadAd((String)codeId, (PAGAppOpenRequest)request, (PAGAppOpenAdLoadListener)this.appOpenAdListener);
    }

    public void showAppOpenAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxAppOpenAdapterListener listener) {
        String codeId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing app open ad for code id \"" + codeId + "\"...");
        this.appOpenAd.setAdInteractionListener((PAGAppOpenAdInteractionListener)this.appOpenAdListener);
        this.appOpenAd.show(activity);
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String codeId = parameters.getThirdPartyAdPlacementId();
        String bidResponse = parameters.getBidResponse();
        boolean isBidding = AppLovinSdkUtils.isValidString((String)bidResponse);
        this.log("Loading " + (isBidding ? "bidding " : "") + "rewarded ad for code id \"" + codeId + "\"...");
        PAGConfig.setUserData((String)this.createAdConfigData(parameters.getServerParameters(), false));
        HashMap<String, String> extraInfo = new HashMap<String, String>();
        extraInfo.put("user_id", this.getWrappingSdk().getUserIdentifier());
        PAGRewardedRequest request = new PAGRewardedRequest();
        request.setExtraInfo(extraInfo);
        if (isBidding) {
            request.setAdString(bidResponse);
        }
        this.rewardedAdListener = new RewardedAdListener(codeId, listener);
        PAGRewardedAd.loadAd((String)codeId, (PAGRewardedRequest)request, (PAGRewardedAdLoadListener)this.rewardedAdListener);
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String codeId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded ad for code id \"" + codeId + "\"...");
        this.configureReward(parameters);
        this.rewardedAd.setAdInteractionListener((PAGRewardedAdInteractionListener)this.rewardedAdListener);
        this.rewardedAd.show(activity);
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        String bidResponse = parameters.getBidResponse();
        String codeId = parameters.getThirdPartyAdPlacementId();
        boolean isBidding = AppLovinSdkUtils.isValidString((String)bidResponse);
        this.log("Loading " + (isBidding ? "bidding " : "") + (isNative ? "native " : "") + adFormat.getLabel() + " ad for code id \"" + codeId + "\"...");
        PAGConfig.setUserData((String)this.createAdConfigData(parameters.getServerParameters(), false));
        if (isNative) {
            PAGNativeRequest request = new PAGNativeRequest();
            if (isBidding) {
                request.setAdString(bidResponse);
            }
            NativeAdViewListener nativeListener = new NativeAdViewListener(parameters, adFormat, activity, listener);
            PAGNativeAd.loadAd((String)codeId, (PAGNativeRequest)request, (PAGNativeAdLoadListener)nativeListener);
        } else {
            AppLovinSdkUtils.Size adSize = adFormat.getSize();
            PAGBannerRequest request = new PAGBannerRequest(new PAGBannerSize(adSize.getWidth(), adSize.getHeight()));
            if (isBidding) {
                request.setAdString(bidResponse);
            }
            AdViewListener adViewListener = new AdViewListener(codeId, adFormat, listener);
            PAGBannerAd.loadAd((String)codeId, (PAGBannerRequest)request, (PAGBannerAdLoadListener)adViewListener);
        }
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, Activity activity, MaxNativeAdAdapterListener listener) {
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        String codeId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "native ad for code id \"" + codeId + "\"...");
        PAGConfig.setUserData((String)this.createAdConfigData(parameters.getServerParameters(), false));
        if (AppLovinSdk.VERSION_CODE < 11010000) {
            this.log("Failing ad load for AppLovin SDK < 11.1.0 which requires an Activity context");
            listener.onNativeAdLoadFailed(MaxAdapterError.UNSPECIFIED);
            return;
        }
        PAGNativeRequest request = new PAGNativeRequest();
        if (isBiddingAd) {
            request.setAdString(bidResponse);
        }
        this.nativeAdListener = new NativeAdListener(parameters, this.getContext(activity), listener);
        PAGNativeAd.loadAd((String)codeId, (PAGNativeRequest)request, (PAGNativeAdLoadListener)this.nativeAdListener);
    }

    private Callable<Drawable> createDrawableTask(final String imageUrl, final Resources resources) {
        return new Callable<Drawable>(){

            @Override
            public Drawable call() throws Exception {
                InputStream inputStream = new URL(imageUrl).openStream();
                Bitmap imageData = BitmapFactory.decodeStream((InputStream)inputStream);
                return new BitmapDrawable(resources, imageData);
            }
        };
    }

    private static MaxAdapterError toMaxError(int byteDanceErrorCode, String byteDanceErrorMessage) {
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (byteDanceErrorCode) {
            case 20000: {
                throw new IllegalStateException("Returned error code for success");
            }
            case 20001: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case -12: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -1: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 40000: 
            case 40001: 
            case 40002: 
            case 40003: 
            case 40004: 
            case 40005: 
            case 40006: 
            case 40007: 
            case 40008: 
            case 40009: 
            case 40010: 
            case 40011: 
            case 40012: 
            case 40013: 
            case 40014: 
            case 40015: 
            case 40016: 
            case 40017: 
            case 40018: 
            case 40019: 
            case 40020: 
            case 40021: 
            case 40022: 
            case 40023: 
            case 40024: 
            case 40025: 
            case 40029: 
            case 50001: 
            case 60001: 
            case 60002: 
            case 60007: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case -11: {
                adapterError = MaxAdapterError.AD_EXPIRED;
                break;
            }
            case -2: {
                adapterError = MaxAdapterError.NO_CONNECTION;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), byteDanceErrorCode, byteDanceErrorMessage);
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private String createAdConfigData(Bundle serverParameters, Boolean isInitializing) {
        if (isInitializing.booleanValue()) {
            return String.format("[{\"name\":\"mediation\",\"value\":\"MAX\"},{\"name\":\"adapter_version\",\"value\":\"%s\"}]", this.getAdapterVersion());
        }
        return String.format("[{\"name\":\"mediation\",\"value\":\"MAX\"},{\"name\":\"adapter_version\",\"value\":\"%s\"},{\"name\":\"hybrid_id\",\"value\":\"%s\"}]", this.getAdapterVersion(), BundleUtils.getString((String)"event_id", (Bundle)serverParameters));
    }

    static {
        executor = Executors.newCachedThreadPool();
    }

    private class MaxByteDanceNativeAd
    extends MaxNativeAd {
        public MaxByteDanceNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
            ArrayList<View> clickableViews = new ArrayList<View>(4);
            if (AppLovinSdkUtils.isValidString((String)this.getTitle()) && maxNativeAdView.getTitleTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getTitleTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getBody()) && maxNativeAdView.getBodyTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getBodyTextView());
            }
            if (this.getIcon() != null && maxNativeAdView.getIconImageView() != null) {
                clickableViews.add((View)maxNativeAdView.getIconImageView());
            }
            if (this.getMediaView() != null && maxNativeAdView.getMediaContentViewGroup() != null) {
                clickableViews.add((View)maxNativeAdView.getMediaContentViewGroup());
            }
            this.prepareForInteraction(clickableViews, (ViewGroup)maxNativeAdView);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            PAGNativeAd nativeAd = ByteDanceMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                ByteDanceMediationAdapter.this.e("Failed to register native ad view for interaction. Native ad is null");
                return false;
            }
            ByteDanceMediationAdapter.this.d("Preparing views for interaction: " + clickableViews + " with container: " + container);
            nativeAd.registerViewForInteraction(container, clickableViews, null, null, (PAGNativeAdInteractionListener)ByteDanceMediationAdapter.this.nativeAdListener);
            return true;
        }
    }

    private class NativeAdListener
    implements PAGNativeAdLoadListener,
    PAGNativeAdInteractionListener,
    PAGVideoAdListener {
        final String codeId;
        final Bundle serverParameters;
        final Context context;
        final MaxNativeAdAdapterListener listener;

        NativeAdListener(MaxAdapterResponseParameters parameters, Context context, MaxNativeAdAdapterListener listener) {
            this.codeId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.context = context;
            this.listener = listener;
        }

        public void onAdLoaded(PAGNativeAd ad) {
            if (ad == null) {
                ByteDanceMediationAdapter.this.log("Native ad(" + this.codeId + ") NO FILL'd");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            ByteDanceMediationAdapter.this.log("Native ad loaded: " + this.codeId + ". Preparing assets...");
            final PAGNativeAdData nativeAdData = ad.getNativeAdData();
            ByteDanceMediationAdapter.this.nativeAd = ad;
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)nativeAdData.getTitle())) {
                ByteDanceMediationAdapter.this.e("Native ad (" + ad + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                return;
            }
            ExecutorService cachingExecutorService = ByteDanceMediationAdapter.this.getCachingExecutorService();
            cachingExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    Future iconDrawableFuture = null;
                    if (nativeAdData.getIcon() != null && StringUtils.isValidString((String)nativeAdData.getIcon().getImageUrl())) {
                        String imageUrl = nativeAdData.getIcon().getImageUrl();
                        ByteDanceMediationAdapter.this.log("Adding native ad icon (" + imageUrl + ") to queue to be fetched");
                        iconDrawableFuture = ByteDanceMediationAdapter.this.createDrawableFuture(imageUrl, NativeAdListener.this.context.getResources());
                    }
                    int imageTaskTimeoutSeconds = BundleUtils.getInt((String)"image_task_timeout_seconds", (int)10, (Bundle)NativeAdListener.this.serverParameters);
                    Drawable iconDrawable = null;
                    try {
                        if (iconDrawableFuture != null) {
                            iconDrawable = (Drawable)iconDrawableFuture.get(imageTaskTimeoutSeconds, TimeUnit.SECONDS);
                        }
                    }
                    catch (Throwable th) {
                        ByteDanceMediationAdapter.this.e("Image fetching tasks failed", th);
                    }
                    final MaxNativeAd.MaxNativeAdImage icon = iconDrawable != null ? new MaxNativeAd.MaxNativeAdImage(iconDrawable) : null;
                    AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ByteDanceMediationAdapter.this.log("Creating native ad with assets");
                            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(nativeAdData.getTitle()).setBody(nativeAdData.getDescription()).setCallToAction(nativeAdData.getButtonText()).setIcon(icon).setOptionsView(nativeAdData.getAdLogoView()).setMediaView((View)nativeAdData.getMediaView());
                            MaxByteDanceNativeAd maxNativeAd = new MaxByteDanceNativeAd(builder);
                            ByteDanceMediationAdapter.this.log("Native ad fully loaded: " + NativeAdListener.this.codeId);
                            NativeAdListener.this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, null);
                        }
                    });
                }
            });
        }

        public void onError(int code, String message) {
            MaxAdapterError adapterError = ByteDanceMediationAdapter.toMaxError(code, message);
            ByteDanceMediationAdapter.this.log("Native ad (" + this.codeId + ") failed to load with error: " + adapterError);
            this.listener.onNativeAdLoadFailed(adapterError);
        }

        public void onAdShowed() {
            ByteDanceMediationAdapter.this.log("Native ad displayed: " + this.codeId);
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdClicked() {
            ByteDanceMediationAdapter.this.log("Native ad clicked: " + this.codeId);
            this.listener.onNativeAdClicked();
        }

        public void onVideoAdPlay() {
            ByteDanceMediationAdapter.this.log("Native ad video started playing");
        }

        public void onVideoAdPaused() {
            ByteDanceMediationAdapter.this.log("Native ad video paused");
        }

        public void onVideoAdComplete() {
            ByteDanceMediationAdapter.this.log("Native ad video completed");
        }

        public void onVideoError() {
            ByteDanceMediationAdapter.this.log("Native ad video error");
        }

        public void onAdDismissed() {
            ByteDanceMediationAdapter.this.log("Native ad hidden: " + this.codeId);
        }
    }

    private class NativeAdViewListener
    implements PAGNativeAdLoadListener,
    PAGNativeAdInteractionListener,
    PAGVideoAdListener {
        final String codeId;
        final Bundle serverParameters;
        final MaxAdFormat adFormat;
        final WeakReference<Activity> activityRef;
        final MaxAdViewAdapterListener listener;

        NativeAdViewListener(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
            this.codeId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.adFormat = adFormat;
            this.activityRef = new WeakReference<Activity>(activity);
            this.listener = listener;
        }

        public void onAdLoaded(final PAGNativeAd nativeAdViewAd) {
            if (nativeAdViewAd == null) {
                ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + "ad(" + this.codeId + ") NO FILL'd");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded: " + this.codeId + ". Preparing assets...");
            final PAGNativeAdData nativeAdData = nativeAdViewAd.getNativeAdData();
            final ExecutorService executorServiceToUse = AppLovinSdk.VERSION_CODE >= 11000000 ? ByteDanceMediationAdapter.this.getCachingExecutorService() : executor;
            final Activity activity = (Activity)this.activityRef.get();
            final Context context = ByteDanceMediationAdapter.this.getContext(activity);
            executorServiceToUse.execute(new Runnable(){

                @Override
                public void run() {
                    Resources resources = context.getResources();
                    Future iconDrawableFuture = null;
                    if (nativeAdData.getIcon() != null && StringUtils.isValidString((String)nativeAdData.getIcon().getImageUrl())) {
                        String imageUrl = nativeAdData.getIcon().getImageUrl();
                        ByteDanceMediationAdapter.this.log("Adding native ad icon (" + imageUrl + ") to queue to be fetched");
                        iconDrawableFuture = AppLovinSdk.VERSION_CODE >= 11000000 ? ByteDanceMediationAdapter.this.createDrawableFuture(imageUrl, resources) : executorServiceToUse.submit(ByteDanceMediationAdapter.this.createDrawableTask(imageUrl, resources));
                    }
                    int imageTaskTimeoutSeconds = BundleUtils.getInt((String)"image_task_timeout_seconds", (int)10, (Bundle)NativeAdViewListener.this.serverParameters);
                    Drawable iconDrawable = null;
                    try {
                        if (iconDrawableFuture != null) {
                            iconDrawable = (Drawable)iconDrawableFuture.get(imageTaskTimeoutSeconds, TimeUnit.SECONDS);
                        }
                    }
                    catch (Throwable th) {
                        ByteDanceMediationAdapter.this.e("Image fetching tasks failed", th);
                    }
                    final MaxNativeAd.MaxNativeAdImage icon = iconDrawable != null ? new MaxNativeAd.MaxNativeAdImage(iconDrawable) : null;
                    AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ViewGroup mediaContentView;
                            ByteDanceMediationAdapter.this.log("Creating native ad with assets");
                            MaxNativeAd maxNativeAd = new MaxNativeAd.Builder().setAdFormat(NativeAdViewListener.this.adFormat).setTitle(nativeAdData.getTitle()).setBody(nativeAdData.getDescription()).setCallToAction(nativeAdData.getButtonText()).setIcon(icon).setOptionsView(nativeAdData.getAdLogoView()).setMediaView((View)nativeAdData.getMediaView()).build();
                            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)NativeAdViewListener.this.serverParameters);
                            if (templateName.contains("vertical") && AppLovinSdk.VERSION_CODE < 9140500) {
                                ByteDanceMediationAdapter.this.log("Vertical native banners are only supported on MAX SDK 9.14.5 and above. Default horizontal native template will be used.");
                            }
                            MaxNativeAdView maxNativeAdView = AppLovinSdk.VERSION_CODE >= 11010000 ? new MaxNativeAdView(maxNativeAd, templateName, context) : new MaxNativeAdView(maxNativeAd, templateName, activity);
                            ArrayList<Object> clickableViews = new ArrayList<Object>(4);
                            if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getTitle()) && maxNativeAdView.getTitleTextView() != null) {
                                clickableViews.add(maxNativeAdView.getTitleTextView());
                            }
                            if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getBody()) && maxNativeAdView.getBodyTextView() != null) {
                                clickableViews.add(maxNativeAdView.getBodyTextView());
                            }
                            if (maxNativeAd.getIcon() != null && maxNativeAdView.getIconImageView() != null) {
                                clickableViews.add(maxNativeAdView.getIconImageView());
                            }
                            Object object = mediaContentView = AppLovinSdk.VERSION_CODE >= 11000000 ? maxNativeAdView.getMediaContentViewGroup() : maxNativeAdView.getMediaContentView();
                            if (maxNativeAd.getMediaView() != null && mediaContentView != null) {
                                clickableViews.add(mediaContentView);
                            }
                            ArrayList<Button> creativeViews = new ArrayList<Button>();
                            if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getCallToAction()) && maxNativeAdView.getCallToActionButton() != null) {
                                creativeViews.add(maxNativeAdView.getCallToActionButton());
                            }
                            nativeAdViewAd.registerViewForInteraction((ViewGroup)maxNativeAdView, clickableViews, creativeViews, null, (PAGNativeAdInteractionListener)NativeAdViewListener.this);
                            ByteDanceMediationAdapter.this.log("Native " + NativeAdViewListener.this.adFormat.getLabel() + " ad fully loaded: " + NativeAdViewListener.this.codeId);
                            NativeAdViewListener.this.listener.onAdViewAdLoaded((View)maxNativeAdView);
                        }
                    });
                }
            });
        }

        public void onError(int code, String message) {
            MaxAdapterError adapterError = ByteDanceMediationAdapter.toMaxError(code, message);
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad (" + this.codeId + ") failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdShowed() {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad displayed: " + this.codeId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked() {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad clicked: " + this.codeId);
            this.listener.onAdViewAdClicked();
        }

        public void onVideoAdPlay() {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad video loaded");
        }

        public void onVideoAdPaused() {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad video paused");
        }

        public void onVideoAdComplete() {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad video completed");
        }

        public void onVideoError() {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad video error");
        }

        public void onAdDismissed() {
            ByteDanceMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad hidden: " + this.codeId);
            this.listener.onAdViewAdHidden();
        }
    }

    private class AdViewListener
    implements PAGBannerAdLoadListener,
    PAGBannerAdInteractionListener {
        private final String codeId;
        private final MaxAdFormat adFormat;
        private final MaxAdViewAdapterListener listener;

        AdViewListener(String codeId, MaxAdFormat adFormat, MaxAdViewAdapterListener listener) {
            this.codeId = codeId;
            this.adFormat = adFormat;
            this.listener = listener;
        }

        public void onAdLoaded(PAGBannerAd ad) {
            if (ad == null) {
                ByteDanceMediationAdapter.this.log(this.adFormat.getLabel() + " ad(" + this.codeId + ") NO FILL'd");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            ByteDanceMediationAdapter.this.log(this.adFormat.getLabel() + " ad (" + this.codeId + ") loaded");
            ByteDanceMediationAdapter.this.adViewAd = ad;
            ByteDanceMediationAdapter.this.adViewAd.setAdInteractionListener((PAGBannerAdInteractionListener)this);
            this.listener.onAdViewAdLoaded(ad.getBannerView());
        }

        public void onError(int code, String message) {
            MaxAdapterError adapterError = ByteDanceMediationAdapter.toMaxError(code, message);
            ByteDanceMediationAdapter.this.log(this.adFormat.getLabel() + " ad (" + this.codeId + ") failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdShowed() {
            ByteDanceMediationAdapter.this.log(this.adFormat.getLabel() + " ad displayed: " + this.codeId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked() {
            ByteDanceMediationAdapter.this.log(this.adFormat.getLabel() + " ad clicked: " + this.codeId);
            this.listener.onAdViewAdClicked();
        }

        public void onAdDismissed() {
            ByteDanceMediationAdapter.this.log(this.adFormat.getLabel() + " ad hidden: " + this.codeId);
            this.listener.onAdViewAdHidden();
        }
    }

    private class RewardedAdListener
    implements PAGRewardedAdLoadListener,
    PAGRewardedAdInteractionListener {
        private final String codeId;
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedAdListener(String codeId, MaxRewardedAdapterListener listener) {
            this.codeId = codeId;
            this.listener = listener;
        }

        public void onAdLoaded(PAGRewardedAd ad) {
            if (ad == null) {
                ByteDanceMediationAdapter.this.log("Rewarded ad(" + this.codeId + ") NO FILL'd");
                this.listener.onRewardedAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            ByteDanceMediationAdapter.this.log("Rewarded ad loaded: " + this.codeId);
            ByteDanceMediationAdapter.this.rewardedAd = ad;
            this.listener.onRewardedAdLoaded();
        }

        public void onError(int code, String message) {
            MaxAdapterError adapterError = ByteDanceMediationAdapter.toMaxError(code, message);
            ByteDanceMediationAdapter.this.log("Rewarded ad (" + this.codeId + ") failed to load with error: " + adapterError);
            this.listener.onRewardedAdLoadFailed(adapterError);
        }

        public void onAdShowed() {
            ByteDanceMediationAdapter.this.log("Rewarded ad displayed: " + this.codeId);
            this.listener.onRewardedAdDisplayed();
            this.listener.onRewardedAdVideoStarted();
        }

        public void onAdClicked() {
            ByteDanceMediationAdapter.this.log("Rewarded ad clicked: " + this.codeId);
            this.listener.onRewardedAdClicked();
        }

        public void onUserEarnedReward(PAGRewardItem rewardItem) {
            ByteDanceMediationAdapter.this.log("Rewarded user with reward: " + rewardItem.getRewardAmount() + " " + rewardItem.getRewardName());
            this.hasGrantedReward = true;
        }

        public void onUserEarnedRewardFail(int code, String message) {
            ByteDanceMediationAdapter.this.log("Failed to reward user with error: " + code + " " + message);
            this.hasGrantedReward = false;
        }

        public void onAdDismissed() {
            ByteDanceMediationAdapter.this.log("Rewarded ad hidden: " + this.codeId);
            this.listener.onRewardedAdVideoCompleted();
            if (this.hasGrantedReward || ByteDanceMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = ByteDanceMediationAdapter.this.getReward();
                ByteDanceMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            this.listener.onRewardedAdHidden();
        }
    }

    private class AppOpenAdListener
    implements PAGAppOpenAdLoadListener,
    PAGAppOpenAdInteractionListener {
        private final String codeId;
        private final MaxAppOpenAdapterListener listener;

        AppOpenAdListener(String codeId, MaxAppOpenAdapterListener listener) {
            this.codeId = codeId;
            this.listener = listener;
        }

        public void onAdLoaded(PAGAppOpenAd ad) {
            if (ad == null) {
                ByteDanceMediationAdapter.this.log("App open ad(" + this.codeId + ") NO FILL'd");
                this.listener.onAppOpenAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            ByteDanceMediationAdapter.this.log("App open ad loaded: " + this.codeId);
            ByteDanceMediationAdapter.this.appOpenAd = ad;
            this.listener.onAppOpenAdLoaded();
        }

        public void onError(int code, String message) {
            MaxAdapterError adapterError = ByteDanceMediationAdapter.toMaxError(code, message);
            ByteDanceMediationAdapter.this.log("App open ad (" + this.codeId + ") failed to load with error: " + adapterError);
            this.listener.onAppOpenAdLoadFailed(adapterError);
        }

        public void onAdShowed() {
            ByteDanceMediationAdapter.this.log("App open ad displayed: " + this.codeId);
            this.listener.onAppOpenAdDisplayed();
        }

        public void onAdClicked() {
            ByteDanceMediationAdapter.this.log("App open ad clicked: " + this.codeId);
            this.listener.onAppOpenAdClicked();
        }

        public void onAdDismissed() {
            ByteDanceMediationAdapter.this.log("App open ad hidden: " + this.codeId);
            this.listener.onAppOpenAdHidden();
        }
    }

    private class InterstitialAdListener
    implements PAGInterstitialAdLoadListener,
    PAGInterstitialAdInteractionListener {
        private final String codeId;
        private final MaxInterstitialAdapterListener listener;

        InterstitialAdListener(String codeId, MaxInterstitialAdapterListener listener) {
            this.codeId = codeId;
            this.listener = listener;
        }

        public void onAdLoaded(PAGInterstitialAd ad) {
            if (ad == null) {
                ByteDanceMediationAdapter.this.log("Interstitial ad(" + this.codeId + ") NO FILL'd");
                this.listener.onInterstitialAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            ByteDanceMediationAdapter.this.log("Interstitial ad loaded: " + this.codeId);
            ByteDanceMediationAdapter.this.interstitialAd = ad;
            this.listener.onInterstitialAdLoaded();
        }

        public void onError(int code, String message) {
            MaxAdapterError adapterError = ByteDanceMediationAdapter.toMaxError(code, message);
            ByteDanceMediationAdapter.this.log("Interstitial ad (" + this.codeId + ") failed to load with error: " + adapterError);
            this.listener.onInterstitialAdLoadFailed(adapterError);
        }

        public void onAdShowed() {
            ByteDanceMediationAdapter.this.log("Interstitial ad displayed: " + this.codeId);
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdClicked() {
            ByteDanceMediationAdapter.this.log("Interstitial ad clicked: " + this.codeId);
            this.listener.onInterstitialAdClicked();
        }

        public void onAdDismissed() {
            ByteDanceMediationAdapter.this.log("Interstitial ad hidden: " + this.codeId);
            this.listener.onInterstitialAdHidden();
        }
    }
}

