/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxRewardedInterstitialAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdExperienceType;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdOptionsView;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.BidderTokenProvider;
import com.facebook.ads.BuildConfig;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdExtendedListener;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeAdView;
import com.facebook.ads.NativeBannerAd;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdExtendedListener;
import com.facebook.ads.RewardedVideoAdListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class FacebookMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxRewardedInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter,
MaxSignalProvider {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus sStatus;
    private AdView mAdView;
    private NativeAd mNativeAd;
    private NativeBannerAd mNativeBannerAd;
    private InterstitialAd mInterstitialAd;
    private RewardedVideoAd mRewardedVideoAd;
    private RewardedVideoAd mRewardedInterAd;
    private final AtomicBoolean onInterstitialAdHiddenCalled = new AtomicBoolean();
    private final AtomicBoolean onRewardedAdVideoCompletedCalled = new AtomicBoolean();
    private final AtomicBoolean onRewardedAdHiddenCalled = new AtomicBoolean();

    public FacebookMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        this.updateAdSettings((MaxAdapterParameters)parameters);
        if (INITIALIZED.compareAndSet(false, true)) {
            sStatus = MaxAdapter.InitializationStatus.INITIALIZING;
            ArrayList placementIds = parameters.getServerParameters().getStringArrayList("placement_ids");
            AudienceNetworkAds.InitListener initListener = new AudienceNetworkAds.InitListener(){

                public void onInitialized(AudienceNetworkAds.InitResult initResult) {
                    if (initResult.isSuccess()) {
                        FacebookMediationAdapter.this.log("Facebook SDK successfully finished initialization: " + initResult.getMessage());
                        sStatus = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                        onCompletionListener.onCompletion(sStatus, null);
                    } else {
                        FacebookMediationAdapter.this.log("Facebook SDK failed to finished initialization: " + initResult.getMessage());
                        sStatus = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                        onCompletionListener.onCompletion(sStatus, initResult.getMessage());
                    }
                }
            };
            if (parameters.isTesting()) {
                AdSettings.setDebugBuild((boolean)true);
            }
            this.log("Initializing Facebook SDK with placements: " + placementIds);
            AudienceNetworkAds.buildInitSettings((Context)this.getContext(activity)).withMediationService(this.getMediationIdentifier()).withPlacementIds((List)placementIds).withInitListener(initListener).initialize();
        } else {
            this.log("Facebook attempted initialization already - marking initialization as completed");
            onCompletionListener.onCompletion(sStatus, null);
        }
    }

    public String getSdkVersion() {
        return this.getVersionString(BuildConfig.class, "VERSION_NAME");
    }

    public String getAdapterVersion() {
        return "6.15.0.0";
    }

    public void onDestroy() {
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.destroy();
            this.mInterstitialAd = null;
        }
        if (this.mRewardedVideoAd != null) {
            this.mRewardedVideoAd.destroy();
            this.mRewardedVideoAd = null;
        }
        if (this.mRewardedInterAd != null) {
            this.mRewardedInterAd.destroy();
            this.mRewardedInterAd = null;
        }
        if (this.mAdView != null) {
            this.mAdView.destroy();
            this.mAdView = null;
        }
        if (this.mNativeAd != null) {
            this.mNativeAd.unregisterView();
            this.mNativeAd.destroy();
            this.mNativeAd = null;
        }
        if (this.mNativeBannerAd != null) {
            this.mNativeBannerAd.unregisterView();
            this.mNativeBannerAd.destroy();
            this.mNativeBannerAd = null;
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        this.updateAdSettings((MaxAdapterParameters)parameters);
        String signal = BidderTokenProvider.getBidderToken((Context)this.getContext(activity));
        callback.onSignalCollected(signal);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading interstitial ad: " + placementId + "...");
        this.updateAdSettings((MaxAdapterParameters)parameters);
        this.mInterstitialAd = new InterstitialAd(activity.getApplicationContext(), placementId);
        InterstitialAd.InterstitialAdLoadConfigBuilder adLoadConfigBuilder = this.mInterstitialAd.buildLoadAdConfig().withAdListener((com.facebook.ads.InterstitialAdListener)new InterstitialAdListener(listener));
        if (this.mInterstitialAd.isAdLoaded() && !this.mInterstitialAd.isAdInvalidated()) {
            this.log("An interstitial ad has been loaded already");
            listener.onInterstitialAdLoaded();
        } else {
            this.log("Loading bidding interstitial ad...");
            this.mInterstitialAd.loadAd(adLoadConfigBuilder.withBid(parameters.getBidResponse()).build());
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial ad: " + parameters.getThirdPartyAdPlacementId() + "...");
        if (this.mInterstitialAd != null && this.mInterstitialAd.isAdLoaded()) {
            if (!this.mInterstitialAd.isAdInvalidated()) {
                this.mInterstitialAd.show();
            } else {
                this.log("Unable to show interstitial - ad expired...");
                listener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_EXPIRED);
            }
        } else {
            this.log("Unable to show interstitial - no ad loaded...");
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
        }
    }

    public void loadRewardedInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, final MaxRewardedInterstitialAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading rewarded interstitial: " + placementId + "...");
        this.updateAdSettings((MaxAdapterParameters)parameters);
        this.mRewardedInterAd = new RewardedVideoAd(activity.getApplicationContext(), placementId);
        RewardedVideoAd.RewardedVideoAdLoadConfigBuilder adLoadConfigBuilder = this.mRewardedInterAd.buildLoadAdConfig().withAdExperience(AdExperienceType.AD_EXPERIENCE_TYPE_REWARDED_INTERSTITIAL).withAdListener((RewardedVideoAdListener)new RewardedVideoAdExtendedListener(){
            private boolean hasGrantedReward;

            public void onAdLoaded(Ad ad) {
                FacebookMediationAdapter.this.log("Rewarded interstitial ad loaded: " + placementId);
                listener.onRewardedInterstitialAdLoaded();
            }

            public void onError(Ad ad, AdError adError) {
                MaxAdapterError adapterError = FacebookMediationAdapter.toMaxError(adError);
                FacebookMediationAdapter.this.log("Rewarded interstitial ad (" + placementId + ") failed to load with error: " + adapterError);
                listener.onRewardedInterstitialAdLoadFailed(adapterError);
            }

            public void onAdClicked(Ad ad) {
                FacebookMediationAdapter.this.log("Rewarded interstitial ad clicked: " + placementId);
                listener.onRewardedInterstitialAdClicked();
            }

            public void onRewardedVideoClosed() {
                if (FacebookMediationAdapter.this.onRewardedAdHiddenCalled.compareAndSet(false, true)) {
                    if (this.hasGrantedReward || FacebookMediationAdapter.this.shouldAlwaysRewardUser()) {
                        MaxReward reward = FacebookMediationAdapter.this.getReward();
                        FacebookMediationAdapter.this.log("Rewarded user with reward: " + reward);
                        listener.onUserRewarded(reward);
                    }
                    FacebookMediationAdapter.this.log("Rewarded interstitial ad hidden: " + placementId);
                    listener.onRewardedInterstitialAdHidden();
                } else {
                    FacebookMediationAdapter.this.log("Rewarded interstitial ad hidden: " + placementId);
                }
            }

            public void onRewardedVideoCompleted() {
                FacebookMediationAdapter.this.log("Rewarded interstitial ad video completed: " + placementId);
                if (FacebookMediationAdapter.this.onRewardedAdVideoCompletedCalled.compareAndSet(false, true)) {
                    listener.onRewardedInterstitialAdVideoCompleted();
                    this.hasGrantedReward = true;
                }
            }

            public void onLoggingImpression(Ad ad) {
                FacebookMediationAdapter.this.log("Rewarded interstitial ad logging impression: " + placementId);
                listener.onRewardedInterstitialAdDisplayed();
                listener.onRewardedInterstitialAdVideoStarted();
            }

            public void onRewardedVideoActivityDestroyed() {
                FacebookMediationAdapter.this.log("Rewarded interstitial ad Activity destroyed: " + placementId);
                if (FacebookMediationAdapter.this.onRewardedAdVideoCompletedCalled.compareAndSet(false, true)) {
                    listener.onRewardedInterstitialAdVideoCompleted();
                }
                if (FacebookMediationAdapter.this.onRewardedAdHiddenCalled.compareAndSet(false, true)) {
                    listener.onRewardedInterstitialAdHidden();
                }
            }
        });
        if (this.mRewardedInterAd.isAdLoaded() && !this.mRewardedInterAd.isAdInvalidated()) {
            this.log("A rewarded interstitial ad has been loaded already");
            listener.onRewardedInterstitialAdLoaded();
        } else {
            this.log("Loading bidding rewarded interstitial ad...");
            this.mRewardedInterAd.loadAd(adLoadConfigBuilder.withBid(parameters.getBidResponse()).build());
        }
    }

    public void showRewardedInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedInterstitialAdapterListener listener) {
        this.log("Showing rewarded interstitial ad: " + parameters.getThirdPartyAdPlacementId() + "...");
        if (this.mRewardedInterAd != null && this.mRewardedInterAd.isAdLoaded()) {
            if (!this.mRewardedInterAd.isAdInvalidated()) {
                this.configureReward(parameters);
                this.mRewardedInterAd.show();
            } else {
                this.log("Unable to show rewarded interstitial ad - ad expired...");
                listener.onRewardedInterstitialAdDisplayFailed(MaxAdapterError.AD_EXPIRED);
            }
        } else {
            this.log("Unable to show rewarded interstitial ad - no ad loaded...");
            listener.onRewardedInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded Interstitial ad not ready"));
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading rewarded: " + placementId + "...");
        this.updateAdSettings((MaxAdapterParameters)parameters);
        this.mRewardedVideoAd = new RewardedVideoAd(activity.getApplicationContext(), placementId);
        RewardedVideoAd.RewardedVideoAdLoadConfigBuilder adLoadConfigBuilder = this.mRewardedVideoAd.buildLoadAdConfig().withAdListener((RewardedVideoAdListener)new RewardedAdListener(listener));
        if (this.mRewardedVideoAd.isAdLoaded() && !this.mRewardedVideoAd.isAdInvalidated()) {
            this.log("A rewarded ad has been loaded already");
            listener.onRewardedAdLoaded();
        } else {
            this.log("Loading bidding rewarded ad...");
            this.mRewardedVideoAd.loadAd(adLoadConfigBuilder.withBid(parameters.getBidResponse()).build());
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad: " + parameters.getThirdPartyAdPlacementId() + "...");
        if (this.mRewardedVideoAd != null && this.mRewardedVideoAd.isAdLoaded()) {
            if (!this.mRewardedVideoAd.isAdInvalidated()) {
                this.configureReward(parameters);
                this.mRewardedVideoAd.show();
            } else {
                this.log("Unable to show rewarded ad - ad expired...");
                listener.onRewardedAdDisplayFailed(MaxAdapterError.AD_EXPIRED);
            }
        } else {
            this.log("Unable to show rewarded ad - no ad loaded...");
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        this.log("Loading" + (isNative ? " native " : " ") + adFormat.getLabel() + " ad: " + placementId + "...");
        this.updateAdSettings((MaxAdapterParameters)parameters);
        if (isNative) {
            this.mNativeAd = new NativeAd(this.getContext(activity), placementId);
            this.mNativeAd.loadAd(this.mNativeAd.buildLoadAdConfig().withAdListener((NativeAdListener)new NativeAdViewListener(parameters.getServerParameters(), adFormat, activity, listener)).withBid(parameters.getBidResponse()).build());
        } else {
            this.mAdView = new AdView(this.getContext(activity), placementId, this.toAdSize(adFormat));
            this.mAdView.loadAd(this.mAdView.buildLoadAdConfig().withAdListener((AdListener)new AdViewListener(adFormat, listener)).withBid(parameters.getBidResponse()).build());
        }
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, Activity activity, MaxNativeAdAdapterListener listener) {
        Bundle serverParameters = parameters.getServerParameters();
        boolean isNativeBanner = BundleUtils.getBoolean((String)"is_native_banner", (Bundle)serverParameters);
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading native " + (isNativeBanner ? "banner " : "") + "ad: " + placementId + "...");
        this.updateAdSettings((MaxAdapterParameters)parameters);
        Context context = this.getContext(activity);
        if (isNativeBanner) {
            this.mNativeBannerAd = new NativeBannerAd(context, placementId);
            this.mNativeBannerAd.loadAd(this.mNativeBannerAd.buildLoadAdConfig().withAdListener((NativeAdListener)new MaxNativeAdListener(parameters.getServerParameters(), context, listener)).withBid(parameters.getBidResponse()).build());
        } else {
            this.mNativeAd = new NativeAd(context, placementId);
            this.mNativeAd.loadAd(this.mNativeAd.buildLoadAdConfig().withAdListener((NativeAdListener)new MaxNativeAdListener(parameters.getServerParameters(), context, listener)).withBid(parameters.getBidResponse()).build());
        }
    }

    private AdSize toAdSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER) {
            return AdSize.BANNER_HEIGHT_50;
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return AdSize.BANNER_HEIGHT_90;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return AdSize.RECTANGLE_HEIGHT_250;
        }
        throw new IllegalArgumentException("Invalid ad format: " + adFormat);
    }

    private void updateAdSettings(MaxAdapterParameters parameters) {
        String testDevicesString;
        Boolean isAgeRestrictedUser;
        Bundle serverParameters = parameters.getServerParameters();
        if (serverParameters.containsKey("video_autoplay")) {
            boolean videoAutoplay = serverParameters.getBoolean("video_autoplay");
            AdSettings.setVideoAutoplay((boolean)videoAutoplay);
        }
        if ((isAgeRestrictedUser = parameters.isAgeRestrictedUser()) != null) {
            AdSettings.setMixedAudience((boolean)isAgeRestrictedUser);
        }
        if (!TextUtils.isEmpty((CharSequence)(testDevicesString = serverParameters.getString("test_device_ids", null)))) {
            List<String> testDeviceList = Arrays.asList(testDevicesString.split(","));
            AdSettings.addTestDevices(testDeviceList);
        }
        AdSettings.setMediationService((String)this.getMediationIdentifier());
    }

    private static MaxAdapterError toMaxError(AdError facebookError) {
        int facebookErrorCode = facebookError.getErrorCode();
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (facebookErrorCode) {
            case 1000: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case 1001: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case 2000: 
            case 2008: {
                adapterError = MaxAdapterError.SERVER_ERROR;
                break;
            }
            case 2001: 
            case 2009: {
                adapterError = MaxAdapterError.TIMEOUT;
                break;
            }
            case 1002: 
            case 2002: 
            case 2100: 
            case 7001: 
            case 7002: 
            case 7004: 
            case 7007: {
                adapterError = MaxAdapterError.INVALID_LOAD_STATE;
                break;
            }
            case 2003: 
            case 2004: 
            case 2006: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case 6001: 
            case 6002: 
            case 6003: {
                adapterError = new MaxAdapterError(-5400, "Missing Native Ad Assets");
                break;
            }
            case 7003: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case 7005: 
            case 7006: 
            case 9001: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), facebookErrorCode, facebookError.getErrorMessage());
    }

    private String getMediationIdentifier() {
        return "APPLOVIN_" + AppLovinSdk.VERSION + ":" + this.getAdapterVersion();
    }

    private MaxNativeAdView createMaxNativeAdView(MaxNativeAd maxNativeAd, String templateName, Activity activity) {
        if (AppLovinSdk.VERSION_CODE >= 11010000) {
            return new MaxNativeAdView(maxNativeAd, templateName, this.getApplicationContext());
        }
        return new MaxNativeAdView(maxNativeAd, templateName, activity);
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private class MaxFacebookNativeAd
    extends MaxNativeAd {
        private MaxFacebookNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
            ArrayList<View> clickableViews = new ArrayList<View>(6);
            if (AppLovinSdkUtils.isValidString((String)this.getTitle()) && maxNativeAdView.getTitleTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getTitleTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getAdvertiser()) && maxNativeAdView.getAdvertiserTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getAdvertiserTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getBody()) && maxNativeAdView.getBodyTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getBodyTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getCallToAction()) && maxNativeAdView.getCallToActionButton() != null) {
                clickableViews.add((View)maxNativeAdView.getCallToActionButton());
            }
            if (this.getIcon() != null && maxNativeAdView.getIconImageView() != null) {
                clickableViews.add((View)maxNativeAdView.getIconImageView());
            }
            if (this.getMediaView() != null && maxNativeAdView.getMediaContentViewGroup() != null) {
                clickableViews.add((View)maxNativeAdView.getMediaContentViewGroup());
            }
            if (clickableViews.isEmpty()) {
                FacebookMediationAdapter.this.e("No clickable views to prepare");
                return;
            }
            this.prepareForInteraction(clickableViews, (ViewGroup)maxNativeAdView);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            NativeAd nativeAd;
            Object object = nativeAd = FacebookMediationAdapter.this.mNativeAd != null ? FacebookMediationAdapter.this.mNativeAd : FacebookMediationAdapter.this.mNativeBannerAd;
            if (nativeAd == null) {
                FacebookMediationAdapter.this.e("Failed to register native ad views: native ad is null.");
                return false;
            }
            if (clickableViews.isEmpty()) {
                FacebookMediationAdapter.this.e("No clickable views to prepare");
                return false;
            }
            ImageView iconImageView = null;
            for (View clickableView : clickableViews) {
                if (!(clickableView instanceof ImageView)) continue;
                iconImageView = (ImageView)clickableView;
                break;
            }
            if (!(nativeAd instanceof NativeBannerAd)) {
                nativeAd.registerViewForInteraction((View)container, (MediaView)this.getMediaView(), iconImageView, clickableViews);
                return true;
            }
            if (iconImageView != null) {
                ((NativeBannerAd)nativeAd).registerViewForInteraction((View)container, iconImageView, clickableViews);
                return true;
            }
            if (this.getMediaView() != null) {
                ((NativeBannerAd)nativeAd).registerViewForInteraction((View)container, (ImageView)this.getMediaView(), clickableViews);
                return true;
            }
            FacebookMediationAdapter.this.e("Failed to register native ad view for interaction: icon image view and media view are null");
            return false;
        }
    }

    private class MaxNativeAdListener
    implements NativeAdListener {
        final Bundle serverParameters;
        final Context context;
        final MaxNativeAdAdapterListener listener;

        MaxNativeAdListener(Bundle serverParameters, Context context, MaxNativeAdAdapterListener listener) {
            this.serverParameters = serverParameters;
            this.context = context;
            this.listener = listener;
        }

        public void onAdLoaded(Ad ad) {
            NativeAd nativeAd;
            FacebookMediationAdapter.this.log("Native ad loaded: " + ad.getPlacementId());
            Object object = nativeAd = FacebookMediationAdapter.this.mNativeAd != null ? FacebookMediationAdapter.this.mNativeAd : FacebookMediationAdapter.this.mNativeBannerAd;
            if (nativeAd == null || nativeAd != ad) {
                FacebookMediationAdapter.this.log("Native ad failed to load: no fill");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            if (nativeAd.isAdInvalidated()) {
                FacebookMediationAdapter.this.log("Native ad failed to load: ad is no longer valid");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.AD_EXPIRED);
                return;
            }
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)nativeAd.getAdHeadline())) {
                FacebookMediationAdapter.this.e("Native ad (" + nativeAd + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                return;
            }
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable((NativeAdBase)nativeAd){
                final /* synthetic */ NativeAdBase val$nativeAd;
                {
                    this.val$nativeAd = nativeAdBase;
                }

                @Override
                public void run() {
                    final MediaView mediaView = new MediaView(MaxNativeAdListener.this.context);
                    Drawable iconDrawable = this.val$nativeAd.getPreloadedIconViewDrawable();
                    final NativeAdBase.Image icon = this.val$nativeAd.getAdIcon();
                    if (iconDrawable != null) {
                        MaxNativeAdListener.this.handleNativeAdLoaded(this.val$nativeAd, iconDrawable, mediaView, MaxNativeAdListener.this.context);
                    } else if (icon != null) {
                        FacebookMediationAdapter.this.getCachingExecutorService().execute(new Runnable(){

                            @Override
                            public void run() {
                                Drawable iconDrawable = null;
                                if (AppLovinSdkUtils.isValidString((String)icon.getUrl())) {
                                    FacebookMediationAdapter.this.log("Adding native ad icon (" + icon.getUrl() + ") to queue to be fetched");
                                    Future iconDrawableFuture = FacebookMediationAdapter.this.createDrawableFuture(icon.getUrl(), MaxNativeAdListener.this.context.getResources());
                                    int imageTaskTimeoutSeconds = BundleUtils.getInt((String)"image_task_timeout_seconds", (int)10, (Bundle)MaxNativeAdListener.this.serverParameters);
                                    try {
                                        if (iconDrawableFuture != null) {
                                            iconDrawable = (Drawable)iconDrawableFuture.get(imageTaskTimeoutSeconds, TimeUnit.SECONDS);
                                        }
                                    }
                                    catch (Throwable th) {
                                        FacebookMediationAdapter.this.e("Image fetching tasks failed", th);
                                    }
                                }
                                MaxNativeAdListener.this.handleNativeAdLoaded(val$nativeAd, iconDrawable, mediaView, MaxNativeAdListener.this.context);
                            }
                        });
                    } else {
                        FacebookMediationAdapter.this.log("No native ad icon (optional) available for the current creative.");
                        MaxNativeAdListener.this.handleNativeAdLoaded(this.val$nativeAd, null, mediaView, MaxNativeAdListener.this.context);
                    }
                }
            });
        }

        public void onMediaDownloaded(Ad ad) {
            FacebookMediationAdapter.this.log("Native ad successfully downloaded media: " + ad.getPlacementId());
        }

        public void onError(Ad ad, AdError adError) {
            MaxAdapterError adapterError = FacebookMediationAdapter.toMaxError(adError);
            FacebookMediationAdapter.this.log("Native ad (" + ad.getPlacementId() + ") failed to load with error (" + adapterError);
            this.listener.onNativeAdLoadFailed(adapterError);
        }

        public void onLoggingImpression(Ad ad) {
            FacebookMediationAdapter.this.log("Native shown: " + ad.getPlacementId());
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdClicked(Ad ad) {
            FacebookMediationAdapter.this.log("Native clicked: " + ad.getPlacementId());
            this.listener.onNativeAdClicked();
        }

        private void handleNativeAdLoaded(NativeAdBase nativeAd, Drawable iconDrawable, MediaView mediaView, Context context) {
            MaxNativeAd.MaxNativeAdImage mainImage = null;
            if (nativeAd instanceof NativeAd && nativeAd.getAdCoverImage() != null) {
                Uri uri = Uri.parse((String)nativeAd.getAdCoverImage().getUrl());
                mainImage = new MaxNativeAd.MaxNativeAdImage(uri);
            }
            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(nativeAd.getAdHeadline()).setAdvertiser(nativeAd.getAdvertiserName()).setBody(nativeAd.getAdBodyText()).setCallToAction(nativeAd.getAdCallToAction()).setIcon(new MaxNativeAd.MaxNativeAdImage(iconDrawable)).setOptionsView((View)new AdOptionsView(context, nativeAd, null));
            if (nativeAd instanceof NativeAd && AppLovinSdk.VERSION_CODE >= 11040399) {
                builder.setMainImage(mainImage);
            }
            float mediaViewAspectRatio = 0.0f;
            if (nativeAd instanceof NativeBannerAd) {
                ImageView mediaViewImageView = new ImageView(context);
                mediaViewImageView.setImageDrawable(iconDrawable);
                builder.setMediaView((View)mediaViewImageView);
                if (iconDrawable != null) {
                    mediaViewAspectRatio = (float)iconDrawable.getIntrinsicWidth() / (float)iconDrawable.getIntrinsicHeight();
                }
            } else {
                builder.setMediaView((View)mediaView);
                mediaViewAspectRatio = (float)mediaView.getMediaWidth() / (float)mediaView.getMediaHeight();
            }
            if (AppLovinSdk.VERSION_CODE >= 11040000) {
                builder.setMediaContentAspectRatio(mediaViewAspectRatio);
            }
            MaxFacebookNativeAd maxNativeAd = new MaxFacebookNativeAd(builder);
            this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, null);
        }
    }

    private class NativeAdViewListener
    implements NativeAdListener {
        final Bundle serverParameters;
        final WeakReference<Activity> activityRef;
        final MaxAdFormat adFormat;
        final MaxAdViewAdapterListener listener;

        NativeAdViewListener(Bundle serverParameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
            this.serverParameters = serverParameters;
            this.activityRef = new WeakReference<Activity>(activity);
            this.adFormat = adFormat;
            this.listener = listener;
        }

        public void onAdLoaded(Ad ad) {
            FacebookMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded: " + ad.getPlacementId());
            if (FacebookMediationAdapter.this.mNativeAd == null || FacebookMediationAdapter.this.mNativeAd != ad) {
                FacebookMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load: no fill");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            if (FacebookMediationAdapter.this.mNativeAd.isAdInvalidated()) {
                FacebookMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load: ad is no longer valid");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.AD_EXPIRED);
                return;
            }
            if (this.adFormat == MaxAdFormat.MREC) {
                View mrecView = NativeAdView.render((Context)FacebookMediationAdapter.this.getContext((Activity)this.activityRef.get()), (NativeAd)FacebookMediationAdapter.this.mNativeAd);
                this.listener.onAdViewAdLoaded(mrecView);
            } else {
                this.renderNativeAdView();
            }
        }

        public void onMediaDownloaded(Ad ad) {
            FacebookMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " successfully downloaded media: " + ad.getPlacementId());
        }

        public void onError(Ad ad, AdError adError) {
            MaxAdapterError adapterError = FacebookMediationAdapter.toMaxError(adError);
            FacebookMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad (" + ad.getPlacementId() + ") failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onLoggingImpression(Ad ad) {
            FacebookMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " shown: " + ad.getPlacementId());
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked(Ad ad) {
            FacebookMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " clicked: " + ad.getPlacementId());
            this.listener.onAdViewAdClicked();
        }

        private void renderNativeAdView() {
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ViewGroup mediaContentView;
                    MaxNativeAdView maxNativeAdView;
                    Activity activity = (Activity)NativeAdViewListener.this.activityRef.get();
                    Context context = FacebookMediationAdapter.this.getContext(activity);
                    MediaView iconView = new MediaView(context);
                    MediaView mediaView = new MediaView(context);
                    MaxNativeAd maxNativeAd = new MaxNativeAd.Builder().setAdFormat(NativeAdViewListener.this.adFormat).setTitle(FacebookMediationAdapter.this.mNativeAd.getAdHeadline()).setAdvertiser(FacebookMediationAdapter.this.mNativeAd.getAdvertiserName()).setBody(FacebookMediationAdapter.this.mNativeAd.getAdBodyText()).setCallToAction(FacebookMediationAdapter.this.mNativeAd.getAdCallToAction()).setIconView((View)iconView).setOptionsView((View)new AdOptionsView(context, (NativeAdBase)FacebookMediationAdapter.this.mNativeAd, null)).setMediaView((View)mediaView).build();
                    String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)NativeAdViewListener.this.serverParameters);
                    if (templateName.contains("vertical")) {
                        if (AppLovinSdk.VERSION_CODE < 9140500) {
                            FacebookMediationAdapter.this.log("Vertical native banners are only supported on MAX SDK 9.14.5 and above. Default native template will be used.");
                        }
                        if (templateName.equals("vertical")) {
                            String verticalTemplateName = NativeAdViewListener.this.adFormat == MaxAdFormat.LEADER ? "vertical_leader_template" : "vertical_media_banner_template";
                            maxNativeAdView = FacebookMediationAdapter.this.createMaxNativeAdView(maxNativeAd, verticalTemplateName, activity);
                        } else {
                            maxNativeAdView = FacebookMediationAdapter.this.createMaxNativeAdView(maxNativeAd, templateName, activity);
                        }
                    } else {
                        maxNativeAdView = AppLovinSdk.VERSION_CODE < 9140500 ? FacebookMediationAdapter.this.createMaxNativeAdView(maxNativeAd, AppLovinSdkUtils.isValidString((String)templateName) ? templateName : "no_body_banner_template", activity) : FacebookMediationAdapter.this.createMaxNativeAdView(maxNativeAd, AppLovinSdkUtils.isValidString((String)templateName) ? templateName : "media_banner_template", activity);
                    }
                    ArrayList<Object> clickableViews = new ArrayList<Object>(6);
                    if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getTitle()) && maxNativeAdView.getTitleTextView() != null) {
                        clickableViews.add(maxNativeAdView.getTitleTextView());
                    }
                    if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getAdvertiser()) && maxNativeAdView.getAdvertiserTextView() != null) {
                        clickableViews.add(maxNativeAdView.getAdvertiserTextView());
                    }
                    if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getBody()) && maxNativeAdView.getBodyTextView() != null) {
                        clickableViews.add(maxNativeAdView.getBodyTextView());
                    }
                    if (AppLovinSdkUtils.isValidString((String)maxNativeAd.getCallToAction()) && maxNativeAdView.getCallToActionButton() != null) {
                        clickableViews.add(maxNativeAdView.getCallToActionButton());
                    }
                    if (maxNativeAd.getIconView() != null && maxNativeAdView.getIconContentView() != null) {
                        clickableViews.add(maxNativeAdView.getIconContentView());
                    }
                    Object object = mediaContentView = AppLovinSdk.VERSION_CODE >= 11000000 ? maxNativeAdView.getMediaContentViewGroup() : maxNativeAdView.getMediaContentView();
                    if (maxNativeAd.getMediaView() != null && mediaContentView != null) {
                        clickableViews.add(mediaContentView);
                    }
                    FacebookMediationAdapter.this.mNativeAd.registerViewForInteraction((View)maxNativeAdView, mediaView, iconView, clickableViews);
                    NativeAdViewListener.this.listener.onAdViewAdLoaded((View)maxNativeAdView);
                }
            });
        }
    }

    private class AdViewListener
    implements AdListener {
        final MaxAdFormat adFormat;
        final MaxAdViewAdapterListener listener;

        AdViewListener(MaxAdFormat adFormat, MaxAdViewAdapterListener listener) {
            this.adFormat = adFormat;
            this.listener = listener;
        }

        public void onAdLoaded(Ad ad) {
            FacebookMediationAdapter.this.log(this.adFormat.getLabel() + " ad loaded: " + ad.getPlacementId());
            this.listener.onAdViewAdLoaded((View)FacebookMediationAdapter.this.mAdView);
        }

        public void onError(Ad ad, AdError adError) {
            MaxAdapterError adapterError = FacebookMediationAdapter.toMaxError(adError);
            FacebookMediationAdapter.this.log(this.adFormat.getLabel() + " ad (" + ad.getPlacementId() + ") failed to load with error (" + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdClicked(Ad ad) {
            FacebookMediationAdapter.this.log(this.adFormat.getLabel() + " ad clicked: " + ad.getPlacementId());
            this.listener.onAdViewAdClicked();
        }

        public void onLoggingImpression(Ad ad) {
            FacebookMediationAdapter.this.log(this.adFormat.getLabel() + " ad displayed: " + ad.getPlacementId());
            this.listener.onAdViewAdDisplayed();
        }
    }

    private class RewardedAdListener
    implements RewardedVideoAdExtendedListener {
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedAdListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded(Ad ad) {
            FacebookMediationAdapter.this.log("Rewarded ad loaded: " + ad.getPlacementId());
            this.listener.onRewardedAdLoaded();
        }

        public void onError(Ad ad, AdError adError) {
            MaxAdapterError adapterError = FacebookMediationAdapter.toMaxError(adError);
            FacebookMediationAdapter.this.log("Rewarded ad (" + ad.getPlacementId() + ") failed to load with error (" + adapterError);
            this.listener.onRewardedAdLoadFailed(adapterError);
        }

        public void onAdClicked(Ad ad) {
            FacebookMediationAdapter.this.log("Rewarded ad clicked: " + ad.getPlacementId());
            this.listener.onRewardedAdClicked();
        }

        public void onRewardedVideoClosed() {
            FacebookMediationAdapter.this.log("Rewarded ad hidden");
            if (FacebookMediationAdapter.this.onRewardedAdHiddenCalled.compareAndSet(false, true)) {
                if (this.hasGrantedReward || FacebookMediationAdapter.this.shouldAlwaysRewardUser()) {
                    MaxReward reward = FacebookMediationAdapter.this.getReward();
                    FacebookMediationAdapter.this.log("Rewarded user with reward: " + reward);
                    this.listener.onUserRewarded(reward);
                }
                this.listener.onRewardedAdHidden();
            }
        }

        public void onRewardedVideoCompleted() {
            FacebookMediationAdapter.this.log("Rewarded ad video completed");
            if (FacebookMediationAdapter.this.onRewardedAdVideoCompletedCalled.compareAndSet(false, true)) {
                this.listener.onRewardedAdVideoCompleted();
                this.hasGrantedReward = true;
            }
        }

        public void onLoggingImpression(Ad ad) {
            FacebookMediationAdapter.this.log("Rewarded ad logging impression: " + ad.getPlacementId());
            this.listener.onRewardedAdDisplayed();
            this.listener.onRewardedAdVideoStarted();
        }

        public void onRewardedVideoActivityDestroyed() {
            FacebookMediationAdapter.this.log("Rewarded ad Activity destroyed");
            if (FacebookMediationAdapter.this.onRewardedAdVideoCompletedCalled.compareAndSet(false, true)) {
                this.listener.onRewardedAdVideoCompleted();
            }
            if (FacebookMediationAdapter.this.onRewardedAdHiddenCalled.compareAndSet(false, true)) {
                this.listener.onRewardedAdHidden();
            }
        }
    }

    private class InterstitialAdListener
    implements InterstitialAdExtendedListener {
        private final MaxInterstitialAdapterListener listener;

        InterstitialAdListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoaded(Ad ad) {
            FacebookMediationAdapter.this.log("Interstitial ad loaded: " + ad.getPlacementId());
            this.listener.onInterstitialAdLoaded();
        }

        public void onError(Ad ad, AdError adError) {
            MaxAdapterError adapterError = FacebookMediationAdapter.toMaxError(adError);
            FacebookMediationAdapter.this.log("Interstitial ad (" + ad.getPlacementId() + ") failed to load with error: " + adapterError);
            this.listener.onInterstitialAdLoadFailed(adapterError);
        }

        public void onAdClicked(Ad ad) {
            FacebookMediationAdapter.this.log("Interstitial ad clicked: " + ad.getPlacementId());
            this.listener.onInterstitialAdClicked();
        }

        public void onLoggingImpression(Ad ad) {
            FacebookMediationAdapter.this.log("Interstitial ad logging impression: " + ad.getPlacementId());
            this.listener.onInterstitialAdDisplayed();
        }

        public void onInterstitialDisplayed(Ad ad) {
            FacebookMediationAdapter.this.log("Interstitial ad displayed: " + ad.getPlacementId());
        }

        public void onInterstitialDismissed(Ad ad) {
            FacebookMediationAdapter.this.log("Interstitial ad hidden: " + ad.getPlacementId());
            if (FacebookMediationAdapter.this.onInterstitialAdHiddenCalled.compareAndSet(false, true)) {
                this.listener.onInterstitialAdHidden();
            }
        }

        public void onInterstitialActivityDestroyed() {
            FacebookMediationAdapter.this.log("Interstitial ad Activity destroyed");
            if (FacebookMediationAdapter.this.onInterstitialAdHiddenCalled.compareAndSet(false, true)) {
                this.listener.onInterstitialAdHidden();
            }
        }

        public void onRewardedAdCompleted() {
        }

        public void onRewardedAdServerSucceeded() {
        }

        public void onRewardedAdServerFailed() {
        }
    }
}

