/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.fyber.inneractive.sdk.external.BidTokenProvider;
import com.fyber.inneractive.sdk.external.ImpressionData;
import com.fyber.inneractive.sdk.external.InneractiveAdManager;
import com.fyber.inneractive.sdk.external.InneractiveAdRequest;
import com.fyber.inneractive.sdk.external.InneractiveAdSpot;
import com.fyber.inneractive.sdk.external.InneractiveAdSpotManager;
import com.fyber.inneractive.sdk.external.InneractiveAdViewEventsListenerWithImpressionData;
import com.fyber.inneractive.sdk.external.InneractiveAdViewUnitController;
import com.fyber.inneractive.sdk.external.InneractiveContentController;
import com.fyber.inneractive.sdk.external.InneractiveErrorCode;
import com.fyber.inneractive.sdk.external.InneractiveFullScreenAdRewardedListener;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenAdEventsListenerWithImpressionData;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenUnitController;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenVideoContentController;
import com.fyber.inneractive.sdk.external.InneractiveUnitController;
import com.fyber.inneractive.sdk.external.OnFyberMarketplaceInitializedListener;
import com.fyber.inneractive.sdk.external.VideoContentListener;
import java.util.concurrent.atomic.AtomicBoolean;

public class InneractiveMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus status;
    private InneractiveAdSpot interstitialSpot;
    private InneractiveAdSpot rewardedSpot;
    private InneractiveAdSpot adViewSpot;
    private ViewGroup adViewGroup;
    private boolean hasGrantedReward;

    public InneractiveMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, @Nullable Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            status = MaxAdapter.InitializationStatus.INITIALIZING;
            String appId = parameters.getServerParameters().getString("app_id", null);
            this.log("Initializing Inneractive SDK with app id: " + appId + "...");
            InneractiveAdManager.setMediationName((String)"Max");
            InneractiveAdManager.setMediationVersion((String)AppLovinSdk.VERSION);
            InneractiveAdManager.initialize((Context)this.getContext(activity), (String)appId, (OnFyberMarketplaceInitializedListener)new OnFyberMarketplaceInitializedListener(){

                public void onFyberMarketplaceInitialized(OnFyberMarketplaceInitializedListener.FyberInitStatus fyberInitStatus) {
                    if (fyberInitStatus == OnFyberMarketplaceInitializedListener.FyberInitStatus.SUCCESSFULLY) {
                        InneractiveMediationAdapter.this.log("Inneractive SDK initialized");
                        status = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                        onCompletionListener.onCompletion(status, null);
                    } else {
                        InneractiveMediationAdapter.this.log("Inneractive SDK failed to initialize with error: " + fyberInitStatus);
                        status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                        onCompletionListener.onCompletion(status, fyberInitStatus.toString());
                    }
                }
            });
        } else {
            onCompletionListener.onCompletion(status, null);
        }
    }

    public String getSdkVersion() {
        return InneractiveAdManager.getVersion();
    }

    public String getAdapterVersion() {
        return "8.4.1.0";
    }

    public void onDestroy() {
        if (this.interstitialSpot != null) {
            this.interstitialSpot.destroy();
            this.interstitialSpot = null;
        }
        if (this.rewardedSpot != null) {
            this.rewardedSpot.destroy();
            this.rewardedSpot = null;
        }
        if (this.adViewSpot != null) {
            this.adViewSpot.destroy();
            this.adViewSpot = null;
        }
        this.adViewGroup = null;
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, @Nullable Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        this.updateUserInfo((MaxAdapterParameters)parameters);
        String signal = BidTokenProvider.getBidderToken();
        callback.onSignalCollected(signal);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, final MaxInterstitialAdapterListener listener) {
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + "interstitial ad for spot id \"" + parameters.getThirdPartyAdPlacementId() + "\"...");
        this.updateUserInfo((MaxAdapterParameters)parameters);
        InneractiveFullscreenVideoContentController videoContentController = new InneractiveFullscreenVideoContentController();
        InneractiveFullscreenUnitController controller = new InneractiveFullscreenUnitController();
        controller.addContentController((InneractiveContentController)videoContentController);
        controller.setEventsListener((InneractiveUnitController.EventsListener)new InneractiveFullscreenAdEventsListenerWithImpressionData(){

            public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
            }

            public void onAdImpression(InneractiveAdSpot inneractiveAdSpot, ImpressionData impressionData) {
                InneractiveMediationAdapter.this.log("Interstitial shown");
                String creativeId = impressionData.getCreativeId();
                if (!TextUtils.isEmpty((CharSequence)creativeId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", creativeId);
                    listener.onInterstitialAdDisplayed(extraInfo);
                } else {
                    listener.onInterstitialAdDisplayed();
                }
            }

            public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
                InneractiveMediationAdapter.this.log("Interstitial clicked");
                listener.onInterstitialAdClicked();
            }

            public void onAdDismissed(InneractiveAdSpot inneractiveAdSpot) {
                InneractiveMediationAdapter.this.log("Interstitial hidden");
                listener.onInterstitialAdHidden();
            }

            public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
                MaxAdapterError adapterError = new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, adDisplayError.toString());
                InneractiveMediationAdapter.this.log("Interstitial failed to show: " + adapterError);
                listener.onInterstitialAdDisplayFailed(adapterError);
            }

            public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
            }

            public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
            }
        });
        this.interstitialSpot = InneractiveAdSpotManager.get().createSpot();
        this.interstitialSpot.addUnitController((InneractiveUnitController)controller);
        this.interstitialSpot.setRequestListener(new InneractiveAdSpot.RequestListener(){

            public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {
                InneractiveMediationAdapter.this.log("Interstitial loaded");
                listener.onInterstitialAdLoaded();
            }

            public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
                MaxAdapterError adapterError = InneractiveMediationAdapter.toMaxError(inneractiveErrorCode);
                InneractiveMediationAdapter.this.log("Interstitial failed to load with Inneractive error: " + adapterError);
                listener.onInterstitialAdLoadFailed(adapterError);
            }
        });
        if (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse())) {
            this.interstitialSpot.loadAd(parameters.getBidResponse());
        } else {
            InneractiveAdRequest request = new InneractiveAdRequest(parameters.getThirdPartyAdPlacementId());
            this.interstitialSpot.requestAd(request);
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial ad...");
        if (this.interstitialSpot.isReady()) {
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController)this.interstitialSpot.getSelectedUnitController();
            controller.show(activity);
        } else {
            this.log("Interstitial ad not ready");
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, MaxAdapterError.AD_NOT_READY.getCode(), MaxAdapterError.AD_NOT_READY.getMessage()));
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, final MaxRewardedAdapterListener listener) {
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + "rewarded ad for spot id \"" + parameters.getThirdPartyAdPlacementId() + "\"...");
        this.updateUserInfo((MaxAdapterParameters)parameters);
        InneractiveFullscreenVideoContentController videoContentController = new InneractiveFullscreenVideoContentController();
        videoContentController.setEventsListener((InneractiveContentController.EventsListener)new VideoContentListener(){

            public void onProgress(int totalDurationMillis, int positionMillis) {
                if (positionMillis == 0) {
                    InneractiveMediationAdapter.this.log("Rewarded video started");
                }
            }

            public void onCompleted() {
                InneractiveMediationAdapter.this.log("Rewarded video completed");
            }

            public void onPlayerError() {
                InneractiveMediationAdapter.this.log("Rewarded video failed to display for unspecified error");
                listener.onRewardedAdDisplayFailed(MaxAdapterError.AD_DISPLAY_FAILED);
            }
        });
        InneractiveFullscreenUnitController controller = new InneractiveFullscreenUnitController();
        controller.addContentController((InneractiveContentController)videoContentController);
        controller.setEventsListener((InneractiveUnitController.EventsListener)new InneractiveFullscreenAdEventsListenerWithImpressionData(){

            public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
            }

            public void onAdImpression(InneractiveAdSpot inneractiveAdSpot, ImpressionData impressionData) {
                InneractiveMediationAdapter.this.log("Rewarded ad shown");
                String creativeId = impressionData.getCreativeId();
                if (!TextUtils.isEmpty((CharSequence)creativeId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", creativeId);
                    listener.onRewardedAdDisplayed(extraInfo);
                } else {
                    listener.onRewardedAdDisplayed();
                }
            }

            public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
                InneractiveMediationAdapter.this.log("Rewarded ad clicked");
                listener.onRewardedAdClicked();
            }

            public void onAdDismissed(InneractiveAdSpot inneractiveAdSpot) {
                if (InneractiveMediationAdapter.this.hasGrantedReward || InneractiveMediationAdapter.this.shouldAlwaysRewardUser()) {
                    MaxReward reward = InneractiveMediationAdapter.this.getReward();
                    InneractiveMediationAdapter.this.log("Rewarded user with reward: " + reward);
                    listener.onUserRewarded(reward);
                }
                InneractiveMediationAdapter.this.log("Rewarded ad hidden");
                listener.onRewardedAdHidden();
            }

            public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
                MaxAdapterError adapterError = new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, adDisplayError.toString());
                InneractiveMediationAdapter.this.log("Rewarded ad failed to show: " + adapterError);
                listener.onRewardedAdDisplayFailed(adapterError);
            }

            public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
            }

            public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
            }
        });
        controller.setRewardedListener(new InneractiveFullScreenAdRewardedListener(){

            public void onAdRewarded(InneractiveAdSpot inneractiveAdSpot) {
                InneractiveMediationAdapter.this.log("User earned reward.");
                InneractiveMediationAdapter.this.hasGrantedReward = true;
            }
        });
        this.rewardedSpot = InneractiveAdSpotManager.get().createSpot();
        this.rewardedSpot.addUnitController((InneractiveUnitController)controller);
        this.rewardedSpot.setRequestListener(new InneractiveAdSpot.RequestListener(){

            public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {
                InneractiveMediationAdapter.this.log("Rewarded ad loaded");
                listener.onRewardedAdLoaded();
            }

            public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
                MaxAdapterError adapterError = InneractiveMediationAdapter.toMaxError(inneractiveErrorCode);
                InneractiveMediationAdapter.this.log("Rewarded ad failed to load with Inneractive error: " + adapterError);
                listener.onRewardedAdLoadFailed(adapterError);
            }
        });
        if (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse())) {
            this.rewardedSpot.loadAd(parameters.getBidResponse());
        } else {
            InneractiveAdRequest request = new InneractiveAdRequest(parameters.getThirdPartyAdPlacementId());
            this.rewardedSpot.requestAd(request);
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad...");
        if (this.rewardedSpot.isReady()) {
            this.configureReward(parameters);
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController)this.rewardedSpot.getSelectedUnitController();
            controller.show(activity);
        } else {
            this.log("Rewarded ad not ready");
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, MaxAdapterError.AD_NOT_READY.getCode(), MaxAdapterError.AD_NOT_READY.getMessage()));
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, @Nullable Activity activity, final MaxAdViewAdapterListener listener) {
        this.log("Loading " + (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse()) ? "bidding " : "") + adFormat.getLabel() + " ad for spot id \"" + parameters.getThirdPartyAdPlacementId() + "\"...");
        this.updateUserInfo((MaxAdapterParameters)parameters);
        final InneractiveAdViewUnitController controller = new InneractiveAdViewUnitController();
        controller.setEventsListener((InneractiveUnitController.EventsListener)new InneractiveAdViewEventsListenerWithImpressionData(){

            public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
            }

            public void onAdImpression(InneractiveAdSpot inneractiveAdSpot, ImpressionData impressionData) {
                InneractiveMediationAdapter.this.log("AdView shown");
                String creativeId = impressionData.getCreativeId();
                if (!TextUtils.isEmpty((CharSequence)creativeId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", creativeId);
                    listener.onAdViewAdDisplayed(extraInfo);
                } else {
                    listener.onAdViewAdDisplayed();
                }
            }

            public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
                InneractiveMediationAdapter.this.log("AdView clicked");
                listener.onAdViewAdClicked();
            }

            public void onAdExpanded(InneractiveAdSpot inneractiveAdSpot) {
                InneractiveMediationAdapter.this.log("AdView expanded");
                listener.onAdViewAdExpanded();
            }

            public void onAdCollapsed(InneractiveAdSpot inneractiveAdSpot) {
                InneractiveMediationAdapter.this.log("AdView collapsed");
                listener.onAdViewAdCollapsed();
            }

            public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
                MaxAdapterError adapterError = new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, adDisplayError.toString());
                InneractiveMediationAdapter.this.log("AdView failed to show: " + adapterError);
                listener.onAdViewAdDisplayFailed(adapterError);
            }

            public void onAdResized(InneractiveAdSpot inneractiveAdSpot) {
            }

            public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
            }

            public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
            }
        });
        this.adViewGroup = new RelativeLayout(this.getContext(activity));
        this.adViewSpot = InneractiveAdSpotManager.get().createSpot();
        this.adViewSpot.addUnitController((InneractiveUnitController)controller);
        this.adViewSpot.setRequestListener(new InneractiveAdSpot.RequestListener(){

            public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {
                ViewGroup currentAdViewGroup = InneractiveMediationAdapter.this.adViewGroup;
                if (currentAdViewGroup == null) {
                    InneractiveMediationAdapter.this.log("AdView container destroyed before it could be loaded");
                    listener.onAdViewAdLoadFailed(MaxAdapterError.INVALID_LOAD_STATE);
                    return;
                }
                if (inneractiveAdSpot.isReady()) {
                    InneractiveMediationAdapter.this.log("AdView loaded");
                    controller.bindView(currentAdViewGroup);
                    listener.onAdViewAdLoaded((View)currentAdViewGroup);
                } else {
                    InneractiveMediationAdapter.this.log("AdView not ready");
                    listener.onAdViewAdLoadFailed(MaxAdapterError.AD_NOT_READY);
                }
            }

            public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
                InneractiveMediationAdapter.this.log("AdView failed to load with Inneractive error: " + inneractiveErrorCode + " " + inneractiveErrorCode.toString());
                listener.onAdViewAdLoadFailed(InneractiveMediationAdapter.toMaxError(inneractiveErrorCode));
            }
        });
        if (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse())) {
            this.adViewSpot.loadAd(parameters.getBidResponse());
        } else {
            InneractiveAdRequest request = new InneractiveAdRequest(parameters.getThirdPartyAdPlacementId());
            this.adViewSpot.requestAd(request);
        }
    }

    private void updateUserInfo(MaxAdapterParameters parameters) {
        Boolean hasUserConsent = parameters.hasUserConsent();
        if (hasUserConsent != null) {
            InneractiveAdManager.setGdprConsent((boolean)hasUserConsent);
        } else {
            InneractiveAdManager.clearGdprConsentData();
        }
        if (parameters.getConsentString() != null) {
            InneractiveAdManager.setGdprConsentString((String)parameters.getConsentString());
        }
        InneractiveMediationAdapter.updateMuteState(parameters.getServerParameters());
        Boolean isDoNotSell = parameters.isDoNotSell();
        if (isDoNotSell != null) {
            InneractiveAdManager.setUSPrivacyString((String)(isDoNotSell != false ? "1YY-" : "1YN-"));
        } else {
            InneractiveAdManager.setUSPrivacyString((String)"1---");
        }
    }

    private static void updateMuteState(Bundle serverParameters) {
        if (serverParameters.containsKey("is_muted")) {
            InneractiveAdManager.setMuteVideo((boolean)serverParameters.getBoolean("is_muted"));
        }
    }

    private static MaxAdapterError toMaxError(InneractiveErrorCode inneractiveErrorCode) {
        String adapterErrorStr;
        int adapterErrorCode;
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (inneractiveErrorCode) {
            case NO_FILL: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case SERVER_INTERNAL_ERROR: {
                adapterError = MaxAdapterError.SERVER_ERROR;
                break;
            }
            case SERVER_INVALID_RESPONSE: {
                adapterError = MaxAdapterError.BAD_REQUEST;
                break;
            }
            case SDK_INTERNAL_ERROR: 
            case ERROR_CODE_NATIVE_VIDEO_NOT_SUPPORTED: 
            case NATIVE_ADS_NOT_SUPPORTED_FOR_OS: 
            case UNSUPPORTED_SPOT: 
            case NON_SECURE_CONTENT_DETECTED: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case CANCELLED: {
                adapterError = MaxAdapterError.AD_NOT_READY;
                break;
            }
            case CONNECTION_TIMEOUT: 
            case LOAD_TIMEOUT: 
            case IN_FLIGHT_TIMEOUT: {
                adapterError = MaxAdapterError.TIMEOUT;
                break;
            }
            case CONNECTION_ERROR: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case UNKNOWN_APP_ID: 
            case INVALID_INPUT: 
            case SDK_NOT_INITIALIZED: 
            case SDK_NOT_INITIALIZED_OR_CONFIG_ERROR: {
                adapterError = MaxAdapterError.NOT_INITIALIZED;
                break;
            }
            case ERROR_CONFIGURATION_MISMATCH: 
            case ERROR_CONFIGURATION_NO_SUCH_SPOT: 
            case SPOT_DISABLED: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case UNSPECIFIED: {
                adapterError = MaxAdapterError.UNSPECIFIED;
            }
        }
        if (inneractiveErrorCode != null) {
            adapterErrorCode = inneractiveErrorCode.ordinal();
            adapterErrorStr = inneractiveErrorCode.name();
        } else {
            adapterErrorCode = 0;
            adapterErrorStr = "";
        }
        return new MaxAdapterError(adapterError, adapterErrorCode, adapterErrorStr);
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }
}

