/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxAppOpenAdapter;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxNativeAdAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxRewardedInterstitialAdapter;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAppOpenAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedInterstitialAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MediaContent;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.admanager.AdManagerAdView;
import com.google.android.gms.ads.admanager.AdManagerInterstitialAd;
import com.google.android.gms.ads.admanager.AdManagerInterstitialAdLoadCallback;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAd;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAdLoadCallback;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class GoogleAdManagerMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxAppOpenAdapter,
MaxRewardedInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter,
MaxNativeAdAdapter {
    private static final int TITLE_LABEL_TAG = 1;
    private static final int MEDIA_VIEW_CONTAINER_TAG = 2;
    private static final int ICON_VIEW_TAG = 3;
    private static final int BODY_VIEW_TAG = 4;
    private static final int CALL_TO_ACTION_VIEW_TAG = 5;
    private static final int ADVERTISER_VIEW_TAG = 8;
    private static final String ADAPTIVE_BANNER_TYPE_INLINE = "inline";
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private AdManagerInterstitialAd interstitialAd;
    private AppOpenAd appOpenAd;
    private RewardedInterstitialAd rewardedInterstitialAd;
    private RewardedAd rewardedAd;
    private AdManagerAdView adView;
    private NativeAd nativeAd;
    private NativeAdView nativeAdView;
    private AppOpenAdListener appOpenAdListener;
    private RewardedInterstitialAdListener rewardedInterstitialAdListener;
    private RewardedAdListener rewardedAdListener;

    public GoogleAdManagerMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    @SuppressLint(value={"MissingPermission"})
    public void initialize(MaxAdapterInitializationParameters parameters, @Nullable Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.log("Initializing Google Ad Manager SDK...");
        if (initialized.compareAndSet(false, true)) {
            MobileAds.initialize((Context)this.getContext(activity));
        }
        onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.DOES_NOT_APPLY, null);
    }

    public String getSdkVersion() {
        return String.valueOf(MobileAds.getVersion());
    }

    public String getAdapterVersion() {
        return "23.5.0.0";
    }

    public void onDestroy() {
        this.log("Destroy called for adapter " + (Object)((Object)this));
        if (this.interstitialAd != null) {
            this.interstitialAd.setFullScreenContentCallback(null);
            this.interstitialAd = null;
        }
        if (this.appOpenAd != null) {
            this.appOpenAd.setFullScreenContentCallback(null);
            this.appOpenAd = null;
            this.appOpenAdListener = null;
        }
        if (this.rewardedInterstitialAd != null) {
            this.rewardedInterstitialAd.setFullScreenContentCallback(null);
            this.rewardedInterstitialAd = null;
            this.rewardedInterstitialAdListener = null;
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.setFullScreenContentCallback(null);
            this.rewardedAd = null;
            this.rewardedAdListener = null;
        }
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
        if (this.nativeAd != null) {
            this.nativeAd.destroy();
            this.nativeAd = null;
        }
        if (this.nativeAdView != null) {
            this.nativeAdView.destroy();
            this.nativeAdView = null;
        }
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, final MaxInterstitialAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading interstitial ad: " + placementId + "...");
        GoogleAdManagerMediationAdapter.updateMuteState(parameters);
        Context context = this.getContext(activity);
        AdManagerAdRequest adRequest = this.createAdRequestWithParameters((MaxAdapterParameters)parameters, context);
        AdManagerInterstitialAd.load((Context)context, (String)placementId, (AdManagerAdRequest)adRequest, (AdManagerInterstitialAdLoadCallback)new AdManagerInterstitialAdLoadCallback(){

            public void onAdLoaded(@NonNull AdManagerInterstitialAd ad) {
                String responseId;
                GoogleAdManagerMediationAdapter.this.log("Interstitial ad loaded: " + placementId + "...");
                GoogleAdManagerMediationAdapter.this.interstitialAd = ad;
                GoogleAdManagerMediationAdapter.this.interstitialAd.setFullScreenContentCallback((FullScreenContentCallback)new InterstitialAdListener(placementId, listener));
                ResponseInfo responseInfo = GoogleAdManagerMediationAdapter.this.interstitialAd.getResponseInfo();
                String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                if (AppLovinSdkUtils.isValidString((String)responseId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    listener.onInterstitialAdLoaded(extraInfo);
                } else {
                    listener.onInterstitialAdLoaded();
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                MaxAdapterError adapterError = GoogleAdManagerMediationAdapter.toMaxError((AdError)loadAdError);
                GoogleAdManagerMediationAdapter.this.log("Interstitial ad (" + placementId + ") failed to load with error: " + adapterError);
                listener.onInterstitialAdLoadFailed(adapterError);
            }
        });
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing interstitial ad: " + placementId + "...");
        if (this.interstitialAd != null) {
            this.interstitialAd.show(activity);
        } else {
            this.log("Interstitial ad failed to show: " + placementId);
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
        }
    }

    public void loadAppOpenAd(@NonNull MaxAdapterResponseParameters parameters, @Nullable Activity activity, final @NonNull MaxAppOpenAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading app open ad: " + placementId + "...");
        GoogleAdManagerMediationAdapter.updateMuteState(parameters);
        Context context = this.getContext(activity);
        AdManagerAdRequest adRequest = this.createAdRequestWithParameters((MaxAdapterParameters)parameters, context);
        int orientation = AppLovinSdkUtils.getOrientation((Context)context);
        AppOpenAd.load((Context)context, (String)placementId, (AdManagerAdRequest)adRequest, (int)orientation, (AppOpenAd.AppOpenAdLoadCallback)new AppOpenAd.AppOpenAdLoadCallback(){

            public void onAdLoaded(@NonNull AppOpenAd ad) {
                String responseId;
                GoogleAdManagerMediationAdapter.this.log("App open ad loaded: " + placementId + "...");
                GoogleAdManagerMediationAdapter.this.appOpenAd = ad;
                GoogleAdManagerMediationAdapter.this.appOpenAdListener = new AppOpenAdListener(placementId, listener);
                ad.setFullScreenContentCallback((FullScreenContentCallback)GoogleAdManagerMediationAdapter.this.appOpenAdListener);
                ResponseInfo responseInfo = GoogleAdManagerMediationAdapter.this.appOpenAd.getResponseInfo();
                String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                if (AppLovinSdkUtils.isValidString((String)responseId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    listener.onAppOpenAdLoaded(extraInfo);
                } else {
                    listener.onAppOpenAdLoaded();
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                MaxAdapterError adapterError = GoogleAdManagerMediationAdapter.toMaxError((AdError)loadAdError);
                GoogleAdManagerMediationAdapter.this.log("App open ad (" + placementId + ") failed to load with error: " + adapterError);
                listener.onAppOpenAdLoadFailed(adapterError);
            }
        });
    }

    public void showAppOpenAd(@NonNull MaxAdapterResponseParameters parameters, @Nullable Activity activity, @NonNull MaxAppOpenAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing app open ad: " + placementId + "...");
        if (this.appOpenAd != null) {
            this.appOpenAd.show(activity);
        } else {
            this.log("App open ad failed to show: " + placementId);
            listener.onAppOpenAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "App open ad not ready"));
        }
    }

    public void loadRewardedInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, final MaxRewardedInterstitialAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading rewarded interstitial ad: " + placementId + "...");
        GoogleAdManagerMediationAdapter.updateMuteState(parameters);
        Context context = this.getContext(activity);
        AdManagerAdRequest adRequest = this.createAdRequestWithParameters((MaxAdapterParameters)parameters, context);
        RewardedInterstitialAd.load((Context)context, (String)placementId, (AdRequest)adRequest, (RewardedInterstitialAdLoadCallback)new RewardedInterstitialAdLoadCallback(){

            public void onAdLoaded(@NonNull RewardedInterstitialAd ad) {
                String responseId;
                GoogleAdManagerMediationAdapter.this.log("Rewarded interstitial ad loaded: " + placementId);
                GoogleAdManagerMediationAdapter.this.rewardedInterstitialAd = ad;
                GoogleAdManagerMediationAdapter.this.rewardedInterstitialAdListener = new RewardedInterstitialAdListener(placementId, listener);
                GoogleAdManagerMediationAdapter.this.rewardedInterstitialAd.setFullScreenContentCallback((FullScreenContentCallback)GoogleAdManagerMediationAdapter.this.rewardedInterstitialAdListener);
                ResponseInfo responseInfo = GoogleAdManagerMediationAdapter.this.rewardedInterstitialAd.getResponseInfo();
                String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                if (AppLovinSdkUtils.isValidString((String)responseId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    listener.onRewardedInterstitialAdLoaded(extraInfo);
                } else {
                    listener.onRewardedInterstitialAdLoaded();
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                MaxAdapterError adapterError = GoogleAdManagerMediationAdapter.toMaxError((AdError)loadAdError);
                GoogleAdManagerMediationAdapter.this.log("Rewarded interstitial ad (" + placementId + ") failed to load with error: " + adapterError);
                listener.onRewardedInterstitialAdLoadFailed(adapterError);
            }
        });
    }

    public void showRewardedInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded interstitial ad: " + placementId + "...");
        if (this.rewardedInterstitialAd != null) {
            this.configureReward(parameters);
            this.rewardedInterstitialAd.show(activity, rewardItem -> {
                this.log("Rewarded interstitial ad user earned reward: " + placementId);
                this.rewardedInterstitialAdListener.hasGrantedReward = true;
            });
        } else {
            this.log("Rewarded interstitial ad failed to show: " + placementId);
            listener.onRewardedInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded Interstitial ad not ready"));
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, final MaxRewardedAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading rewarded ad: " + placementId + "...");
        GoogleAdManagerMediationAdapter.updateMuteState(parameters);
        Context context = this.getContext(activity);
        AdManagerAdRequest adRequest = this.createAdRequestWithParameters((MaxAdapterParameters)parameters, context);
        RewardedAd.load((Context)context, (String)placementId, (AdManagerAdRequest)adRequest, (RewardedAdLoadCallback)new RewardedAdLoadCallback(){

            public void onAdLoaded(@NonNull RewardedAd ad) {
                String responseId;
                GoogleAdManagerMediationAdapter.this.log("Rewarded ad loaded: " + placementId + "...");
                GoogleAdManagerMediationAdapter.this.rewardedAd = ad;
                GoogleAdManagerMediationAdapter.this.rewardedAdListener = new RewardedAdListener(placementId, listener);
                GoogleAdManagerMediationAdapter.this.rewardedAd.setFullScreenContentCallback((FullScreenContentCallback)GoogleAdManagerMediationAdapter.this.rewardedAdListener);
                ResponseInfo responseInfo = GoogleAdManagerMediationAdapter.this.rewardedAd.getResponseInfo();
                String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                if (AppLovinSdkUtils.isValidString((String)responseId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    listener.onRewardedAdLoaded(extraInfo);
                } else {
                    listener.onRewardedAdLoaded();
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                MaxAdapterError adapterError = GoogleAdManagerMediationAdapter.toMaxError((AdError)loadAdError);
                GoogleAdManagerMediationAdapter.this.log("Rewarded ad (" + placementId + ") failed to load with error: " + adapterError);
                listener.onRewardedAdLoadFailed(adapterError);
            }
        });
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded ad: " + placementId + "...");
        if (this.rewardedAd != null) {
            this.configureReward(parameters);
            this.rewardedAd.show(activity, rewardItem -> {
                this.log("Rewarded ad user earned reward: " + placementId);
                this.rewardedAdListener.hasGrantedReward = true;
            });
        } else {
            this.log("Rewarded ad failed to show: " + placementId);
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, @Nullable Activity activity, MaxAdViewAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        this.log("Loading " + (isNative ? "native " : "") + adFormat.getLabel() + " ad for placement id: " + placementId + "...");
        Context context = this.getContext(activity);
        AdManagerAdRequest adRequest = this.createAdRequestWithParameters((MaxAdapterParameters)parameters, context);
        if (isNative) {
            NativeAdOptions.Builder optionsBuilder = new NativeAdOptions.Builder();
            optionsBuilder.setAdChoicesPlacement(this.getAdChoicesPlacement(parameters));
            optionsBuilder.setRequestMultipleImages(adFormat == MaxAdFormat.MREC);
            NativeAdViewListener nativeAdViewListener = new NativeAdViewListener(parameters, adFormat, activity, listener);
            AdLoader adLoader = new AdLoader.Builder(context, placementId).withNativeAdOptions(optionsBuilder.build()).forNativeAd((NativeAd.OnNativeAdLoadedListener)nativeAdViewListener).withAdListener((AdListener)nativeAdViewListener).build();
            adLoader.loadAd(adRequest);
        } else {
            this.adView = new AdManagerAdView(context);
            this.adView.setAdUnitId(placementId);
            this.adView.setAdListener((AdListener)new AdViewListener(placementId, adFormat, listener));
            boolean isAdaptiveBanner = parameters.getServerParameters().getBoolean("adaptive_banner", false);
            this.adView.setAdSize(this.toAdSize(adFormat, isAdaptiveBanner, (MaxAdapterParameters)parameters, context));
            this.adView.loadAd(adRequest);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void loadNativeAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxNativeAdAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading native ad for placement id: " + placementId + "...");
        Context context = this.getContext(activity);
        AdManagerAdRequest adRequest = this.createAdRequestWithParameters((MaxAdapterParameters)parameters, context);
        NativeAdOptions.Builder nativeAdOptionsBuilder = new NativeAdOptions.Builder();
        nativeAdOptionsBuilder.setAdChoicesPlacement(this.getAdChoicesPlacement(parameters));
        String template = BundleUtils.getString((String)"template", (String)"", (Bundle)parameters.getServerParameters());
        nativeAdOptionsBuilder.setRequestMultipleImages(template.contains("medium"));
        NativeAdListener nativeAdListener = new NativeAdListener(parameters, context, listener);
        AdLoader adLoader = new AdLoader.Builder(context, placementId).withNativeAdOptions(nativeAdOptionsBuilder.build()).forNativeAd((NativeAd.OnNativeAdLoadedListener)nativeAdListener).withAdListener((AdListener)nativeAdListener).build();
        adLoader.loadAd((AdRequest)adRequest);
    }

    private static MaxAdapterError toMaxError(AdError googleAdManagerError) {
        int googleAdManagerErrorCode = googleAdManagerError.getCode();
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (googleAdManagerErrorCode) {
            case 3: 
            case 9: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case 2: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case 0: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case 1: 
            case 10: {
                adapterError = MaxAdapterError.BAD_REQUEST;
                break;
            }
            case 8: 
            case 11: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), googleAdManagerErrorCode, googleAdManagerError.getMessage());
    }

    private AdSize toAdSize(MaxAdFormat adFormat, boolean isAdaptiveBanner, MaxAdapterParameters parameters, Context context) {
        if (adFormat == MaxAdFormat.BANNER || adFormat == MaxAdFormat.LEADER) {
            if (isAdaptiveBanner) {
                return this.getAdaptiveAdSize(parameters, context);
            }
            return adFormat == MaxAdFormat.BANNER ? AdSize.BANNER : AdSize.LEADERBOARD;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return AdSize.MEDIUM_RECTANGLE;
        }
        throw new IllegalArgumentException("Unsupported ad format: " + adFormat);
    }

    private AdSize getAdaptiveAdSize(MaxAdapterParameters parameters, Context context) {
        int bannerWidth = this.getAdaptiveBannerWidth(parameters, context);
        if (this.isInlineAdaptiveBanner(parameters)) {
            int inlineMaxHeight = this.getInlineAdaptiveBannerMaxHeight(parameters);
            if (inlineMaxHeight > 0) {
                return AdSize.getInlineAdaptiveBannerAdSize((int)bannerWidth, (int)inlineMaxHeight);
            }
            return AdSize.getCurrentOrientationInlineAdaptiveBannerAdSize((Context)context, (int)bannerWidth);
        }
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)context, (int)bannerWidth);
    }

    private boolean isInlineAdaptiveBanner(MaxAdapterParameters parameters) {
        Map localExtraParameters = parameters.getLocalExtraParameters();
        Object adaptiveBannerType = localExtraParameters.get("adaptive_banner_type");
        return adaptiveBannerType instanceof String && ADAPTIVE_BANNER_TYPE_INLINE.equalsIgnoreCase((String)adaptiveBannerType);
    }

    private int getInlineAdaptiveBannerMaxHeight(MaxAdapterParameters parameters) {
        Map localExtraParameters = parameters.getLocalExtraParameters();
        Object inlineMaxHeight = localExtraParameters.get("inline_adaptive_banner_max_height");
        return inlineMaxHeight instanceof Integer ? (Integer)inlineMaxHeight : 0;
    }

    private int getAdaptiveBannerWidth(MaxAdapterParameters parameters, Context context) {
        Map localExtraParameters = parameters.getLocalExtraParameters();
        Object widthObj = localExtraParameters.get("adaptive_banner_width");
        if (widthObj instanceof Integer) {
            return (Integer)widthObj;
        }
        if (widthObj != null) {
            this.e("Expected parameter \"adaptive_banner_width\" to be of type Integer, received: " + widthObj.getClass());
        }
        int deviceWidthPx = GoogleAdManagerMediationAdapter.getApplicationWindowWidth(context);
        return AppLovinSdkUtils.pxToDp((Context)context, (int)deviceWidthPx);
    }

    public static int getApplicationWindowWidth(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        return outMetrics.widthPixels;
    }

    private AdManagerAdRequest createAdRequestWithParameters(MaxAdapterParameters parameters, Context context) {
        Object customTargetingDataObject;
        Object publisherProvidedId;
        Object neighbouringContentUrlStringsObject;
        Object contentUrlString;
        Boolean isDoNotSell;
        Boolean hasUserConsent;
        AdManagerAdRequest.Builder requestBuilder = new AdManagerAdRequest.Builder();
        Bundle serverParameters = parameters.getServerParameters();
        if (serverParameters.getBoolean("set_mediation_identifier", true)) {
            requestBuilder.setRequestAgent(GoogleAdManagerMediationAdapter.mediationTag());
        }
        Bundle networkExtras = new Bundle();
        String eventId = BundleUtils.getString((String)"event_id", (Bundle)serverParameters);
        if (AppLovinSdkUtils.isValidString((String)eventId)) {
            networkExtras.putString("placement_req_id", eventId);
        }
        if ((hasUserConsent = parameters.hasUserConsent()) != null && !hasUserConsent.booleanValue()) {
            networkExtras.putString("npa", "1");
        }
        if ((isDoNotSell = parameters.isDoNotSell()) != null && isDoNotSell.booleanValue()) {
            networkExtras.putInt("rdp", 1);
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putInt("gad_rdp", 1).apply();
        } else {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().remove("gad_rdp").apply();
        }
        Map localExtraParameters = parameters.getLocalExtraParameters();
        Object maxContentRating = localExtraParameters.get("google_max_ad_content_rating");
        if (maxContentRating instanceof String) {
            networkExtras.putString("max_ad_content_rating", (String)maxContentRating);
        }
        if ((contentUrlString = localExtraParameters.get("google_content_url")) instanceof String) {
            requestBuilder.setContentUrl((String)contentUrlString);
        }
        if ((neighbouringContentUrlStringsObject = localExtraParameters.get("google_neighbouring_content_url_strings")) instanceof List) {
            try {
                requestBuilder.setNeighboringContentUrls((List)neighbouringContentUrlStringsObject);
            }
            catch (Throwable th) {
                this.e("Neighbouring content URL strings extra param needs to be of type List<String>.", th);
            }
        }
        if ((publisherProvidedId = localExtraParameters.get("ppid")) instanceof String) {
            requestBuilder.setPublisherProvidedId((String)publisherProvidedId);
        }
        if ((customTargetingDataObject = localExtraParameters.get("custom_targeting")) instanceof Map) {
            try {
                Map customTargetingDataMap = (Map)customTargetingDataObject;
                for (String key : customTargetingDataMap.keySet()) {
                    Object value = customTargetingDataMap.get(key);
                    if (value instanceof String) {
                        requestBuilder.addCustomTargeting(key, (String)value);
                        continue;
                    }
                    if (value instanceof List) {
                        requestBuilder.addCustomTargeting(key, (List)value);
                        continue;
                    }
                    this.e("Object in the map needs to be either of type String or List<String>.");
                }
            }
            catch (Throwable th) {
                this.e("Custom targeting extra param value needs to be of type Map<String, Object>.", th);
            }
        }
        requestBuilder.addNetworkExtrasBundle(AdMobAdapter.class, networkExtras);
        return requestBuilder.build();
    }

    private static void updateMuteState(MaxAdapterResponseParameters parameters) {
        Bundle serverParameters = parameters.getServerParameters();
        if (serverParameters.containsKey("is_muted")) {
            MobileAds.setAppMuted((boolean)serverParameters.getBoolean("is_muted"));
        }
    }

    private int getAdChoicesPlacement(MaxAdapterResponseParameters parameters) {
        Map localExtraParams = parameters.getLocalExtraParameters();
        Object adChoicesPlacementObj = localExtraParams != null ? localExtraParams.get("gam_ad_choices_placement") : null;
        return this.isValidAdChoicesPlacement(adChoicesPlacementObj) ? (Integer)adChoicesPlacementObj : 1;
    }

    private boolean isValidAdChoicesPlacement(Object placementObj) {
        return placementObj instanceof Integer && ((Integer)placementObj == 0 || (Integer)placementObj == 1 || (Integer)placementObj == 3 || (Integer)placementObj == 2);
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private class RewardedAdListener
    extends FullScreenContentCallback {
        private final String placementId;
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedAdListener(String placementId, MaxRewardedAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdShowedFullScreenContent() {
            GoogleAdManagerMediationAdapter.this.log("Rewarded ad shown: " + this.placementId);
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", adError.getCode(), adError.getMessage());
            GoogleAdManagerMediationAdapter.this.log("Rewarded ad (" + this.placementId + ") failed to show with error: " + adapterError);
            this.listener.onRewardedAdDisplayFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleAdManagerMediationAdapter.this.log("Rewarded ad impression recorded: " + this.placementId);
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdClicked() {
            GoogleAdManagerMediationAdapter.this.log("Rewarded ad clicked: " + this.placementId);
            this.listener.onRewardedAdClicked();
        }

        public void onAdDismissedFullScreenContent() {
            if (this.hasGrantedReward || GoogleAdManagerMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = GoogleAdManagerMediationAdapter.this.getReward();
                GoogleAdManagerMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            GoogleAdManagerMediationAdapter.this.log("Rewarded ad hidden: " + this.placementId);
            this.listener.onRewardedAdHidden();
        }
    }

    private class RewardedInterstitialAdListener
    extends FullScreenContentCallback {
        private final String placementId;
        private final MaxRewardedInterstitialAdapterListener listener;
        private boolean hasGrantedReward;

        private RewardedInterstitialAdListener(String placementId, MaxRewardedInterstitialAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdShowedFullScreenContent() {
            GoogleAdManagerMediationAdapter.this.log("Rewarded interstitial ad shown: " + this.placementId);
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", adError.getCode(), adError.getMessage());
            GoogleAdManagerMediationAdapter.this.log("Rewarded interstitial ad (" + this.placementId + ") failed to show with error: " + adapterError);
            this.listener.onRewardedInterstitialAdDisplayFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleAdManagerMediationAdapter.this.log("Rewarded interstitial ad impression recorded: " + this.placementId);
            this.listener.onRewardedInterstitialAdDisplayed();
        }

        public void onAdClicked() {
            GoogleAdManagerMediationAdapter.this.log("Rewarded interstitial ad clicked" + this.placementId);
            this.listener.onRewardedInterstitialAdClicked();
        }

        public void onAdDismissedFullScreenContent() {
            if (this.hasGrantedReward || GoogleAdManagerMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = GoogleAdManagerMediationAdapter.this.getReward();
                GoogleAdManagerMediationAdapter.this.log("Rewarded interstitial ad rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            GoogleAdManagerMediationAdapter.this.log("Rewarded interstitial ad hidden: " + this.placementId);
            this.listener.onRewardedInterstitialAdHidden();
        }
    }

    private class AppOpenAdListener
    extends FullScreenContentCallback {
        private final String placementId;
        private final MaxAppOpenAdapterListener listener;

        AppOpenAdListener(String placementId, MaxAppOpenAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdShowedFullScreenContent() {
            GoogleAdManagerMediationAdapter.this.log("App open ad shown: " + this.placementId);
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad display failed", adError.getCode(), adError.getMessage());
            GoogleAdManagerMediationAdapter.this.log("App open ad (" + this.placementId + ") failed to show with error: " + adapterError);
            this.listener.onAppOpenAdDisplayFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleAdManagerMediationAdapter.this.log("App open ad impression recorded: " + this.placementId);
            this.listener.onAppOpenAdDisplayed();
        }

        public void onAdClicked() {
            GoogleAdManagerMediationAdapter.this.log("App open ad clicked: " + this.placementId);
            this.listener.onAppOpenAdClicked();
        }

        public void onAdDismissedFullScreenContent() {
            GoogleAdManagerMediationAdapter.this.log("App open ad hidden: " + this.placementId);
            this.listener.onAppOpenAdHidden();
        }
    }

    private class NativeAdViewListener
    extends AdListener
    implements NativeAd.OnNativeAdLoadedListener {
        final String placementId;
        final MaxAdFormat adFormat;
        final Bundle serverParameters;
        final WeakReference<Activity> activityRef;
        final MaxAdViewAdapterListener listener;

        NativeAdViewListener(MaxAdapterResponseParameters parameters, @Nullable MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
            this.placementId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.activityRef = new WeakReference<Activity>(activity);
            this.adFormat = adFormat;
            this.listener = listener;
        }

        public void onNativeAdLoaded(final @NonNull NativeAd nativeAd) {
            GoogleAdManagerMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded: " + this.placementId);
            if (TextUtils.isEmpty((CharSequence)nativeAd.getHeadline())) {
                GoogleAdManagerMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load: Google native ad is missing one or more required assets");
                this.listener.onAdViewAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                nativeAd.destroy();
                return;
            }
            GoogleAdManagerMediationAdapter.this.nativeAd = nativeAd;
            Activity activity = (Activity)this.activityRef.get();
            final Context context = GoogleAdManagerMediationAdapter.this.getContext(activity);
            final MediaView mediaView = new MediaView(context);
            MediaContent mediaContent = nativeAd.getMediaContent();
            if (mediaContent != null) {
                mediaView.setMediaContent(mediaContent);
            }
            NativeAd.Image icon = nativeAd.getIcon();
            MaxNativeAd.MaxNativeAdImage maxNativeAdImage = null;
            if (icon != null) {
                maxNativeAdImage = icon.getDrawable() != null ? new MaxNativeAd.MaxNativeAdImage(icon.getDrawable()) : new MaxNativeAd.MaxNativeAdImage(icon.getUri());
            }
            final MaxNativeAd maxNativeAd = new MaxNativeAd.Builder().setAdFormat(this.adFormat).setTitle(nativeAd.getHeadline()).setBody(nativeAd.getBody()).setCallToAction(nativeAd.getCallToAction()).setIcon(maxNativeAdImage).setMediaView((View)mediaView).build();
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    String responseId;
                    String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)NativeAdViewListener.this.serverParameters);
                    MaxNativeAdView maxNativeAdView = new MaxNativeAdView(maxNativeAd, templateName, context);
                    GoogleAdManagerMediationAdapter.this.nativeAdView = new NativeAdView(context);
                    GoogleAdManagerMediationAdapter.this.nativeAdView.setIconView((View)maxNativeAdView.getIconImageView());
                    GoogleAdManagerMediationAdapter.this.nativeAdView.setHeadlineView((View)maxNativeAdView.getTitleTextView());
                    GoogleAdManagerMediationAdapter.this.nativeAdView.setBodyView((View)maxNativeAdView.getBodyTextView());
                    GoogleAdManagerMediationAdapter.this.nativeAdView.setMediaView(mediaView);
                    GoogleAdManagerMediationAdapter.this.nativeAdView.setCallToActionView((View)maxNativeAdView.getCallToActionButton());
                    GoogleAdManagerMediationAdapter.this.nativeAdView.setNativeAd(nativeAd);
                    GoogleAdManagerMediationAdapter.this.nativeAdView.addView((View)maxNativeAdView);
                    ResponseInfo responseInfo = nativeAd.getResponseInfo();
                    String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                    if (AppLovinSdkUtils.isValidString((String)responseId)) {
                        Bundle extraInfo = new Bundle(1);
                        extraInfo.putString("creative_id", responseId);
                        NativeAdViewListener.this.listener.onAdViewAdLoaded((View)GoogleAdManagerMediationAdapter.this.nativeAdView, extraInfo);
                    } else {
                        NativeAdViewListener.this.listener.onAdViewAdLoaded((View)GoogleAdManagerMediationAdapter.this.nativeAdView);
                    }
                }
            });
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            MaxAdapterError adapterError = GoogleAdManagerMediationAdapter.toMaxError((AdError)loadAdError);
            GoogleAdManagerMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad (" + this.placementId + ") failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleAdManagerMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad shown");
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked() {
            GoogleAdManagerMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad clicked");
            this.listener.onAdViewAdClicked();
        }

        public void onAdOpened() {
            GoogleAdManagerMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad opened");
            this.listener.onAdViewAdExpanded();
        }

        public void onAdClosed() {
            GoogleAdManagerMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad closed");
            this.listener.onAdViewAdCollapsed();
        }
    }

    private class AdViewListener
    extends AdListener {
        final String placementId;
        final MaxAdFormat adFormat;
        final MaxAdViewAdapterListener listener;

        AdViewListener(String placementId, MaxAdFormat adFormat, MaxAdViewAdapterListener listener) {
            this.placementId = placementId;
            this.adFormat = adFormat;
            this.listener = listener;
        }

        public void onAdLoaded() {
            AdSize adSize;
            String responseId;
            GoogleAdManagerMediationAdapter.this.log(this.adFormat.getLabel() + " ad loaded: " + this.placementId);
            Bundle extraInfo = new Bundle(3);
            ResponseInfo responseInfo = GoogleAdManagerMediationAdapter.this.adView.getResponseInfo();
            String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
            if (AppLovinSdkUtils.isValidString((String)responseId)) {
                extraInfo.putString("creative_id", responseId);
            }
            if ((adSize = GoogleAdManagerMediationAdapter.this.adView.getAdSize()) != null) {
                extraInfo.putInt("ad_width", adSize.getWidth());
                extraInfo.putInt("ad_height", adSize.getHeight());
            }
            this.listener.onAdViewAdLoaded((View)GoogleAdManagerMediationAdapter.this.adView, extraInfo);
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            MaxAdapterError adapterError = GoogleAdManagerMediationAdapter.toMaxError((AdError)loadAdError);
            GoogleAdManagerMediationAdapter.this.log(this.adFormat.getLabel() + " ad (" + this.placementId + ") failed to load with error code: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleAdManagerMediationAdapter.this.log(this.adFormat.getLabel() + " ad shown: " + this.placementId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdOpened() {
            GoogleAdManagerMediationAdapter.this.log(this.adFormat.getLabel() + " ad opened");
            this.listener.onAdViewAdClicked();
        }

        public void onAdClosed() {
            GoogleAdManagerMediationAdapter.this.log(this.adFormat.getLabel() + " ad closed");
        }
    }

    private class NativeAdListener
    extends AdListener
    implements NativeAd.OnNativeAdLoadedListener {
        final String placementId;
        final Bundle serverParameters;
        final Context context;
        final MaxNativeAdAdapterListener listener;

        public NativeAdListener(MaxAdapterResponseParameters parameters, Context context, MaxNativeAdAdapterListener listener) {
            this.placementId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.context = context;
            this.listener = listener;
        }

        public void onNativeAdLoaded(final @NonNull NativeAd nativeAd) {
            GoogleAdManagerMediationAdapter.this.log("Native ad loaded: " + this.placementId);
            GoogleAdManagerMediationAdapter.this.nativeAd = nativeAd;
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)nativeAd.getHeadline())) {
                GoogleAdManagerMediationAdapter.this.e("Native ad (" + nativeAd + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                return;
            }
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MediaView mediaView = null;
                    MediaContent mediaContent = nativeAd.getMediaContent();
                    List images = nativeAd.getImages();
                    Drawable mainImage = null;
                    float mediaContentAspectRatio = 0.0f;
                    if (mediaContent != null) {
                        MediaView googleMediaView = new MediaView(NativeAdListener.this.context);
                        googleMediaView.setMediaContent(mediaContent);
                        mediaView = googleMediaView;
                        mainImage = mediaContent.getMainImage();
                        mediaContentAspectRatio = mediaContent.getAspectRatio();
                    } else if (images != null && images.size() > 0) {
                        NativeAd.Image mediaImage = (NativeAd.Image)images.get(0);
                        ImageView mediaImageView = new ImageView(NativeAdListener.this.context);
                        Drawable mediaImageDrawable = mediaImage.getDrawable();
                        if (mediaImageDrawable != null) {
                            mediaImageView.setImageDrawable(mediaImage.getDrawable());
                            mediaView = mediaImageView;
                            mediaContentAspectRatio = (float)mediaImageDrawable.getIntrinsicWidth() / (float)mediaImageDrawable.getIntrinsicHeight();
                        }
                    }
                    NativeAd.Image icon = nativeAd.getIcon();
                    MaxNativeAd.MaxNativeAdImage iconImage = null;
                    if (icon != null) {
                        iconImage = icon.getDrawable() != null ? new MaxNativeAd.MaxNativeAdImage(icon.getDrawable()) : new MaxNativeAd.MaxNativeAdImage(icon.getUri());
                    }
                    MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(nativeAd.getHeadline()).setAdvertiser(nativeAd.getAdvertiser()).setBody(nativeAd.getBody()).setCallToAction(nativeAd.getCallToAction()).setIcon(iconImage).setMediaView((View)mediaView);
                    if (AppLovinSdk.VERSION_CODE >= 11040399) {
                        builder.setMainImage(new MaxNativeAd.MaxNativeAdImage(mainImage));
                    }
                    if (AppLovinSdk.VERSION_CODE >= 11040000) {
                        builder.setMediaContentAspectRatio(mediaContentAspectRatio);
                    }
                    if (AppLovinSdk.VERSION_CODE >= 11070000) {
                        builder.setStarRating(nativeAd.getStarRating());
                    }
                    MaxGoogleAdManagerNativeAd maxNativeAd = new MaxGoogleAdManagerNativeAd(builder);
                    ResponseInfo responseInfo = nativeAd.getResponseInfo();
                    String responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    NativeAdListener.this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, extraInfo);
                }
            });
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            MaxAdapterError adapterError = GoogleAdManagerMediationAdapter.toMaxError((AdError)loadAdError);
            GoogleAdManagerMediationAdapter.this.log("Native ad (" + this.placementId + ") failed to load with error: " + adapterError);
            this.listener.onNativeAdLoadFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleAdManagerMediationAdapter.this.log("Native ad shown");
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdClicked() {
            GoogleAdManagerMediationAdapter.this.log("Native ad clicked");
            this.listener.onNativeAdClicked();
        }

        public void onAdOpened() {
            GoogleAdManagerMediationAdapter.this.log("Native ad opened");
        }

        public void onAdClosed() {
            GoogleAdManagerMediationAdapter.this.log("Native ad closed");
        }
    }

    private static class AutoMeasuringMediaView
    extends MediaView {
        AutoMeasuringMediaView(Context context) {
            super(context);
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.requestLayout();
        }

        public void requestLayout() {
            super.requestLayout();
            this.post(() -> {
                this.measure(View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getHeight(), (int)0x40000000));
                this.layout(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
            });
        }
    }

    private class MaxGoogleAdManagerNativeAd
    extends MaxNativeAd {
        public MaxGoogleAdManagerNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            NativeAd nativeAd = GoogleAdManagerMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                GoogleAdManagerMediationAdapter.this.e("Failed to register native ad views: native ad is null.");
                return false;
            }
            GoogleAdManagerMediationAdapter.this.nativeAdView = new NativeAdView(container.getContext());
            if (container instanceof MaxNativeAdView) {
                MaxNativeAdView maxNativeAdView = (MaxNativeAdView)container;
                View mainView = maxNativeAdView.getMainView();
                maxNativeAdView.removeView(mainView);
                GoogleAdManagerMediationAdapter.this.nativeAdView.addView(mainView);
                maxNativeAdView.addView((View)GoogleAdManagerMediationAdapter.this.nativeAdView);
                GoogleAdManagerMediationAdapter.this.nativeAdView.setIconView((View)maxNativeAdView.getIconImageView());
                GoogleAdManagerMediationAdapter.this.nativeAdView.setHeadlineView((View)maxNativeAdView.getTitleTextView());
                GoogleAdManagerMediationAdapter.this.nativeAdView.setAdvertiserView((View)maxNativeAdView.getAdvertiserTextView());
                GoogleAdManagerMediationAdapter.this.nativeAdView.setBodyView((View)maxNativeAdView.getBodyTextView());
                GoogleAdManagerMediationAdapter.this.nativeAdView.setCallToActionView((View)maxNativeAdView.getCallToActionButton());
                View mediaView = this.getMediaView();
                if (mediaView instanceof MediaView) {
                    GoogleAdManagerMediationAdapter.this.nativeAdView.setMediaView((MediaView)mediaView);
                } else if (mediaView instanceof ImageView) {
                    GoogleAdManagerMediationAdapter.this.nativeAdView.setImageView(mediaView);
                }
                GoogleAdManagerMediationAdapter.this.nativeAdView.setNativeAd(nativeAd);
            } else {
                MediaView googleMediaView;
                MediaContent googleMediaContent;
                boolean hasPluginLayout;
                for (View view : clickableViews) {
                    Object viewTag = view.getTag();
                    if (viewTag == null) continue;
                    int tag = (Integer)viewTag;
                    if (tag == 1) {
                        GoogleAdManagerMediationAdapter.this.nativeAdView.setHeadlineView(view);
                        continue;
                    }
                    if (tag == 3) {
                        GoogleAdManagerMediationAdapter.this.nativeAdView.setIconView(view);
                        continue;
                    }
                    if (tag == 4) {
                        GoogleAdManagerMediationAdapter.this.nativeAdView.setBodyView(view);
                        continue;
                    }
                    if (tag == 5) {
                        GoogleAdManagerMediationAdapter.this.nativeAdView.setCallToActionView(view);
                        continue;
                    }
                    if (tag != 8) continue;
                    GoogleAdManagerMediationAdapter.this.nativeAdView.setAdvertiserView(view);
                }
                Object mediaView = this.getMediaView();
                if (mediaView == null) {
                    return true;
                }
                ViewGroup pluginContainer = (ViewGroup)mediaView.getParent();
                if (pluginContainer == null) {
                    return true;
                }
                pluginContainer.removeView(mediaView);
                boolean bl = hasPluginLayout = pluginContainer instanceof RelativeLayout || pluginContainer instanceof FrameLayout;
                if (!hasPluginLayout && mediaView instanceof MediaView && (googleMediaContent = (googleMediaView = (MediaView)mediaView).getMediaContent()) != null && googleMediaContent.hasVideoContent()) {
                    mediaView = new AutoMeasuringMediaView(container.getContext());
                    googleMediaView.setMediaContent(nativeAd.getMediaContent());
                }
                ViewGroup.LayoutParams mediaViewLayout = new ViewGroup.LayoutParams(-1, -1);
                GoogleAdManagerMediationAdapter.this.nativeAdView.addView(mediaView, mediaViewLayout);
                if (mediaView instanceof MediaView) {
                    GoogleAdManagerMediationAdapter.this.nativeAdView.setMediaView((MediaView)mediaView);
                } else if (mediaView instanceof ImageView) {
                    GoogleAdManagerMediationAdapter.this.nativeAdView.setImageView((View)((ImageView)mediaView));
                }
                GoogleAdManagerMediationAdapter.this.nativeAdView.setNativeAd(nativeAd);
                ViewGroup.LayoutParams nativeAdViewLayout = new ViewGroup.LayoutParams(-1, -1);
                if (hasPluginLayout) {
                    pluginContainer.addView((View)GoogleAdManagerMediationAdapter.this.nativeAdView, nativeAdViewLayout);
                } else {
                    GoogleAdManagerMediationAdapter.this.nativeAdView.measure(View.MeasureSpec.makeMeasureSpec((int)pluginContainer.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)pluginContainer.getHeight(), (int)0x40000000));
                    GoogleAdManagerMediationAdapter.this.nativeAdView.layout(0, 0, pluginContainer.getWidth(), pluginContainer.getHeight());
                    pluginContainer.addView((View)GoogleAdManagerMediationAdapter.this.nativeAdView);
                }
            }
            return true;
        }
    }

    private class InterstitialAdListener
    extends FullScreenContentCallback {
        private final String placementId;
        private final MaxInterstitialAdapterListener listener;

        InterstitialAdListener(String placementId, MaxInterstitialAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdShowedFullScreenContent() {
            GoogleAdManagerMediationAdapter.this.log("Interstitial ad shown: " + this.placementId);
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", adError.getCode(), adError.getMessage());
            GoogleAdManagerMediationAdapter.this.log("Interstitial ad (" + this.placementId + ") failed to show with error: " + adapterError);
            this.listener.onInterstitialAdDisplayFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleAdManagerMediationAdapter.this.log("Interstitial ad impression recorded: " + this.placementId);
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdClicked() {
            GoogleAdManagerMediationAdapter.this.log("Interstitial ad clicked: " + this.placementId);
            this.listener.onInterstitialAdClicked();
        }

        public void onAdDismissedFullScreenContent() {
            GoogleAdManagerMediationAdapter.this.log("Interstitial ad hidden: " + this.placementId);
            this.listener.onInterstitialAdHidden();
        }
    }
}

