/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxAppOpenAdapter;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxNativeAdAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAppOpenAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MediaContent;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class GoogleMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxAppOpenAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter,
MaxNativeAdAdapter {
    private static final int TITLE_LABEL_TAG = 1;
    private static final int MEDIA_VIEW_CONTAINER_TAG = 2;
    private static final int ICON_VIEW_TAG = 3;
    private static final int BODY_VIEW_TAG = 4;
    private static final int CALL_TO_ACTION_VIEW_TAG = 5;
    private static final int ADVERTISER_VIEW_TAG = 8;
    private static final String ADAPTIVE_BANNER_TYPE_INLINE = "inline";
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus status;
    private InterstitialAd interstitialAd;
    private AppOpenAd appOpenAd;
    private RewardedAd rewardedAd;
    private AdView adView;
    private NativeAd nativeAd;
    private NativeAdView nativeAdView;
    private AppOpenAdListener appOpenAdListener;
    private RewardedAdListener rewardedAdListener;

    public GoogleMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    @SuppressLint(value={"MissingPermission"})
    public void initialize(MaxAdapterInitializationParameters parameters, @Nullable Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.log("Initializing Google SDK...");
        if (initialized.compareAndSet(false, true)) {
            Context context = this.getContext(activity);
            MobileAds.disableMediationAdapterInitialization((Context)context);
            if (parameters.getServerParameters().getBoolean("init_without_callback", false)) {
                status = MaxAdapter.InitializationStatus.DOES_NOT_APPLY;
                MobileAds.initialize((Context)context);
                onCompletionListener.onCompletion(status, null);
            } else {
                status = MaxAdapter.InitializationStatus.INITIALIZING;
                MobileAds.initialize((Context)context, initializationStatus -> {
                    AdapterStatus googleAdsStatus = (AdapterStatus)initializationStatus.getAdapterStatusMap().get("com.google.android.gms.ads.MobileAds");
                    AdapterStatus.State googleAdsState = googleAdsStatus != null ? googleAdsStatus.getInitializationState() : null;
                    this.log("Initialization complete with status " + googleAdsState);
                    status = AdapterStatus.State.READY == googleAdsState ? MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS : MaxAdapter.InitializationStatus.INITIALIZED_UNKNOWN;
                    onCompletionListener.onCompletion(status, null);
                });
            }
        } else {
            onCompletionListener.onCompletion(status, null);
        }
    }

    public String getSdkVersion() {
        return String.valueOf(MobileAds.getVersion());
    }

    public String getAdapterVersion() {
        return "24.3.0.1";
    }

    public void onDestroy() {
        this.log("Destroy called for adapter " + (Object)((Object)this));
        if (this.interstitialAd != null) {
            this.interstitialAd.setFullScreenContentCallback(null);
            this.interstitialAd = null;
        }
        if (this.appOpenAd != null) {
            this.appOpenAd.setFullScreenContentCallback(null);
            this.appOpenAd = null;
            this.appOpenAdListener = null;
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.setFullScreenContentCallback(null);
            this.rewardedAd = null;
            this.rewardedAdListener = null;
        }
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
        if (this.nativeAd != null) {
            this.nativeAd.destroy();
            this.nativeAd = null;
        }
        if (this.nativeAdView != null) {
            this.nativeAdView.destroy();
            this.nativeAdView = null;
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, @Nullable Activity activity, final MaxSignalCollectionListener callback) {
        Context context = this.getContext(activity);
        AdRequest adRequest = this.createAdRequestWithParameters(true, parameters.getAdFormat(), (MaxAdapterParameters)parameters, context);
        QueryInfo.generate((Context)context, (AdFormat)this.toAdFormat(parameters), (AdRequest)adRequest, (QueryInfoGenerationCallback)new QueryInfoGenerationCallback(){

            public void onSuccess(@NonNull QueryInfo queryInfo) {
                GoogleMediationAdapter.this.log("Signal collection successful");
                callback.onSignalCollected(queryInfo.getQuery());
            }

            public void onFailure(@NonNull String errorMessage) {
                GoogleMediationAdapter.this.log("Signal collection failed with error: " + errorMessage);
                callback.onSignalCollectionFailed(errorMessage);
            }
        });
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, final MaxInterstitialAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)parameters.getBidResponse());
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "interstitial ad: " + placementId + "...");
        GoogleMediationAdapter.updateMuteState(parameters.getServerParameters());
        Context context = this.getContext(activity);
        AdRequest adRequest = this.createAdRequestWithParameters(isBiddingAd, MaxAdFormat.INTERSTITIAL, (MaxAdapterParameters)parameters, context);
        InterstitialAd.load((Context)context, (String)placementId, (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

            public void onAdLoaded(@NonNull InterstitialAd ad) {
                String responseId;
                GoogleMediationAdapter.this.log("Interstitial ad loaded: " + placementId + "...");
                GoogleMediationAdapter.this.interstitialAd = ad;
                GoogleMediationAdapter.this.interstitialAd.setFullScreenContentCallback((FullScreenContentCallback)new InterstitialAdListener(placementId, listener));
                ResponseInfo responseInfo = GoogleMediationAdapter.this.interstitialAd.getResponseInfo();
                String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                if (AppLovinSdkUtils.isValidString((String)responseId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    listener.onInterstitialAdLoaded(extraInfo);
                } else {
                    listener.onInterstitialAdLoaded();
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
                GoogleMediationAdapter.this.log("Interstitial ad (" + placementId + ") failed to load with error: " + adapterError);
                listener.onInterstitialAdLoadFailed(adapterError);
            }
        });
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing interstitial ad: " + placementId + "...");
        if (this.interstitialAd != null) {
            this.interstitialAd.show(activity);
        } else {
            this.log("Interstitial ad failed to show: " + placementId);
            MaxAdapterError error = new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, "Interstitial ad not ready");
            listener.onInterstitialAdDisplayFailed(error);
        }
    }

    public void loadAppOpenAd(@NonNull MaxAdapterResponseParameters parameters, @Nullable Activity activity, final @NonNull MaxAppOpenAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)parameters.getBidResponse());
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "app open ad: " + placementId + "...");
        GoogleMediationAdapter.updateMuteState(parameters.getServerParameters());
        Context context = this.getContext(activity);
        AdRequest adRequest = this.createAdRequestWithParameters(isBiddingAd, MaxAdFormat.APP_OPEN, (MaxAdapterParameters)parameters, context);
        AppOpenAd.load((Context)context, (String)placementId, (AdRequest)adRequest, (AppOpenAd.AppOpenAdLoadCallback)new AppOpenAd.AppOpenAdLoadCallback(){

            public void onAdLoaded(@NonNull AppOpenAd ad) {
                String responseId;
                GoogleMediationAdapter.this.log("App open ad loaded: " + placementId + "...");
                GoogleMediationAdapter.this.appOpenAd = ad;
                GoogleMediationAdapter.this.appOpenAdListener = new AppOpenAdListener(placementId, listener);
                ad.setFullScreenContentCallback((FullScreenContentCallback)GoogleMediationAdapter.this.appOpenAdListener);
                ResponseInfo responseInfo = GoogleMediationAdapter.this.appOpenAd.getResponseInfo();
                String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                if (AppLovinSdkUtils.isValidString((String)responseId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    listener.onAppOpenAdLoaded(extraInfo);
                } else {
                    listener.onAppOpenAdLoaded();
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
                GoogleMediationAdapter.this.log("App open ad (" + placementId + ") failed to load with error: " + adapterError);
                listener.onAppOpenAdLoadFailed(adapterError);
            }
        });
    }

    public void showAppOpenAd(@NonNull MaxAdapterResponseParameters parameters, @Nullable Activity activity, @NonNull MaxAppOpenAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing app open ad: " + placementId + "...");
        if (this.appOpenAd != null) {
            this.appOpenAd.show(activity);
        } else {
            this.log("App open ad failed to show: " + placementId);
            MaxAdapterError error = new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, "App open ad not ready");
            listener.onAppOpenAdDisplayFailed(error);
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, final MaxRewardedAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)parameters.getBidResponse());
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "rewarded ad: " + placementId + "...");
        GoogleMediationAdapter.updateMuteState(parameters.getServerParameters());
        Context context = this.getContext(activity);
        AdRequest adRequest = this.createAdRequestWithParameters(isBiddingAd, MaxAdFormat.REWARDED, (MaxAdapterParameters)parameters, context);
        RewardedAd.load((Context)context, (String)placementId, (AdRequest)adRequest, (RewardedAdLoadCallback)new RewardedAdLoadCallback(){

            public void onAdLoaded(@NonNull RewardedAd ad) {
                String responseId;
                GoogleMediationAdapter.this.log("Rewarded ad loaded: " + placementId + "...");
                GoogleMediationAdapter.this.rewardedAd = ad;
                GoogleMediationAdapter.this.rewardedAdListener = new RewardedAdListener(placementId, listener);
                GoogleMediationAdapter.this.rewardedAd.setFullScreenContentCallback((FullScreenContentCallback)GoogleMediationAdapter.this.rewardedAdListener);
                ResponseInfo responseInfo = GoogleMediationAdapter.this.rewardedAd.getResponseInfo();
                String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                if (AppLovinSdkUtils.isValidString((String)responseId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    listener.onRewardedAdLoaded(extraInfo);
                } else {
                    listener.onRewardedAdLoaded();
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
                GoogleMediationAdapter.this.log("Rewarded ad (" + placementId + ") failed to load with error: " + adapterError);
                listener.onRewardedAdLoadFailed(adapterError);
            }
        });
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded ad: " + placementId + "...");
        if (this.rewardedAd != null) {
            this.configureReward(parameters);
            this.rewardedAd.show(activity, rewardItem -> {
                this.log("Rewarded ad user earned reward: " + placementId);
                this.rewardedAdListener.hasGrantedReward = true;
            });
        } else {
            this.log("Rewarded ad failed to show: " + placementId);
            MaxAdapterError error = new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, "Rewarded ad not ready");
            listener.onRewardedAdDisplayFailed(error);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, @Nullable Activity activity, MaxAdViewAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)parameters.getBidResponse());
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + (isNative ? "native " : "") + adFormat.getLabel() + " ad for placement id: " + placementId + "...");
        Context context = this.getContext(activity);
        AdRequest adRequest = this.createAdRequestWithParameters(isBiddingAd, adFormat, (MaxAdapterParameters)parameters, context);
        if (isNative) {
            NativeAdOptions.Builder nativeAdOptionsBuilder = new NativeAdOptions.Builder();
            nativeAdOptionsBuilder.setAdChoicesPlacement(this.getAdChoicesPlacement(parameters));
            nativeAdOptionsBuilder.setRequestMultipleImages(adFormat == MaxAdFormat.MREC);
            NativeAdViewListener nativeAdViewListener = new NativeAdViewListener(parameters, adFormat, activity, listener);
            AdLoader adLoader = new AdLoader.Builder(context, placementId).withNativeAdOptions(nativeAdOptionsBuilder.build()).forNativeAd((NativeAd.OnNativeAdLoadedListener)nativeAdViewListener).withAdListener((AdListener)nativeAdViewListener).build();
            adLoader.loadAd(adRequest);
        } else {
            this.adView = new AdView(context);
            this.adView.setAdUnitId(placementId);
            this.adView.setAdListener((AdListener)new AdViewListener(placementId, adFormat, listener));
            boolean isAdaptiveBanner = parameters.getServerParameters().getBoolean("adaptive_banner", false);
            this.adView.setAdSize(this.toAdSize(adFormat, isAdaptiveBanner, (MaxAdapterParameters)parameters, context));
            this.adView.loadAd(adRequest);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void loadNativeAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxNativeAdAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)parameters.getBidResponse());
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + " native ad for placement id: " + placementId + "...");
        Context context = this.getContext(activity);
        AdRequest adRequest = this.createAdRequestWithParameters(isBiddingAd, MaxAdFormat.NATIVE, (MaxAdapterParameters)parameters, context);
        NativeAdOptions.Builder nativeAdOptionsBuilder = new NativeAdOptions.Builder();
        nativeAdOptionsBuilder.setAdChoicesPlacement(this.getAdChoicesPlacement(parameters));
        String template = BundleUtils.getString((String)"template", (String)"", (Bundle)parameters.getServerParameters());
        nativeAdOptionsBuilder.setRequestMultipleImages(template.contains("medium"));
        NativeAdListener nativeAdListener = new NativeAdListener(parameters, context, listener);
        AdLoader adLoader = new AdLoader.Builder(context, placementId).withNativeAdOptions(nativeAdOptionsBuilder.build()).forNativeAd((NativeAd.OnNativeAdLoadedListener)nativeAdListener).withAdListener((AdListener)nativeAdListener).build();
        adLoader.loadAd(adRequest);
    }

    private static MaxAdapterError toMaxError(AdError googleAdsError) {
        int googleErrorCode = googleAdsError.getCode();
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (googleErrorCode) {
            case 3: 
            case 9: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case 2: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case 0: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case 1: 
            case 10: {
                adapterError = MaxAdapterError.BAD_REQUEST;
                break;
            }
            case 8: 
            case 11: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
            }
        }
        return new MaxAdapterError(adapterError, googleErrorCode, googleAdsError.getMessage());
    }

    private AdSize toAdSize(MaxAdFormat adFormat, boolean isAdaptiveBanner, MaxAdapterParameters parameters, Context context) {
        if (isAdaptiveBanner && this.isAdaptiveAdFormat(adFormat, parameters)) {
            return this.getAdaptiveAdSize(parameters, context);
        }
        if (adFormat == MaxAdFormat.BANNER) {
            return AdSize.BANNER;
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return AdSize.LEADERBOARD;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return AdSize.MEDIUM_RECTANGLE;
        }
        throw new IllegalArgumentException("Unsupported ad format: " + adFormat);
    }

    private AdSize getAdaptiveAdSize(MaxAdapterParameters parameters, Context context) {
        int bannerWidth = this.getAdaptiveBannerWidth(parameters, context);
        if (this.isInlineAdaptiveBanner(parameters)) {
            int inlineMaxHeight = this.getInlineAdaptiveBannerMaxHeight(parameters);
            if (inlineMaxHeight > 0) {
                return AdSize.getInlineAdaptiveBannerAdSize((int)bannerWidth, (int)inlineMaxHeight);
            }
            return AdSize.getCurrentOrientationInlineAdaptiveBannerAdSize((Context)context, (int)bannerWidth);
        }
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)context, (int)bannerWidth);
    }

    private boolean isAdaptiveAdFormat(MaxAdFormat adFormat, MaxAdapterParameters parameters) {
        boolean isInlineAdaptiveMRec = adFormat == MaxAdFormat.MREC && this.isInlineAdaptiveBanner(parameters);
        return isInlineAdaptiveMRec || adFormat == MaxAdFormat.BANNER || adFormat == MaxAdFormat.LEADER;
    }

    private boolean isInlineAdaptiveBanner(MaxAdapterParameters parameters) {
        Map localExtraParameters = parameters.getLocalExtraParameters();
        Object adaptiveBannerType = localExtraParameters.get("adaptive_banner_type");
        return adaptiveBannerType instanceof String && ADAPTIVE_BANNER_TYPE_INLINE.equalsIgnoreCase((String)adaptiveBannerType);
    }

    private int getInlineAdaptiveBannerMaxHeight(MaxAdapterParameters parameters) {
        Map localExtraParameters = parameters.getLocalExtraParameters();
        Object inlineMaxHeight = localExtraParameters.get("inline_adaptive_banner_max_height");
        return inlineMaxHeight instanceof Integer ? (Integer)inlineMaxHeight : 0;
    }

    private int getAdaptiveBannerWidth(MaxAdapterParameters parameters, Context context) {
        Map localExtraParameters = parameters.getLocalExtraParameters();
        Object widthObj = localExtraParameters.get("adaptive_banner_width");
        if (widthObj instanceof Integer) {
            return (Integer)widthObj;
        }
        if (widthObj != null) {
            this.e("Expected parameter \"adaptive_banner_width\" to be of type Integer, received: " + widthObj.getClass());
        }
        int deviceWidthPx = GoogleMediationAdapter.getApplicationWindowWidth(context);
        return AppLovinSdkUtils.pxToDp((Context)context, (int)deviceWidthPx);
    }

    public static int getApplicationWindowWidth(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        return outMetrics.widthPixels;
    }

    private AdFormat toAdFormat(MaxAdapterSignalCollectionParameters parameters) {
        boolean isNative;
        MaxAdFormat adFormat = parameters.getAdFormat();
        boolean bl = isNative = parameters.getServerParameters().getBoolean("is_native") || adFormat == MaxAdFormat.NATIVE;
        if (isNative) {
            return AdFormat.NATIVE;
        }
        if (adFormat.isAdViewAd()) {
            return AdFormat.BANNER;
        }
        if (adFormat == MaxAdFormat.INTERSTITIAL) {
            return AdFormat.INTERSTITIAL;
        }
        if (adFormat == MaxAdFormat.REWARDED) {
            return AdFormat.REWARDED;
        }
        if (adFormat == MaxAdFormat.APP_OPEN) {
            return AdFormat.APP_OPEN_AD;
        }
        throw new IllegalArgumentException("Unsupported ad format: " + adFormat);
    }

    @SuppressLint(value={"ApplySharedPref"})
    private AdRequest createAdRequestWithParameters(boolean isBiddingAd, MaxAdFormat adFormat, MaxAdapterParameters parameters, Context context) {
        Object neighbouringContentUrlStringsObject;
        Object contentUrlString;
        Boolean isDoNotSell;
        Boolean hasUserConsent;
        AdRequest.Builder requestBuilder = new AdRequest.Builder();
        Bundle serverParameters = parameters.getServerParameters();
        Bundle networkExtras = new Bundle(6);
        boolean isDv360Bidding = false;
        if (isBiddingAd) {
            String bidResponse;
            Object isAdaptiveBannerObj;
            String bidderType = BundleUtils.getString((String)"bidder", (String)"", (Bundle)serverParameters);
            if ("dv360".equalsIgnoreCase(bidderType)) {
                isDv360Bidding = true;
            }
            networkExtras.putString("query_info_type", isDv360Bidding ? "requester_type_3" : "requester_type_2");
            if (adFormat.isAdViewAd() && (isAdaptiveBannerObj = parameters.getLocalExtraParameters().get("adaptive_banner")) instanceof String && "true".equalsIgnoreCase((String)isAdaptiveBannerObj)) {
                AdSize adaptiveAdSize = this.toAdSize(adFormat, true, parameters, context);
                if (this.isInlineAdaptiveBanner(parameters)) {
                    networkExtras.putInt("inlined_adaptive_banner_w", adaptiveAdSize.getWidth());
                    networkExtras.putInt("inlined_adaptive_banner_h", adaptiveAdSize.getHeight());
                } else {
                    networkExtras.putInt("adaptive_banner_w", adaptiveAdSize.getWidth());
                    networkExtras.putInt("adaptive_banner_h", adaptiveAdSize.getHeight());
                }
            }
            if (parameters instanceof MaxAdapterResponseParameters && AppLovinSdkUtils.isValidString((String)(bidResponse = ((MaxAdapterResponseParameters)parameters).getBidResponse()))) {
                requestBuilder.setAdString(bidResponse);
            }
        }
        requestBuilder.setRequestAgent(isDv360Bidding ? "applovin_dv360" : "applovin");
        String eventId = BundleUtils.getString((String)"event_id", (Bundle)serverParameters);
        if (AppLovinSdkUtils.isValidString((String)eventId)) {
            networkExtras.putString("placement_req_id", eventId);
        }
        if ((hasUserConsent = parameters.hasUserConsent()) != null && !hasUserConsent.booleanValue()) {
            networkExtras.putString("npa", "1");
        }
        if ((isDoNotSell = parameters.isDoNotSell()) != null && isDoNotSell.booleanValue()) {
            networkExtras.putInt("rdp", 1);
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putInt("gad_rdp", 1).apply();
        } else {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().remove("gad_rdp").apply();
        }
        Map localExtraParameters = parameters.getLocalExtraParameters();
        Object maxContentRating = localExtraParameters.get("google_max_ad_content_rating");
        if (maxContentRating instanceof String) {
            networkExtras.putString("max_ad_content_rating", (String)maxContentRating);
        }
        if ((contentUrlString = localExtraParameters.get("google_content_url")) instanceof String) {
            requestBuilder.setContentUrl((String)contentUrlString);
        }
        if ((neighbouringContentUrlStringsObject = localExtraParameters.get("google_neighbouring_content_url_strings")) instanceof List) {
            try {
                requestBuilder.setNeighboringContentUrls((List)neighbouringContentUrlStringsObject);
            }
            catch (Throwable th) {
                this.e("Neighbouring content URL strings extra param needs to be of type List<String>.", th);
            }
        }
        requestBuilder.addNetworkExtrasBundle(AdMobAdapter.class, networkExtras);
        return requestBuilder.build();
    }

    private static void updateMuteState(Bundle serverParameters) {
        if (serverParameters.containsKey("is_muted")) {
            MobileAds.setAppMuted((boolean)serverParameters.getBoolean("is_muted"));
        }
    }

    private int getAdChoicesPlacement(MaxAdapterResponseParameters parameters) {
        Map localExtraParams = parameters.getLocalExtraParameters();
        Object adChoicesPlacementObj = localExtraParams != null ? localExtraParams.get("admob_ad_choices_placement") : null;
        return this.isValidAdChoicesPlacement(adChoicesPlacementObj) ? (Integer)adChoicesPlacementObj : 1;
    }

    private boolean isValidAdChoicesPlacement(Object placementObj) {
        return placementObj instanceof Integer && ((Integer)placementObj == 0 || (Integer)placementObj == 1 || (Integer)placementObj == 3 || (Integer)placementObj == 2);
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private class RewardedAdListener
    extends FullScreenContentCallback {
        private final String placementId;
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedAdListener(String placementId, MaxRewardedAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdShowedFullScreenContent() {
            GoogleMediationAdapter.this.log("Rewarded ad shown: " + this.placementId);
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            MaxAdapterError adapterError = new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, adError.getCode(), adError.getMessage());
            GoogleMediationAdapter.this.log("Rewarded ad (" + this.placementId + ") failed to show with error: " + adapterError);
            this.listener.onRewardedAdDisplayFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log("Rewarded ad impression recorded: " + this.placementId);
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdClicked() {
            GoogleMediationAdapter.this.log("Rewarded ad clicked: " + this.placementId);
            this.listener.onRewardedAdClicked();
        }

        public void onAdDismissedFullScreenContent() {
            if (this.hasGrantedReward || GoogleMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = GoogleMediationAdapter.this.getReward();
                GoogleMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            GoogleMediationAdapter.this.log("Rewarded ad hidden: " + this.placementId);
            this.listener.onRewardedAdHidden();
        }
    }

    private class AppOpenAdListener
    extends FullScreenContentCallback {
        private final String placementId;
        private final MaxAppOpenAdapterListener listener;

        AppOpenAdListener(String placementId, MaxAppOpenAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdShowedFullScreenContent() {
            GoogleMediationAdapter.this.log("App open ad shown: " + this.placementId);
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            MaxAdapterError adapterError = new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, adError.getCode(), adError.getMessage());
            GoogleMediationAdapter.this.log("App open ad (" + this.placementId + ") failed to show with error: " + adapterError);
            this.listener.onAppOpenAdDisplayFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log("App open ad impression recorded: " + this.placementId);
            this.listener.onAppOpenAdDisplayed();
        }

        public void onAdClicked() {
            GoogleMediationAdapter.this.log("App open ad clicked: " + this.placementId);
            this.listener.onAppOpenAdClicked();
        }

        public void onAdDismissedFullScreenContent() {
            GoogleMediationAdapter.this.log("App open ad hidden: " + this.placementId);
            this.listener.onAppOpenAdHidden();
        }
    }

    private class NativeAdViewListener
    extends AdListener
    implements NativeAd.OnNativeAdLoadedListener {
        final String placementId;
        final MaxAdFormat adFormat;
        final Bundle serverParameters;
        final WeakReference<Activity> activityRef;
        final MaxAdViewAdapterListener listener;

        NativeAdViewListener(MaxAdapterResponseParameters parameters, @Nullable MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
            this.placementId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.activityRef = new WeakReference<Activity>(activity);
            this.adFormat = adFormat;
            this.listener = listener;
        }

        public void onNativeAdLoaded(final @NonNull NativeAd nativeAd) {
            GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded: " + this.placementId);
            GoogleMediationAdapter.this.nativeAd = nativeAd;
            Activity activity = (Activity)this.activityRef.get();
            final Context context = GoogleMediationAdapter.this.getContext(activity);
            final MediaView mediaView = new MediaView(context);
            MediaContent mediaContent = nativeAd.getMediaContent();
            if (mediaContent != null) {
                mediaView.setMediaContent(mediaContent);
            }
            NativeAd.Image icon = nativeAd.getIcon();
            MaxNativeAd.MaxNativeAdImage maxNativeAdImage = null;
            if (icon != null) {
                maxNativeAdImage = icon.getDrawable() != null ? new MaxNativeAd.MaxNativeAdImage(icon.getDrawable()) : new MaxNativeAd.MaxNativeAdImage(icon.getUri());
            }
            final MaxNativeAd maxNativeAd = new MaxNativeAd.Builder().setAdFormat(this.adFormat).setTitle(nativeAd.getHeadline()).setBody(nativeAd.getBody()).setCallToAction(nativeAd.getCallToAction()).setIcon(maxNativeAdImage).setMediaView((View)mediaView).build();
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    String responseId;
                    String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)NativeAdViewListener.this.serverParameters);
                    MaxNativeAdView maxNativeAdView = new MaxNativeAdView(maxNativeAd, templateName, context);
                    GoogleMediationAdapter.this.nativeAdView = new NativeAdView(context);
                    GoogleMediationAdapter.this.nativeAdView.setIconView((View)maxNativeAdView.getIconImageView());
                    GoogleMediationAdapter.this.nativeAdView.setHeadlineView((View)maxNativeAdView.getTitleTextView());
                    GoogleMediationAdapter.this.nativeAdView.setBodyView((View)maxNativeAdView.getBodyTextView());
                    GoogleMediationAdapter.this.nativeAdView.setMediaView(mediaView);
                    GoogleMediationAdapter.this.nativeAdView.setCallToActionView((View)maxNativeAdView.getCallToActionButton());
                    GoogleMediationAdapter.this.nativeAdView.setNativeAd(nativeAd);
                    GoogleMediationAdapter.this.nativeAdView.addView((View)maxNativeAdView);
                    ResponseInfo responseInfo = nativeAd.getResponseInfo();
                    String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                    if (AppLovinSdkUtils.isValidString((String)responseId)) {
                        Bundle extraInfo = new Bundle(1);
                        extraInfo.putString("creative_id", responseId);
                        NativeAdViewListener.this.listener.onAdViewAdLoaded((View)GoogleMediationAdapter.this.nativeAdView, extraInfo);
                    } else {
                        NativeAdViewListener.this.listener.onAdViewAdLoaded((View)GoogleMediationAdapter.this.nativeAdView);
                    }
                }
            });
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
            GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad (" + this.placementId + ") failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad shown");
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked() {
            GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad clicked");
            this.listener.onAdViewAdClicked();
        }

        public void onAdOpened() {
            GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad opened");
            this.listener.onAdViewAdExpanded();
        }

        public void onAdClosed() {
            GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad closed");
            this.listener.onAdViewAdCollapsed();
        }
    }

    private class AdViewListener
    extends AdListener {
        final String placementId;
        final MaxAdFormat adFormat;
        final MaxAdViewAdapterListener listener;

        AdViewListener(String placementId, MaxAdFormat adFormat, MaxAdViewAdapterListener listener) {
            this.placementId = placementId;
            this.adFormat = adFormat;
            this.listener = listener;
        }

        public void onAdLoaded() {
            AdSize adSize;
            String responseId;
            GoogleMediationAdapter.this.log(this.adFormat.getLabel() + " ad loaded: " + this.placementId);
            Bundle extraInfo = new Bundle(3);
            ResponseInfo responseInfo = GoogleMediationAdapter.this.adView.getResponseInfo();
            String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
            if (AppLovinSdkUtils.isValidString((String)responseId)) {
                extraInfo.putString("creative_id", responseId);
            }
            if ((adSize = GoogleMediationAdapter.this.adView.getAdSize()) != null) {
                extraInfo.putInt("ad_width", adSize.getWidth());
                extraInfo.putInt("ad_height", adSize.getHeight());
            }
            this.listener.onAdViewAdLoaded((View)GoogleMediationAdapter.this.adView, extraInfo);
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
            GoogleMediationAdapter.this.log(this.adFormat.getLabel() + " ad (" + this.placementId + ") failed to load with error code: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log(this.adFormat.getLabel() + " ad shown: " + this.placementId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdOpened() {
            GoogleMediationAdapter.this.log(this.adFormat.getLabel() + " ad opened");
            this.listener.onAdViewAdClicked();
        }

        public void onAdClosed() {
            GoogleMediationAdapter.this.log(this.adFormat.getLabel() + " ad closed");
        }
    }

    private class NativeAdListener
    extends AdListener
    implements NativeAd.OnNativeAdLoadedListener {
        final String placementId;
        final Bundle serverParameters;
        final Context context;
        final MaxNativeAdAdapterListener listener;

        public NativeAdListener(MaxAdapterResponseParameters parameters, Context context, MaxNativeAdAdapterListener listener) {
            this.placementId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.context = context;
            this.listener = listener;
        }

        public void onNativeAdLoaded(final @NonNull NativeAd nativeAd) {
            GoogleMediationAdapter.this.log("Native ad loaded: " + this.placementId);
            GoogleMediationAdapter.this.nativeAd = nativeAd;
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)nativeAd.getHeadline())) {
                GoogleMediationAdapter.this.e("Native ad (" + nativeAd + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                return;
            }
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MediaView mediaView = null;
                    MediaContent mediaContent = nativeAd.getMediaContent();
                    List images = nativeAd.getImages();
                    Drawable mainImage = null;
                    float mediaContentAspectRatio = 0.0f;
                    if (mediaContent != null) {
                        MediaView googleMediaView = new MediaView(NativeAdListener.this.context);
                        googleMediaView.setMediaContent(mediaContent);
                        mediaView = googleMediaView;
                        mainImage = mediaContent.getMainImage();
                        mediaContentAspectRatio = mediaContent.getAspectRatio();
                    } else if (images != null && images.size() > 0) {
                        NativeAd.Image mediaImage = (NativeAd.Image)images.get(0);
                        ImageView mediaImageView = new ImageView(NativeAdListener.this.context);
                        Drawable mediaImageDrawable = mediaImage.getDrawable();
                        if (mediaImageDrawable != null) {
                            mediaImageView.setImageDrawable(mediaImageDrawable);
                            mediaView = mediaImageView;
                            mediaContentAspectRatio = (float)mediaImageDrawable.getIntrinsicWidth() / (float)mediaImageDrawable.getIntrinsicHeight();
                        }
                    }
                    NativeAd.Image icon = nativeAd.getIcon();
                    MaxNativeAd.MaxNativeAdImage iconImage = null;
                    if (icon != null) {
                        iconImage = icon.getDrawable() != null ? new MaxNativeAd.MaxNativeAdImage(icon.getDrawable()) : new MaxNativeAd.MaxNativeAdImage(icon.getUri());
                    }
                    MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(nativeAd.getHeadline()).setAdvertiser(nativeAd.getAdvertiser()).setBody(nativeAd.getBody()).setCallToAction(nativeAd.getCallToAction()).setIcon(iconImage).setMediaView((View)mediaView).setMainImage(new MaxNativeAd.MaxNativeAdImage(mainImage)).setMediaContentAspectRatio(mediaContentAspectRatio).setStarRating(nativeAd.getStarRating());
                    MaxGoogleNativeAd maxNativeAd = new MaxGoogleNativeAd(builder);
                    ResponseInfo responseInfo = nativeAd.getResponseInfo();
                    String responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    NativeAdListener.this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, extraInfo);
                }
            });
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
            GoogleMediationAdapter.this.log("Native ad (" + this.placementId + ") failed to load with error: " + adapterError);
            this.listener.onNativeAdLoadFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log("Native ad shown");
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdClicked() {
            GoogleMediationAdapter.this.log("Native ad clicked");
            this.listener.onNativeAdClicked();
        }

        public void onAdOpened() {
            GoogleMediationAdapter.this.log("Native ad opened");
        }

        public void onAdClosed() {
            GoogleMediationAdapter.this.log("Native ad closed");
        }
    }

    private static class AutoMeasuringMediaView
    extends MediaView {
        AutoMeasuringMediaView(Context context) {
            super(context);
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.requestLayout();
        }

        public void requestLayout() {
            super.requestLayout();
            this.post(() -> {
                this.measure(View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getHeight(), (int)0x40000000));
                this.layout(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
            });
        }
    }

    private class MaxGoogleNativeAd
    extends MaxNativeAd {
        public MaxGoogleNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            NativeAd nativeAd = GoogleMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                GoogleMediationAdapter.this.e("Failed to register native ad views: native ad is null.");
                return false;
            }
            GoogleMediationAdapter.this.nativeAdView = new NativeAdView(container.getContext());
            if (container instanceof MaxNativeAdView) {
                MaxNativeAdView maxNativeAdView = (MaxNativeAdView)container;
                View mainView = maxNativeAdView.getMainView();
                maxNativeAdView.removeView(mainView);
                GoogleMediationAdapter.this.nativeAdView.addView(mainView);
                maxNativeAdView.addView((View)GoogleMediationAdapter.this.nativeAdView);
                GoogleMediationAdapter.this.nativeAdView.setIconView((View)maxNativeAdView.getIconImageView());
                GoogleMediationAdapter.this.nativeAdView.setHeadlineView((View)maxNativeAdView.getTitleTextView());
                GoogleMediationAdapter.this.nativeAdView.setAdvertiserView((View)maxNativeAdView.getAdvertiserTextView());
                GoogleMediationAdapter.this.nativeAdView.setBodyView((View)maxNativeAdView.getBodyTextView());
                GoogleMediationAdapter.this.nativeAdView.setCallToActionView((View)maxNativeAdView.getCallToActionButton());
                View mediaView = this.getMediaView();
                if (mediaView instanceof MediaView) {
                    GoogleMediationAdapter.this.nativeAdView.setMediaView((MediaView)mediaView);
                } else if (mediaView instanceof ImageView) {
                    GoogleMediationAdapter.this.nativeAdView.setImageView(mediaView);
                }
                GoogleMediationAdapter.this.nativeAdView.setNativeAd(nativeAd);
            } else {
                boolean hasPluginLayout;
                ViewGroup pluginContainer;
                Object mediaView = null;
                for (View view : clickableViews) {
                    Object viewTag = view.getTag();
                    if (viewTag == null) continue;
                    int tag = (Integer)viewTag;
                    if (tag == 1) {
                        GoogleMediationAdapter.this.nativeAdView.setHeadlineView(view);
                        continue;
                    }
                    if (tag == 3) {
                        GoogleMediationAdapter.this.nativeAdView.setIconView(view);
                        continue;
                    }
                    if (tag == 4) {
                        GoogleMediationAdapter.this.nativeAdView.setBodyView(view);
                        continue;
                    }
                    if (tag == 5) {
                        GoogleMediationAdapter.this.nativeAdView.setCallToActionView(view);
                        continue;
                    }
                    if (tag == 8) {
                        GoogleMediationAdapter.this.nativeAdView.setAdvertiserView(view);
                        continue;
                    }
                    if (tag != 2) continue;
                    mediaView = this.getMediaView();
                }
                ViewGroup viewGroup = pluginContainer = mediaView != null ? (ViewGroup)mediaView.getParent() : container;
                if (pluginContainer == null) {
                    return true;
                }
                boolean bl = hasPluginLayout = pluginContainer instanceof RelativeLayout || pluginContainer instanceof FrameLayout;
                if (mediaView != null) {
                    MediaView googleMediaView;
                    MediaContent googleMediaContent;
                    pluginContainer.removeView(mediaView);
                    if (!hasPluginLayout && mediaView instanceof MediaView && (googleMediaContent = (googleMediaView = (MediaView)mediaView).getMediaContent()) != null && googleMediaContent.hasVideoContent()) {
                        mediaView = new AutoMeasuringMediaView(pluginContainer.getContext());
                        googleMediaView.setMediaContent(nativeAd.getMediaContent());
                    }
                    ViewGroup.LayoutParams mediaViewLayout = new ViewGroup.LayoutParams(-1, -1);
                    GoogleMediationAdapter.this.nativeAdView.addView(mediaView, mediaViewLayout);
                    if (mediaView instanceof MediaView) {
                        GoogleMediationAdapter.this.nativeAdView.setMediaView((MediaView)mediaView);
                    } else if (mediaView instanceof ImageView) {
                        GoogleMediationAdapter.this.nativeAdView.setImageView((View)((ImageView)mediaView));
                    }
                } else {
                    ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
                    View view = new View(pluginContainer.getContext());
                    GoogleMediationAdapter.this.nativeAdView.addView(view, layoutParams);
                    GoogleMediationAdapter.this.nativeAdView.setStoreView(view);
                }
                GoogleMediationAdapter.this.nativeAdView.setNativeAd(nativeAd);
                if (hasPluginLayout) {
                    ViewGroup.LayoutParams nativeAdViewLayout = new ViewGroup.LayoutParams(-1, -1);
                    pluginContainer.addView((View)GoogleMediationAdapter.this.nativeAdView, nativeAdViewLayout);
                } else {
                    GoogleMediationAdapter.this.nativeAdView.measure(View.MeasureSpec.makeMeasureSpec((int)pluginContainer.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)pluginContainer.getHeight(), (int)0x40000000));
                    GoogleMediationAdapter.this.nativeAdView.layout(0, 0, pluginContainer.getWidth(), pluginContainer.getHeight());
                    pluginContainer.addView((View)GoogleMediationAdapter.this.nativeAdView);
                }
            }
            return true;
        }
    }

    private class InterstitialAdListener
    extends FullScreenContentCallback {
        private final String placementId;
        private final MaxInterstitialAdapterListener listener;

        InterstitialAdListener(String placementId, MaxInterstitialAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdShowedFullScreenContent() {
            GoogleMediationAdapter.this.log("Interstitial ad shown: " + this.placementId);
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            MaxAdapterError adapterError = new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, adError.getCode(), adError.getMessage());
            GoogleMediationAdapter.this.log("Interstitial ad (" + this.placementId + ") failed to show with error: " + adapterError);
            this.listener.onInterstitialAdDisplayFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log("Interstitial ad impression recorded: " + this.placementId);
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdClicked() {
            GoogleMediationAdapter.this.log("Interstitial ad clicked: " + this.placementId);
            this.listener.onInterstitialAdClicked();
        }

        public void onAdDismissedFullScreenContent() {
            GoogleMediationAdapter.this.log("Interstitial ad hidden: " + this.placementId);
            this.listener.onInterstitialAdHidden();
        }
    }
}

