/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.hyprmx.android.BuildConfig;
import com.hyprmx.android.sdk.banner.HyprMXBannerListener;
import com.hyprmx.android.sdk.banner.HyprMXBannerSize;
import com.hyprmx.android.sdk.banner.HyprMXBannerView;
import com.hyprmx.android.sdk.consent.ConsentStatus;
import com.hyprmx.android.sdk.core.HyprMX;
import com.hyprmx.android.sdk.core.HyprMXErrors;
import com.hyprmx.android.sdk.core.HyprMXState;
import com.hyprmx.android.sdk.placement.HyprMXRewardedShowListener;
import com.hyprmx.android.sdk.placement.HyprMXShowListener;
import com.hyprmx.android.sdk.placement.Placement;
import com.hyprmx.android.sdk.utility.HyprMXLog;

public class HyprMXMediationAdapter
extends MediationAdapterBase
implements MaxAdViewAdapter,
MaxInterstitialAdapter,
MaxRewardedAdapter {
    private HyprMXBannerView adView;
    private Placement interstitialAd;
    private Placement rewardedAd;

    public HyprMXMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public String getSdkVersion() {
        return this.getVersionString(BuildConfig.class, "HYPRMX_VERSION");
    }

    public String getAdapterVersion() {
        return "6.4.2.0";
    }

    public void onDestroy() {
        if (this.adView != null) {
            this.adView.destroy();
            this.adView.setListener(null);
            this.adView = null;
        }
        this.interstitialAd = null;
        this.rewardedAd = null;
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        if (HyprMX.INSTANCE.getInitializationState() == HyprMXState.NOT_INITIALIZED) {
            String distributorId = parameters.getServerParameters().getString("distributor_id");
            this.log("Initializing HyprMX SDK with distributor id: " + distributorId);
            HyprMXLog.enableDebugLogs((boolean)parameters.isTesting());
            HyprMX.INSTANCE.setMediationProvider("applovin_max", this.getAdapterVersion(), AppLovinSdk.VERSION);
            this.updateUserConsent((MaxAdapterParameters)parameters);
            HyprMX.INSTANCE.initialize(this.getApplicationContext(), distributorId, initResult -> {
                if (!initResult.isSuccess()) {
                    this.log("HyprMX SDK failed to initialize for distributorId: " + distributorId);
                    onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_FAILURE, initResult.getMessage());
                    return;
                }
                this.log("HyprMX SDK initialized for distributorId: " + distributorId);
                onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS, null);
            });
        } else if (HyprMX.INSTANCE.getInitializationState() == HyprMXState.INITIALIZATION_COMPLETE) {
            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS, null);
        } else if (HyprMX.INSTANCE.getInitializationState() == HyprMXState.INITIALIZATION_FAILED) {
            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_FAILURE, null);
        } else if (HyprMX.INSTANCE.getInitializationState() == HyprMXState.INITIALIZING) {
            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZING, null);
        } else {
            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_UNKNOWN, null);
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + adFormat.getLabel() + " AdView ad for placement: " + placementId + "...");
        this.updateUserConsent((MaxAdapterParameters)parameters);
        Activity context = activity != null ? activity : this.getApplicationContext();
        this.adView = new HyprMXBannerView((Context)context, null, placementId, this.toAdSize(adFormat));
        this.adView.setListener((HyprMXBannerListener)new AdViewListener(listener));
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        AppLovinSdkUtils.Size size = adFormat.getSize();
        this.adView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(Math.round((float)size.getWidth() * displayMetrics.density), Math.round((float)size.getHeight() * displayMetrics.density)));
        this.adView.loadAd(isAdAvailable -> {
            if (!isAdAvailable) {
                this.log("AdView failed to load for placement: " + placementId);
                listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            this.log("AdView loaded for placement: " + placementId);
            listener.onAdViewAdLoaded((View)this.adView);
        });
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading interstitial ad for placement: " + placementId);
        this.updateUserConsent((MaxAdapterParameters)parameters);
        this.interstitialAd = HyprMX.INSTANCE.getPlacement(placementId);
        this.interstitialAd.loadAd(isAdAvailable -> {
            if (!isAdAvailable) {
                this.log("Interstitial failed to load for placement: " + placementId);
                listener.onInterstitialAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            this.log("Interstitial ad loaded for placement: " + placementId);
            listener.onInterstitialAdLoaded();
        });
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing interstitial ad for placement: " + placementId);
        if (this.interstitialAd == null || !this.interstitialAd.isAdAvailable()) {
            this.log("Interstitial ad not ready for placement: " + placementId);
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
            return;
        }
        this.interstitialAd.showAd((HyprMXShowListener)new InterstitialListener(listener));
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading rewarded ad for placement: " + placementId);
        this.updateUserConsent((MaxAdapterParameters)parameters);
        this.rewardedAd = HyprMX.INSTANCE.getPlacement(placementId);
        this.rewardedAd.loadAd(isAdAvailable -> {
            if (!isAdAvailable) {
                this.log("Rewarded ad failed to load for placement: " + placementId);
                listener.onRewardedAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            this.log("Rewarded ad loaded for placement: " + placementId);
            listener.onRewardedAdLoaded();
        });
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded ad for placement: " + placementId);
        if (this.rewardedAd == null || !this.rewardedAd.isAdAvailable()) {
            this.log("Rewarded ad not ready for placement: " + placementId);
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
            return;
        }
        this.configureReward(parameters);
        this.rewardedAd.showAd((HyprMXShowListener)new RewardedAdListener(listener));
    }

    private ConsentStatus getConsentStatus(MaxAdapterParameters parameters) {
        Boolean hasUserConsent = parameters.hasUserConsent();
        Boolean isDoNotSell = parameters.isDoNotSell();
        if ((this.isNull(isDoNotSell) || this.isFalse(isDoNotSell)) && this.isTrue(hasUserConsent)) {
            return ConsentStatus.CONSENT_GIVEN;
        }
        if (this.isTrue(isDoNotSell) || this.isFalse(hasUserConsent)) {
            return ConsentStatus.CONSENT_DECLINED;
        }
        return ConsentStatus.CONSENT_STATUS_UNKNOWN;
    }

    private boolean isTrue(Boolean privacyConsent) {
        return privacyConsent != null && privacyConsent != false;
    }

    private boolean isFalse(Boolean privacyConsent) {
        return privacyConsent != null && privacyConsent == false;
    }

    private boolean isNull(Boolean privacyConsent) {
        return privacyConsent == null;
    }

    private void updateUserConsent(MaxAdapterParameters parameters) {
        HyprMX.INSTANCE.setConsentStatus(this.getConsentStatus(parameters));
        Boolean isAgeRestrictedUser = parameters.isAgeRestrictedUser();
        if (isAgeRestrictedUser != null) {
            HyprMX.INSTANCE.setAgeRestrictedUser(isAgeRestrictedUser.booleanValue());
        }
    }

    private HyprMXBannerSize toAdSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER) {
            return HyprMXBannerSize.HyprMXAdSizeBanner.INSTANCE;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return HyprMXBannerSize.HyprMXAdSizeMediumRectangle.INSTANCE;
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return HyprMXBannerSize.HyprMXAdSizeLeaderboard.INSTANCE;
        }
        throw new IllegalArgumentException("Unsupported ad format: " + adFormat);
    }

    private class AdViewListener
    implements HyprMXBannerListener {
        final MaxAdViewAdapterListener listener;

        AdViewListener(MaxAdViewAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdImpression(@NonNull HyprMXBannerView ad) {
            HyprMXMediationAdapter.this.log("AdView tracked impression for placement: " + ad.getPlacementName());
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked(@NonNull HyprMXBannerView ad) {
            HyprMXMediationAdapter.this.log("AdView clicked for placement: " + ad.getPlacementName());
            this.listener.onAdViewAdClicked();
        }

        public void onAdOpened(@NonNull HyprMXBannerView ad) {
            HyprMXMediationAdapter.this.log("AdView expanded for placement: " + ad.getPlacementName());
            this.listener.onAdViewAdExpanded();
        }

        public void onAdClosed(@NonNull HyprMXBannerView ad) {
            HyprMXMediationAdapter.this.log("AdView collapsed for placement: " + ad.getPlacementName());
            this.listener.onAdViewAdCollapsed();
        }

        public void onAdLeftApplication(@NonNull HyprMXBannerView ad) {
            HyprMXMediationAdapter.this.log("AdView will leave application for placement: " + ad.getPlacementName());
        }
    }

    private class InterstitialListener
    implements HyprMXShowListener {
        final MaxInterstitialAdapterListener listener;

        InterstitialListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdStarted(@NonNull Placement placement) {
            HyprMXMediationAdapter.this.log("Interstitial did show: " + placement.getName());
        }

        public void onAdImpression(@NonNull Placement placement) {
            HyprMXMediationAdapter.this.log("Interstitial did track impression: " + placement.getName());
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdDisplayError(@NonNull Placement placement, @NonNull HyprMXErrors hyprMXError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", hyprMXError.ordinal(), hyprMXError.name());
            HyprMXMediationAdapter.this.log("Interstitial failed to display with error: " + adapterError + ", for placement: " + placement.getName());
            this.listener.onInterstitialAdDisplayFailed(adapterError);
        }

        public void onAdClosed(@NonNull Placement placement, boolean finished) {
            HyprMXMediationAdapter.this.log("Interstitial ad hidden with finished state: " + finished + " for placement: " + placement.getName());
            this.listener.onInterstitialAdHidden();
        }
    }

    private class RewardedAdListener
    implements HyprMXRewardedShowListener {
        final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedAdListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdStarted(@NonNull Placement placement) {
            HyprMXMediationAdapter.this.log("Rewarded ad did show: " + placement.getName());
        }

        public void onAdImpression(@NonNull Placement placement) {
            HyprMXMediationAdapter.this.log("Rewarded ad did track impression: " + placement.getName());
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdDisplayError(@NonNull Placement placement, @NonNull HyprMXErrors hyprMXError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", hyprMXError.ordinal(), hyprMXError.name());
            HyprMXMediationAdapter.this.log("Rewarded ad failed to display with error: " + adapterError + ", for placement: " + placement.getName());
            this.listener.onRewardedAdDisplayFailed(adapterError);
        }

        public void onAdRewarded(@NonNull Placement placement, @NonNull String rewardName, int rewardValue) {
            HyprMXMediationAdapter.this.log("Rewarded ad for placement: " + placement.getName() + " granted reward with rewardName: " + rewardName + " rewardValue: " + rewardValue);
            this.hasGrantedReward = true;
        }

        public void onAdClosed(@NonNull Placement placement, boolean finished) {
            if (this.hasGrantedReward || HyprMXMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = HyprMXMediationAdapter.this.getReward();
                HyprMXMediationAdapter.this.log("Rewarded user with reward: " + reward + " for placement: " + placement.getName());
                this.listener.onUserRewarded(reward);
            }
            HyprMXMediationAdapter.this.log("Rewarded ad hidden with finished state: " + finished + " for placement: " + placement.getName());
            this.listener.onRewardedAdHidden();
        }
    }
}

