/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.inmobi.ads.AdMetaInfo;
import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiBanner;
import com.inmobi.ads.InMobiInterstitial;
import com.inmobi.ads.InMobiNative;
import com.inmobi.ads.listeners.BannerAdEventListener;
import com.inmobi.ads.listeners.InterstitialAdEventListener;
import com.inmobi.ads.listeners.NativeAdEventListener;
import com.inmobi.compliance.InMobiPrivacyCompliance;
import com.inmobi.sdk.InMobiSdk;
import com.inmobi.sdk.SdkInitializationListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class InMobiMediationAdapter
extends MediationAdapterBase
implements MaxAdViewAdapter,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxSignalProvider {
    private static final String KEY_PARTNER_GDPR_CONSENT = "partner_gdpr_consent_available";
    private static final String KEY_PARTNER_GDPR_APPLIES = "partner_gdpr_applies";
    private static final float DEFAULT_MEDIA_CONTENT_ASPECT_RATIO = 1.9050859f;
    private static final int DEFAULT_IMAGE_TASK_TIMEOUT_SECONDS = 5;
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus status;
    private InMobiBanner adView;
    private InMobiInterstitial interstitialAd;
    private InMobiInterstitial rewardedAd;
    private InMobiNative nativeAd;

    public InMobiMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public String getSdkVersion() {
        return InMobiSdk.getVersion();
    }

    public String getAdapterVersion() {
        return "10.6.2.0";
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, MaxSignalCollectionListener callback) {
        if (!InMobiSdk.isSDKInitialized()) {
            callback.onSignalCollectionFailed("InMobi SDK initialization failed.");
            return;
        }
        this.updatePrivacySettings((MaxAdapterParameters)parameters);
        String signal = InMobiSdk.getToken(this.getExtras((MaxAdapterParameters)parameters), null);
        callback.onSignalCollected(signal);
    }

    public Boolean shouldInitializeOnUiThread() {
        return true;
    }

    public void onDestroy() {
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
        if (this.nativeAd != null) {
            this.nativeAd.destroy();
            this.nativeAd = null;
        }
        this.interstitialAd = null;
        this.rewardedAd = null;
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (INITIALIZED.compareAndSet(false, true)) {
            final String accountId = parameters.getServerParameters().getString("account_id");
            this.log("Initializing InMobi SDK with account id: " + accountId + "...");
            final Context context = this.getContext(activity);
            status = MaxAdapter.InitializationStatus.INITIALIZING;
            final JSONObject consentObject = this.getConsentJSONObject((MaxAdapterParameters)parameters);
            if (accountId == null) {
                this.log("InMobi SDK initialization failed with null account id");
                status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                onCompletionListener.onCompletion(status, "Account id is null");
                return;
            }
            Runnable initializeSdkRunnable = new Runnable(){

                @Override
                public void run() {
                    InMobiSdk.init((Context)context, (String)accountId, (JSONObject)consentObject, (SdkInitializationListener)new SdkInitializationListener(){

                        public void onInitializationComplete(@Nullable Error error) {
                            if (error != null) {
                                InMobiMediationAdapter.this.log("InMobi SDK initialization failed with error: " + error.getMessage());
                                status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                                onCompletionListener.onCompletion(status, error.getMessage());
                            } else {
                                InMobiMediationAdapter.this.log("InMobi SDK successfully initialized.");
                                status = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                                onCompletionListener.onCompletion(status, null);
                            }
                        }
                    });
                }
            };
            this.initializeSdkOnUiThread(initializeSdkRunnable);
            InMobiSdk.LogLevel logLevel = parameters.isTesting() ? InMobiSdk.LogLevel.DEBUG : InMobiSdk.LogLevel.ERROR;
            InMobiSdk.setLogLevel((InMobiSdk.LogLevel)logLevel);
        } else {
            this.log("InMobi SDK already initialized");
            onCompletionListener.onCompletion(status, null);
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
        long placementId = Long.parseLong(parameters.getThirdPartyAdPlacementId());
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        this.log("Loading" + (isNative ? " native " : " ") + adFormat.getLabel() + " AdView ad for placement: " + placementId + "...");
        if (!InMobiSdk.isSDKInitialized()) {
            this.log("InMobi SDK not successfully initialized: failing " + adFormat.getLabel() + " ad load...");
            listener.onAdViewAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updatePrivacySettings((MaxAdapterParameters)parameters);
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        Context context = this.getContext(activity);
        if (isNative) {
            this.nativeAd = new InMobiNative(context, placementId, (NativeAdEventListener)new NativeAdViewListener(parameters, adFormat, activity, listener));
            this.nativeAd.setExtras(this.getExtras((MaxAdapterParameters)parameters));
            if (isBiddingAd) {
                this.nativeAd.load(bidResponse.getBytes());
            } else {
                this.nativeAd.load();
            }
        } else {
            int height;
            int width;
            this.adView = new InMobiBanner(context, placementId);
            this.adView.setExtras(this.getExtras((MaxAdapterParameters)parameters));
            this.adView.setAnimationType(InMobiBanner.AnimationType.ANIMATION_OFF);
            this.adView.setEnableAutoRefresh(false);
            this.adView.setListener((BannerAdEventListener)new AdViewListener(listener));
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            display.getMetrics(displayMetrics);
            if (adFormat == MaxAdFormat.BANNER) {
                width = 320;
                height = 50;
            } else if (adFormat == MaxAdFormat.LEADER) {
                width = 728;
                height = 90;
            } else if (adFormat == MaxAdFormat.MREC) {
                width = 300;
                height = 250;
            } else {
                throw new IllegalArgumentException("Unsupported ad format: " + adFormat);
            }
            this.adView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(Math.round((float)width * displayMetrics.density), Math.round((float)height * displayMetrics.density)));
            if (isBiddingAd) {
                this.adView.load(bidResponse.getBytes());
            } else {
                this.adView.load();
            }
        }
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        long placementId = Long.parseLong(parameters.getThirdPartyAdPlacementId());
        this.log("Loading interstitial ad for placement: " + placementId + "...");
        if (!InMobiSdk.isSDKInitialized()) {
            this.log("InMobi SDK not successfully initialized: failing interstitial ad load...");
            listener.onInterstitialAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.interstitialAd = this.loadFullscreenAd(placementId, parameters, new InterstitialListener(listener), activity);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial ad...");
        boolean success = this.showFullscreenAd(this.interstitialAd);
        if (!success) {
            this.log("Interstitial ad not ready");
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        long placementId = Long.parseLong(parameters.getThirdPartyAdPlacementId());
        this.log("Loading rewarded ad for placement: " + placementId + "...");
        if (!InMobiSdk.isSDKInitialized()) {
            this.log("InMobi SDK not successfully initialized: failing rewarded ad load...");
            listener.onRewardedAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.rewardedAd = this.loadFullscreenAd(placementId, parameters, new RewardedAdListener(listener), activity);
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad...");
        this.configureReward(parameters);
        boolean success = this.showFullscreenAd(this.rewardedAd);
        if (!success) {
            this.log("Rewarded ad not ready");
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
        }
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, Activity activity, MaxNativeAdAdapterListener listener) {
        if (!InMobiSdk.isSDKInitialized()) {
            this.log("InMobi SDK not successfully initialized: failing native ad load...");
            listener.onNativeAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updatePrivacySettings((MaxAdapterParameters)parameters);
        long placementId = Long.parseLong(parameters.getThirdPartyAdPlacementId());
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "native ad for placement: " + placementId + "...");
        Context context = this.getContext(activity);
        this.nativeAd = new InMobiNative(context, placementId, (NativeAdEventListener)new NativeAdListener(parameters, context, listener));
        this.nativeAd.setExtras(this.getExtras((MaxAdapterParameters)parameters));
        if (isBiddingAd) {
            this.nativeAd.load(bidResponse.getBytes());
        } else {
            this.nativeAd.load();
        }
    }

    private void initializeSdkOnUiThread(Runnable initializeRunnable) {
        if (AppLovinSdk.VERSION_CODE >= 11090000) {
            initializeRunnable.run();
        } else {
            AppLovinSdkUtils.runOnUiThread((Runnable)initializeRunnable);
        }
    }

    private InMobiInterstitial loadFullscreenAd(long placementId, MaxAdapterResponseParameters parameters, InterstitialAdEventListener listener, Activity activity) {
        InMobiInterstitial interstitial = new InMobiInterstitial((Context)activity, placementId, listener);
        interstitial.setExtras(this.getExtras((MaxAdapterParameters)parameters));
        this.updatePrivacySettings((MaxAdapterParameters)parameters);
        String bidResponse = parameters.getBidResponse();
        if (!TextUtils.isEmpty((CharSequence)bidResponse)) {
            interstitial.load(bidResponse.getBytes());
        } else {
            interstitial.load();
        }
        return interstitial;
    }

    private boolean showFullscreenAd(InMobiInterstitial interstitial) {
        if (interstitial.isReady()) {
            interstitial.show();
            return true;
        }
        return false;
    }

    private JSONObject getConsentJSONObject(MaxAdapterParameters parameters) {
        JSONObject consentObject = new JSONObject();
        try {
            Boolean hasUserConsent = parameters.hasUserConsent();
            if (hasUserConsent != null) {
                consentObject.put(KEY_PARTNER_GDPR_CONSENT, (Object)hasUserConsent);
            }
        }
        catch (JSONException ex) {
            this.log("Failed to create consent JSON object", ex);
        }
        return consentObject;
    }

    private void updatePrivacySettings(MaxAdapterParameters parameters) {
        Boolean isDoNotSell;
        InMobiSdk.setPartnerGDPRConsent((JSONObject)this.getConsentJSONObject(parameters));
        Boolean isAgeRestrictedUser = parameters.isAgeRestrictedUser();
        if (isAgeRestrictedUser != null) {
            InMobiSdk.setIsAgeRestricted((boolean)isAgeRestrictedUser);
        }
        if ((isDoNotSell = parameters.isDoNotSell()) != null) {
            InMobiPrivacyCompliance.setDoNotSell((boolean)isDoNotSell);
        }
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private Map<String, String> getExtras(MaxAdapterParameters parameters) {
        HashMap<String, String> extras = new HashMap<String, String>(3);
        extras.put("tp", "c_applovin");
        extras.put("tp-ver", AppLovinSdk.VERSION);
        Boolean isAgeRestrictedUser = parameters.isAgeRestrictedUser();
        if (isAgeRestrictedUser != null) {
            extras.put("coppa", isAgeRestrictedUser != false ? "1" : "0");
        }
        return extras;
    }

    private float getNativeAdMediaContentAspectRatio(MaxAdapterParameters parameters) {
        Map localExtraParameters = parameters.getLocalExtraParameters();
        Object aspectRatioObj = localExtraParameters.get("native_ad_media_content_aspect_ratio");
        if (aspectRatioObj instanceof Number) {
            return ((Number)aspectRatioObj).floatValue();
        }
        return 1.9050859f;
    }

    private Drawable fetchNativeAdIcon(@NonNull String iconUrl, Bundle serverParameters, Context context) {
        if (TextUtils.isEmpty((CharSequence)iconUrl)) {
            this.log("Native ad icon url " + iconUrl + " is not valid");
            return null;
        }
        this.log("Adding native ad icon (" + iconUrl + ") to queue to be fetched");
        Future iconDrawableFuture = this.createDrawableFuture(iconUrl, context.getResources());
        try {
            int imageTaskTimeoutSeconds = BundleUtils.getInt((String)"image_task_timeout_seconds", (int)5, (Bundle)serverParameters);
            return (Drawable)iconDrawableFuture.get(imageTaskTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (Throwable th) {
            this.e("Failed to fetch icon image from URL: " + iconUrl, th);
            return null;
        }
    }

    private MaxNativeAdView createMaxNativeAdView(MaxNativeAd maxNativeAd, String templateName, Activity activity) {
        if (AppLovinSdk.VERSION_CODE >= 11010000) {
            return new MaxNativeAdView(maxNativeAd, templateName, this.getApplicationContext());
        }
        return new MaxNativeAdView(maxNativeAd, templateName, activity);
    }

    private static MaxAdapterError toMaxError(InMobiAdRequestStatus inMobiError) {
        InMobiAdRequestStatus.StatusCode inMobiErrorCode = inMobiError.getStatusCode();
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (inMobiErrorCode) {
            case NO_ERROR: {
                adapterError = MaxAdapterError.UNSPECIFIED;
                break;
            }
            case NETWORK_UNREACHABLE: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case NO_FILL: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case REQUEST_INVALID: {
                adapterError = MaxAdapterError.BAD_REQUEST;
                break;
            }
            case REQUEST_TIMED_OUT: {
                adapterError = MaxAdapterError.TIMEOUT;
                break;
            }
            case INTERNAL_ERROR: 
            case GDPR_COMPLIANCE_ENFORCED: 
            case GET_SIGNALS_CALLED_WHILE_LOADING: 
            case CALLED_FROM_WRONG_THREAD: 
            case LOW_MEMORY: 
            case MISSING_REQUIRED_DEPENDENCIES: 
            case INVALID_RESPONSE_IN_LOAD: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case SERVER_ERROR: {
                adapterError = MaxAdapterError.SERVER_ERROR;
                break;
            }
            case AD_ACTIVE: 
            case EARLY_REFRESH_REQUEST: 
            case REPETITIVE_LOAD: 
            case LOAD_WITH_RESPONSE_CALLED_WHILE_LOADING: 
            case REQUEST_PENDING: {
                adapterError = MaxAdapterError.INVALID_LOAD_STATE;
                break;
            }
            case AD_NO_LONGER_AVAILABLE: {
                adapterError = MaxAdapterError.AD_EXPIRED;
                break;
            }
            case MONETIZATION_DISABLED: 
            case CONFIGURATION_ERROR: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), inMobiErrorCode.ordinal(), inMobiError.getMessage());
    }

    private List<View> getClickableViews(MaxNativeAdView maxNativeAdView) {
        if (AppLovinSdk.VERSION_CODE < 11050300) {
            ArrayList<View> clickableViews = new ArrayList<View>(5);
            if (maxNativeAdView.getTitleTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getTitleTextView());
            }
            if (maxNativeAdView.getAdvertiserTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getAdvertiserTextView());
            }
            if (maxNativeAdView.getBodyTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getBodyTextView());
            }
            if (maxNativeAdView.getCallToActionButton() != null) {
                clickableViews.add((View)maxNativeAdView.getCallToActionButton());
            }
            if (maxNativeAdView.getIconImageView() != null) {
                clickableViews.add((View)maxNativeAdView.getIconImageView());
            }
            return clickableViews;
        }
        return maxNativeAdView.getClickableViews();
    }

    private class MaxInMobiNativeAd
    extends MaxNativeAd {
        private final MaxAdapterListener listener;
        private final MaxAdFormat format;

        public MaxInMobiNativeAd(MaxAdapterListener listener, MaxNativeAd.Builder builder, MaxAdFormat format) {
            super(builder);
            this.listener = listener;
            this.format = format;
        }

        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
            this.prepareForInteraction(InMobiMediationAdapter.this.getClickableViews(maxNativeAdView), (ViewGroup)maxNativeAdView);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            final InMobiNative nativeAd = InMobiMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                InMobiMediationAdapter.this.e("Failed to register native ad views: native ad is null.");
                return false;
            }
            final FrameLayout mediaView = (FrameLayout)this.getMediaView();
            mediaView.post(new Runnable(){

                @Override
                public void run() {
                    View primaryView;
                    int layoutWidth;
                    boolean isHorizontalBanner;
                    int primaryViewWidth = mediaView.getWidth();
                    int primaryViewHeight = mediaView.getHeight();
                    boolean bl = isHorizontalBanner = MaxInMobiNativeAd.this.format == MaxAdFormat.BANNER && primaryViewWidth > primaryViewHeight;
                    if (AppLovinSdk.VERSION_CODE < 11060000 && isHorizontalBanner) {
                        primaryViewWidth = (int)((float)primaryViewHeight * MaxInMobiNativeAd.this.getMediaContentAspectRatio());
                    }
                    if (primaryViewWidth == 0 && ((layoutWidth = mediaView.getLayoutParams().width) == -2 || layoutWidth == -1)) {
                        primaryViewWidth = (int)((float)primaryViewHeight * MaxInMobiNativeAd.this.getMediaContentAspectRatio());
                    }
                    if ((primaryView = nativeAd.getPrimaryViewOfWidth(mediaView.getContext(), null, (ViewGroup)mediaView, primaryViewWidth)) == null) {
                        return;
                    }
                    mediaView.addView(primaryView);
                    if (AppLovinSdk.VERSION_CODE < 11060000 && isHorizontalBanner) {
                        ((FrameLayout.LayoutParams)primaryView.getLayoutParams()).gravity = 17;
                    }
                }
            });
            View.OnClickListener clickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    InMobiMediationAdapter.this.log("Native ad clicked from click listener");
                    nativeAd.reportAdClickAndOpenLandingPage();
                    if (MaxInMobiNativeAd.this.format == MaxAdFormat.NATIVE) {
                        ((MaxNativeAdAdapterListener)MaxInMobiNativeAd.this.listener).onNativeAdClicked();
                    } else if (MaxInMobiNativeAd.this.format.isAdViewAd()) {
                        ((MaxAdViewAdapterListener)MaxInMobiNativeAd.this.listener).onAdViewAdClicked();
                    } else {
                        InMobiMediationAdapter.this.log("Unsupported ad format: must be adView ad or native ad");
                    }
                }
            };
            for (View clickableView : clickableViews) {
                if (clickableView == null) continue;
                clickableView.setOnClickListener(clickListener);
            }
            return true;
        }
    }

    private class NativeAdListener
    extends NativeAdEventListener {
        private final String placementId;
        private final Context context;
        private final MaxNativeAdAdapterListener listener;
        private final Bundle serverParameters;
        private final float mediaContentAspectRatio;

        NativeAdListener(MaxAdapterResponseParameters parameters, Context context, MaxNativeAdAdapterListener listener) {
            this.placementId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.mediaContentAspectRatio = InMobiMediationAdapter.this.getNativeAdMediaContentAspectRatio((MaxAdapterParameters)parameters);
            this.context = context;
            this.listener = listener;
        }

        public void onAdLoadSucceeded(final InMobiNative inMobiNative, final @NonNull AdMetaInfo adMetaInfo) {
            if (InMobiMediationAdapter.this.nativeAd == null || inMobiNative == null || InMobiMediationAdapter.this.nativeAd != inMobiNative) {
                InMobiMediationAdapter.this.log("Native ad failed to load: no fill");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)inMobiNative.getAdTitle())) {
                InMobiMediationAdapter.this.e("Native ad (" + inMobiNative + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                return;
            }
            InMobiMediationAdapter.this.log("Native ad loaded: " + this.placementId);
            InMobiMediationAdapter.this.getCachingExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    Drawable iconDrawable = InMobiMediationAdapter.this.fetchNativeAdIcon(inMobiNative.getAdIconUrl(), NativeAdListener.this.serverParameters, NativeAdListener.this.context);
                    NativeAdListener.this.handleNativeAdLoaded(inMobiNative, adMetaInfo, iconDrawable, NativeAdListener.this.context);
                }
            });
        }

        private void handleNativeAdLoaded(final @NonNull InMobiNative inMobiNative, final @NonNull AdMetaInfo adMetaInfo, final Drawable iconDrawable, final Context context) {
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ImageView imageView = new ImageView(context);
                    imageView.setImageDrawable(iconDrawable);
                    FrameLayout frameLayout = new FrameLayout(context);
                    MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(inMobiNative.getAdTitle()).setBody(inMobiNative.getAdDescription()).setCallToAction(inMobiNative.getAdCtaText()).setIcon(new MaxNativeAd.MaxNativeAdImage(iconDrawable)).setMediaView((View)frameLayout).setMediaContentAspectRatio(NativeAdListener.this.mediaContentAspectRatio);
                    if (AppLovinSdk.VERSION_CODE >= 11070000) {
                        builder.setStarRating(Double.valueOf(inMobiNative.getAdRating()));
                    }
                    MaxInMobiNativeAd maxInMobiNativeAd = new MaxInMobiNativeAd((MaxAdapterListener)NativeAdListener.this.listener, builder, MaxAdFormat.NATIVE);
                    if (AppLovinSdkUtils.isValidString((String)adMetaInfo.getCreativeID())) {
                        Bundle extraInfo = new Bundle(1);
                        extraInfo.putString("creative_id", adMetaInfo.getCreativeID());
                        NativeAdListener.this.listener.onNativeAdLoaded((MaxNativeAd)maxInMobiNativeAd, extraInfo);
                    } else {
                        NativeAdListener.this.listener.onNativeAdLoaded((MaxNativeAd)maxInMobiNativeAd, null);
                    }
                }
            });
        }

        public void onAdLoadFailed(@NonNull InMobiNative inMobiNative, @NonNull InMobiAdRequestStatus inMobiAdRequestStatus) {
            MaxAdapterError adapterError = InMobiMediationAdapter.toMaxError(inMobiAdRequestStatus);
            InMobiMediationAdapter.this.log("Native ad failed to load with error " + adapterError);
            this.listener.onNativeAdLoadFailed(adapterError);
        }

        public void onAdImpression(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native ad shown");
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdClicked(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native ad clicked");
            this.listener.onNativeAdClicked();
        }

        public void onUserWillLeaveApplication(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native ad user will leave application");
        }

        public void onAdFullScreenWillDisplay(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native ad fullscreen will display");
        }

        public void onAdFullScreenDisplayed(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native ad fullscreen displayed");
        }

        public void onAdFullScreenDismissed(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native ad fullscreen dismissed");
        }

        public void onAdStatusChanged(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native ad status changed");
        }
    }

    private class NativeAdViewListener
    extends NativeAdEventListener {
        private final String placementId;
        private final WeakReference<Activity> activityRef;
        private final MaxAdViewAdapterListener listener;
        private final Bundle serverParameters;
        private final MaxAdFormat adFormat;
        private final float mediaContentAspectRatio;

        NativeAdViewListener(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
            this.placementId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.mediaContentAspectRatio = InMobiMediationAdapter.this.getNativeAdMediaContentAspectRatio((MaxAdapterParameters)parameters);
            this.adFormat = adFormat;
            this.activityRef = new WeakReference<Activity>(activity);
            this.listener = listener;
        }

        public void onAdLoadSucceeded(final InMobiNative inMobiNative, final @NonNull AdMetaInfo adMetaInfo) {
            if (InMobiMediationAdapter.this.nativeAd == null || inMobiNative == null || InMobiMediationAdapter.this.nativeAd != inMobiNative) {
                InMobiMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load: no fill");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            if (TextUtils.isEmpty((CharSequence)inMobiNative.getAdTitle())) {
                InMobiMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad does not have required assets.");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
                return;
            }
            InMobiMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded: " + this.placementId);
            final Activity activity = (Activity)this.activityRef.get();
            final Context context = InMobiMediationAdapter.this.getContext(activity);
            InMobiMediationAdapter.this.getCachingExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    final Drawable iconDrawable = InMobiMediationAdapter.this.fetchNativeAdIcon(inMobiNative.getAdIconUrl(), NativeAdViewListener.this.serverParameters, context);
                    AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MaxNativeAdView maxNativeAdView;
                            ImageView imageView = new ImageView(context);
                            imageView.setImageDrawable(iconDrawable);
                            FrameLayout frameLayout = new FrameLayout(context);
                            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(NativeAdViewListener.this.adFormat).setTitle(inMobiNative.getAdTitle()).setBody(inMobiNative.getAdDescription()).setCallToAction(inMobiNative.getAdCtaText()).setIcon(new MaxNativeAd.MaxNativeAdImage(iconDrawable)).setMediaView((View)frameLayout).setMediaContentAspectRatio(NativeAdViewListener.this.mediaContentAspectRatio);
                            MaxInMobiNativeAd maxInMobiNativeAd = new MaxInMobiNativeAd((MaxAdapterListener)NativeAdViewListener.this.listener, builder, NativeAdViewListener.this.adFormat);
                            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)NativeAdViewListener.this.serverParameters);
                            if (templateName.contains("vertical")) {
                                if (AppLovinSdk.VERSION_CODE < 9140500) {
                                    InMobiMediationAdapter.this.log("Vertical native banners are only supported on MAX SDK 9.14.5 and above. Default horizontal native template will be used.");
                                }
                                if (templateName.equals("vertical")) {
                                    String verticalTemplateName = NativeAdViewListener.this.adFormat == MaxAdFormat.LEADER ? "vertical_leader_template" : "vertical_media_banner_template";
                                    maxNativeAdView = InMobiMediationAdapter.this.createMaxNativeAdView(maxInMobiNativeAd, verticalTemplateName, activity);
                                } else {
                                    maxNativeAdView = InMobiMediationAdapter.this.createMaxNativeAdView(maxInMobiNativeAd, templateName, activity);
                                }
                            } else {
                                maxNativeAdView = AppLovinSdk.VERSION_CODE < 9140500 ? InMobiMediationAdapter.this.createMaxNativeAdView(maxInMobiNativeAd, AppLovinSdkUtils.isValidString((String)templateName) ? templateName : "no_body_banner_template", activity) : InMobiMediationAdapter.this.createMaxNativeAdView(maxInMobiNativeAd, AppLovinSdkUtils.isValidString((String)templateName) ? templateName : "media_banner_template", activity);
                            }
                            maxInMobiNativeAd.prepareForInteraction(InMobiMediationAdapter.this.getClickableViews(maxNativeAdView), (ViewGroup)maxNativeAdView);
                            if (AppLovinSdk.VERSION_CODE >= 9150000 && AppLovinSdkUtils.isValidString((String)adMetaInfo.getCreativeID())) {
                                Bundle extraInfo = new Bundle(1);
                                extraInfo.putString("creative_id", adMetaInfo.getCreativeID());
                                NativeAdViewListener.this.listener.onAdViewAdLoaded((View)maxNativeAdView, extraInfo);
                            } else {
                                NativeAdViewListener.this.listener.onAdViewAdLoaded((View)maxNativeAdView);
                            }
                        }
                    });
                }
            });
        }

        public void onAdLoadFailed(@NonNull InMobiNative inMobiNative, @NonNull InMobiAdRequestStatus inMobiAdRequestStatus) {
            MaxAdapterError adapterError = InMobiMediationAdapter.toMaxError(inMobiAdRequestStatus);
            InMobiMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load with error " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdImpression(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad shown");
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad clicked");
            this.listener.onAdViewAdClicked();
        }

        public void onUserWillLeaveApplication(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad user will leave application");
        }

        public void onAdFullScreenWillDisplay(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad fullscreen will display");
        }

        public void onAdFullScreenDisplayed(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad fullscreen displayed");
        }

        public void onAdFullScreenDismissed(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad fullscreen dismissed");
        }

        public void onAdStatusChanged(@NonNull InMobiNative inMobiNative) {
            InMobiMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad status changed");
        }
    }

    private class RewardedAdListener
    extends InterstitialAdEventListener {
        final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedAdListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdFetchSuccessful(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
            InMobiMediationAdapter.this.log("Rewarded ad request succeeded");
        }

        public void onAdLoadSucceeded(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
            InMobiMediationAdapter.this.log("Rewarded ad loaded");
            if (AppLovinSdk.VERSION_CODE >= 9150000 && !TextUtils.isEmpty((CharSequence)adMetaInfo.getCreativeID())) {
                Bundle extraInfo = new Bundle(1);
                extraInfo.putString("creative_id", adMetaInfo.getCreativeID());
                this.listener.onRewardedAdLoaded(extraInfo);
            } else {
                this.listener.onRewardedAdLoaded();
            }
        }

        public void onAdLoadFailed(@NonNull InMobiInterstitial inMobiInterstitial, InMobiAdRequestStatus inMobiAdRequestStatus) {
            InMobiMediationAdapter.this.log("Rewarded ad failed to load with error code " + inMobiAdRequestStatus.getStatusCode() + " and message: " + inMobiAdRequestStatus.getMessage());
            MaxAdapterError adapterError = InMobiMediationAdapter.toMaxError(inMobiAdRequestStatus);
            this.listener.onRewardedAdLoadFailed(adapterError);
        }

        public void onAdDisplayFailed(@NonNull InMobiInterstitial inMobiInterstitial) {
            InMobiMediationAdapter.this.log("Rewarded ad failed to display");
            this.listener.onRewardedAdDisplayFailed(MaxAdapterError.UNSPECIFIED);
        }

        public void onAdWillDisplay(@NonNull InMobiInterstitial inMobiInterstitial) {
            InMobiMediationAdapter.this.log("Rewarded ad did show");
        }

        public void onAdDisplayed(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
            InMobiMediationAdapter.this.log("Rewarded ad did show");
            this.listener.onRewardedAdVideoStarted();
        }

        public void onAdImpression(@NonNull InMobiInterstitial inMobiInterstitial) {
            InMobiMediationAdapter.this.log("Rewarded ad impression tracked");
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdClicked(@NonNull InMobiInterstitial inMobiInterstitial, Map<Object, Object> map) {
            InMobiMediationAdapter.this.log("Rewarded ad clicked");
            this.listener.onRewardedAdClicked();
        }

        public void onAdDismissed(@NonNull InMobiInterstitial inMobiInterstitial) {
            InMobiMediationAdapter.this.log("Rewarded ad hidden");
            this.listener.onRewardedAdVideoCompleted();
            if (this.hasGrantedReward || InMobiMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = InMobiMediationAdapter.this.getReward();
                InMobiMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            this.listener.onRewardedAdHidden();
        }

        public void onUserLeftApplication(@NonNull InMobiInterstitial inMobiInterstitial) {
            InMobiMediationAdapter.this.log("Rewarded ad will leave application");
        }

        public void onRewardsUnlocked(@NonNull InMobiInterstitial inMobiInterstitial, Map<Object, Object> map) {
            InMobiMediationAdapter.this.log("Rewarded ad granted reward");
            this.hasGrantedReward = true;
        }
    }

    private class InterstitialListener
    extends InterstitialAdEventListener {
        final MaxInterstitialAdapterListener listener;

        InterstitialListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdFetchSuccessful(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
            InMobiMediationAdapter.this.log("Interstitial request succeeded");
        }

        public void onAdLoadSucceeded(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
            InMobiMediationAdapter.this.log("Interstitial loaded");
            if (AppLovinSdk.VERSION_CODE >= 9150000 && !TextUtils.isEmpty((CharSequence)adMetaInfo.getCreativeID())) {
                Bundle extraInfo = new Bundle(1);
                extraInfo.putString("creative_id", adMetaInfo.getCreativeID());
                this.listener.onInterstitialAdLoaded(extraInfo);
            } else {
                this.listener.onInterstitialAdLoaded();
            }
        }

        public void onAdLoadFailed(@NonNull InMobiInterstitial inMobiInterstitial, InMobiAdRequestStatus inMobiAdRequestStatus) {
            InMobiMediationAdapter.this.log("Interstitial failed to load with error code " + inMobiAdRequestStatus.getStatusCode() + " and message: " + inMobiAdRequestStatus.getMessage());
            MaxAdapterError adapterError = InMobiMediationAdapter.toMaxError(inMobiAdRequestStatus);
            this.listener.onInterstitialAdLoadFailed(adapterError);
        }

        public void onAdDisplayFailed(@NonNull InMobiInterstitial inMobiInterstitial) {
            InMobiMediationAdapter.this.log("Interstitial failed to display");
            this.listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed"));
        }

        public void onAdWillDisplay(@NonNull InMobiInterstitial inMobiInterstitial) {
            InMobiMediationAdapter.this.log("Interstitial will show");
        }

        public void onAdDisplayed(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
            InMobiMediationAdapter.this.log("Interstitial did show");
        }

        public void onAdImpression(@NonNull InMobiInterstitial inMobiInterstitial) {
            InMobiMediationAdapter.this.log("Interstitial impression tracked");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdClicked(@NonNull InMobiInterstitial inMobiInterstitial, Map<Object, Object> map) {
            InMobiMediationAdapter.this.log("Interstitial clicked");
            this.listener.onInterstitialAdClicked();
        }

        public void onAdDismissed(@NonNull InMobiInterstitial inMobiInterstitial) {
            InMobiMediationAdapter.this.log("Interstitial hidden");
            this.listener.onInterstitialAdHidden();
        }

        public void onUserLeftApplication(@NonNull InMobiInterstitial inMobiInterstitial) {
            InMobiMediationAdapter.this.log("Interstitial will leave application");
        }
    }

    private class AdViewListener
    extends BannerAdEventListener {
        final MaxAdViewAdapterListener listener;

        AdViewListener(MaxAdViewAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoadSucceeded(@NonNull InMobiBanner inMobiBanner, @NonNull AdMetaInfo adMetaInfo) {
            InMobiMediationAdapter.this.log("AdView loaded");
            if (AppLovinSdk.VERSION_CODE >= 9150000 && !TextUtils.isEmpty((CharSequence)adMetaInfo.getCreativeID())) {
                Bundle extraInfo = new Bundle(1);
                extraInfo.putString("creative_id", adMetaInfo.getCreativeID());
                this.listener.onAdViewAdLoaded((View)inMobiBanner, extraInfo);
            } else {
                this.listener.onAdViewAdLoaded((View)inMobiBanner);
            }
        }

        public void onAdLoadFailed(@NonNull InMobiBanner inMobiBanner, InMobiAdRequestStatus inMobiAdRequestStatus) {
            InMobiMediationAdapter.this.log("AdView failed to load with error code " + inMobiAdRequestStatus.getStatusCode() + " and message: " + inMobiAdRequestStatus.getMessage());
            MaxAdapterError adapterError = InMobiMediationAdapter.toMaxError(inMobiAdRequestStatus);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdDisplayed(@NonNull InMobiBanner inMobiBanner) {
            InMobiMediationAdapter.this.log("AdView expanded");
            this.listener.onAdViewAdExpanded();
        }

        public void onAdImpression(@NonNull InMobiBanner inMobiBanner) {
            InMobiMediationAdapter.this.log("AdView impression tracked");
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdDismissed(@NonNull InMobiBanner inMobiBanner) {
            InMobiMediationAdapter.this.log("AdView collapsed");
            this.listener.onAdViewAdCollapsed();
        }

        public void onAdClicked(@NonNull InMobiBanner inMobiBanner, Map<Object, Object> map) {
            InMobiMediationAdapter.this.log("AdView clicked");
            this.listener.onAdViewAdClicked();
        }

        public void onUserLeftApplication(@NonNull InMobiBanner inMobiBanner) {
            InMobiMediationAdapter.this.log("AdView will leave application");
        }
    }
}

