/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.adapters.MediationAdapterRouter;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyBannerLayout;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyBannerListener;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyRewardedVideoListener;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.unity3d.ironsourceads.AdSize;
import com.unity3d.ironsourceads.InitListener;
import com.unity3d.ironsourceads.InitRequest;
import com.unity3d.ironsourceads.IronSourceAds;
import com.unity3d.ironsourceads.banner.BannerAdLoader;
import com.unity3d.ironsourceads.banner.BannerAdLoaderListener;
import com.unity3d.ironsourceads.banner.BannerAdRequest;
import com.unity3d.ironsourceads.banner.BannerAdView;
import com.unity3d.ironsourceads.banner.BannerAdViewListener;
import com.unity3d.ironsourceads.interstitial.InterstitialAd;
import com.unity3d.ironsourceads.interstitial.InterstitialAdListener;
import com.unity3d.ironsourceads.interstitial.InterstitialAdLoader;
import com.unity3d.ironsourceads.interstitial.InterstitialAdLoaderListener;
import com.unity3d.ironsourceads.interstitial.InterstitialAdRequest;
import com.unity3d.ironsourceads.rewarded.RewardedAd;
import com.unity3d.ironsourceads.rewarded.RewardedAdListener;
import com.unity3d.ironsourceads.rewarded.RewardedAdLoader;
import com.unity3d.ironsourceads.rewarded.RewardedAdLoaderListener;
import com.unity3d.ironsourceads.rewarded.RewardedAdRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class IronSourceMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final IronSourceRouter ROUTER = new IronSourceRouter();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    private static final List<String> loadedAdViewPlacementIdentifiers = Collections.synchronizedList(new ArrayList());
    private static MaxAdapter.InitializationStatus status;
    private String mRouterPlacementIdentifier;
    @Nullable
    private String adViewPlacementIdentifier;
    private ISDemandOnlyBannerLayout adView;
    private BannerAdView biddingAdView;
    private InterstitialAd biddingInterstitialAd;
    private RewardedAd biddingRewardedAd;
    private BiddingRewardedListener biddingRewardedListener;
    private BiddingInterstitialListener biddingInterstitialListener;

    public IronSourceMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, @Nullable Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (INITIALIZED.compareAndSet(false, true)) {
            status = MaxAdapter.InitializationStatus.INITIALIZING;
            String appKey = parameters.getServerParameters().getString("app_key");
            this.log("Initializing IronSource SDK with app key: " + appKey + "...");
            IronSource.setMediationType((String)("MAX" + this.getAdapterVersionCode() + "SDK" + AppLovinSdk.VERSION_CODE));
            this.setPrivacySettings((MaxAdapterParameters)parameters);
            Boolean isDoNotSell = parameters.isDoNotSell();
            if (isDoNotSell != null) {
                IronSource.setMetaData((String)"do_not_sell", (String)Boolean.toString(isDoNotSell));
            }
            IronSource.setAdaptersDebug((boolean)parameters.isTesting());
            IronSource.setISDemandOnlyInterstitialListener((ISDemandOnlyInterstitialListener)ROUTER);
            IronSource.setISDemandOnlyRewardedVideoListener((ISDemandOnlyRewardedVideoListener)ROUTER);
            InitRequest initRequest = new InitRequest.Builder(appKey).withLegacyAdFormats(this.getAdFormatsToInitialize(parameters)).build();
            IronSourceAds.init((Context)this.getApplicationContext(), (InitRequest)initRequest, (InitListener)new InitListener(){

                public void onInitSuccess() {
                    IronSourceMediationAdapter.this.log("IronSource SDK initialized.");
                    status = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(status, null);
                }

                public void onInitFailed(@NonNull IronSourceError ironSourceError) {
                    IronSourceMediationAdapter.this.log("Failed to initialize IronSource SDK with error: " + ironSourceError);
                    status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    onCompletionListener.onCompletion(status, ironSourceError.getErrorMessage());
                }
            });
        } else {
            onCompletionListener.onCompletion(status, null);
        }
    }

    public String getSdkVersion() {
        return IronSourceUtils.getSDKVersion();
    }

    public String getAdapterVersion() {
        return "8.6.1.0.0";
    }

    public void onDestroy() {
        if (this.adViewPlacementIdentifier != null) {
            this.log("Destroying adview with instance ID: " + this.adViewPlacementIdentifier);
            IronSource.destroyISDemandOnlyBanner((String)this.adViewPlacementIdentifier);
            loadedAdViewPlacementIdentifiers.remove(this.adViewPlacementIdentifier);
        }
        ROUTER.removeAdapter((MaxAdapter)this, this.mRouterPlacementIdentifier);
        if (this.biddingAdView != null) {
            this.biddingAdView.setListener(null);
            this.biddingAdView = null;
        }
        if (this.biddingInterstitialAd != null) {
            this.biddingInterstitialAd.setListener(null);
            this.biddingInterstitialAd = null;
        }
        if (this.biddingRewardedAd != null) {
            this.biddingRewardedAd.setListener(null);
            this.biddingRewardedAd = null;
        }
        this.biddingInterstitialListener = null;
        this.biddingRewardedListener = null;
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, @Nullable Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        this.setPrivacySettings((MaxAdapterParameters)parameters);
        String signal = IronSource.getISDemandOnlyBiddingData((Context)this.getApplicationContext());
        callback.onSignalCollected(signal);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        this.setPrivacySettings((MaxAdapterParameters)parameters);
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        String instanceId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading ironSource " + (isBiddingAd ? "bidding " : "") + "interstitial for instance ID: " + instanceId);
        if (isBiddingAd) {
            InterstitialAdRequest adRequest = new InterstitialAdRequest.Builder(instanceId, bidResponse).build();
            this.biddingInterstitialListener = new BiddingInterstitialListener(listener);
            InterstitialAdLoader.loadAd((InterstitialAdRequest)adRequest, (InterstitialAdLoaderListener)this.biddingInterstitialListener);
        } else {
            this.mRouterPlacementIdentifier = IronSourceRouter.getInterstitialRouterIdentifier(instanceId);
            ROUTER.addInterstitialAdapter((MaxAdapter)this, listener, this.mRouterPlacementIdentifier);
            if (IronSource.isISDemandOnlyInterstitialReady((String)instanceId)) {
                this.log("Ad is available already for instance ID: " + instanceId);
                ROUTER.onAdLoaded(this.mRouterPlacementIdentifier);
            } else {
                IronSource.loadISDemandOnlyInterstitial((Activity)activity, (String)instanceId);
            }
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        String instanceId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing ironSource interstitial for instance ID: " + instanceId);
        if (isBiddingAd) {
            if (this.biddingInterstitialAd == null || !this.biddingInterstitialAd.isReadyToShow()) {
                this.log("Unable to show ironSource interstitial - ad is not ready for instance ID: " + instanceId);
                listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
                return;
            }
            if (activity == null) {
                this.log("Interstitial ad display failed: Activity is null");
                listener.onInterstitialAdDisplayFailed(MaxAdapterError.MISSING_ACTIVITY);
                return;
            }
            this.biddingInterstitialAd.setListener((InterstitialAdListener)this.biddingInterstitialListener);
            this.biddingInterstitialAd.show(activity);
        } else {
            ROUTER.addShowingAdapter((MaxAdapter)this);
            if (!IronSource.isISDemandOnlyInterstitialReady((String)instanceId)) {
                this.log("Unable to show ironSource interstitial - no ad loaded for instance ID: " + instanceId);
                ROUTER.onAdDisplayFailed(IronSourceRouter.getInterstitialRouterIdentifier(instanceId), new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
                return;
            }
            IronSource.showISDemandOnlyInterstitial((String)instanceId);
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        this.setPrivacySettings((MaxAdapterParameters)parameters);
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        String instanceId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading ironSource " + (isBiddingAd ? "bidding " : "") + "rewarded for instance ID: " + instanceId);
        if (isBiddingAd) {
            RewardedAdRequest adRequest = new RewardedAdRequest.Builder(instanceId, bidResponse).build();
            this.biddingRewardedListener = new BiddingRewardedListener(listener);
            RewardedAdLoader.loadAd((RewardedAdRequest)adRequest, (RewardedAdLoaderListener)this.biddingRewardedListener);
        } else {
            this.mRouterPlacementIdentifier = IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId);
            ROUTER.addRewardedAdapter((MaxAdapter)this, listener, this.mRouterPlacementIdentifier);
            if (IronSource.isISDemandOnlyRewardedVideoAvailable((String)instanceId)) {
                this.log("Ad is available already for instance ID: " + instanceId);
                ROUTER.onAdLoaded(this.mRouterPlacementIdentifier);
            } else {
                IronSource.loadISDemandOnlyRewardedVideo((Activity)activity, (String)instanceId);
            }
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        String instanceId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing ironSource rewarded for instance ID: " + instanceId);
        if (isBiddingAd) {
            if (this.biddingRewardedAd == null || !this.biddingRewardedAd.isReadyToShow()) {
                this.log("Unable to show ironSource rewarded - ad is not ready for instance ID: " + instanceId);
                listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
                return;
            }
            if (activity == null) {
                this.log("Rewarded ad display failed: Activity is null");
                listener.onRewardedAdDisplayFailed(MaxAdapterError.MISSING_ACTIVITY);
                return;
            }
            this.configureReward(parameters);
            this.biddingRewardedAd.setListener((RewardedAdListener)this.biddingRewardedListener);
            this.biddingRewardedAd.show(activity);
        } else {
            ROUTER.addShowingAdapter((MaxAdapter)this);
            if (!IronSource.isISDemandOnlyRewardedVideoAvailable((String)instanceId)) {
                this.log("Unable to show ironSource rewarded - no ad loaded...");
                ROUTER.onAdDisplayFailed(IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId), new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
                return;
            }
            this.configureReward(parameters);
            IronSource.showISDemandOnlyRewardedVideo((String)instanceId);
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, @Nullable Activity activity, MaxAdViewAdapterListener listener) {
        this.setPrivacySettings((MaxAdapterParameters)parameters);
        String bidResponse = parameters.getBidResponse();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)bidResponse);
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + adFormat.getLabel() + " ad for instance ID: " + parameters.getThirdPartyAdPlacementId());
        if (isBiddingAd) {
            AdSize adSize = this.toISAdSize(adFormat);
            BannerAdRequest bannerAdRequest = new BannerAdRequest.Builder(this.getApplicationContext(), parameters.getThirdPartyAdPlacementId(), bidResponse, adSize).build();
            BannerAdLoader.loadAd((BannerAdRequest)bannerAdRequest, (BannerAdLoaderListener)new BiddingAdViewListener(listener));
        } else {
            if (activity == null) {
                this.log(adFormat.getLabel() + " ad load failed: Activity is null");
                listener.onAdViewAdLoadFailed(MaxAdapterError.MISSING_ACTIVITY);
                return;
            }
            if (loadedAdViewPlacementIdentifiers.contains(parameters.getThirdPartyAdPlacementId())) {
                this.log("AdView ad failed to load for instance ID: " + parameters.getThirdPartyAdPlacementId() + ". An ad with the same instance ID is already loaded");
                listener.onAdViewAdLoadFailed(new MaxAdapterError(MaxAdapterError.INTERNAL_ERROR.getCode(), MaxAdapterError.INTERNAL_ERROR.getMessage(), 0, "An ad with the same instance ID is already loaded"));
                return;
            }
            this.adViewPlacementIdentifier = parameters.getThirdPartyAdPlacementId();
            this.adView = IronSource.createBannerForDemandOnly((Activity)activity, (ISBannerSize)this.toISBannerSize(adFormat));
            this.adView.setBannerDemandOnlyListener((ISDemandOnlyBannerListener)new AdViewListener(listener));
            IronSource.loadISDemandOnlyBanner((Activity)activity, (ISDemandOnlyBannerLayout)this.adView, (String)this.adViewPlacementIdentifier);
        }
    }

    private void setPrivacySettings(MaxAdapterParameters parameters) {
        Boolean hasUserConsent = parameters.hasUserConsent();
        if (hasUserConsent != null) {
            IronSource.setConsent((boolean)hasUserConsent);
        }
    }

    private List<IronSourceAds.AdFormat> getAdFormatsToInitialize(MaxAdapterInitializationParameters parameters) {
        ArrayList adFormats = parameters.getServerParameters().getStringArrayList("init_ad_formats");
        if (adFormats == null || adFormats.isEmpty()) {
            return Arrays.asList(IronSourceAds.AdFormat.INTERSTITIAL, IronSourceAds.AdFormat.REWARDED, IronSourceAds.AdFormat.BANNER);
        }
        ArrayList<IronSourceAds.AdFormat> adFormatsToInitialize = new ArrayList<IronSourceAds.AdFormat>();
        if (adFormats.contains("inter")) {
            adFormatsToInitialize.add(IronSourceAds.AdFormat.INTERSTITIAL);
        }
        if (adFormats.contains("rewarded")) {
            adFormatsToInitialize.add(IronSourceAds.AdFormat.REWARDED);
        }
        if (adFormats.contains("banner")) {
            adFormatsToInitialize.add(IronSourceAds.AdFormat.BANNER);
        }
        return adFormatsToInitialize;
    }

    private ISBannerSize toISBannerSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER) {
            return ISBannerSize.BANNER;
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return ISBannerSize.LARGE;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return ISBannerSize.RECTANGLE;
        }
        throw new IllegalArgumentException("Invalid ad format: " + adFormat);
    }

    private AdSize toISAdSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER) {
            return AdSize.banner();
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return AdSize.leaderboard();
        }
        if (adFormat == MaxAdFormat.MREC) {
            return AdSize.mediumRectangle();
        }
        throw new IllegalArgumentException("Invalid ad format: " + adFormat);
    }

    private static MaxAdapterError toMaxError(IronSourceError ironSourceError) {
        int ironSourceErrorCode = ironSourceError.getErrorCode();
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (ironSourceErrorCode) {
            case 1: 
            case 527: 
            case 605: 
            case 610: 
            case 611: 
            case 613: 
            case 614: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1007: 
            case 1008: 
            case 1028: 
            case 1030: 
            case 1034: 
            case 1038: 
            case 1039: 
            case 1040: 
            case 1041: 
            case 1060: 
            case 1061: 
            case 7101: 
            case 7102: 
            case 7103: 
            case 7104: 
            case 7201: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case 501: 
            case 502: 
            case 505: 
            case 506: 
            case 615: 
            case 616: 
            case 1020: 
            case 1021: 
            case 1029: 
            case 1031: 
            case 7105: 
            case 7106: 
            case 7107: 
            case 7108: 
            case 7109: 
            case 7110: 
            case 7111: 
            case 7112: 
            case 7116: 
            case 7117: 
            case 7118: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case 508: 
            case 600: 
            case 601: 
            case 602: 
            case 603: 
            case 607: 
            case 612: 
            case 1010: 
            case 7001: 
            case 7002: 
            case 7003: 
            case 7004: 
            case 7115: {
                adapterError = MaxAdapterError.NOT_INITIALIZED;
                break;
            }
            case 509: 
            case 606: 
            case 621: 
            case 1024: 
            case 1035: 
            case 1058: 
            case 1158: 
            case 3306: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case 510: {
                adapterError = MaxAdapterError.UNSPECIFIED;
                break;
            }
            case 520: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case 526: 
            case 604: {
                adapterError = MaxAdapterError.AD_FREQUENCY_CAPPED;
                break;
            }
            case 608: 
            case 609: 
            case 1032: 
            case 1033: 
            case 1052: 
            case 1055: 
            case 7113: {
                adapterError = MaxAdapterError.TIMEOUT;
                break;
            }
            case 1006: {
                adapterError = MaxAdapterError.SIGNAL_COLLECTION_TIMEOUT;
                break;
            }
            case 1022: 
            case 1023: 
            case 1026: 
            case 1027: 
            case 1036: 
            case 1037: 
            case 1050: 
            case 1053: 
            case 1056: {
                adapterError = MaxAdapterError.INVALID_LOAD_STATE;
                break;
            }
            case 1051: 
            case 1054: 
            case 7202: {
                adapterError = MaxAdapterError.AD_NOT_READY;
                break;
            }
            case 1057: {
                adapterError = MaxAdapterError.AD_EXPIRED;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), ironSourceErrorCode, ironSourceError.getErrorMessage());
    }

    private long getAdapterVersionCode() {
        String simplifiedVersionString = this.getAdapterVersion().replaceAll("[^0-9.]", "");
        String[] versionNumbers = simplifiedVersionString.split("\\.");
        long versionCode = 0L;
        for (String num : versionNumbers) {
            if ((versionCode *= 100L) != 0L && num.length() > 2) {
                versionCode += (long)Integer.parseInt(num.substring(0, 2));
                continue;
            }
            versionCode += num.isEmpty() ? 0L : (long)Integer.parseInt(num);
        }
        return versionCode;
    }

    private static class IronSourceRouter
    extends MediationAdapterRouter
    implements ISDemandOnlyInterstitialListener,
    ISDemandOnlyRewardedVideoListener {
        private boolean hasGrantedReward;

        private IronSourceRouter() {
        }

        void initialize(MaxAdapterInitializationParameters parameters, @Nullable Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        }

        public void onInterstitialAdReady(String instanceId) {
            this.log("Interstitial loaded for instance ID: " + instanceId);
            this.onAdLoaded(IronSourceRouter.getInterstitialRouterIdentifier(instanceId));
        }

        public void onInterstitialAdLoadFailed(String instanceId, IronSourceError ironSourceError) {
            this.log("Interstitial ad failed to load for instance ID: " + instanceId + " with error: " + ironSourceError);
            this.onAdLoadFailed(IronSourceRouter.getInterstitialRouterIdentifier(instanceId), IronSourceMediationAdapter.toMaxError(ironSourceError));
        }

        public void onInterstitialAdOpened(String instanceId) {
            this.log("Interstitial ad displayed for instance ID: " + instanceId);
            this.onAdDisplayed(IronSourceRouter.getInterstitialRouterIdentifier(instanceId));
        }

        public void onInterstitialAdShowFailed(String instanceId, IronSourceError ironSourceError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", ironSourceError.getErrorCode(), ironSourceError.getErrorMessage());
            this.log("Interstitial ad failed to show for instance ID: " + instanceId + " with error: " + adapterError);
            this.onAdDisplayFailed(IronSourceRouter.getInterstitialRouterIdentifier(instanceId), adapterError);
        }

        public void onInterstitialAdClicked(String instanceId) {
            this.log("Interstitial ad clicked for instance ID: " + instanceId);
            this.onAdClicked(IronSourceRouter.getInterstitialRouterIdentifier(instanceId));
        }

        public void onInterstitialAdClosed(String instanceId) {
            this.log("Interstitial ad closed for instance ID: " + instanceId);
            this.onAdHidden(IronSourceRouter.getInterstitialRouterIdentifier(instanceId));
        }

        public void onRewardedVideoAdLoadSuccess(String instanceId) {
            this.log("Rewarded ad loaded for instance ID: " + instanceId);
            this.onAdLoaded(IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId));
        }

        public void onRewardedVideoAdLoadFailed(String instanceId, IronSourceError ironSourceError) {
            this.log("Rewarded ad failed to load for instance ID: " + instanceId);
            this.onAdLoadFailed(IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId), IronSourceMediationAdapter.toMaxError(ironSourceError));
        }

        public void onRewardedVideoAdOpened(String instanceId) {
            this.log("Rewarded ad shown for instance ID: " + instanceId);
            String routerPlacementId = IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId);
            this.onAdDisplayed(routerPlacementId);
        }

        public void onRewardedVideoAdShowFailed(String instanceId, IronSourceError ironSourceError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", ironSourceError.getErrorCode(), ironSourceError.getErrorMessage());
            this.log("Rewarded ad failed to show for instance ID: " + instanceId + " with error: " + adapterError);
            this.onAdDisplayFailed(IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId), adapterError);
        }

        public void onRewardedVideoAdClicked(String instanceId) {
            this.log("Rewarded ad clicked for instance ID: " + instanceId);
            this.onAdClicked(IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId));
        }

        public void onRewardedVideoAdClosed(String instanceId) {
            String routerPlacementId = IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId);
            if (this.hasGrantedReward || this.shouldAlwaysRewardUser(routerPlacementId)) {
                MaxReward reward = this.getReward(routerPlacementId);
                this.log("Rewarded  ad rewarded user with reward: " + reward + " for instance ID: " + instanceId);
                this.onUserRewarded(routerPlacementId, reward);
            }
            this.log("Rewarded ad hidden for instance ID: " + instanceId);
            this.onAdHidden(routerPlacementId);
        }

        public void onRewardedVideoAdRewarded(String instanceId) {
            this.log("Rewarded ad granted reward for instance ID: " + instanceId);
            this.hasGrantedReward = true;
        }

        private static String getInterstitialRouterIdentifier(String instanceId) {
            return instanceId + "-" + IronSource.AD_UNIT.INTERSTITIAL;
        }

        private static String getRewardedVideoRouterIdentifier(String instanceId) {
            return instanceId + "-" + IronSource.AD_UNIT.REWARDED_VIDEO;
        }
    }

    private class BiddingInterstitialListener
    implements InterstitialAdLoaderListener,
    InterstitialAdListener {
        private final MaxInterstitialAdapterListener listener;

        BiddingInterstitialListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onInterstitialAdLoaded(@NonNull InterstitialAd ad) {
            IronSourceMediationAdapter.this.log("Interstitial loaded for bidding instance ID: " + ad.getAdInfo().getInstanceId());
            IronSourceMediationAdapter.this.biddingInterstitialAd = ad;
            this.listener.onInterstitialAdLoaded(this.createExtraInfo(ad));
        }

        public void onInterstitialAdLoadFailed(@NonNull IronSourceError ironSourceError) {
            IronSourceMediationAdapter.this.log("Interstitial ad failed to load for bidding instance with error: " + ironSourceError);
            this.listener.onInterstitialAdLoadFailed(IronSourceMediationAdapter.toMaxError(ironSourceError));
        }

        public void onInterstitialAdShown(@NonNull InterstitialAd ad) {
            IronSourceMediationAdapter.this.log("Interstitial ad displayed for bidding instance ID: " + ad.getAdInfo().getInstanceId());
            this.listener.onInterstitialAdDisplayed(this.createExtraInfo(ad));
        }

        public void onInterstitialAdFailedToShow(@NonNull InterstitialAd ad, @NonNull IronSourceError ironSourceError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", ironSourceError.getErrorCode(), ironSourceError.getErrorMessage());
            IronSourceMediationAdapter.this.log("Interstitial ad failed to show for bidding instance ID: " + ad.getAdInfo().getInstanceId() + " with error: " + adapterError);
            this.listener.onInterstitialAdDisplayFailed(adapterError, this.createExtraInfo(ad));
        }

        public void onInterstitialAdClicked(@NonNull InterstitialAd ad) {
            IronSourceMediationAdapter.this.log("Interstitial ad clicked for bidding instance ID: " + ad.getAdInfo().getInstanceId());
            this.listener.onInterstitialAdClicked(this.createExtraInfo(ad));
        }

        public void onInterstitialAdDismissed(@NonNull InterstitialAd ad) {
            IronSourceMediationAdapter.this.log("Interstitial ad closed for bidding instance ID: " + ad.getAdInfo().getInstanceId());
            this.listener.onInterstitialAdHidden(this.createExtraInfo(ad));
        }

        @Nullable
        private Bundle createExtraInfo(@NonNull InterstitialAd ad) {
            String adId = ad.getAdInfo().getAdId();
            if (TextUtils.isEmpty((CharSequence)adId)) {
                return null;
            }
            Bundle extraInfo = new Bundle(1);
            extraInfo.putString("creative_id", adId);
            return extraInfo;
        }
    }

    private class BiddingRewardedListener
    implements RewardedAdLoaderListener,
    RewardedAdListener {
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        BiddingRewardedListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onRewardedAdLoaded(@NonNull RewardedAd ad) {
            IronSourceMediationAdapter.this.log("Rewarded ad loaded for bidding instance ID: " + ad.getAdInfo().getInstanceId());
            IronSourceMediationAdapter.this.biddingRewardedAd = ad;
            this.listener.onRewardedAdLoaded(this.createExtraInfo(ad));
        }

        public void onRewardedAdLoadFailed(@NonNull IronSourceError ironSourceError) {
            IronSourceMediationAdapter.this.log("Rewarded ad failed to load for bidding instance with error: " + ironSourceError);
            this.listener.onRewardedAdLoadFailed(IronSourceMediationAdapter.toMaxError(ironSourceError));
        }

        public void onRewardedAdShown(@NonNull RewardedAd ad) {
            IronSourceMediationAdapter.this.log("Rewarded ad shown for bidding instance ID: " + ad.getAdInfo().getInstanceId());
            this.listener.onRewardedAdDisplayed(this.createExtraInfo(ad));
        }

        public void onRewardedAdFailedToShow(@NonNull RewardedAd ad, @NonNull IronSourceError ironSourceError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", ironSourceError.getErrorCode(), ironSourceError.getErrorMessage());
            IronSourceMediationAdapter.this.log("Rewarded ad failed to show for bidding instance ID: " + ad.getAdInfo().getInstanceId() + " with error: " + adapterError);
            this.listener.onRewardedAdDisplayFailed(adapterError, this.createExtraInfo(ad));
        }

        public void onRewardedAdClicked(@NonNull RewardedAd ad) {
            IronSourceMediationAdapter.this.log("Rewarded ad clicked for instance ID: " + ad.getAdInfo().getInstanceId());
            this.listener.onRewardedAdClicked(this.createExtraInfo(ad));
        }

        public void onRewardedAdDismissed(@NonNull RewardedAd ad) {
            if (this.hasGrantedReward || IronSourceMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = IronSourceMediationAdapter.this.getReward();
                IronSourceMediationAdapter.this.log("Rewarded ad rewarded user with reward: " + reward + " for instance ID: " + ad.getAdInfo().getInstanceId());
                this.listener.onUserRewarded(reward);
            }
            IronSourceMediationAdapter.this.log("Rewarded ad hidden for instance ID: " + ad.getAdInfo().getInstanceId());
            this.listener.onRewardedAdHidden(this.createExtraInfo(ad));
        }

        public void onUserEarnedReward(@NonNull RewardedAd ad) {
            IronSourceMediationAdapter.this.log("Rewarded ad granted reward for instance ID: " + ad.getAdInfo().getInstanceId());
            this.hasGrantedReward = true;
        }

        @Nullable
        private Bundle createExtraInfo(@NonNull RewardedAd ad) {
            String adId = ad.getAdInfo().getAdId();
            if (TextUtils.isEmpty((CharSequence)adId)) {
                return null;
            }
            Bundle extraInfo = new Bundle(1);
            extraInfo.putString("creative_id", adId);
            return extraInfo;
        }
    }

    private class BiddingAdViewListener
    implements BannerAdLoaderListener,
    BannerAdViewListener {
        private final MaxAdViewAdapterListener listener;

        BiddingAdViewListener(MaxAdViewAdapterListener listener) {
            this.listener = listener;
        }

        public void onBannerAdLoaded(@NonNull BannerAdView ad) {
            IronSourceMediationAdapter.this.log("AdView loaded for instance ID: " + ad.getAdInfo().getInstanceId());
            IronSourceMediationAdapter.this.biddingAdView = ad;
            IronSourceMediationAdapter.this.biddingAdView.setListener((BannerAdViewListener)this);
            this.listener.onAdViewAdLoaded((View)IronSourceMediationAdapter.this.biddingAdView, this.createExtraInfo(ad));
        }

        public void onBannerAdLoadFailed(@NonNull IronSourceError ironSourceError) {
            MaxAdapterError adapterError = IronSourceMediationAdapter.toMaxError(ironSourceError);
            IronSourceMediationAdapter.this.log("AdView ad failed to load for bidding instance with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onBannerAdClicked(@NonNull BannerAdView ad) {
            IronSourceMediationAdapter.this.log("AdView ad clicked");
            this.listener.onAdViewAdClicked(this.createExtraInfo(ad));
        }

        public void onBannerAdShown(@NonNull BannerAdView ad) {
            IronSourceMediationAdapter.this.log("AdView ad displayed");
            this.listener.onAdViewAdDisplayed(this.createExtraInfo(ad));
        }

        @Nullable
        private Bundle createExtraInfo(@NonNull BannerAdView ad) {
            String adId = ad.getAdInfo().getAdId();
            if (TextUtils.isEmpty((CharSequence)adId)) {
                return null;
            }
            Bundle extraInfo = new Bundle(1);
            extraInfo.putString("creative_id", adId);
            return extraInfo;
        }
    }

    private class AdViewListener
    implements ISDemandOnlyBannerListener {
        private final MaxAdViewAdapterListener listener;

        AdViewListener(MaxAdViewAdapterListener listener) {
            this.listener = listener;
        }

        public void onBannerAdLoaded(String instanceId) {
            IronSourceMediationAdapter.this.log("AdView loaded for instance ID: " + instanceId);
            this.listener.onAdViewAdLoaded((View)IronSourceMediationAdapter.this.adView);
        }

        public void onBannerAdLoadFailed(String instanceId, IronSourceError ironSourceError) {
            MaxAdapterError adapterError = IronSourceMediationAdapter.toMaxError(ironSourceError);
            IronSourceMediationAdapter.this.log("AdView ad failed to load for instance ID: " + instanceId + " with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onBannerAdClicked(String instanceId) {
            IronSourceMediationAdapter.this.log("AdView ad clicked for instance ID: " + instanceId);
            this.listener.onAdViewAdClicked();
        }

        public void onBannerAdShown(String instanceId) {
            loadedAdViewPlacementIdentifiers.add(instanceId);
            IronSourceMediationAdapter.this.log("AdView ad displayed for instance ID: " + instanceId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onBannerAdLeftApplication(String instanceId) {
            IronSourceMediationAdapter.this.log("AdView ad left application for instance ID: " + instanceId);
        }
    }
}

