/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxAppOpenAdapter;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxNativeAdAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAppOpenAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.adapters.MediationAdapterRouter;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.mbridge.msdk.MBridgeConstans;
import com.mbridge.msdk.foundation.same.net.Aa;
import com.mbridge.msdk.interstitialvideo.out.InterstitialVideoListener;
import com.mbridge.msdk.interstitialvideo.out.MBBidInterstitialVideoHandler;
import com.mbridge.msdk.interstitialvideo.out.MBInterstitialVideoHandler;
import com.mbridge.msdk.mbbid.out.BidConstants;
import com.mbridge.msdk.mbbid.out.BidManager;
import com.mbridge.msdk.nativex.view.MBMediaView;
import com.mbridge.msdk.out.BannerAdListener;
import com.mbridge.msdk.out.BannerSize;
import com.mbridge.msdk.out.Campaign;
import com.mbridge.msdk.out.Frame;
import com.mbridge.msdk.out.MBBannerView;
import com.mbridge.msdk.out.MBBidNativeHandler;
import com.mbridge.msdk.out.MBBidRewardVideoHandler;
import com.mbridge.msdk.out.MBConfiguration;
import com.mbridge.msdk.out.MBRewardVideoHandler;
import com.mbridge.msdk.out.MBSplashHandler;
import com.mbridge.msdk.out.MBSplashLoadListener;
import com.mbridge.msdk.out.MBSplashShowListener;
import com.mbridge.msdk.out.MBridgeIds;
import com.mbridge.msdk.out.MBridgeSDKFactory;
import com.mbridge.msdk.out.NativeListener;
import com.mbridge.msdk.out.OnMBMediaViewListener;
import com.mbridge.msdk.out.RewardInfo;
import com.mbridge.msdk.out.RewardVideoListener;
import com.mbridge.msdk.system.MBridgeSDKImpl;
import com.mbridge.msdk.video.bt.module.b.g;
import com.mbridge.msdk.widget.MBAdChoice;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class MintegralMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxAppOpenAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter,
MaxSignalProvider,
MaxNativeAdAdapter {
    private static final MintegralMediationAdapterRouter router;
    private static final AtomicBoolean initialized;
    private static final ExecutorService executor;
    private static final String APP_ID_PARAMETER = "app_id";
    private static final String APP_KEY_PARAMETER = "app_key";
    private static final String NOT_INITIALIZED = "init error";
    private static final String NO_FILL_1 = "no ads available can show";
    private static final String NO_FILL_2 = "no ads available";
    private static final String NO_FILL_3 = "no server ads available";
    private static final String NO_FILL_4 = "no ads source";
    private static final String NO_FILL_5 = "load no ad";
    private static final String NETWORK_ERROR = "network exception";
    private static final String BAD_REQUEST = "request parameter is null";
    private static final String TIMEOUT = "load timeout";
    private static final String UNIT_ID_EMPTY = "UnitId is null";
    private static final String NETWORK_IO_ERROR = "Network error,I/O exception";
    private static final String EXCEPTION_RETURN_EMPTY = "EXCEPTION_RETURN_EMPTY";
    private static final String EXCEPTION_TIMEOUT = "EXCEPTION_TIMEOUT";
    private static final String EXCEPTION_IV_RECALLNET_INVALIDATE = "EXCEPTION_IV_RECALLNET_INVALIDATE";
    private static final String EXCEPTION_SIGN_ERROR = "EXCEPTION_SIGN_ERROR";
    private static final String EXCEPTION_UNIT_NOT_FOUND = "EXCEPTION_UNIT_NOT_FOUND";
    private static final String EXCEPTION_UNIT_ID_EMPTY = "EXCEPTION_UNIT_ID_EMPTY";
    private static final String EXCEPTION_UNIT_NOT_FOUND_IN_APP = "EXCEPTION_UNIT_NOT_FOUND_IN_APP";
    private static final String EXCEPTION_UNIT_ADTYPE_ERROR = "EXCEPTION_UNIT_ADTYPE_ERROR";
    private static final String EXCEPTION_APP_ID_EMPTY = "EXCEPTION_APP_ID_EMPTY";
    private static final String EXCEPTION_APP_NOT_FOUND = "EXCEPTION_APP_NOT_FOUND";
    private static String sSdkVersion;
    private static final int DEFAULT_IMAGE_TASK_TIMEOUT_SECONDS = 5;
    private static final Map<String, MBInterstitialVideoHandler> mbInterstitialVideoHandlers;
    private static final Map<String, MBBidInterstitialVideoHandler> mbBidInterstitialVideoHandlers;
    private static final Map<String, MBRewardVideoHandler> mbRewardVideoHandlers;
    private static final Map<String, MBBidRewardVideoHandler> mbBidRewardVideoHandlers;
    private String mbUnitId;
    private MBInterstitialVideoHandler mbInterstitialVideoHandler;
    private MBBidInterstitialVideoHandler mbBidInterstitialVideoHandler;
    private MBSplashHandler mbSplashHandler;
    private MBRewardVideoHandler mbRewardVideoHandler;
    private MBBidRewardVideoHandler mbBidRewardVideoHandler;
    private MBBannerView mbBannerView;
    private MBBidNativeHandler mbBidNativeHandler;
    private MBBidNativeHandler mbBidNativeAdViewHandler;
    private Campaign nativeAdCampaign;
    private ViewGroup nativeAdContainer;
    private MaxNativeAd nativeAd;
    private List<View> clickableViews;

    public MintegralMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        MBridgeConstans.DEBUG = parameters.isTesting();
        if (initialized.compareAndSet(false, true)) {
            Boolean isAgeRestrictedUser;
            Boolean isDoNotSell;
            this.setChannelCode();
            String appId = parameters.getServerParameters().getString(APP_ID_PARAMETER);
            String appKey = parameters.getServerParameters().getString(APP_KEY_PARAMETER);
            this.log("Initializing Mintegral SDK with app id: " + appId + " and app key: " + appKey + "...");
            MBridgeSDKImpl mBridgeSDK = MBridgeSDKFactory.getMBridgeSDK();
            Context context = this.getContext(activity);
            Boolean hasUserConsent = parameters.hasUserConsent();
            if (hasUserConsent != null) {
                int consent = hasUserConsent != false ? 1 : 0;
                mBridgeSDK.setUserPrivateInfoType(context, "authority_all_info", consent);
                mBridgeSDK.setConsentStatus(context, consent);
            }
            if ((isDoNotSell = parameters.isDoNotSell()) != null && isDoNotSell.booleanValue()) {
                mBridgeSDK.setDoNotTrackStatus(context, true);
            }
            if ((isAgeRestrictedUser = parameters.isAgeRestrictedUser()) != null) {
                mBridgeSDK.setCoppaStatus(context, isAgeRestrictedUser.booleanValue());
            }
            Map map = mBridgeSDK.getMBConfigurationMap(appId, appKey);
            mBridgeSDK.init(map, context);
        }
        onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.DOES_NOT_APPLY, null);
    }

    public String getSdkVersion() {
        if (sSdkVersion == null) {
            sSdkVersion = this.getVersionString(MBConfiguration.class, "SDK_VERSION");
        }
        return sSdkVersion;
    }

    public String getAdapterVersion() {
        return "16.7.81.0";
    }

    public void onDestroy() {
        if (this.mbInterstitialVideoHandler != null) {
            this.mbInterstitialVideoHandler.setInterstitialVideoListener(null);
            this.mbInterstitialVideoHandler = null;
        }
        if (this.mbBidInterstitialVideoHandler != null) {
            this.mbBidInterstitialVideoHandler.setInterstitialVideoListener(null);
            this.mbBidInterstitialVideoHandler = null;
        }
        if (this.mbSplashHandler != null) {
            this.mbSplashHandler.onDestroy();
            this.mbSplashHandler.setSplashLoadListener(null);
            this.mbSplashHandler.setSplashShowListener(null);
            this.mbSplashHandler = null;
        }
        if (this.mbRewardVideoHandler != null) {
            this.mbRewardVideoHandler.setRewardVideoListener(null);
            this.mbRewardVideoHandler = null;
        }
        if (this.mbBidRewardVideoHandler != null) {
            this.mbBidRewardVideoHandler.setRewardVideoListener(null);
            this.mbBidRewardVideoHandler = null;
        }
        if (this.mbBannerView != null) {
            this.mbBannerView.release();
            this.mbBannerView = null;
        }
        if (this.mbBidNativeHandler != null) {
            this.mbBidNativeHandler.unregisterView((View)this.nativeAdContainer, this.clickableViews, this.nativeAdCampaign);
            this.mbBidNativeHandler.bidRelease();
            this.mbBidNativeHandler.setAdListener(null);
            this.mbBidNativeHandler = null;
        }
        if (this.mbBidNativeAdViewHandler != null) {
            this.mbBidNativeAdViewHandler.unregisterView((View)this.nativeAdContainer, this.clickableViews, this.nativeAdCampaign);
            this.mbBidNativeAdViewHandler.bidRelease();
            this.mbBidNativeAdViewHandler.setAdListener(null);
            this.mbBidNativeAdViewHandler = null;
        }
        if (this.nativeAd != null) {
            if (this.nativeAd.getMediaView() instanceof MBMediaView) {
                ((MBMediaView)this.nativeAd.getMediaView()).destory();
            }
            this.nativeAd = null;
        }
        this.nativeAdCampaign = null;
        router.removeAdapter((MaxAdapter)this, this.mbUnitId);
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, MaxSignalCollectionListener callback) {
        String signal;
        this.log("Collecting signal...");
        String adUnitId = parameters.getAdUnitId();
        if (AppLovinSdkUtils.isValidString((String)adUnitId)) {
            Bundle credentials = BundleUtils.getBundle((String)"credentials", (Bundle)Bundle.EMPTY, (Bundle)parameters.getServerParameters());
            Bundle adUnitCredentials = BundleUtils.getBundle((String)adUnitId, (Bundle)Bundle.EMPTY, (Bundle)credentials);
            HashMap<String, String> info = new HashMap<String, String>(3);
            info.put(BidConstants.BID_FILTER_KEY_PLACEMENT_ID, BundleUtils.getString((String)"placement_id", (String)"", (Bundle)adUnitCredentials));
            info.put(BidConstants.BID_FILTER_KEY_UNIT_ID, BundleUtils.getString((String)"ad_unit_id", (String)"", (Bundle)adUnitCredentials));
            info.put(BidConstants.BID_FILTER_KEY_AD_TYPE, MintegralMediationAdapter.toMintegralAdType(parameters.getAdFormat()));
            signal = BidManager.getBuyerUid((Context)this.getContext(activity), info);
        } else {
            signal = BidManager.getBuyerUid((Context)this.getContext(activity));
        }
        callback.onSignalCollected(signal);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        boolean shouldUpdateMuteState = parameters.getServerParameters().containsKey("is_muted");
        int muteState = parameters.getServerParameters().getBoolean("is_muted") ? 1 : 2;
        this.mbUnitId = parameters.getThirdPartyAdPlacementId();
        String placementId = BundleUtils.getString((String)"placement_id", (Bundle)parameters.getServerParameters());
        router.addInterstitialAdapter((MaxAdapter)this, listener, this.mbUnitId);
        if (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse())) {
            this.log("Loading bidding interstitial ad for unit id: " + this.mbUnitId + " and placement id: " + placementId + "...");
            if (mbBidInterstitialVideoHandlers.containsKey(this.mbUnitId)) {
                this.mbBidInterstitialVideoHandler = mbBidInterstitialVideoHandlers.get(this.mbUnitId);
            } else {
                this.mbBidInterstitialVideoHandler = new MBBidInterstitialVideoHandler((Context)activity, placementId, this.mbUnitId);
                mbBidInterstitialVideoHandlers.put(this.mbUnitId, this.mbBidInterstitialVideoHandler);
            }
            this.mbBidInterstitialVideoHandler.setInterstitialVideoListener(router.getInterstitialListener());
            if (shouldUpdateMuteState) {
                this.mbBidInterstitialVideoHandler.playVideoMute(muteState);
            }
            this.mbBidInterstitialVideoHandler.loadFromBid(parameters.getBidResponse());
        } else {
            this.log("Loading mediated interstitial ad for unit id: " + this.mbUnitId + " and placement id: " + placementId + "...");
            if (mbInterstitialVideoHandlers.containsKey(this.mbUnitId)) {
                this.mbInterstitialVideoHandler = mbInterstitialVideoHandlers.get(this.mbUnitId);
            } else {
                this.mbInterstitialVideoHandler = new MBInterstitialVideoHandler((Context)activity, placementId, this.mbUnitId);
                mbInterstitialVideoHandlers.put(this.mbUnitId, this.mbInterstitialVideoHandler);
            }
            this.mbInterstitialVideoHandler.setInterstitialVideoListener(router.getInterstitialListener());
            if (this.mbInterstitialVideoHandler.isReady()) {
                this.log("A mediated interstitial ad is ready already");
                if (AppLovinSdkUtils.isValidString((String)this.mbInterstitialVideoHandler.getCreativeIdWithUnitId())) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", this.mbInterstitialVideoHandler.getCreativeIdWithUnitId());
                    router.onAdLoaded(this.mbUnitId, extraInfo);
                } else {
                    router.onAdLoaded(this.mbUnitId);
                }
            } else {
                if (shouldUpdateMuteState) {
                    this.mbInterstitialVideoHandler.playVideoMute(muteState);
                }
                this.mbInterstitialVideoHandler.load();
            }
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        router.addShowingAdapter((MaxAdapter)this);
        if (this.mbBidInterstitialVideoHandler != null && this.mbBidInterstitialVideoHandler.isBidReady()) {
            this.log("Showing bidding interstitial...");
            this.mbBidInterstitialVideoHandler.showFromBid();
        } else if (this.mbInterstitialVideoHandler != null && this.mbInterstitialVideoHandler.isReady()) {
            this.log("Showing mediated interstitial...");
            this.mbInterstitialVideoHandler.show();
        } else {
            this.log("Unable to show interstitial - no ad loaded...");
            router.onAdDisplayFailed(this.mbUnitId, new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
        }
    }

    public void loadAppOpenAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxAppOpenAdapterListener listener) {
        this.mbUnitId = parameters.getThirdPartyAdPlacementId();
        String placementId = BundleUtils.getString((String)"placement_id", (Bundle)parameters.getServerParameters());
        if (activity == null) {
            this.log("App open ad \"" + placementId + "\" load failed: Activity is null");
            listener.onAppOpenAdLoadFailed(MaxAdapterError.MISSING_ACTIVITY);
            return;
        }
        this.log("Loading bidding app open ad for unit id: " + this.mbUnitId + " and placement id: " + placementId + "...");
        this.mbSplashHandler = new MBSplashHandler(activity, placementId, this.mbUnitId);
        AppOpenAdListener appOpenAdListener = new AppOpenAdListener(listener);
        this.mbSplashHandler.setSplashLoadListener((MBSplashLoadListener)appOpenAdListener);
        this.mbSplashHandler.setSplashShowListener((MBSplashShowListener)appOpenAdListener);
        this.mbSplashHandler.preLoadByToken(parameters.getBidResponse());
    }

    public void showAppOpenAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxAppOpenAdapterListener listener) {
        String bidResponse = parameters.getBidResponse();
        if (this.mbSplashHandler == null || !this.mbSplashHandler.isReady(bidResponse)) {
            this.log("Unable to show app open ad - no ad loaded...");
            listener.onAppOpenAdDisplayFailed(new MaxAdapterError(MaxAdapterError.AD_DISPLAY_FAILED, 0, "App open ad not ready"));
            return;
        }
        if (activity == null) {
            this.log("App open ad \"" + this.mbUnitId + "\" display failed: Activity is null");
            listener.onAppOpenAdDisplayFailed(MaxAdapterError.MISSING_ACTIVITY);
            return;
        }
        this.log("Showing app open ad...");
        RelativeLayout container = new RelativeLayout(this.getContext(activity));
        ViewGroup contentViewGroup = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
        contentViewGroup.addView((View)container);
        this.mbSplashHandler.show((ViewGroup)container, bidResponse);
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        boolean shouldUpdateMuteState = parameters.getServerParameters().containsKey("is_muted");
        int muteState = parameters.getServerParameters().getBoolean("is_muted") ? 1 : 2;
        this.mbUnitId = parameters.getThirdPartyAdPlacementId();
        String placementId = BundleUtils.getString((String)"placement_id", (Bundle)parameters.getServerParameters());
        router.addRewardedAdapter((MaxAdapter)this, listener, this.mbUnitId);
        if (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse())) {
            this.log("Loading bidding rewarded ad for unit id: " + this.mbUnitId + " and placement id: " + placementId + "...");
            if (mbBidRewardVideoHandlers.containsKey(this.mbUnitId)) {
                this.mbBidRewardVideoHandler = mbBidRewardVideoHandlers.get(this.mbUnitId);
            } else {
                this.mbBidRewardVideoHandler = new MBBidRewardVideoHandler((Context)activity, placementId, this.mbUnitId);
                mbBidRewardVideoHandlers.put(this.mbUnitId, this.mbBidRewardVideoHandler);
            }
            this.mbBidRewardVideoHandler.setRewardVideoListener((g)router.getRewardedListener());
            if (shouldUpdateMuteState) {
                this.mbBidRewardVideoHandler.playVideoMute(muteState);
            }
            this.mbBidRewardVideoHandler.loadFromBid(parameters.getBidResponse());
        } else {
            this.log("Loading mediated rewarded ad for unit id: " + this.mbUnitId + " and placement id: " + placementId + "...");
            if (mbRewardVideoHandlers.containsKey(this.mbUnitId)) {
                this.mbRewardVideoHandler = mbRewardVideoHandlers.get(this.mbUnitId);
            } else {
                this.mbRewardVideoHandler = new MBRewardVideoHandler((Context)activity, placementId, this.mbUnitId);
                mbRewardVideoHandlers.put(this.mbUnitId, this.mbRewardVideoHandler);
            }
            this.mbRewardVideoHandler.setRewardVideoListener((g)router.getRewardedListener());
            if (this.mbRewardVideoHandler.isReady()) {
                this.log("A mediated rewarded ad is ready already");
                if (AppLovinSdkUtils.isValidString((String)this.mbRewardVideoHandler.getCreativeIdWithUnitId())) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", this.mbRewardVideoHandler.getCreativeIdWithUnitId());
                    router.onAdLoaded(this.mbUnitId, extraInfo);
                } else {
                    router.onAdLoaded(this.mbUnitId);
                }
            } else {
                if (shouldUpdateMuteState) {
                    this.mbRewardVideoHandler.playVideoMute(muteState);
                }
                this.mbRewardVideoHandler.load();
            }
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        router.addShowingAdapter((MaxAdapter)this);
        this.configureReward(parameters);
        Bundle serverParameters = parameters.getServerParameters();
        String rewardId = serverParameters.getString("reward_id", "");
        String userId = serverParameters.getString("user_id", "");
        if (this.mbBidRewardVideoHandler != null && this.mbBidRewardVideoHandler.isBidReady()) {
            this.log("Showing bidding rewarded ad...");
            this.mbBidRewardVideoHandler.showFromBid(rewardId, userId);
        } else if (this.mbRewardVideoHandler != null && this.mbRewardVideoHandler.isReady()) {
            this.log("Showing mediated rewarded ad...");
            this.mbRewardVideoHandler.show(rewardId, userId);
        } else {
            this.log("Unable to show rewarded ad - no ad loaded...");
            router.onAdDisplayFailed(this.mbUnitId, new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, final MaxAdViewAdapterListener listener) {
        this.mbUnitId = parameters.getThirdPartyAdPlacementId();
        String placementId = BundleUtils.getString((String)"placement_id", (Bundle)parameters.getServerParameters());
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        this.log("Loading" + (isNative ? " native " : " ") + adFormat.getLabel() + " AdView ad for placement: " + placementId + "...");
        if (isNative) {
            Map properties = MBBidNativeHandler.getNativeProperties((String)placementId, (String)this.mbUnitId);
            properties.put("ad_num", 1);
            properties.put("videoSupport", true);
            NativeAdViewListener nativeAdViewListener = new NativeAdViewListener(parameters, adFormat, this.getContext(activity), listener);
            this.mbBidNativeAdViewHandler = new MBBidNativeHandler(properties, this.getContext(activity));
            this.mbBidNativeAdViewHandler.setAdListener((NativeListener.NativeAdListener)nativeAdViewListener);
            this.mbBidNativeAdViewHandler.bidLoad(parameters.getBidResponse());
        } else {
            this.mbBannerView = new MBBannerView(this.getContext(activity));
            this.mbBannerView.init(this.toBannerSize(adFormat), placementId, this.mbUnitId);
            this.mbBannerView.setAllowShowCloseBtn(false);
            this.mbBannerView.setRefreshTime(0);
            this.mbBannerView.setBannerAdListener(new BannerAdListener(){

                public void onLoadSuccessed(MBridgeIds mBridgeIds) {
                    MintegralMediationAdapter.this.log("Banner ad loaded for: " + mBridgeIds);
                    if (AppLovinSdkUtils.isValidString((String)MintegralMediationAdapter.this.mbBannerView.getCreativeIdWithUnitId())) {
                        Bundle extraInfo = new Bundle(1);
                        extraInfo.putString("creative_id", MintegralMediationAdapter.this.mbBannerView.getCreativeIdWithUnitId());
                        listener.onAdViewAdLoaded((View)MintegralMediationAdapter.this.mbBannerView, extraInfo);
                    } else {
                        listener.onAdViewAdLoaded((View)MintegralMediationAdapter.this.mbBannerView);
                    }
                }

                public void onLoadFailed(MBridgeIds mBridgeIds, String msg) {
                    MintegralMediationAdapter.this.log("Banner ad failed to load: " + msg + " for: " + mBridgeIds);
                    listener.onAdViewAdLoadFailed(MintegralMediationAdapter.toMaxError(msg));
                }

                public void onLogImpression(MBridgeIds mBridgeIds) {
                    MintegralMediationAdapter.this.log("Banner ad displayed");
                    listener.onAdViewAdDisplayed();
                }

                public void onClick(MBridgeIds mBridgeIds) {
                    MintegralMediationAdapter.this.log("Banner ad clicked");
                    listener.onAdViewAdClicked();
                }

                public void onLeaveApp(MBridgeIds mBridgeIds) {
                    MintegralMediationAdapter.this.log("Banner ad will leave application");
                }

                public void showFullScreen(MBridgeIds mBridgeIds) {
                    MintegralMediationAdapter.this.log("Banner ad expanded");
                    listener.onAdViewAdExpanded();
                }

                public void closeFullScreen(MBridgeIds mBridgeIds) {
                    MintegralMediationAdapter.this.log("Banner ad collapsed");
                    listener.onAdViewAdCollapsed();
                }

                public void onCloseBanner(MBridgeIds mBridgeIds) {
                    MintegralMediationAdapter.this.log("Banner ad closed");
                }
            });
            if (AppLovinSdkUtils.isValidString((String)parameters.getBidResponse())) {
                this.mbBannerView.loadFromBid(parameters.getBidResponse());
            } else {
                this.mbBannerView.load();
            }
        }
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, Activity activity, MaxNativeAdAdapterListener listener) {
        this.mbUnitId = parameters.getThirdPartyAdPlacementId();
        String placementId = BundleUtils.getString((String)"placement_id", (Bundle)parameters.getServerParameters());
        this.log("Loading bidding native ad for unit id: " + this.mbUnitId + " and placement id: " + placementId + "...");
        Map properties = MBBidNativeHandler.getNativeProperties((String)placementId, (String)this.mbUnitId);
        properties.put("ad_num", 1);
        properties.put("videoSupport", true);
        NativeAdListener nativeAdListener = new NativeAdListener(parameters, this.getContext(activity), listener);
        this.mbBidNativeHandler = new MBBidNativeHandler(properties, this.getContext(activity));
        this.mbBidNativeHandler.setAdListener((NativeListener.NativeAdListener)nativeAdListener);
        this.mbBidNativeHandler.bidLoad(parameters.getBidResponse());
    }

    private MaxNativeAdView createMaxNativeAdViewWithNativeAd(MaxNativeAd maxNativeAd, String templateName, Context context) {
        if (templateName.contains("vertical")) {
            if (templateName.equals("vertical")) {
                String verticalTemplateName = maxNativeAd.getFormat() == MaxAdFormat.LEADER ? "vertical_leader_template" : "vertical_media_banner_template";
                return new MaxNativeAdView(maxNativeAd, verticalTemplateName, context);
            }
            return new MaxNativeAdView(maxNativeAd, templateName, context);
        }
        return new MaxNativeAdView(maxNativeAd, AppLovinSdkUtils.isValidString((String)templateName) ? templateName : "media_banner_template", context);
    }

    private ExecutorService getExecutorServiceToUse() {
        if (AppLovinSdk.VERSION_CODE >= 11000000) {
            return this.getCachingExecutorService();
        }
        return executor;
    }

    private static String toMintegralAdType(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.INTERSTITIAL) {
            return BidConstants.BID_FILTER_VALUE_AD_TYPE_INTERSTITIAL_VIDEO;
        }
        if (adFormat == MaxAdFormat.REWARDED) {
            return BidConstants.BID_FILTER_VALUE_AD_TYPE_REWARD_VIDEO;
        }
        if (adFormat == MaxAdFormat.APP_OPEN) {
            return BidConstants.BID_FILTER_VALUE_AD_TYPE_SPLASH;
        }
        if (adFormat == MaxAdFormat.BANNER || adFormat == MaxAdFormat.LEADER || adFormat == MaxAdFormat.MREC) {
            return BidConstants.BID_FILTER_VALUE_AD_TYPE_BANNER;
        }
        if (adFormat == MaxAdFormat.NATIVE) {
            return BidConstants.BID_FILTER_VALUE_AD_TYPE_NATIVE;
        }
        return "-1";
    }

    private static MaxAdapterError toMaxError(String mintegralError) {
        MaxAdapterError adapterError = NOT_INITIALIZED.equals(mintegralError) || mintegralError.contains(EXCEPTION_IV_RECALLNET_INVALIDATE) ? MaxAdapterError.NOT_INITIALIZED : (mintegralError.contains(NO_FILL_1) || mintegralError.contains(NO_FILL_2) || mintegralError.contains(NO_FILL_3) || mintegralError.contains(NO_FILL_4) || mintegralError.contains(NO_FILL_5) || mintegralError.contains(EXCEPTION_RETURN_EMPTY) ? MaxAdapterError.NO_FILL : (NETWORK_ERROR.equalsIgnoreCase(mintegralError) || mintegralError.contains(NETWORK_IO_ERROR) ? MaxAdapterError.NO_CONNECTION : (BAD_REQUEST.equalsIgnoreCase(mintegralError) ? MaxAdapterError.BAD_REQUEST : (TIMEOUT.equalsIgnoreCase(mintegralError) || mintegralError.contains(EXCEPTION_TIMEOUT) ? MaxAdapterError.TIMEOUT : (mintegralError.contains(EXCEPTION_SIGN_ERROR) || mintegralError.contains(EXCEPTION_UNIT_NOT_FOUND) || mintegralError.contains(EXCEPTION_UNIT_ID_EMPTY) || mintegralError.contains(EXCEPTION_UNIT_NOT_FOUND_IN_APP) || mintegralError.contains(EXCEPTION_UNIT_ADTYPE_ERROR) || mintegralError.contains(EXCEPTION_APP_ID_EMPTY) || mintegralError.contains(EXCEPTION_APP_NOT_FOUND) || mintegralError.contains(UNIT_ID_EMPTY) ? MaxAdapterError.INVALID_CONFIGURATION : MaxAdapterError.UNSPECIFIED)))));
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), 0, mintegralError);
    }

    private Context getContext(Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private BannerSize toBannerSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER || adFormat == MaxAdFormat.LEADER) {
            return new BannerSize(3, 0, 0);
        }
        if (adFormat == MaxAdFormat.MREC) {
            return new BannerSize(2, 0, 0);
        }
        throw new IllegalArgumentException("Unsupported ad format: " + adFormat);
    }

    private List<View> getClickableViews(MaxNativeAdView maxNativeAdView) {
        if (AppLovinSdk.VERSION_CODE < 11050300) {
            ArrayList<View> clickableViews = new ArrayList<View>(5);
            if (maxNativeAdView.getTitleTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getTitleTextView());
            }
            if (maxNativeAdView.getAdvertiserTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getAdvertiserTextView());
            }
            if (maxNativeAdView.getBodyTextView() != null) {
                clickableViews.add((View)maxNativeAdView.getBodyTextView());
            }
            if (maxNativeAdView.getCallToActionButton() != null) {
                clickableViews.add((View)maxNativeAdView.getCallToActionButton());
            }
            if (maxNativeAdView.getIconImageView() != null) {
                clickableViews.add((View)maxNativeAdView.getIconImageView());
            }
            return clickableViews;
        }
        return maxNativeAdView.getClickableViews();
    }

    private void setChannelCode() {
        try {
            Class<Aa> mintegralSdkClass = Aa.class;
            Method method = mintegralSdkClass.getDeclaredMethod("b", String.class);
            method.setAccessible(true);
            method.invoke(mintegralSdkClass, "Y+H6DFttYrPQYcI9+F2F+F5/Hv==");
        }
        catch (Throwable th) {
            this.e("Failed to set channel code", th);
        }
    }

    static {
        initialized = new AtomicBoolean();
        executor = Executors.newCachedThreadPool();
        mbInterstitialVideoHandlers = new HashMap<String, MBInterstitialVideoHandler>();
        mbBidInterstitialVideoHandlers = new HashMap<String, MBBidInterstitialVideoHandler>();
        mbRewardVideoHandlers = new HashMap<String, MBRewardVideoHandler>();
        mbBidRewardVideoHandlers = new HashMap<String, MBBidRewardVideoHandler>();
        router = (MintegralMediationAdapterRouter)MediationAdapterRouter.getSharedInstance(MintegralMediationAdapterRouter.class);
    }

    private static class MintegralMediationAdapterRouter
    extends MediationAdapterRouter {
        private final InterstitialVideoListener interstitialVideoListener = new InterstitialVideoListener(){

            public void onVideoLoadSuccess(MBridgeIds mBridgeIds) {
                this.log("Interstitial successfully loaded and video has been downloaded for: " + mBridgeIds);
                String unitId = mBridgeIds.getUnitId();
                MBInterstitialVideoHandler mbInterstitialVideoHandler = (MBInterstitialVideoHandler)mbInterstitialVideoHandlers.get(unitId);
                MBBidInterstitialVideoHandler mbBidInterstitialVideoHandler = (MBBidInterstitialVideoHandler)mbBidInterstitialVideoHandlers.get(unitId);
                String creativeId = mbBidInterstitialVideoHandler != null ? mbBidInterstitialVideoHandler.getCreativeIdWithUnitId() : mbInterstitialVideoHandler.getCreativeIdWithUnitId();
                if (AppLovinSdkUtils.isValidString((String)creativeId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", creativeId);
                    this.onAdLoaded(unitId, extraInfo);
                } else {
                    this.onAdLoaded(unitId);
                }
            }

            public void onLoadSuccess(MBridgeIds mBridgeIds) {
                this.log("Interstitial successfully loaded but video still needs to be downloaded for: " + mBridgeIds);
            }

            public void onVideoLoadFail(MBridgeIds mBridgeIds, String errorMsg) {
                this.log("Interstitial failed to load: " + errorMsg + " for: " + mBridgeIds);
                this.onAdLoadFailed(mBridgeIds.getUnitId(), MintegralMediationAdapter.toMaxError(errorMsg));
            }

            public void onAdShow(MBridgeIds mBridgeIds) {
                this.log("Interstitial displayed");
                this.onAdDisplayed(mBridgeIds.getUnitId());
            }

            public void onShowFail(MBridgeIds mBridgeIds, String errorMsg) {
                MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", 0, errorMsg);
                this.log("Interstitial failed to show: " + adapterError);
                this.onAdDisplayFailed(mBridgeIds.getUnitId(), adapterError);
            }

            public void onVideoAdClicked(MBridgeIds mBridgeIds) {
                this.log("Interstitial clicked");
                this.onAdClicked(mBridgeIds.getUnitId());
            }

            public void onAdClose(MBridgeIds mBridgeIds, RewardInfo rewardInfo) {
                this.log("Interstitial hidden");
                this.onAdHidden(mBridgeIds.getUnitId());
            }

            public void onVideoComplete(MBridgeIds mBridgeIds) {
                this.log("Interstitial video completed");
            }

            public void onAdCloseWithIVReward(MBridgeIds mBridgeIds, RewardInfo rewardInfo) {
                this.log("Interstitial with reward hidden");
            }

            public void onEndcardShow(MBridgeIds mBridgeIds) {
                this.log("Interstitial endcard shown");
            }
        };
        private final RewardVideoListener rewardVideoListener = new RewardVideoListener(){

            public void onVideoLoadSuccess(MBridgeIds mBridgeIds) {
                this.log("Rewarded ad successfully loaded and video has been downloaded for: " + mBridgeIds);
                String unitId = mBridgeIds.getUnitId();
                MBRewardVideoHandler mbRewardVideoHandler = (MBRewardVideoHandler)mbRewardVideoHandlers.get(unitId);
                MBBidRewardVideoHandler mbBidRewardVideoHandler = (MBBidRewardVideoHandler)mbBidRewardVideoHandlers.get(unitId);
                String creativeId = mbBidRewardVideoHandler != null ? mbBidRewardVideoHandler.getCreativeIdWithUnitId() : mbRewardVideoHandler.getCreativeIdWithUnitId();
                if (AppLovinSdkUtils.isValidString((String)creativeId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", creativeId);
                    this.onAdLoaded(unitId, extraInfo);
                } else {
                    this.onAdLoaded(unitId);
                }
            }

            public void onLoadSuccess(MBridgeIds mBridgeIds) {
                this.log("Rewarded ad successfully loaded but video still needs to be downloaded for: " + mBridgeIds);
            }

            public void onVideoLoadFail(MBridgeIds mBridgeIds, String errorMsg) {
                this.log("Rewarded ad failed to load: " + errorMsg + " for: " + mBridgeIds);
                this.onAdLoadFailed(mBridgeIds.getUnitId(), MintegralMediationAdapter.toMaxError(errorMsg));
            }

            public void onAdShow(MBridgeIds mBridgeIds) {
                this.log("Rewarded ad displayed");
                String unitId = mBridgeIds.getUnitId();
                this.onAdDisplayed(unitId);
            }

            public void onShowFail(MBridgeIds mBridgeIds, String errorMsg) {
                MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", 0, errorMsg);
                this.log("Rewarded ad failed to show: " + adapterError);
                this.onAdDisplayFailed(mBridgeIds.getUnitId(), adapterError);
            }

            public void onVideoAdClicked(MBridgeIds mBridgeIds) {
                this.log("Rewarded ad clicked");
                this.onAdClicked(mBridgeIds.getUnitId());
            }

            public void onAdClose(MBridgeIds mBridgeIds, RewardInfo rewardInfo) {
                this.log("Rewarded ad hidden");
                String unitId = mBridgeIds.getUnitId();
                if (rewardInfo.isCompleteView()) {
                    this.onUserRewarded(unitId, this.getReward(unitId));
                } else if (this.shouldAlwaysRewardUser(unitId)) {
                    this.onUserRewarded(unitId, this.getReward(unitId));
                }
                this.onAdHidden(unitId);
            }

            public void onVideoComplete(MBridgeIds mBridgeIds) {
                this.log("Rewarded ad video completed");
            }

            public void onEndcardShow(MBridgeIds mBridgeIds) {
                this.log("Rewarded ad endcard shown");
            }
        };

        private MintegralMediationAdapterRouter() {
        }

        InterstitialVideoListener getInterstitialListener() {
            return this.interstitialVideoListener;
        }

        RewardVideoListener getRewardedListener() {
            return this.rewardVideoListener;
        }

        void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        }
    }

    private class AppOpenAdListener
    implements MBSplashLoadListener,
    MBSplashShowListener {
        private final MaxAppOpenAdapterListener listener;

        private AppOpenAdListener(MaxAppOpenAdapterListener listener) {
            this.listener = listener;
        }

        public void onLoadSuccessed(MBridgeIds mBridgeIds, int requestType) {
            MintegralMediationAdapter.this.log("App open ad loaded for: " + mBridgeIds);
            Bundle extraInfo = null;
            String creativeId = MintegralMediationAdapter.this.mbSplashHandler.getCreativeIdWithUnitId();
            if (AppLovinSdkUtils.isValidString((String)creativeId)) {
                extraInfo = new Bundle(1);
                extraInfo.putString("creative_id", creativeId);
            }
            this.listener.onAppOpenAdLoaded(extraInfo);
        }

        public void onLoadFailed(MBridgeIds mBridgeIds, String errorMsg, int requestType) {
            MaxAdapterError adapterError = MintegralMediationAdapter.toMaxError(errorMsg);
            MintegralMediationAdapter.this.log("App open ad failed to load: " + adapterError);
            this.listener.onAppOpenAdLoadFailed(adapterError);
        }

        public void isSupportZoomOut(MBridgeIds mBridgeIds, boolean supportsZoomOut) {
            MintegralMediationAdapter.this.log("App open ad supports zoom out: " + supportsZoomOut);
        }

        public void onShowSuccessed(MBridgeIds mBridgeIds) {
            MintegralMediationAdapter.this.log("App open ad displayed");
            this.listener.onAppOpenAdDisplayed();
        }

        public void onShowFailed(MBridgeIds mBridgeIds, String errorMsg) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", 0, errorMsg);
            MintegralMediationAdapter.this.log("App open ad failed to show: " + adapterError);
            this.listener.onAppOpenAdDisplayFailed(adapterError);
        }

        public void onAdClicked(MBridgeIds mBridgeIds) {
            MintegralMediationAdapter.this.log("App open ad clicked");
            this.listener.onAppOpenAdClicked();
        }

        public void onDismiss(MBridgeIds mBridgeIds, int dismissType) {
            MintegralMediationAdapter.this.log("App open ad hidden");
            this.listener.onAppOpenAdHidden();
        }

        public void onAdTick(MBridgeIds mBridgeIds, long timeUntilFinishedMillis) {
            MintegralMediationAdapter.this.log("App open ad ticked with " + timeUntilFinishedMillis + " ms remaining");
        }

        public void onZoomOutPlayStart(MBridgeIds mBridgeIds) {
            MintegralMediationAdapter.this.log("App open ad zoom out started");
        }

        public void onZoomOutPlayFinish(MBridgeIds mBridgeIds) {
            MintegralMediationAdapter.this.log("App open ad zoom out finished");
        }
    }

    private class NativeAdViewListener
    implements NativeListener.NativeAdListener,
    OnMBMediaViewListener {
        private final Bundle serverParameters;
        private final MaxAdFormat adFormat;
        private final Context context;
        private final MaxAdViewAdapterListener listener;
        private final String unitId;
        private final String placementId;

        NativeAdViewListener(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Context context, MaxAdViewAdapterListener listener) {
            this.serverParameters = parameters.getServerParameters();
            this.adFormat = adFormat;
            this.context = context;
            this.listener = listener;
            this.unitId = parameters.getThirdPartyAdPlacementId();
            this.placementId = BundleUtils.getString((String)"placement_id", (Bundle)parameters.getServerParameters());
        }

        public void onAdLoaded(List<Campaign> campaigns, int templates) {
            if (campaigns == null || campaigns.isEmpty()) {
                MintegralMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load for unit id: " + this.unitId + " placement id: " + this.placementId + " with error: no fill");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            final Campaign campaign = campaigns.get(0);
            if (TextUtils.isEmpty((CharSequence)campaign.getAppName())) {
                MintegralMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load for unit id: " + this.unitId + " placement id: " + this.placementId + " with error: missing required assets");
                this.listener.onAdViewAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                return;
            }
            MintegralMediationAdapter.this.nativeAdCampaign = campaign;
            MintegralMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded for unit id: " + this.unitId + " placement id: " + this.placementId);
            MintegralMediationAdapter.this.getExecutorServiceToUse().submit(new Runnable(){

                @Override
                public void run() {
                    String iconUrl = campaign.getIconUrl();
                    String mainImageUrl = campaign.getImageUrl();
                    Future iconDrawableFuture = MintegralMediationAdapter.this.createDrawableFuture(iconUrl, NativeAdViewListener.this.context.getResources());
                    MaxNativeAd.MaxNativeAdImage iconImage = null;
                    Uri uri = Uri.parse((String)mainImageUrl);
                    MaxNativeAd.MaxNativeAdImage mainImage = new MaxNativeAd.MaxNativeAdImage(uri);
                    try {
                        int imageTaskTimeoutSeconds = BundleUtils.getInt((String)"image_task_timeout_seconds", (int)5, (Bundle)NativeAdViewListener.this.serverParameters);
                        Drawable iconDrawable = (Drawable)iconDrawableFuture.get(imageTaskTimeoutSeconds, TimeUnit.SECONDS);
                        if (iconDrawable != null) {
                            iconImage = new MaxNativeAd.MaxNativeAdImage(iconDrawable);
                        }
                    }
                    catch (Throwable th) {
                        MintegralMediationAdapter.this.log("Failed to fetch icon image from URL: " + iconUrl, th);
                    }
                    final MaxNativeAd.MaxNativeAdImage finalIconImage = iconImage;
                    AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MBMediaView mediaView = new MBMediaView(NativeAdViewListener.this.context);
                            mediaView.setNativeAd(campaign);
                            mediaView.setOnMediaViewListener((OnMBMediaViewListener)NativeAdViewListener.this);
                            MBAdChoice adChoiceView = new MBAdChoice(NativeAdViewListener.this.context);
                            adChoiceView.setCampaign(campaign);
                            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(NativeAdViewListener.this.adFormat).setTitle(campaign.getAppName()).setBody(campaign.getAppDesc()).setCallToAction(campaign.getAdCall()).setIcon(finalIconImage).setOptionsView((View)adChoiceView).setMediaView((View)mediaView);
                            MintegralMediationAdapter.this.nativeAd = new MaxMintegralNativeAd(builder);
                            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)NativeAdViewListener.this.serverParameters);
                            MaxNativeAdView maxNativeAdView = MintegralMediationAdapter.this.createMaxNativeAdViewWithNativeAd(MintegralMediationAdapter.this.nativeAd, templateName, NativeAdViewListener.this.context);
                            MintegralMediationAdapter.this.nativeAd.prepareForInteraction(MintegralMediationAdapter.this.getClickableViews(maxNativeAdView), (ViewGroup)maxNativeAdView);
                            NativeAdViewListener.this.listener.onAdViewAdLoaded((View)maxNativeAdView);
                        }
                    });
                }
            });
        }

        public void onAdLoadError(String message) {
            MaxAdapterError error = MintegralMediationAdapter.toMaxError(message);
            MintegralMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load for unit id: " + this.unitId + " placement id: " + this.placementId + " with error: " + error);
            this.listener.onAdViewAdLoadFailed(error);
        }

        public void onLoggingImpression(int adSourceType) {
            MintegralMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad shown for unit id: " + this.unitId + " placement id: " + this.placementId);
            this.listener.onAdViewAdDisplayed(null);
        }

        public void onAdClick(Campaign campaign) {
            MintegralMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad clicked for unit id: " + this.unitId + " placement id: " + this.placementId);
            this.listener.onAdViewAdClicked();
        }

        public void onAdFramesLoaded(List<Frame> list) {
            MintegralMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad frames loaded for unit id: " + this.unitId + " placement id: " + this.placementId);
        }

        public void onEnterFullscreen() {
            MintegralMediationAdapter.this.log("Media view entered fullscreen");
        }

        public void onExitFullscreen() {
            MintegralMediationAdapter.this.log("Media view exited fullscreen");
        }

        public void onStartRedirection(Campaign campaign, String url) {
            MintegralMediationAdapter.this.log("Media view started redirection with url: " + url);
        }

        public void onFinishRedirection(Campaign campaign, String url) {
            MintegralMediationAdapter.this.log("Media view finished redirection with url: " + url);
        }

        public void onRedirectionFailed(Campaign campaign, String url) {
            MintegralMediationAdapter.this.log("Media view redirection failed with url: " + url);
        }

        public void onVideoAdClicked(Campaign campaign) {
            MintegralMediationAdapter.this.log("Media view clicked for unit id: " + this.unitId + " placement id: " + this.placementId);
            this.listener.onAdViewAdClicked();
        }

        public void onVideoStart() {
            MintegralMediationAdapter.this.log("Media view video started");
        }
    }

    private class NativeAdListener
    implements NativeListener.NativeAdListener,
    OnMBMediaViewListener {
        private final MaxAdapterResponseParameters parameters;
        private final Context context;
        private final MaxNativeAdAdapterListener listener;
        private final String unitId;
        private final String placementId;

        NativeAdListener(MaxAdapterResponseParameters parameters, Context context, MaxNativeAdAdapterListener listener) {
            this.parameters = parameters;
            this.context = context;
            this.listener = listener;
            this.unitId = parameters.getThirdPartyAdPlacementId();
            this.placementId = BundleUtils.getString((String)"placement_id", (Bundle)parameters.getServerParameters());
        }

        public void onAdLoaded(List<Campaign> campaigns, int templates) {
            if (campaigns == null || campaigns.isEmpty()) {
                MintegralMediationAdapter.this.log("Native ad failed to load for unit id: " + this.unitId + " placement id: " + this.placementId + " with error: no fill");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            Campaign campaign = campaigns.get(0);
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.parameters.getServerParameters());
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)campaign.getAppName())) {
                MintegralMediationAdapter.this.log("Native ad failed to load for unit id: " + this.unitId + " placement id: " + this.placementId + " with error: missing required assets");
                this.listener.onNativeAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                return;
            }
            MintegralMediationAdapter.this.nativeAdCampaign = campaign;
            MintegralMediationAdapter.this.log("Native ad loaded for unit id: " + this.unitId + " placement id: " + this.placementId);
            this.processNativeAd(campaign);
        }

        public void onAdLoadError(String message) {
            MaxAdapterError error = MintegralMediationAdapter.toMaxError(message);
            MintegralMediationAdapter.this.log("Native ad failed to load for unit id: " + this.unitId + " placement id: " + this.placementId + " with error: " + error);
            this.listener.onNativeAdLoadFailed(error);
        }

        public void onLoggingImpression(int adSourceType) {
            MintegralMediationAdapter.this.log("Native ad shown for unit id: " + this.unitId + " placement id: " + this.placementId);
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdClick(Campaign campaign) {
            MintegralMediationAdapter.this.log("Native ad clicked for unit id: " + this.unitId + " placement id: " + this.placementId);
            this.listener.onNativeAdClicked();
        }

        public void onAdFramesLoaded(List<Frame> list) {
            MintegralMediationAdapter.this.log("Native ad frames loaded for unit id: " + this.unitId + " placement id: " + this.placementId);
        }

        public void onEnterFullscreen() {
            MintegralMediationAdapter.this.log("Media view entered fullscreen");
        }

        public void onExitFullscreen() {
            MintegralMediationAdapter.this.log("Media view exited fullscreen");
        }

        public void onStartRedirection(Campaign campaign, String url) {
            MintegralMediationAdapter.this.log("Media view started redirection with url: " + url);
        }

        public void onFinishRedirection(Campaign campaign, String url) {
            MintegralMediationAdapter.this.log("Media view finished redirection with url: " + url);
        }

        public void onRedirectionFailed(Campaign campaign, String url) {
            MintegralMediationAdapter.this.log("Media view redirection failed with url: " + url);
        }

        public void onVideoAdClicked(Campaign campaign) {
            MintegralMediationAdapter.this.log("Media view clicked for unit id: " + this.unitId + " placement id: " + this.placementId);
            this.listener.onNativeAdClicked();
        }

        public void onVideoStart() {
            MintegralMediationAdapter.this.log("Media view video started");
        }

        private void processNativeAd(final Campaign campaign) {
            MintegralMediationAdapter.this.getExecutorServiceToUse().submit(new Runnable(){

                @Override
                public void run() {
                    String iconUrl = campaign.getIconUrl();
                    String mainImageUrl = campaign.getImageUrl();
                    Future iconDrawableFuture = MintegralMediationAdapter.this.createDrawableFuture(iconUrl, NativeAdListener.this.context.getResources());
                    MaxNativeAd.MaxNativeAdImage iconImage = null;
                    Uri uri = Uri.parse((String)mainImageUrl);
                    final MaxNativeAd.MaxNativeAdImage mainImage = new MaxNativeAd.MaxNativeAdImage(uri);
                    try {
                        int imageTaskTimeoutSeconds = BundleUtils.getInt((String)"image_task_timeout_seconds", (int)5, (Bundle)NativeAdListener.this.parameters.getServerParameters());
                        Drawable iconDrawable = (Drawable)iconDrawableFuture.get(imageTaskTimeoutSeconds, TimeUnit.SECONDS);
                        if (iconDrawable != null) {
                            iconImage = new MaxNativeAd.MaxNativeAdImage(iconDrawable);
                        }
                    }
                    catch (Throwable th) {
                        MintegralMediationAdapter.this.log("Failed to fetch icon image from URL: " + iconUrl, th);
                    }
                    final MaxNativeAd.MaxNativeAdImage finalIconImage = iconImage;
                    AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MBMediaView mediaView = new MBMediaView(NativeAdListener.this.context);
                            mediaView.setNativeAd(campaign);
                            mediaView.setOnMediaViewListener((OnMBMediaViewListener)NativeAdListener.this);
                            MBAdChoice adChoiceView = new MBAdChoice(NativeAdListener.this.context);
                            adChoiceView.setCampaign(campaign);
                            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(campaign.getAppName()).setBody(campaign.getAppDesc()).setCallToAction(campaign.getAdCall()).setIcon(finalIconImage).setOptionsView((View)adChoiceView).setMediaView((View)mediaView);
                            if (AppLovinSdk.VERSION_CODE >= 11040399) {
                                builder.setMainImage(mainImage);
                            }
                            if (AppLovinSdk.VERSION_CODE >= 11070000) {
                                builder.setStarRating(Double.valueOf(campaign.getRating()));
                            }
                            MintegralMediationAdapter.this.nativeAd = new MaxMintegralNativeAd(builder);
                            NativeAdListener.this.listener.onNativeAdLoaded(MintegralMediationAdapter.this.nativeAd, null);
                        }
                    });
                }
            });
        }
    }

    private class MaxMintegralNativeAd
    extends MaxNativeAd {
        public MaxMintegralNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
            this.prepareForInteraction(MintegralMediationAdapter.this.getClickableViews(maxNativeAdView), (ViewGroup)maxNativeAdView);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            Campaign nativeAdCampaign = MintegralMediationAdapter.this.nativeAdCampaign;
            if (nativeAdCampaign == null) {
                MintegralMediationAdapter.this.e("Failed to register native ad views: native ad is null.");
                return false;
            }
            MintegralMediationAdapter.this.d("Preparing views for interaction: " + clickableViews + " with container: " + container);
            if (this.getFormat() == MaxAdFormat.NATIVE) {
                if (MintegralMediationAdapter.this.mbBidNativeHandler != null) {
                    MintegralMediationAdapter.this.mbBidNativeHandler.registerView((View)container, clickableViews, nativeAdCampaign);
                } else {
                    MintegralMediationAdapter.this.e("Failed to register native ad views: mbBidNativeHandler is null.");
                }
            } else if (MintegralMediationAdapter.this.mbBidNativeAdViewHandler != null) {
                MintegralMediationAdapter.this.mbBidNativeAdViewHandler.registerView((View)container, clickableViews, nativeAdCampaign);
            } else {
                MintegralMediationAdapter.this.e("Failed to register native ad views: mbBidNativeAdViewHandler is null.");
            }
            MintegralMediationAdapter.this.nativeAdContainer = container;
            MintegralMediationAdapter.this.clickableViews = clickableViews;
            return true;
        }
    }
}

